/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.saml.rp.servlet;

import com.tridium.authn.BAuthenticationService;
import com.tridium.authn.LoginFailureCause;
import com.tridium.nre.security.SecretChars;
import com.tridium.saml.SAMLConfigurationException;
import com.tridium.saml.SAMLException;
import com.tridium.saml.SAMLMetadataException;
import com.tridium.saml.authnScheme.BISamlXmlDecrypter;
import com.tridium.saml.authnScheme.BSAMLAuthenticationScheme;
import com.tridium.saml.rp.AuthnRequest;
import com.tridium.saml.rp.servlet.SAMLAuthenticationInfo;
import com.tridium.saml.rp.servlet.SAMLAuthenticationInfoHandler;
import com.tridium.saml.rp.servlet.SAMLUuidMap;
import com.tridium.saml.utils.SAMLUtils;
import com.tridium.web.CookieUtil;
import com.tridium.web.Template;
import com.tridium.web.session.NiagaraWebSession;
import com.tridium.web.session.WebSessionUtil;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Calendar;
import java.util.HashMap;
import java.util.TimeZone;
import java.util.logging.Level;
import javax.baja.authn.BSSOAuthenticationScheme;
import javax.baja.naming.BOrd;
import javax.baja.security.BCertificateAliasAndPassword;
import javax.baja.security.BPassword;
import javax.baja.security.crypto.CertManagerFactory;
import javax.baja.security.crypto.ICryptoManager;
import javax.baja.security.crypto.IKeyStore;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.baja.web.servlets.UnauthenticatedServlet;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.owasp.encoder.Encode;

public class SAMLRPServlet
extends UnauthenticatedServlet {
    private static final BOrd metadataTemplate = BOrd.make((String)"module://saml/rc/metadata.vm");
    private static final BOrd metadataEncTemplate = BOrd.make((String)"module://saml/rc/metadata_enc.vm");
    private static SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");

    public void init() {
        AccessController.doPrivileged(() -> {
            SAMLUuidMap.IN_RESPONSE_TO_SCHEME_MAP.init();
            return null;
        });
    }

    public void destroy() {
        AccessController.doPrivileged(() -> {
            SAMLUuidMap.IN_RESPONSE_TO_SCHEME_MAP.destroy();
            return null;
        });
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        NiagaraWebSession session = null;
        try {
            session = WebSessionUtil.getSession((HttpServletRequest)request, (boolean)false);
            if (request.getRequestURI().endsWith("metadata")) {
                this.getMetadata(request, response);
            } else {
                this.processLoginRequest(request, response);
            }
        }
        catch (SAMLMetadataException e) {
            response.sendError(404, e.getGenericErrorMessage() + ": " + e.getMessage());
        }
        catch (SAMLException e) {
            SAMLUtils.log(Level.WARNING, e.getGenericErrorMessage(), e);
            response.addCookie(CookieUtil.createCookie((String)"niagara_failure_cause", (String)LoginFailureCause.SSO_FAILURE.name(), (int)-1));
            response.addCookie(CookieUtil.createCookie((String)"niagara_failure_info", (String)Base64.getEncoder().encodeToString(String.format("SAML login failed (%s)", e.getGenericErrorMessage()).getBytes(StandardCharsets.UTF_8)), (int)-1));
            response.sendRedirect("/login?auth=fail");
        }
        catch (Throwable t) {
            SAMLUtils.log(Level.WARNING, t.getMessage(), t);
            response.addCookie(CookieUtil.createCookie((String)"niagara_failure_cause", (String)LoginFailureCause.SSO_FAILURE.name(), (int)-1));
            response.sendRedirect("/login?auth=fail");
        }
    }

    private void getMetadata(HttpServletRequest request, HttpServletResponse response) throws SAMLException {
        String encodedSigningCert;
        IKeyStore keyStore;
        BasicContext cx = new BasicContext(null, request.getLocale().toLanguageTag());
        Lexicon lex = Lexicon.make((String)"saml", (Context)cx);
        String authSchemeName = request.getParameter("scheme");
        if (authSchemeName == null || authSchemeName.isEmpty()) {
            throw new SAMLMetadataException(lex.get("saml.exception.noSchemeInQuery"));
        }
        BAuthenticationService authnService = (BAuthenticationService)Sys.getService((Type)BAuthenticationService.TYPE);
        BValue requestedScheme = authnService.getAuthenticationSchemes().get(authSchemeName);
        if (!(requestedScheme instanceof BSAMLAuthenticationScheme)) {
            throw new SAMLMetadataException(lex.getText("saml.exception.samlSchemeNotFound", new Object[]{authSchemeName}));
        }
        BSAMLAuthenticationScheme samlScheme = (BSAMLAuthenticationScheme)requestedScheme;
        Calendar calendar = Calendar.getInstance();
        calendar.add(1, 2);
        String baseUrl = samlScheme.getEntityId();
        if (baseUrl.isEmpty()) {
            throw new SAMLConfigurationException(lex.get("saml.exception.noEntityId"));
        }
        try {
            keyStore = CertManagerFactory.getInstance().getKeyStore();
        }
        catch (Exception e) {
            throw new SAMLException("Error getting keystore", e);
        }
        try {
            X509Certificate signingCert = keyStore.getCertificate(samlScheme.getSamlServerCertAliasAndPassword().getAlias());
            encodedSigningCert = Base64.getEncoder().encodeToString(signingCert.getEncoded());
        }
        catch (Exception e) {
            throw new SAMLConfigurationException(String.format("Invalid signing cert {%s}", samlScheme.getSamlServerCertAliasAndPassword().getAlias()), e);
        }
        String encryptionElement = "";
        BISamlXmlDecrypter[] decrypters = (BISamlXmlDecrypter[])samlScheme.getChildren(BISamlXmlDecrypter.class);
        if (decrypters.length != 0) {
            try {
                X509Certificate encryptionCert = decrypters[0].getEncryptionCertificate();
                if (encryptionCert != null) {
                    String encodedEncryptionCert = Base64.getEncoder().encodeToString(encryptionCert.getEncoded());
                    HashMap<String, String> encryptionTemplateMap = new HashMap<String, String>();
                    encryptionTemplateMap.put("encryptionCert", encodedEncryptionCert);
                    encryptionElement = Template.process(encryptionTemplateMap, (BOrd)metadataEncTemplate, (boolean)true);
                }
            }
            catch (SAMLException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SAMLException("Could not generate SAML encryption metadata", e);
            }
        }
        try {
            HashMap<String, String> templateMap = new HashMap<String, String>();
            templateMap.put("timestamp", format.format(calendar.getTime()));
            templateMap.put("baseUrl", Encode.forXmlAttribute((String)baseUrl));
            templateMap.put("signingCert", encodedSigningCert);
            templateMap.put("encryptionElement", encryptionElement);
            templateMap.put("assertionConsumerService", Encode.forXmlAttribute((String)(baseUrl + "assertionConsumerService")));
            response.setContentType("text/xml");
            response.getWriter().print(Template.process(templateMap, (BOrd)metadataTemplate, (boolean)true));
        }
        catch (IOException e) {
            throw new SAMLException("Could not generate SAML encryption metadata", e);
        }
    }

    private void processLoginRequest(HttpServletRequest request, HttpServletResponse response) throws IOException, SAMLException {
        SAMLAuthenticationInfo authenticationInfo = SAMLAuthenticationInfoHandler.getAuthenticationInfo(WebSessionUtil.getId((String)request.getRequestedSessionId()));
        if (authenticationInfo != null) {
            response.sendRedirect("/ord");
            return;
        }
        BSSOAuthenticationScheme ssoScheme = null;
        Cookie ssoSchemeCookie = CookieUtil.getCookieFromName((HttpServletRequest)request, (String)"niagara_current_sso_scheme");
        if (ssoSchemeCookie != null) {
            ssoScheme = BAuthenticationService.getService().getSSOAuthenticationScheme(ssoSchemeCookie.getValue());
        }
        if (!(ssoScheme instanceof BSAMLAuthenticationScheme)) {
            throw new SAMLException(Lexicon.make((String)"saml").get("saml.exception.noSSOScheme"));
        }
        BSAMLAuthenticationScheme samlScheme = (BSAMLAuthenticationScheme)ssoScheme;
        String samlURL = String.format("%s:%s%s", samlScheme.getIdpHostURL(), samlScheme.getIdpHostPort(), samlScheme.getIdpLoginPath());
        try {
            new URL(samlURL);
        }
        catch (MalformedURLException e) {
            throw new SAMLConfigurationException(Lexicon.make((String)"saml").getText("saml.exception.invalidURL", new Object[]{samlURL}), e);
        }
        String destinationUrl = !samlScheme.getIncludeQueryParamsInDestination() && samlURL.contains("?") ? samlURL.substring(0, samlURL.indexOf(63)) : samlURL;
        AuthnRequest authnRequest = AccessController.doPrivileged(() -> AuthnRequest.make(samlScheme, SAMLUtils.getAssertionConsumerURL(samlScheme, request), SAMLUtils.getIssuerURL(samlScheme, request), destinationUrl));
        AccessController.doPrivileged(() -> {
            SAMLUuidMap.IN_RESPONSE_TO_SCHEME_MAP.put(authnRequest.getId(), samlScheme, samlScheme.getTimeSkew().getMillis());
            return null;
        });
        String authnRequestXML = authnRequest.getRequest();
        String encodedAuthnRequest = SAMLUtils.encodeSAMLMessageXML(authnRequestXML, true, true);
        String authnRequestQuery = "SAMLRequest=" + encodedAuthnRequest;
        if (this.shouldSignRequest()) {
            authnRequestQuery = authnRequestQuery + "&SigAlg=" + URLEncoder.encode("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", "UTF-8");
            byte[] authnRequestQuerySignature = this.signEntity(authnRequestQuery, samlScheme);
            String encodedSignature = URLEncoder.encode(Base64.getEncoder().encodeToString(authnRequestQuerySignature), "UTF-8");
            authnRequestQuery = authnRequestQuery + "&Signature=" + encodedSignature;
        }
        String fullURL = samlURL.contains("?") ? String.format("%s&%s", samlURL, authnRequestQuery) : String.format("%s?%s", samlURL, authnRequestQuery);
        response.sendRedirect(fullURL);
    }

    private byte[] signEntity(String entity, BSAMLAuthenticationScheme samlScheme) throws SAMLException {
        PrivateKey privateKey;
        block17: {
            try {
                ICryptoManager cryptoManager = CertManagerFactory.getInstance();
                BCertificateAliasAndPassword aliasAndPassword = samlScheme.getSamlServerCertAliasAndPassword();
                if (aliasAndPassword.getPassword().isDefault()) {
                    privateKey = (PrivateKey)cryptoManager.getKeyStore().getKey(aliasAndPassword.getAlias(), null);
                    break block17;
                }
                try (SecretChars passwordChars = AccessController.doPrivileged(() -> ((BPassword)aliasAndPassword.getPassword()).getSecretChars());){
                    privateKey = (PrivateKey)cryptoManager.getKeyStore().getKey(aliasAndPassword.getAlias(), passwordChars.get());
                }
            }
            catch (Exception e) {
                Lexicon lex = Lexicon.make((String)"saml");
                throw new SAMLException(lex.get("saml.exception.serverCert"), e);
            }
        }
        try {
            Signature signature = Signature.getInstance("SHA256withRSA");
            signature.initSign(privateKey);
            signature.update(entity.getBytes());
            return signature.sign();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            Lexicon lex = Lexicon.make((String)"saml");
            throw new SAMLException(lex.get("saml.exception.signAuthnRequest"), e);
        }
    }

    private boolean shouldSignRequest() {
        return true;
    }

    static {
        format.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

