/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.saml.idp;

import com.onelogin.saml2.util.Util;
import com.tridium.crypto.core.io.CoreCryptoManager;
import com.tridium.crypto.core.io.ICoreKeyStore;
import com.tridium.nre.security.SecretChars;
import com.tridium.saml.BSAMLAuthenticationSchemeRankInfo;
import com.tridium.saml.BSAMLAuthenticationSchemeRankMixIn;
import com.tridium.saml.SAMLException;
import com.tridium.saml.SAMLIdPConfigurationException;
import com.tridium.saml.attributes.BSAMLUserPropertyType;
import com.tridium.saml.authnScheme.BSAMLAuthenticationScheme;
import com.tridium.saml.idp.BCircleOfTrust;
import com.tridium.saml.idp.BSAMLCoTPrototypesMixIn;
import com.tridium.saml.idp.BSAMLIdPService;
import com.tridium.saml.rp.AuthnRequest;
import com.tridium.saml.utils.SAMLUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.Key;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.authn.BAuthenticationScheme;
import javax.baja.naming.SlotPath;
import javax.baja.security.BCertificateAliasAndPassword;
import javax.baja.security.BPassword;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BString;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IdPResponse {
    private final AuthnRequest authnRequest;
    private final BUser authenticatedUser;
    private final UUID responseId;
    private final UUID assertionId;
    private final ZonedDateTime issueInstant;
    private final X509Certificate encryptingCertificate;
    private final boolean encryptionConfigured;
    private String authnContextClassRef;
    BCircleOfTrust circleOfTrust;
    private static final Duration minimumNotBefore = Duration.ofMinutes(1L);
    private static final Duration minimumNotOnOrAfter = Duration.ofMinutes(5L);
    private static final Logger LOG = Logger.getLogger("saml");

    public IdPResponse(AuthnRequest authnRequest, BUser authenticatedUser, boolean encryptionConfigured, X509Certificate encryptingCertificate, BCircleOfTrust circleOfTrust) {
        this.authnRequest = authnRequest;
        this.authenticatedUser = authenticatedUser;
        this.encryptionConfigured = encryptionConfigured;
        this.encryptingCertificate = encryptingCertificate;
        this.circleOfTrust = circleOfTrust;
        this.responseId = UUID.randomUUID();
        this.assertionId = UUID.randomUUID();
        this.issueInstant = ZonedDateTime.now();
    }

    void setAuthnContextClassRef(String authnContextClassRef) {
        this.authnContextClassRef = authnContextClassRef;
    }

    private static String getValidAuthnContextClassRef(String proposedAuthnContextClassRef) {
        block3: {
            if (proposedAuthnContextClassRef.startsWith("urn:oasis:names:tc:SAML:2.0:ac:classes:")) {
                try {
                    new URI(proposedAuthnContextClassRef);
                    return proposedAuthnContextClassRef;
                }
                catch (URISyntaxException e) {
                    if (!LOG.isLoggable(Level.FINE)) break block3;
                    LOG.fine("Invalid AuthnContextClassRef found: " + proposedAuthnContextClassRef + ". Using unspecified");
                }
            }
        }
        return "urn:oasis:names:tc:SAML:2.0:ac:classes:unspecified";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getXMLResponse() throws SAMLException {
        Optional service = Sys.findService((Type)BSAMLIdPService.TYPE);
        if (!service.isPresent()) {
            throw new BajaRuntimeException("SAML IdP Service could not be found when requesting Issuer for IdP Response.");
        }
        BSAMLIdPService idpService = (BSAMLIdPService)((Object)service.get());
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            XMLOutputFactory xmlFactory = XMLOutputFactory.newInstance();
            XMLStreamWriter xmlWriter = xmlFactory.createXMLStreamWriter(byteArrayOutputStream);
            xmlWriter.writeStartElement("samlp", "Response", "urn:oasis:names:tc:SAML:2.0:protocol");
            xmlWriter.writeNamespace("samlp", "urn:oasis:names:tc:SAML:2.0:protocol");
            xmlWriter.writeAttribute("ID", "Niagara_" + this.responseId.toString());
            xmlWriter.writeAttribute("Version", "2.0");
            xmlWriter.writeAttribute("IssueInstant", this.getIssueInstant());
            xmlWriter.writeAttribute("Destination", this.getDestination());
            xmlWriter.writeAttribute("InResponseTo", this.getInResponseTo());
            xmlWriter.writeStartElement("saml", "Issuer", "urn:oasis:names:tc:SAML:2.0:assertion");
            xmlWriter.writeNamespace("saml", "urn:oasis:names:tc:SAML:2.0:assertion");
            xmlWriter.writeCharacters(IdPResponse.getIssuer(idpService));
            xmlWriter.writeEndElement();
            String statusCode = this.getStatusCode();
            xmlWriter.writeStartElement("samlp", "Status", "urn:oasis:names:tc:SAML:2.0:protocol");
            xmlWriter.writeNamespace("samlp", "urn:oasis:names:tc:SAML:2.0:protocol");
            xmlWriter.writeStartElement("samlp", "StatusCode", "urn:oasis:names:tc:SAML:2.0:protocol");
            xmlWriter.writeNamespace("samlp", "urn:oasis:names:tc:SAML:2.0:protocol");
            xmlWriter.writeAttribute("Value", statusCode);
            xmlWriter.writeEndElement();
            xmlWriter.writeEndElement();
            if ("urn:oasis:names:tc:SAML:2.0:status:Success".equals(statusCode)) {
                this.writeAssertion(xmlWriter, idpService);
            }
            xmlWriter.writeEndElement();
            xmlWriter.flush();
            Document response = SAMLUtils.loadXML(byteArrayOutputStream.toString());
            if (response == null) {
                throw new SAMLException("Failed to create response XML");
            }
            if ("urn:oasis:names:tc:SAML:2.0:status:Success".equals(statusCode)) {
                IdPResponse.signAssertion(response);
            }
            if (this.encryptionConfigured && "urn:oasis:names:tc:SAML:2.0:status:Success".equals(statusCode)) {
                response = idpService.getEncrypter().encryptResponse(response, this.encryptingCertificate);
            }
            IdPResponse.signResponse(response);
            Document finalResponse = response;
            String string = AccessController.doPrivileged(() -> Util.convertDocumentToString(finalResponse));
            return string;
        }
        catch (IOException | XMLStreamException e) {
            throw new SAMLException("Error generating SAML Response", e);
        }
    }

    private void writeAssertion(XMLStreamWriter xmlWriter, BSAMLIdPService idpService) throws XMLStreamException, SAMLException {
        xmlWriter.writeStartElement("saml", "Assertion", "urn:oasis:names:tc:SAML:2.0:assertion");
        xmlWriter.writeNamespace("saml", "urn:oasis:names:tc:SAML:2.0:assertion");
        xmlWriter.writeAttribute("ID", "Niagara_" + this.assertionId.toString());
        xmlWriter.writeAttribute("Version", "2.0");
        xmlWriter.writeAttribute("IssueInstant", this.getIssueInstant());
        xmlWriter.writeStartElement("saml", "Issuer", "urn:oasis:names:tc:SAML:2.0:assertion");
        xmlWriter.writeNamespace("saml", "urn:oasis:names:tc:SAML:2.0:assertion");
        xmlWriter.writeCharacters(IdPResponse.getIssuer(idpService));
        xmlWriter.writeEndElement();
        xmlWriter.writeStartElement("saml", "Subject", "urn:oasis:names:tc:SAML:2.0:assertion");
        xmlWriter.writeNamespace("saml", "urn:oasis:names:tc:SAML:2.0:assertion");
        xmlWriter.writeStartElement("saml", "NameID", "urn:oasis:names:tc:SAML:2.0:assertion");
        xmlWriter.writeNamespace("saml", "urn:oasis:names:tc:SAML:2.0:assertion");
        xmlWriter.writeAttribute("Format", "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
        xmlWriter.writeCharacters(this.getUsername());
        xmlWriter.writeEndElement();
        xmlWriter.writeEndElement();
        xmlWriter.writeStartElement("saml", "Conditions", "urn:oasis:names:tc:SAML:2.0:assertion");
        xmlWriter.writeAttribute("NotBefore", this.getNotBefore(idpService));
        xmlWriter.writeAttribute("NotOnOrAfter", this.getNotOnOrAfter(idpService));
        xmlWriter.writeStartElement("saml", "AudienceRestriction", "urn:oasis:names:tc:SAML:2.0:assertion");
        xmlWriter.writeNamespace("saml", "urn:oasis:names:tc:SAML:2.0:assertion");
        xmlWriter.writeStartElement("saml", "Audience", "urn:oasis:names:tc:SAML:2.0:assertion");
        xmlWriter.writeNamespace("saml", "urn:oasis:names:tc:SAML:2.0:assertion");
        xmlWriter.writeCharacters(this.getAudience());
        xmlWriter.writeEndElement();
        xmlWriter.writeEndElement();
        xmlWriter.writeEndElement();
        xmlWriter.writeStartElement("saml", "AuthnStatement", "urn:oasis:names:tc:SAML:2.0:assertion");
        xmlWriter.writeNamespace("saml", "urn:oasis:names:tc:SAML:2.0:assertion");
        xmlWriter.writeAttribute("AuthnInstant", this.getIssueInstant());
        xmlWriter.writeStartElement("saml", "AuthnContext", "urn:oasis:names:tc:SAML:2.0:assertion");
        xmlWriter.writeNamespace("saml", "urn:oasis:names:tc:SAML:2.0:assertion");
        xmlWriter.writeStartElement("saml", "AuthnContextClassRef", "urn:oasis:names:tc:SAML:2.0:assertion");
        xmlWriter.writeNamespace("saml", "urn:oasis:names:tc:SAML:2.0:assertion");
        if (this.authnContextClassRef == null || this.authnContextClassRef.isEmpty()) {
            xmlWriter.writeCharacters("urn:oasis:names:tc:SAML:2.0:ac:classes:unspecified");
        } else {
            xmlWriter.writeCharacters(IdPResponse.getValidAuthnContextClassRef(this.authnContextClassRef));
        }
        xmlWriter.writeEndElement();
        xmlWriter.writeEndElement();
        xmlWriter.writeEndElement();
        this.writeAttributes(xmlWriter);
        xmlWriter.writeEndElement();
    }

    private void writeAttributes(XMLStreamWriter xmlWriter) throws XMLStreamException, SAMLException {
        String fullName = this.authenticatedUser.getFullName();
        String email = this.authenticatedUser.getEmail();
        BAbsTime expirationAbsTime = this.authenticatedUser.getExpiration();
        String language = this.authenticatedUser.getLanguage();
        String cellPhoneNumber = this.authenticatedUser.getCellPhoneNumber();
        BSAMLCoTPrototypesMixIn[] samlPrototypesMixin = (BSAMLCoTPrototypesMixIn[])this.authenticatedUser.getChildren(BSAMLCoTPrototypesMixIn.class);
        if (samlPrototypesMixin.length != 1) {
            throw new SAMLIdPConfigurationException(String.format("Incorrect number of SAMLCoTPrototypesMixins found on user: %s. Expected 1.", this.authenticatedUser.getName()));
        }
        String samlPrototypes = ((BString)samlPrototypesMixin[0].get(this.circleOfTrust.getName())).getString();
        HashSet<String> samlPrototypeValues = new HashSet<String>();
        for (String samlPrototype : samlPrototypes.split(",")) {
            if (this.circleOfTrust.getPrototypes().get(samlPrototype) == null || samlPrototype.isEmpty()) continue;
            samlPrototypeValues.add(SlotPath.unescape((String)samlPrototype));
        }
        if (fullName.isEmpty() && email.isEmpty() && expirationAbsTime.isNull() && language.isEmpty() && cellPhoneNumber.isEmpty() && samlPrototypeValues.isEmpty()) {
            return;
        }
        xmlWriter.writeStartElement("saml", "AttributeStatement", "urn:oasis:names:tc:SAML:2.0:assertion");
        xmlWriter.writeNamespace("saml", "urn:oasis:names:tc:SAML:2.0:assertion");
        if (!fullName.isEmpty()) {
            IdPResponse.writeAttribute(xmlWriter, BSAMLUserPropertyType.fullName.getTag(), Collections.singleton(fullName));
        }
        if (!email.isEmpty()) {
            IdPResponse.writeAttribute(xmlWriter, BSAMLUserPropertyType.email.getTag(), Collections.singleton(email));
        }
        if (!expirationAbsTime.isNull()) {
            try {
                ZonedDateTime expirationDate = ZonedDateTime.ofInstant(Instant.ofEpochMilli(expirationAbsTime.getMillis()), ZoneId.of(expirationAbsTime.getTimeZone().getId()));
                String expiration = expirationDate.format(DateTimeFormatter.ISO_INSTANT);
                IdPResponse.writeAttribute(xmlWriter, BSAMLUserPropertyType.expiration.getTag(), Collections.singleton(expiration));
            }
            catch (Exception e) {
                throw new SAMLException("Could not generate 'expiration' attribute for SAML Response", e);
            }
        }
        if (!language.isEmpty()) {
            IdPResponse.writeAttribute(xmlWriter, BSAMLUserPropertyType.language.getTag(), Collections.singleton(language));
        }
        if (!cellPhoneNumber.isEmpty()) {
            IdPResponse.writeAttribute(xmlWriter, BSAMLUserPropertyType.cellPhoneNumber.getTag(), Collections.singleton(cellPhoneNumber));
        }
        if (!samlPrototypeValues.isEmpty()) {
            IdPResponse.writeAttribute(xmlWriter, BSAMLUserPropertyType.prototypeName.getTag(), samlPrototypeValues);
        }
        xmlWriter.writeEndElement();
    }

    private static void writeAttribute(XMLStreamWriter xmlWriter, String attributeName, Set<String> attributeValues) throws XMLStreamException {
        xmlWriter.writeStartElement("saml", "Attribute", "urn:oasis:names:tc:SAML:2.0:assertion");
        xmlWriter.writeNamespace("saml", "urn:oasis:names:tc:SAML:2.0:assertion");
        xmlWriter.writeAttribute("Name", attributeName);
        for (String attributeValue : attributeValues) {
            xmlWriter.writeStartElement("saml", "AttributeValue", "urn:oasis:names:tc:SAML:2.0:assertion");
            xmlWriter.writeNamespace("saml", "urn:oasis:names:tc:SAML:2.0:assertion");
            xmlWriter.writeCharacters(attributeValue);
            xmlWriter.writeEndElement();
        }
        xmlWriter.writeEndElement();
    }

    private String getIssueInstant() {
        return this.issueInstant.format(DateTimeFormatter.ISO_INSTANT);
    }

    private String getDestination() {
        return this.authnRequest.getAssertionConsumerServiceURL();
    }

    private String getInResponseTo() {
        return "_" + this.authnRequest.getId();
    }

    private static String getIssuer(BSAMLIdPService idpService) {
        return idpService.getEntityId();
    }

    private String getUsername() {
        return this.authenticatedUser.getUsername();
    }

    private String getNotBefore(BSAMLIdPService idpService) {
        ZonedDateTime notBefore = this.issueInstant.minus(minimumNotBefore);
        if (idpService.getApplyTimeSkewToResponse()) {
            notBefore = notBefore.minus(idpService.getTimeSkew().toDuration());
        }
        return notBefore.format(DateTimeFormatter.ISO_INSTANT);
    }

    private String getNotOnOrAfter(BSAMLIdPService idpService) {
        ZonedDateTime notOnOrAfter = this.issueInstant.plus(minimumNotOnOrAfter);
        if (idpService.getApplyTimeSkewToResponse()) {
            notOnOrAfter = notOnOrAfter.plus(idpService.getTimeSkew().toDuration());
        }
        return notOnOrAfter.format(DateTimeFormatter.ISO_INSTANT);
    }

    private String getAudience() {
        return this.authnRequest.getIssuerURL();
    }

    private String getStatusCode() throws SAMLException {
        BSAMLAuthenticationSchemeRankInfo schemeRankInfo;
        BAuthenticationScheme authenticationScheme = this.authenticatedUser.getAuthenticationScheme();
        BSAMLAuthenticationSchemeRankMixIn rankMixIn = (BSAMLAuthenticationSchemeRankMixIn)authenticationScheme.getMixIn(BSAMLAuthenticationSchemeRankMixIn.TYPE);
        if (rankMixIn == null) {
            throw new SAMLIdPConfigurationException("Could not find rank mixin for scheme: " + authenticationScheme.getName());
        }
        BSAMLAuthenticationSchemeRankInfo bSAMLAuthenticationSchemeRankInfo = schemeRankInfo = this.authnRequest.isTlsUsed() ? rankMixIn.getWithTls() : rankMixIn.getWithoutTls();
        if (authenticationScheme instanceof BSAMLAuthenticationScheme && this.authnContextClassRef != null && !this.authnContextClassRef.isEmpty()) {
            if (!this.authnContextClassRef.startsWith("urn:oasis:names:tc:SAML:2.0:ac:classes:")) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Received unsupported AuthnContextClassRef from IdP: " + this.authnContextClassRef + ". Using default");
                }
            } else {
                schemeRankInfo = new BSAMLAuthenticationSchemeRankInfo(BSAMLAuthenticationScheme.TYPE.toString(), this.authnRequest.isTlsUsed(), this.authnContextClassRef.substring("urn:oasis:names:tc:SAML:2.0:ac:classes:".length()), schemeRankInfo.getRank());
            }
        }
        if (BSAMLAuthenticationSchemeRankMixIn.schemeRankMeetsRequirements(schemeRankInfo, this.authnRequest)) {
            return "urn:oasis:names:tc:SAML:2.0:status:Success";
        }
        return "urn:oasis:names:tc:SAML:2.0:status:Responder";
    }

    private static Element getElement(Element rootElement, String namespace, String elementName) throws SAMLException {
        NodeList nodeList = rootElement.getElementsByTagNameNS(namespace, elementName);
        if (nodeList.getLength() != 1) {
            throw new SAMLException("Invalid number of " + elementName + " elements. Expected 1.");
        }
        Node node = nodeList.item(0);
        return (Element)node;
    }

    private static BCertificateAliasAndPassword getSigningCertificateAliasAndPassword() {
        Optional idpService = Sys.findService((Type)BSAMLIdPService.TYPE);
        if (!idpService.isPresent()) {
            throw new BajaRuntimeException("SAML IdP Service could not be found when requesting Signing Certificate Alias for IdP Response.");
        }
        return ((BSAMLIdPService)((Object)idpService.get())).getIdpSigningCertAliasAndPassword();
    }

    private static void signAssertion(Document response) throws SAMLException {
        Element rootElement = response.getDocumentElement();
        Element assertionElement = IdPResponse.getElement(rootElement, "urn:oasis:names:tc:SAML:2.0:assertion", "Assertion");
        Element subjectElement = IdPResponse.getElement(rootElement, "urn:oasis:names:tc:SAML:2.0:assertion", "Subject");
        IdPResponse.signXml(assertionElement, subjectElement);
    }

    private static void signResponse(Document response) throws SAMLException {
        String responseString = null;
        if (SAMLUtils.log.isLoggable(Level.FINEST)) {
            responseString = AccessController.doPrivileged(() -> Util.convertDocumentToString(response));
        }
        SAMLUtils.log(Level.FINEST, "Unsigned generated response:\n" + responseString);
        Element rootElement = response.getDocumentElement();
        Element statusElement = IdPResponse.getElement(rootElement, "urn:oasis:names:tc:SAML:2.0:protocol", "Status");
        IdPResponse.signXml(response.getDocumentElement(), statusElement);
        SAMLUtils.log(Level.FINEST, "Signed XML document:\n" + responseString);
    }

    private static void signXml(Element elementToSign, Element nextSibling) throws SAMLException {
        try {
            Key key;
            X509Certificate signingCertificate;
            SignedInfo signedInfo;
            XMLSignatureFactory signatureFactory;
            block20: {
                signatureFactory = XMLSignatureFactory.getInstance("DOM");
                elementToSign.setIdAttribute("ID", true);
                String elementUri = '#' + elementToSign.getAttributes().getNamedItem("ID").getNodeValue();
                Reference elementReference = signatureFactory.newReference(elementUri, signatureFactory.newDigestMethod("http://www.w3.org/2001/04/xmlenc#sha256", null), Collections.singletonList(signatureFactory.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null)), null, null);
                signedInfo = signatureFactory.newSignedInfo(signatureFactory.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", (C14NMethodParameterSpec)null), signatureFactory.newSignatureMethod("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", null), Collections.singletonList(elementReference));
                CoreCryptoManager coreCryptoManager = CoreCryptoManager.get();
                ICoreKeyStore keyStore = coreCryptoManager.getKeyStore();
                try {
                    BCertificateAliasAndPassword aliasAndPassword = IdPResponse.getSigningCertificateAliasAndPassword();
                    signingCertificate = keyStore.getCertificate(aliasAndPassword.getAlias());
                    if (aliasAndPassword.getPassword().isDefault()) {
                        key = keyStore.getKey(aliasAndPassword.getAlias(), null);
                        break block20;
                    }
                    try (SecretChars passwordChars = AccessController.doPrivileged(() -> ((BPassword)aliasAndPassword.getPassword()).getSecretChars());){
                        key = keyStore.getKey(aliasAndPassword.getAlias(), passwordChars.get());
                    }
                }
                catch (UnrecoverableKeyException e) {
                    throw new SAMLIdPConfigurationException("Could not retrieve signing cert due to invalid password <" + IdPResponse.getSigningCertificateAliasAndPassword().getAlias() + '>', e);
                }
                catch (Exception e) {
                    throw new SAMLIdPConfigurationException("Could not retrieve configured signing cert <" + IdPResponse.getSigningCertificateAliasAndPassword().getAlias() + '>', e);
                }
            }
            if (signingCertificate == null || key == null) {
                throw new SAMLIdPConfigurationException("Could not retrieve configured signing cert <" + IdPResponse.getSigningCertificateAliasAndPassword().getAlias() + '>');
            }
            KeyInfoFactory keyInfoFactory = signatureFactory.getKeyInfoFactory();
            ArrayList<Object> x509Content = new ArrayList<Object>();
            x509Content.add(signingCertificate.getSubjectX500Principal().getName());
            x509Content.add(signingCertificate);
            X509Data x509Data = keyInfoFactory.newX509Data(x509Content);
            KeyInfo keyInfo = keyInfoFactory.newKeyInfo(Collections.singletonList(x509Data));
            DOMSignContext documentSignContext = new DOMSignContext(key, (Node)elementToSign, (Node)nextSibling);
            XMLSignature signature = signatureFactory.newXMLSignature(signedInfo, keyInfo);
            signature.sign(documentSignContext);
        }
        catch (SAMLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SAMLException(e.getMessage(), e);
        }
    }
}

