/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.ui;

import com.tridium.fox.sys.NiagaraStation;
import java.lang.reflect.Field;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.history.ext.BHistoryExt;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.util.CoalesceQueue;
import javax.baja.util.ICoalesceable;
import javax.baja.util.ThreadPoolWorker;
import javax.baja.util.Worker;

public abstract class HistorySourceSubscriber
extends Subscriber {
    Class<?> historyImportClass = null;
    Field lastSuccessSlot = null;
    static Logger log = Logger.getLogger("history");
    private static CoalesceQueue queue = new CoalesceQueue(1000);
    private static ThreadPoolWorker threadPool = new ThreadPoolWorker((Worker.ITodo)queue);

    public final void event(BComponentEvent event) {
        block4: {
            BComponentEvent filteredEvent = this.filterHistorySourceEvent(event);
            if (filteredEvent != null) {
                try {
                    if (!threadPool.isRunning()) {
                        threadPool.start("HistorySourceSubscriber");
                    }
                    queue.enqueue((Object)new EventProcessor(this, filteredEvent));
                }
                catch (Exception e) {
                    if (!log.isLoggable(Level.FINE)) break block4;
                    log.log(Level.FINE, "Encountered error enqueuing history source event" + event, e);
                }
            }
        }
    }

    protected BComponentEvent filterHistorySourceEvent(BComponentEvent event) {
        BComponent source = event.getSourceComponent();
        if (source instanceof NiagaraStation) {
            return null;
        }
        if (source instanceof BHistoryExt) {
            if (!BHistoryExt.lastRecord.equals(event.getSlot())) {
                return null;
            }
        } else {
            try {
                if (this.historyImportClass == null) {
                    this.historyImportClass = Sys.loadClass((String)"driver", (String)"javax.baja.driver.history.BHistoryImport");
                }
                if (this.historyImportClass.isInstance(source)) {
                    Object lastSuccessProperty;
                    if (this.lastSuccessSlot == null) {
                        this.lastSuccessSlot = this.historyImportClass.getField("lastSuccess");
                    }
                    if (!(lastSuccessProperty = this.lastSuccessSlot.get(source)).equals(event.getSlot())) {
                        return null;
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return event;
    }

    protected boolean allowCoalescedEvents() {
        return false;
    }

    public abstract void historySourceEvent(BComponentEvent var1);

    public static final Context makeAsyncContext(Context cx) {
        return new BasicContext(cx, BFacets.make((String)"asyncHistorySubscribe", (boolean)true));
    }

    static {
        threadPool.setMaxThreads(100);
    }

    static class EventProcessor
    implements Runnable,
    ICoalesceable {
        HistorySourceSubscriber subscriber;
        BComponentEvent event;

        public EventProcessor(HistorySourceSubscriber subscriber, BComponentEvent event) {
            this.subscriber = subscriber;
            this.event = event;
        }

        @Override
        public void run() {
            block3: {
                try {
                    if (this.subscriber.getSubscriptionCount() > 0) {
                        this.subscriber.historySourceEvent(this.event);
                    }
                }
                catch (Exception e) {
                    if (!log.isLoggable(Level.FINE)) break block3;
                    log.log(Level.FINE, "Encountered error processing history source event" + this.event, e);
                }
            }
        }

        public Object getCoalesceKey() {
            if (this.subscriber.allowCoalescedEvents()) {
                return this.subscriber;
            }
            return this;
        }

        public ICoalesceable coalesce(ICoalesceable c) {
            return c;
        }
    }
}

