/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.ui;

import javax.baja.history.BTrendFlags;
import javax.baja.history.BTrendRecord;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFloat;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BWidget;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbPlugin;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType(agent={@AgentOn(types={"history:TrendRecord"})})
public class BTrendRecordFE
extends BWbFieldEditor {
    @Generated
    public static final Type TYPE = Sys.loadType(BTrendRecordFE.class);
    private static Lexicon lex = Lexicon.make((String)"history");
    private BWbFieldEditor tsEd = BWbFieldEditor.makeFor((BObject)BAbsTime.DEFAULT);
    private BCheckBox hiddenCheck = new BCheckBox(lex.getText("Hidden"));
    private BWbFieldEditor valueEd = BWbFieldEditor.makeFor((BObject)BFloat.DEFAULT);
    private boolean tsReadonly = false;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BTrendRecordFE() {
        this.valueEd.loadValue((BObject)BFloat.make((float)0.0f), null);
        this.setContent((BWidget)this.tsEd);
        this.add(null, (BValue)this.hiddenCheck);
        this.add("value", (BValue)this.valueEd);
        this.add("hiddenLink", (BValue)new BLink((BComponent)this.hiddenCheck, (Slot)BCheckBox.actionPerformed, (Slot)setModified));
        this.add("valueMod", (BValue)new BLink((BComponent)this.valueEd, (Slot)BWbPlugin.pluginModified, (Slot)setModified));
        this.add("valueAction", (BValue)new BLink((BComponent)this.valueEd, (Slot)BWbPlugin.actionPerformed, (Slot)actionPerformed));
    }

    public void setTimestampReadonly(boolean ro) {
        this.tsReadonly = ro;
        this.tsEd.setReadonly(this.tsReadonly);
    }

    public void computePreferredSize() {
        double w = 0.0;
        double h = 0.0;
        this.tsEd.computePreferredSize();
        this.hiddenCheck.computePreferredSize();
        this.valueEd.computePreferredSize();
        w = this.tsEd.getPreferredWidth() + 4.0 + this.hiddenCheck.getPreferredWidth() + 4.0 + this.valueEd.getPreferredWidth();
        h = this.tsEd.getPreferredHeight();
        h = Math.max(h, this.hiddenCheck.getPreferredHeight());
        h = Math.max(h, this.valueEd.getPreferredHeight());
        this.setPreferredSize(w, h);
    }

    public void doLayout(BWidget[] kids) {
        this.tsEd.computePreferredSize();
        this.hiddenCheck.computePreferredSize();
        this.valueEd.computePreferredSize();
        double x = 0.0;
        double h = this.getHeight();
        this.tsEd.setBounds(x, (h - this.tsEd.getPreferredHeight()) / 2.0, this.tsEd.getPreferredWidth(), this.tsEd.getPreferredHeight());
        this.hiddenCheck.setBounds(x += this.tsEd.getPreferredWidth() + 4.0, (h - this.hiddenCheck.getPreferredHeight()) / 2.0, this.hiddenCheck.getPreferredWidth(), this.hiddenCheck.getPreferredHeight());
        this.valueEd.setBounds(x += this.hiddenCheck.getPreferredWidth() + 4.0, (h - this.valueEd.getPreferredHeight()) / 2.0, this.valueEd.getPreferredWidth(), this.valueEd.getPreferredHeight());
        x += this.valueEd.getPreferredWidth() + 4.0;
    }

    public void doLoadValue(BObject value, Context context) {
        BTrendRecord rec = (BTrendRecord)value;
        this.tsEd.loadValue((BObject)rec.getTimestamp());
        this.hiddenCheck.setSelected(rec.getTrendFlags().getBit(4));
        BValue recValue = rec.get(rec.getValueProperty());
        Type valueType = rec.get(rec.getValueProperty()).getType();
        Type currentType = null;
        try {
            currentType = this.valueEd.saveValue(null).getType();
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
        if (currentType == valueType) {
            this.valueEd.loadValue((BObject)recValue, context);
        } else {
            boolean readonly = this.valueEd != null ? this.valueEd.isReadonly() : false;
            this.remove("value");
            this.remove("valueMod");
            this.remove("valueAction");
            this.valueEd = BWbFieldEditor.makeFor((BObject)recValue);
            this.valueEd.setReadonly(readonly);
            this.valueEd.loadValue((BObject)recValue, context);
            this.add("value", (BValue)this.valueEd);
            this.add("valueMod", (BValue)new BLink((BComponent)this.valueEd, (Slot)BWbPlugin.pluginModified, (Slot)setModified));
            this.add("valueAction", (BValue)new BLink((BComponent)this.valueEd, (Slot)BWbPlugin.actionPerformed, (Slot)actionPerformed));
            this.relayout();
        }
    }

    public BObject doSaveValue(BObject value, Context context) throws Exception {
        BTrendRecord rec = (BTrendRecord)value;
        rec.setTimestamp((BAbsTime)this.tsEd.saveValue(context));
        BTrendFlags newFlags = rec.getTrendFlags().set(4, this.hiddenCheck.isSelected());
        rec.setTrendFlags(newFlags);
        rec.set(rec.getValueProperty(), (BValue)this.valueEd.saveValue(context));
        return rec;
    }

    public void doSetReadonly(boolean ro) {
        this.tsEd.setReadonly(this.tsReadonly || ro);
        this.hiddenCheck.setEnabled(!ro);
        this.valueEd.setReadonly(ro);
    }
}

