/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.ui;

import com.tridium.bql.util.BDynamicTimeRange;
import com.tridium.bql.util.BDynamicTimeRangeType;
import com.tridium.history.BHistory;
import com.tridium.history.BHistoryDeltaQuery;
import com.tridium.history.BHistoryTimeQuery;
import com.tridium.history.fox.BFoxHistory;
import com.tridium.history.ui.HistorySourceSubscriber;
import com.tridium.history.ui.HistoryUiUtil;
import com.tridium.history.util.BICombinableHistory;
import com.tridium.workbench.fieldeditors.BDynamicTimeRangeFE;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.chart.BAbsTimeAxis;
import javax.baja.chart.BAxis;
import javax.baja.chart.BAxisDimension;
import javax.baja.chart.BChartPane;
import javax.baja.chart.BDiscreteAxis;
import javax.baja.chart.BDiscreteLineChart;
import javax.baja.chart.BLineChart;
import javax.baja.chart.BNumericAxis;
import javax.baja.chart.ChartModel;
import javax.baja.chart.ChartSpec;
import javax.baja.chart.Series;
import javax.baja.chart.SimpleChartModel;
import javax.baja.chart.TableSeries;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.collection.TableCursor;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistorySpace;
import javax.baja.history.BIChartableHistoryAgent;
import javax.baja.history.BIHistory;
import javax.baja.history.BNumericTrendRecord;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.history.ext.BHistoryExt;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.IntHashMap;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BIObject;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BBorder;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BToggleButton;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.view.BWbView;

@NiagaraType(agent={@AgentOn(types={"history:IHistory", "history:HistoryExt"}, requiredPermissions="r")})
@NiagaraProperties(value={@NiagaraProperty(name="showTimeRangeEditor", type="boolean", defaultValue="true"), @NiagaraProperty(name="defaultTimeRange", type="BDynamicTimeRange", defaultValue="BDynamicTimeRange.DEFAULT"), @NiagaraProperty(name="showDeltaEditor", type="boolean", defaultValue="true"), @NiagaraProperty(name="defaultDelta", type="boolean", defaultValue="false"), @NiagaraProperty(name="showLiveUpdates", type="boolean", defaultValue="true"), @NiagaraProperty(name="defaultLiveUpdates", type="boolean", defaultValue="false"), @NiagaraProperty(name="showInterpolateTail", type="boolean", defaultValue="true"), @NiagaraProperty(name="defaultInterpolateTail", type="boolean", defaultValue="false")})
@NiagaraActions(value={@NiagaraAction(name="query", flags=16), @NiagaraAction(name="liveUpdate", flags=16), @NiagaraAction(name="refresh", flags=16)})
public class BHistoryChart
extends BWbView
implements BIChartableHistoryAgent {
    @Generated
    public static final Property showTimeRangeEditor = BHistoryChart.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property defaultTimeRange = BHistoryChart.newProperty((int)0, (BValue)BDynamicTimeRange.DEFAULT, null);
    @Generated
    public static final Property showDeltaEditor = BHistoryChart.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property defaultDelta = BHistoryChart.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property showLiveUpdates = BHistoryChart.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property defaultLiveUpdates = BHistoryChart.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property showInterpolateTail = BHistoryChart.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property defaultInterpolateTail = BHistoryChart.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Action query = BHistoryChart.newAction((int)16, null);
    @Generated
    public static final Action liveUpdate = BHistoryChart.newAction((int)16, null);
    @Generated
    public static final Action refresh = BHistoryChart.newAction((int)16, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BHistoryChart.class);
    static final BImage PLAY_ICON = BImage.make((BIcon)BIcon.std((String)"mediaPlay.png"));
    static final BImage PAUSE_ICON = BImage.make((BIcon)BIcon.std((String)"mediaPause.png"));
    static Lexicon lex = Lexicon.make((String)"history");
    private static HashMap<String, State> states = new HashMap();
    private BDynamicTimeRangeFE timeRangeEd;
    private BToggleButton deltaEd;
    private Context tzContext;
    private boolean deltaEnabled;
    private boolean chartReady = false;
    private ToggleCommand deltaCmd;
    private BLabel liveUpdatesStatus;
    private BAbstractButton toolBarLiveUpdatesButton;
    private BToggleButton liveUpdatesToggle;
    private ToggleCommand liveUpdatesCmd;
    private BToggleButton interpolateTailToggle;
    private ToggleCommand interpolateTailCmd;
    private HistoryChartSubscriber mySubscriber = new HistoryChartSubscriber(this);
    private BHistory currentHistory = null;
    private BIHistory cachedHistory = null;
    private BObject cachedValue = null;
    private boolean shouldUpdate = false;
    public Object syncObj = new Object();
    public BAbsTime lastTimestamp = BAbsTime.NULL;
    private BITable<? extends BHistoryRecord> lastQueryResult = null;
    private boolean lastUpdateState = false;
    private Clock.Ticket ticket = null;
    private static String NRE_PROP_INTERPOLATE_TAIL = "niagara.history.interpolateRefreshInterval";
    private static Long INTERPOLATE_TAIL_MS_INTERVAL = AccessController.doPrivileged(() -> Long.valueOf(System.getProperty(NRE_PROP_INTERPOLATE_TAIL, "10000")));
    private static BRelTime INTERPOLATE_TAIL_INTERVAL = BRelTime.make((long)INTERPOLATE_TAIL_MS_INTERVAL);

    @Generated
    public boolean getShowTimeRangeEditor() {
        return this.getBoolean(showTimeRangeEditor);
    }

    @Generated
    public void setShowTimeRangeEditor(boolean v) {
        this.setBoolean(showTimeRangeEditor, v, null);
    }

    @Generated
    public BDynamicTimeRange getDefaultTimeRange() {
        return (BDynamicTimeRange)this.get(defaultTimeRange);
    }

    @Generated
    public void setDefaultTimeRange(BDynamicTimeRange v) {
        this.set(defaultTimeRange, (BValue)v, null);
    }

    @Generated
    public boolean getShowDeltaEditor() {
        return this.getBoolean(showDeltaEditor);
    }

    @Generated
    public void setShowDeltaEditor(boolean v) {
        this.setBoolean(showDeltaEditor, v, null);
    }

    @Generated
    public boolean getDefaultDelta() {
        return this.getBoolean(defaultDelta);
    }

    @Generated
    public void setDefaultDelta(boolean v) {
        this.setBoolean(defaultDelta, v, null);
    }

    @Generated
    public boolean getShowLiveUpdates() {
        return this.getBoolean(showLiveUpdates);
    }

    @Generated
    public void setShowLiveUpdates(boolean v) {
        this.setBoolean(showLiveUpdates, v, null);
    }

    @Generated
    public boolean getDefaultLiveUpdates() {
        return this.getBoolean(defaultLiveUpdates);
    }

    @Generated
    public void setDefaultLiveUpdates(boolean v) {
        this.setBoolean(defaultLiveUpdates, v, null);
    }

    @Generated
    public boolean getShowInterpolateTail() {
        return this.getBoolean(showInterpolateTail);
    }

    @Generated
    public void setShowInterpolateTail(boolean v) {
        this.setBoolean(showInterpolateTail, v, null);
    }

    @Generated
    public boolean getDefaultInterpolateTail() {
        return this.getBoolean(defaultInterpolateTail);
    }

    @Generated
    public void setDefaultInterpolateTail(boolean v) {
        this.setBoolean(defaultInterpolateTail, v, null);
    }

    @Generated
    public void query() {
        this.invoke(query, null, null);
    }

    @Generated
    public void liveUpdate() {
        this.invoke(liveUpdate, null, null);
    }

    @Generated
    public void refresh() {
        this.invoke(refresh, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BHistoryChart() {
        this.initCommands();
        BEdgePane main = new BEdgePane();
        this.timeRangeEd = new BDynamicTimeRangeFE();
        this.timeRangeEd.loadValue((BObject)BDynamicTimeRange.TODAY);
        this.timeRangeEd.setVisible(this.getShowTimeRangeEditor());
        this.deltaEd = new BToggleButton(this.deltaCmd, false, true);
        this.deltaEd.setSelected(false);
        this.deltaEd.setVisible(this.getShowDeltaEditor());
        this.liveUpdatesToggle = new BToggleButton(this.liveUpdatesCmd, false, true);
        this.liveUpdatesToggle.setSelected(false);
        this.liveUpdatesToggle.setVisible(this.getShowLiveUpdates());
        this.interpolateTailToggle = new BToggleButton(this.interpolateTailCmd, false, true);
        this.interpolateTailToggle.setSelected(false);
        this.interpolateTailToggle.setEnabled(this.getEnableInterpolateTail());
        this.interpolateTailToggle.setVisible(true);
        this.liveUpdatesStatus = new BLabel(lex.getText("history.liveUpdates.inProgress"), BHalign.right);
        this.liveUpdatesStatus.setVisible(false);
        BToolBar toolbar = new BToolBar();
        main.setTop((BWidget)new BBorderPane((BWidget)toolbar, 0.0, 0.0, 5.0, 0.0));
        main.getTop().setVisible(this.getShowDeltaEditor() || this.getShowLiveUpdates() || this.getShowTimeRangeEditor());
        BChartPane chartPane = new BChartPane();
        chartPane.getCanvas().setShowHorizontalGridLines(true);
        chartPane.getCanvas().setShowVerticalGridLines(true);
        main.setCenter((BWidget)new BBorderPane((BWidget)chartPane, BBorder.inset, BInsets.NULL));
        this.setContent((BWidget)main);
        this.rebuildToolbar();
        this.linkTo("rangeLink", (BComponent)this.timeRangeEd, (Slot)BWbFieldEditor.setModified, (Slot)query);
        this.linkTo("zoomOutLink", (BComponent)chartPane, (Slot)BChartPane.hidePanRequested, (Slot)liveUpdate);
    }

    public BToolBar getViewToolBar() {
        BToolBar tb = new BToolBar();
        this.toolBarLiveUpdatesButton = tb.add("liveUpdates", (Command)this.liveUpdatesCmd);
        tb.add("delta", (Command)this.deltaCmd);
        return tb;
    }

    public BWidget getViewStatusBarSupplement() {
        return this.liveUpdatesStatus;
    }

    private void initCommands() {
        this.deltaCmd = new ToggleCommand((BWidget)this, BHistoryChart.lex.module, "command.delta"){

            public CommandArtifact doInvoke() {
                BHistoryChart.this.query();
                return null;
            }
        };
        this.liveUpdatesCmd = new ToggleCommand((BWidget)this, BHistoryChart.lex.module, "command.liveUpdates"){

            public CommandArtifact doInvoke() {
                if (!this.isEnabled()) {
                    return null;
                }
                boolean enableUpdates = this.isSelected();
                if (enableUpdates == BHistoryChart.this.lastUpdateState) {
                    return null;
                }
                BHistoryChart.this.lastUpdateState = enableUpdates;
                if (BHistoryChart.this.currentHistory != null) {
                    if (enableUpdates) {
                        BHistoryChart.this.liveUpdatesStatus.setVisible(true);
                        BHistoryChart.this.liveUpdatesStatus.relayoutSync();
                        BHistoryChart.this.currentHistory.subscribe((Subscriber)BHistoryChart.this.mySubscriber, HistorySourceSubscriber.makeAsyncContext(BHistoryChart.this.getCurrentContext()));
                    } else {
                        BHistoryChart.this.currentHistory.unsubscribe((Subscriber)BHistoryChart.this.mySubscriber, HistorySourceSubscriber.makeAsyncContext(BHistoryChart.this.getCurrentContext()));
                    }
                }
                if (enableUpdates) {
                    this.icon = PAUSE_ICON;
                    if (BHistoryChart.this.toolBarLiveUpdatesButton != null) {
                        BHistoryChart.this.toolBarLiveUpdatesButton.setImage(PAUSE_ICON);
                    }
                    BHistoryChart.this.liveUpdatesToggle.setImage(PAUSE_ICON);
                    BHistoryChart.this.interpolateTailToggle.setEnabled(BHistoryChart.this.getEnableInterpolateTail());
                    BHistoryChart.this.interpolateTailToggle.setSelected(BHistoryChart.this.getDefaultInterpolateTail());
                } else {
                    BHistoryChart.this.liveUpdatesStatus.setVisible(false);
                    BHistoryChart.this.liveUpdatesStatus.relayoutSync();
                    this.icon = PLAY_ICON;
                    if (BHistoryChart.this.toolBarLiveUpdatesButton != null) {
                        BHistoryChart.this.toolBarLiveUpdatesButton.setImage(PLAY_ICON);
                    }
                    BHistoryChart.this.liveUpdatesToggle.setImage(PLAY_ICON);
                    BHistoryChart.this.interpolateTailToggle.setEnabled(false);
                    BHistoryChart.this.interpolateTailToggle.setSelected(false);
                }
                BHistoryChart.this.refresh();
                return null;
            }
        };
        this.interpolateTailCmd = new ToggleCommand((BWidget)this, BHistoryChart.lex.module, "command.interpolateTail"){

            public CommandArtifact doInvoke() {
                BHistoryChart.this.refresh();
                return null;
            }
        };
    }

    /*
     * Unable to fully structure code
     */
    public void doLoadValue(BObject value, Context context) {
        history = this.getHistory(value);
        if (history instanceof BHistory) {
            if (history instanceof BFoxHistory) {
                if (history != this.currentHistory) {
                    try {
                        this.currentHistory.unsubscribe((Subscriber)this.mySubscriber, HistorySourceSubscriber.makeAsyncContext(context));
                    }
                    catch (Exception var4_4) {
                        // empty catch block
                    }
                    this.currentHistory = (BHistory)history;
                }
            } else if (this.currentHistory != null) {
                if (this.currentHistory.getId().equals((Object)history.getId())) {
                    history = this.currentHistory;
                } else {
                    try {
                        this.currentHistory.unsubscribe((Subscriber)this.mySubscriber, HistorySourceSubscriber.makeAsyncContext(context));
                    }
                    catch (Exception var4_5) {
                        // empty catch block
                    }
                    this.currentHistory = (BHistory)history;
                }
            } else {
                this.currentHistory = (BHistory)history;
            }
        } else {
            if (this.currentHistory != null) {
                try {
                    this.currentHistory.unsubscribe((Subscriber)this.mySubscriber, HistorySourceSubscriber.makeAsyncContext(context));
                }
                catch (Exception var4_6) {
                    // empty catch block
                }
            }
            this.currentHistory = null;
        }
        this.tzContext = new BasicContext(context, BFacets.make((String)"TimeZone", (BIDataValue)history.getConfig().getTimeZone()));
        recTypeSpec = history.getRecordType();
        type = recTypeSpec.getResolvedType();
        this.deltaEnabled = type.is(BNumericTrendRecord.TYPE);
        this.deltaCmd.setEnabled(this.deltaEnabled);
        liveUpdatesEnabled = this.currentHistory != null && this.currentHistory.canSubscribe(context) != false;
        this.liveUpdatesCmd.setEnabled(liveUpdatesEnabled);
        this.interpolateTailCmd.setEnabled(this.getEnableInterpolateTail());
        this.rebuildToolbar();
        defRange = this.getDefaultTimeRange();
        if (defRange.equals((Object)BDynamicTimeRange.DEFAULT)) {
            conn = ((BHistorySpace)history.getSpace()).getConnection(null);
            var9_12 = null;
            try {
                this.timeRangeEd.loadValue((BObject)BDynamicTimeRange.make((BAbsTime)conn.getFirstTimestamp(history), (BAbsTime)BAbsTime.NULL), this.tzContext);
                recordCount = conn.getRecordCount(history);
                lastTs = conn.getLastTimestamp(history);
                if (recordCount <= 500) ** GOTO lbl73
                now = Clock.time();
                if (now.dateEquals(lastTs)) {
                    this.timeRangeEd.loadValue((BObject)BDynamicTimeRange.TODAY, this.tzContext);
                }
                range = BDynamicTimeRange.make((BAbsTime)lastTs.timeOfDay(0, 0, 0, 0), (BAbsTime)BAbsTime.NULL);
                this.timeRangeEd.loadValue((BObject)range, this.tzContext);
            }
            catch (Throwable var10_15) {
                var9_12 = var10_15;
                throw var10_15;
            }
            finally {
                if (conn != null) {
                    if (var9_12 != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable var10_14) {
                            var9_12.addSuppressed(var10_14);
                        }
                    } else {
                        conn.close();
                    }
                }
            }
        } else {
            this.timeRangeEd.loadValue((BObject)defRange, this.tzContext);
        }
lbl73:
        // 4 sources

        this.deltaEd.setSelected(this.deltaEnabled != false && this.getDefaultDelta() != false);
        this.liveUpdatesToggle.setSelected(liveUpdatesEnabled != false && this.getDefaultLiveUpdates() != false);
        this.interpolateTailToggle.setSelected(this.liveUpdatesToggle.getSelected() != false && this.getDefaultInterpolateTail() != false);
        this.restoreState(this.toKey());
        if (HistoryUiUtil.requiresSyncLoad(history, (BWidget)this, context)) {
            this.doQuery();
        } else {
            this.query();
        }
        if (this.interpolateTailToggle.isSelected()) {
            this.ticket = Clock.schedule((BComponent)this, (BRelTime)BHistoryChart.INTERPOLATE_TAIL_INTERVAL, (Action)BHistoryChart.refresh, null);
        }
    }

    public void doRefresh() {
        if (!this.getChartPane().isZoomed(BAxisDimension.x) && !this.getChartPane().isZoomed(BAxisDimension.y)) {
            if (this.getCurrentValue() != null) {
                this.doQuery(false);
            } else {
                this.refreshInterpolateTail();
            }
        }
        if (this.ticket != null) {
            this.ticket.cancel();
            this.ticket = null;
        }
        if (this.interpolateTailToggle.isSelected()) {
            this.ticket = Clock.schedule((BComponent)this, (BRelTime)INTERPOLATE_TAIL_INTERVAL, (Action)refresh, null);
        }
    }

    protected BObject doSaveValue(BObject value, Context cx) {
        if (this.currentHistory != null) {
            try {
                this.currentHistory.unsubscribe((Subscriber)this.mySubscriber, HistorySourceSubscriber.makeAsyncContext(cx));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.currentHistory = null;
        }
        return value;
    }

    public void stopped() throws Exception {
        if (this.ticket != null) {
            this.ticket.cancel();
            this.ticket = null;
        }
        if (this.currentHistory != null) {
            try {
                this.currentHistory.unsubscribe((Subscriber)this.mySubscriber, HistorySourceSubscriber.makeAsyncContext(null));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.currentHistory = null;
        }
        super.stopped();
    }

    public void doQuery() {
        this.doQuery(true);
    }

    private void refreshInterpolateTail() {
        if (this.interpolateTailToggle != null) {
            this.interpolateTailToggle.setEnabled(this.getEnableInterpolateTail());
            if (!this.getEnableInterpolateTail()) {
                this.interpolateTailToggle.setSelected(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doQuery(boolean reload) {
        Object object = this.syncObj;
        synchronized (object) {
            this.refreshInterpolateTail();
            BWidgetShell shell = this.getShell();
            if (shell != null && reload) {
                shell.enterBusy();
            }
            try {
                boolean append;
                BDynamicTimeRange timeRange;
                BHistoryTimeQuery result;
                BIHistory history;
                block27: {
                    history = this.getHistory(this.getCurrentValue());
                    result = null;
                    timeRange = null;
                    append = false;
                    try {
                        timeRange = (BDynamicTimeRange)this.timeRangeEd.saveValue();
                        if (reload || BAbsTime.NULL.equals((Object)this.lastTimestamp)) break block27;
                        BAbsTime start = this.lastTimestamp.add(BRelTime.make((long)1L));
                        BAbsTime current = BAbsTime.make((long)System.currentTimeMillis(), (BTimeZone)history.getConfig().getTimeZone());
                        BAbsTime editorStart = timeRange.getStartTime(current);
                        if (BAbsTime.NULL.equals((Object)editorStart) || start.isAfter(editorStart)) {
                            BAbsTime editorEnd = timeRange.getEndTime(current);
                            if (!BAbsTime.NULL.equals((Object)editorEnd)) {
                                if (!start.isBefore(editorEnd)) return;
                            }
                            timeRange = BDynamicTimeRange.make((BAbsTime)start, (BAbsTime)editorEnd);
                            append = true;
                        }
                    }
                    catch (Exception e) {
                        if (!reload) throw new BajaRuntimeException((Throwable)e);
                        BDialog.error((BWidget)this, (String)lex.getText("timerange.error"), (Object)lex.getText("timerange.checkRange"), (Throwable)e);
                        throw new BajaRuntimeException((Throwable)e);
                    }
                }
                BOrd historyOrd = history.getOrdInSession();
                String historyOrdParams = "?" + timeRange.toOrdParams() + ";delta=" + this.deltaCmd.isSelected();
                String historyOrdStr = historyOrd.toString();
                String nextSchemeOrdStr = "";
                int historySchemeIndex = historyOrdStr.indexOf("history:");
                int nextSchemeIndex = historyOrdStr.indexOf("|", historySchemeIndex);
                if (nextSchemeIndex > 0) {
                    nextSchemeOrdStr = historyOrdStr.substring(nextSchemeIndex);
                    historyOrdStr = historyOrdStr.substring(0, nextSchemeIndex);
                }
                BOrd historyQuery = BOrd.make((String)(historyOrdStr + historyOrdParams + nextSchemeOrdStr));
                BOrd ord = BOrd.make((BOrd)history.getAbsoluteOrd(), (BOrd)historyQuery).normalize();
                result = (BHistoryTimeQuery)ord.resolve().get();
                if (append) {
                    if (result == null) {
                        result = this.lastQueryResult;
                    } else {
                        if (!(result instanceof BICombinableHistory)) {
                            this.doQuery(false);
                            return;
                        }
                        if (((BICombinableHistory)result).isEmpty()) {
                            result = this.lastQueryResult;
                        } else if (this.lastQueryResult instanceof BHistoryTimeQuery && result instanceof BHistoryTimeQuery) {
                            result = ((BHistoryTimeQuery)this.lastQueryResult).combine(result);
                        } else if (this.lastQueryResult instanceof BHistoryDeltaQuery && result instanceof BHistoryDeltaQuery) {
                            result = ((BHistoryDeltaQuery)this.lastQueryResult).combine((BHistoryDeltaQuery)result);
                        } else {
                            this.doQuery(true);
                            return;
                        }
                    }
                }
                try {
                    this.loadData((BITable<? extends BHistoryRecord>)result, history);
                }
                catch (Exception e) {
                    BDialog.error((BWidget)this, (String)BDialog.TITLE_ERROR, (Object)lex.getText("historyChart.noChartableValue"), (Throwable)e);
                    this.chartReady = true;
                    if (shell == null) return;
                    if (!reload) return;
                    shell.exitBusy();
                    return;
                }
            }
            finally {
                this.chartReady = true;
                if (shell != null && reload) {
                    shell.exitBusy();
                }
            }
            return;
        }
    }

    public void loadData(BITable<? extends BHistoryRecord> result, BIHistory history) {
        BHistoryId id = history.getId();
        BChartPane chartPane = this.getChartPane();
        ColumnList cols = result.getColumns();
        Column valueColumn = cols.get("value");
        if (valueColumn == null) {
            throw new RuntimeException("No value column");
        }
        Type valueType = valueColumn.getType();
        BNumericAxis vAxis = null;
        BLineChart newChart = null;
        if (valueType.is(BINumeric.TYPE)) {
            vAxis = new BNumericAxis();
            newChart = new BLineChart();
        } else if (valueType.is(BEnum.TYPE)) {
            vAxis = new BDiscreteAxis();
            ((BDiscreteAxis)vAxis).setRange((Object[])this.getEnumRange(result, valueColumn));
            newChart = new BDiscreteLineChart();
        } else {
            throw new RuntimeException("Value has invalid type " + valueType);
        }
        SimpleChartModel model = new SimpleChartModel();
        chartPane.getHeader().setTitle(history.getNavDisplayName(BHistory.FULL_DISPLAY_NAME_CX));
        TableSeries series = new TableSeries(null, result, "timestamp", "value");
        boolean interpolateTail = false;
        interpolateTail = this.interpolateTailToggle != null ? this.interpolateTailToggle.getSelected() : this.getDefaultInterpolateTail();
        series.setInterpolateTail(interpolateTail);
        model.add(new ChartSpec((Series)series, (BAxis)new BAbsTimeAxis(history.getConfig().getTimeZone()), (BAxis)vAxis));
        newChart.setModel((ChartModel)model);
        if (chartPane.get("chart") != null) {
            chartPane.remove("chart");
        }
        chartPane.add("chart", (BValue)newChart);
        chartPane.noZoom();
        chartPane.getCanvas().setZoomed(false);
        if (result instanceof BICombinableHistory) {
            this.lastTimestamp = ((BICombinableHistory)result).lastTimestamp();
        } else {
            BAbsTime last = BAbsTime.NULL;
            try (TableCursor cursor = result.cursor();){
                while (cursor.next()) {
                    last = ((BHistoryRecord)cursor.get()).getTimestamp();
                }
            }
            this.lastTimestamp = last;
        }
        this.lastQueryResult = result;
        chartPane.relayout();
    }

    public void doLiveUpdate() {
        this.doLiveUpdate(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLiveUpdate(boolean force) {
        if (!this.liveUpdatesCmd.isSelected()) {
            return;
        }
        BChartPane chartPane = this.getChartPane();
        Object object = this.syncObj;
        synchronized (object) {
            if (!chartPane.isZoomed(BAxisDimension.x) && !chartPane.isZoomed(BAxisDimension.y)) {
                if (force || this.shouldUpdate) {
                    this.shouldUpdate = false;
                    this.doQuery(false);
                }
            } else {
                this.shouldUpdate = true;
            }
        }
    }

    private BIObject[] getEnumRange(BITable<?> table, Column col) {
        BEnumRange enumRange;
        BFacets facets = col.getFacets();
        BObject range = null;
        if (facets != null) {
            range = facets.get("range");
        }
        if (range instanceof BEnumRange && (enumRange = (BEnumRange)range).getOrdinals().length != 0) {
            return BHistoryChart.extractEnumRange((BEnumRange)range, table, col);
        }
        try (TableCursor cursor = table.cursor();){
            if (cursor.next()) {
                BIObject value = cursor.cell(col);
                if (value instanceof BEnum) {
                    BEnumRange enumRange2 = ((BEnum)value).getRange();
                    BIObject[] bIObjectArray = BHistoryChart.extractEnumRange(enumRange2, table, col);
                    return bIObjectArray;
                }
                BIObject[] bIObjectArray = BHistoryChart.extractRange(table, col);
                return bIObjectArray;
            }
            Type type = col.getType();
            if (!type.isAbstract() && type.is(BFrozenEnum.TYPE)) {
                BIObject[] bIObjectArray = BHistoryChart.extractEnumRange(((BEnum)type.getInstance()).getRange(), table, col);
                return bIObjectArray;
            }
            BIObject[] bIObjectArray = new BIObject[]{};
            return bIObjectArray;
        }
    }

    private static BIObject[] extractEnumRange(BEnumRange range, BITable<?> table, Column column) {
        int[] ordinals = range.getOrdinals();
        IntHashMap ordMap = new IntHashMap(Math.max(7, ordinals.length));
        for (int ordinal : ordinals) {
            ordMap.put(ordinal, (Object)range.get(ordinal));
        }
        try (TableCursor cursor = table.cursor();){
            while (cursor.next()) {
                BEnum value = (BEnum)cursor.cell(column).as(BEnum.class);
                if (ordMap.get(value.getOrdinal()) != null) continue;
                ordMap.put(value.getOrdinal(), (Object)value);
            }
        }
        Object[] values = (BEnum[])ordMap.toArray((Object[])new BEnum[ordMap.size()]);
        SortUtil.sort((Object[])values);
        return values;
    }

    private static BIObject[] extractRange(BITable<?> table, Column column) {
        ArrayList<BIObject> temp = new ArrayList<BIObject>();
        try (TableCursor cursor = table.cursor();){
            while (cursor.next()) {
                BIObject value = cursor.cell(column);
                if (temp.contains(value)) continue;
                temp.add(value);
            }
        }
        Object[] range = temp.toArray(new BIObject[0]);
        if (range[0] instanceof Comparable) {
            SortUtil.sort((Object[])range);
        }
        return range;
    }

    public void changed(Property p, Context cx) {
        if (p == showTimeRangeEditor || p == showDeltaEditor || p == showLiveUpdates || p == showInterpolateTail) {
            this.rebuildToolbar();
        }
        if (p == defaultInterpolateTail) {
            this.refresh();
        }
    }

    private BToolBar getToolbar() {
        BEdgePane content = (BEdgePane)this.getContent();
        BBorderPane top = (BBorderPane)content.getTop();
        return (BToolBar)top.getContent();
    }

    private void unparent(BComplex complex) {
        if (complex.getParent() != null) {
            complex.getParent().asComponent().remove(complex);
        }
    }

    private boolean getEnableInterpolateTail() {
        if (this.liveUpdatesToggle == null || !this.liveUpdatesToggle.isSelected()) {
            return false;
        }
        boolean shouldEnable = false;
        try {
            BDynamicTimeRange timeRange = (BDynamicTimeRange)this.timeRangeEd.saveValue();
            BDynamicTimeRangeType rangeType = timeRange.getRangeType();
            shouldEnable = rangeType != BDynamicTimeRangeType.yesterday && rangeType != BDynamicTimeRangeType.lastWeek && rangeType != BDynamicTimeRangeType.lastMonth && rangeType != BDynamicTimeRangeType.lastYear;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return shouldEnable;
    }

    private void rebuildToolbar() {
        BToolBar toolbar = this.getToolbar();
        boolean a = this.currentHistory != null && this.getShowLiveUpdates();
        boolean b = this.deltaEnabled && this.getShowDeltaEditor();
        boolean c = this.getShowTimeRangeEditor();
        boolean d = this.getShowInterpolateTail();
        toolbar.removeAll();
        this.unparent((BComplex)this.liveUpdatesToggle);
        this.unparent((BComplex)this.deltaEd);
        this.unparent((BComplex)this.timeRangeEd);
        this.unparent((BComplex)this.interpolateTailToggle);
        if (a) {
            toolbar.add("live", (BValue)this.liveUpdatesToggle);
        }
        if (a && (b || c || d)) {
            toolbar.add(null, (BValue)new BSeparator());
        }
        if (b) {
            toolbar.add("delta", (BValue)this.deltaEd);
        }
        if (b && d) {
            toolbar.add(null, (BValue)new BSeparator());
        }
        if (d) {
            toolbar.add("interpolate", (BValue)this.interpolateTailToggle);
            this.interpolateTailToggle.setEnabled(this.getEnableInterpolateTail());
        }
        if ((b || d) && c) {
            toolbar.add(null, (BValue)new BSeparator());
        }
        if (c) {
            toolbar.add("timerange", (BValue)this.timeRangeEd);
        }
        if (this.getContent() instanceof BEdgePane) {
            ((BEdgePane)this.getContent()).getTop().setVisible(this.getShowDeltaEditor() || this.getShowLiveUpdates() || this.getShowTimeRangeEditor() || this.getShowInterpolateTail());
        }
    }

    protected BIHistory getHistory(BObject o) {
        if (o != this.cachedValue || this.cachedHistory == null) {
            this.cachedValue = o;
            if (o instanceof BIHistory) {
                this.cachedHistory = (BIHistory)o;
            } else if (o instanceof BHistoryExt) {
                BHistoryExt ext = (BHistoryExt)o;
                ext.lease(1);
                BHistoryConfig cfg = ext.getHistoryConfig();
                BHistoryId id = cfg.getId();
                BOrd base = ext.getAbsoluteOrd();
                BOrd ord = BOrd.make((BOrd)base, (String)("history: " + id));
                this.cachedHistory = (BIHistory)ord.resolve().get();
            } else {
                this.cachedHistory = null;
            }
        }
        return this.cachedHistory;
    }

    private String toKey() {
        BWbShell shell = this.getWbShell();
        if (shell == null) {
            return null;
        }
        OrdTarget ordTarget = shell.getActiveOrdTarget();
        if (ordTarget == null) {
            return null;
        }
        return "" + ordTarget.getOrdWithoutViewQuery();
    }

    public void activated() {
        this.restoreState(this.toKey());
    }

    public void deactivated() {
        this.saveState(this.toKey());
        if (this.currentHistory != null) {
            try {
                this.currentHistory.unsubscribe((Subscriber)this.mySubscriber, HistorySourceSubscriber.makeAsyncContext(null));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.currentHistory = null;
        }
    }

    private void saveState(String key) {
        try {
            State state = new State();
            state.timeRange = (BDynamicTimeRange)this.timeRangeEd.saveValue();
            state.deltaState = this.deltaCmd.isSelected();
            state.liveUpdatesState = this.liveUpdatesCmd.isSelected();
            states.put(key, state);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void restoreState(String key) {
        if (key == null) {
            return;
        }
        State state = states.get(key);
        if (state == null) {
            return;
        }
        this.timeRangeEd.loadValue((BObject)state.timeRange, this.tzContext);
        this.deltaEd.setSelected(state.deltaState);
        this.liveUpdatesToggle.setSelected(state.liveUpdatesState);
    }

    public BChartPane getChartPane() {
        BEdgePane main = (BEdgePane)this.getContent();
        BBorderPane center = (BBorderPane)main.getCenter();
        return (BChartPane)center.getContent();
    }

    public boolean isReady() {
        return this.chartReady;
    }

    public BIHistory getHistory() {
        return this.getHistory(this.getCurrentValue());
    }

    public BDynamicTimeRange getRange() throws Exception {
        return (BDynamicTimeRange)this.timeRangeEd.saveValue();
    }

    public boolean isDelta() {
        return this.deltaCmd.isSelected();
    }

    public BChartPane popChartPane() {
        BChartPane chartPane = this.getChartPane();
        BBorderPane parent = (BBorderPane)chartPane.getParentWidget();
        parent.setContent((BWidget)new BNullWidget());
        return chartPane;
    }

    static class HistoryChartSubscriber
    extends HistorySourceSubscriber {
        BHistoryChart chart = null;

        public HistoryChartSubscriber(BHistoryChart chart) {
            this.chart = chart;
        }

        @Override
        protected boolean allowCoalescedEvents() {
            return true;
        }

        @Override
        public void historySourceEvent(BComponentEvent event) {
            try {
                this.chart.doLiveUpdate(true);
            }
            catch (Throwable throwable) {
                BasicContext cx = new BasicContext(this.chart.getCurrentContext(), BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE));
                this.chart.liveUpdatesStatus.setText(lex.getText("history.liveUpdates.lastUpdate", new Object[]{BAbsTime.now().toString((Context)cx)}));
                this.chart.liveUpdatesStatus.relayoutSync();
                throw throwable;
            }
            BasicContext cx = new BasicContext(this.chart.getCurrentContext(), BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE));
            this.chart.liveUpdatesStatus.setText(lex.getText("history.liveUpdates.lastUpdate", new Object[]{BAbsTime.now().toString((Context)cx)}));
            this.chart.liveUpdatesStatus.relayoutSync();
        }

        protected void unsubscribed(BComponent c, Context cx) {
            block20: {
                try {
                    BIHistory viewHistory = this.chart.getHistory(this.chart.getCurrentValue());
                    if (!(this.chart.getShell() instanceof BWbShell)) break block20;
                    BOrd activeOrd = ((BWbShell)this.chart.getShell()).getActiveOrd();
                    BOrd spaceOrd = BOrd.make((BOrd)activeOrd, (String)"history:");
                    BHistorySpace space = (BHistorySpace)spaceOrd.get();
                    try (HistorySpaceConnection conn = space.getConnection(cx);){
                        BIHistory spaceHistory = conn.getHistory(viewHistory.getId());
                        if (spaceHistory != viewHistory) {
                            this.chart.cachedHistory = spaceHistory;
                            if (spaceHistory instanceof BHistory) {
                                this.chart.currentHistory = (BHistory)spaceHistory;
                            } else {
                                this.chart.currentHistory = null;
                            }
                            if (this.chart.liveUpdatesCmd.isSelected()) {
                                this.chart.liveUpdatesCmd.setSelected(false);
                                if (this.chart.currentHistory != null) {
                                    this.chart.liveUpdatesCmd.setSelected(true);
                                }
                            }
                            if (this.chart.currentHistory == null) {
                                this.chart.liveUpdatesCmd.setEnabled(false);
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    Logger.getLogger("history").log(Level.SEVERE, "Error in BHistoryChart::unsubscribe", ex);
                }
            }
        }
    }

    private static class State {
        BDynamicTimeRange timeRange;
        boolean deltaState;
        boolean liveUpdatesState;

        private State() {
        }
    }
}

