/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.naxisVideo.ui;

import com.tridium.videoDriver.ui.videoStream.decoder.GenericMjpegDecoder;
import com.tridium.videoDriver.videoStream.decoder.VidFrame;
import java.io.IOException;
import java.util.Calendar;
import javax.baja.nre.util.ByteBuffer;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BajaRuntimeException;

public class AxisVideoMjpegDecoder
extends GenericMjpegDecoder {
    private static final int BEGIN_AXIS_JPEG_COMMENT = 10;
    private static final int BEGIN_AXIS_TIMESTAMP_COMMENT = 1;

    protected void processJpegComment(VidFrame vf, byte[] buffer, int from, int len) {
        if (buffer != null) {
            ByteBuffer buf = new ByteBuffer(buffer);
            buf.seek(from);
            try {
                if (len > 0 && buf.read() == 10) {
                    if (len > 1 && buf.read() == 1) {
                        long axisCameraSecondsSinceEpochLocalTime = buf.readInt() & 0xFFFFFFFF;
                        int axisCameraFractionalHundredthSeconds = buf.read() & 0xFF;
                        int axisCameraFractionalMilliseconds = axisCameraFractionalHundredthSeconds * 10;
                        long axisCameraMillisSinceEpochLocalTime = axisCameraSecondsSinceEpochLocalTime * 1000L + (long)axisCameraFractionalMilliseconds;
                        Calendar javaCalendar = Calendar.getInstance();
                        long deltaFromUtc = javaCalendar.get(15) + javaCalendar.get(16);
                        long axisCameraMillisSinceEpochUtc = axisCameraMillisSinceEpochLocalTime - deltaFromUtc;
                        vf.timeIndex = BAbsTime.make((long)axisCameraMillisSinceEpochUtc);
                    }
                    super.processJpegComment(vf, buffer, from, len);
                }
                super.processJpegComment(vf, buffer, from, len);
            }
            catch (IOException ioe) {
                throw new BajaRuntimeException("Caught IOException while not even performing IO!!!", (Throwable)ioe);
            }
        } else {
            super.processJpegComment(vf, buffer, from, len);
        }
    }
}

