/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.util;

import com.lynxspring.px.editor.BOverrideSetPointFE;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.BEnumWritable;
import javax.baja.control.BNumericWritable;
import javax.baja.control.BStringWritable;
import javax.baja.control.util.BEnumOverride;
import javax.baja.control.util.BNumericOverride;
import javax.baja.control.util.BOverride;
import javax.baja.control.util.BStringOverride;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BIEnum;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BNumber;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BValueBinding;
import javax.baja.ui.BWidget;
import javax.baja.workbench.CannotSaveException;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="duration", type="BRelTime", defaultValue="BRelTime.makeMinutes(30)"), @NiagaraProperty(name="widgetEvent", type="String", defaultValue=""), @NiagaraProperty(name="widgetProperty", type="String", defaultValue="")})
public class BOverrideSetPointBinding
extends BValueBinding {
    public static final Property duration = BOverrideSetPointBinding.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)30), null);
    public static final Property widgetEvent = BOverrideSetPointBinding.newProperty((int)0, (String)"", null);
    public static final Property widgetProperty = BOverrideSetPointBinding.newProperty((int)0, (String)"", null);
    public static final Type TYPE = Sys.loadType(BOverrideSetPointBinding.class);

    public BRelTime getDuration() {
        return (BRelTime)this.get(duration);
    }

    public void setDuration(BRelTime v) {
        this.set(duration, (BValue)v, null);
    }

    public String getWidgetEvent() {
        return this.getString(widgetEvent);
    }

    public void setWidgetEvent(String v) {
        this.setString(widgetEvent, v, null);
    }

    public String getWidgetProperty() {
        return this.getString(widgetProperty);
    }

    public void setWidgetProperty(String v) {
        this.setString(widgetProperty, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean invokedOnWidget(Action action, BValue value, Context cx) {
        if (action.getName().equals(this.getWidgetEvent())) {
            this.saveOverride();
            return true;
        }
        return false;
    }

    public boolean firedOnWidget(Topic topic, BValue event, Context cx) {
        if (topic.getName().equals(this.getWidgetEvent())) {
            this.saveOverride();
            return true;
        }
        return false;
    }

    public boolean isDegraded() {
        return !this.isBound() || !this.getTarget().canWrite();
    }

    public void targetChanged() {
        super.targetChanged();
        this.loadOverride();
    }

    public void save(Context cx) throws Exception {
        if (!this.isBound()) {
            return;
        }
        BWidget widget = this.getWidget();
        if (widget instanceof BOverrideSetPointFE) {
            ((BOverrideSetPointFE)widget).saveOverride(this);
            return;
        }
    }

    public void loadOverride() {
        BWidget widget = this.getWidget();
        if (widget instanceof BOverrideSetPointFE) {
            ((BOverrideSetPointFE)widget).loadOverride(this);
            return;
        }
        Property prop = widget.getProperty(this.getWidgetProperty());
        if (prop == null) {
            return;
        }
        BValue w = widget.get(prop);
        if (!this.isBound()) {
            return;
        }
        BValue t = (BValue)this.get();
        BValue s = this.convert(t, w);
        if (s != null) {
            widget.set(prop, s);
        }
    }

    public void saveOverride() {
        BValue w = this.saveWidgetProperty();
        if (w == null) {
            return;
        }
        this.saveOverride(w);
    }

    public void saveOverride(BValue w) {
        if (!this.isBound()) {
            return;
        }
        try {
            if (this.saveAction(w)) {
                return;
            }
        }
        catch (CannotSaveException e) {
            return;
        }
        System.out.println("WARNING: No mechanism found to save " + this.getOrd());
    }

    BValue saveWidgetProperty() {
        BWidget widget = this.getWidget();
        Property prop = widget.getProperty(this.getWidgetProperty());
        if (prop == null) {
            return null;
        }
        return widget.get(prop);
    }

    private boolean saveAction(BValue v) throws CannotSaveException {
        block12: {
            BComponent c = this.getTarget().getComponent();
            try {
                if (c instanceof BBooleanWritable && v instanceof BBoolean) {
                    boolean newState;
                    boolean active = ((BBooleanWritable)c).getBoolean();
                    if (active == (newState = ((BBoolean)v).getBoolean())) {
                        return true;
                    }
                    BOverride dur = new BOverride();
                    dur.setDuration(this.getDuration());
                    if (newState) {
                        c.invoke(c.getAction("active"), (BValue)dur);
                    } else {
                        c.invoke(c.getAction("inactive"), (BValue)dur);
                    }
                    break block12;
                }
                Action action = c.getAction("override");
                this.verifyBounds(v, c.getSlotFacets((Slot)action));
                if (c instanceof BEnumWritable && v instanceof BDynamicEnum) {
                    if (((BEnumWritable)c).getEnum().getOrdinal() == ((BDynamicEnum)v).getOrdinal()) {
                        return true;
                    }
                    c.invoke(action, (BValue)new BEnumOverride(this.getDuration(), (BDynamicEnum)v));
                    break block12;
                }
                if (c instanceof BNumericWritable && v instanceof BDouble) {
                    if (((BNumericWritable)c).getNumeric() == ((BDouble)v).getDouble()) {
                        return true;
                    }
                    c.invoke(action, (BValue)new BNumericOverride(this.getDuration(), ((BDouble)v).getDouble()));
                    break block12;
                }
                if (c instanceof BStringWritable && v instanceof BString) {
                    if (((BStringWritable)c).getOut().getValue().equals(((BString)v).getString())) {
                        return true;
                    }
                    c.invoke(action, (BValue)new BStringOverride(this.getDuration(), ((BString)v).getString()));
                    break block12;
                }
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new CannotSaveException((Throwable)e);
            }
        }
        return true;
    }

    private void verifyBounds(BValue v, BFacets facets) throws CannotSaveException {
        if (facets == null) {
            return;
        }
        BNumber min = (BNumber)facets.get("min");
        BNumber max = (BNumber)facets.get("max");
        if (v instanceof BDouble) {
            double d = ((BDouble)v).getDouble();
            if (min != null && d < min.getDouble()) {
                throw new CannotSaveException();
            }
            if (max != null && d > max.getDouble()) {
                throw new CannotSaveException();
            }
        } else if (v instanceof BInteger) {
            int i = ((BInteger)v).getInt();
            if (min != null && i < min.getInt()) {
                throw new CannotSaveException();
            }
            if (max != null && i > max.getInt()) {
                throw new CannotSaveException();
            }
        }
    }

    public BValue convert(BValue from, BValue to) {
        double x;
        if (from.getType() == to.getType()) {
            return from;
        }
        if (from instanceof BINumeric && to instanceof BNumber) {
            x = ((BINumeric)from).getNumeric();
            switch (to.getType().getDataTypeSymbol()) {
                case 'i': {
                    return BInteger.make((int)((int)x));
                }
                case 'l': {
                    return BLong.make((long)((long)x));
                }
                case 'f': {
                    return BFloat.make((float)((float)x));
                }
                case 'd': {
                    return BDouble.make((double)((float)x));
                }
            }
        }
        if (from instanceof BINumeric && to instanceof BStatusNumeric) {
            x = ((BINumeric)from).getNumeric();
            return new BStatusNumeric(x);
        }
        if (from instanceof BIBoolean && to instanceof BBoolean) {
            return BBoolean.make((boolean)((BIBoolean)from).getBoolean());
        }
        if (from instanceof BIBoolean && to instanceof BStatusBoolean) {
            return new BStatusBoolean(((BIBoolean)from).getBoolean());
        }
        if (from instanceof BIEnum && to instanceof BDynamicEnum) {
            return ((BIEnum)from).getEnum();
        }
        if (from instanceof BIEnum && to instanceof BStatusEnum) {
            return new BStatusEnum(((BIEnum)from).getEnum());
        }
        if (from instanceof BString && to instanceof BStatusString) {
            return new BStatusString(((BString)from).getString());
        }
        System.out.println("WARNING: OverrideSetPointBinding convert " + from.getType() + " -> " + to.getType());
        return null;
    }
}

