/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.util;

import com.lynxspring.px.BTransferButton;
import com.lynxspring.util.BTransferFilter;
import com.tridium.gx.awt.ImageManager;
import com.tridium.ui.BOptionDialog;
import com.tridium.ui.file.BFilePreview;
import com.tridium.ui.file.BListView;
import com.tridium.ui.file.FileChooserModel;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.space.BSpace;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraAction(name="imageUploaded", parameterType="BString", defaultValue="BString.DEFAULT")
public class BImageChooserDialog
extends BOptionDialog {
    private static final Lexicon lex = Lexicon.make(BTransferButton.class);
    public static final Action imageUploaded = BImageChooserDialog.newAction((int)0, (BValue)BString.DEFAULT, null);
    public static final Type TYPE = Sys.loadType(BImageChooserDialog.class);
    BTransferButton upload;
    FileChooserModel model;
    BListView listView;
    BFilePreview preview;
    BFileSpace space;
    String dir;

    public void imageUploaded(BString arg) {
        this.invoke(imageUploaded, (BValue)arg, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BImageChooserDialog() {
    }

    public BImageChooserDialog(BFileSpace space, BWidget parent, BImage curImage) {
        this(space, "images", parent, lex.getText("upload.image.title"), curImage);
    }

    public BImageChooserDialog(BFileSpace space, BWidget parent, String title, BImage curImage) {
        this(space, "images", parent, title, curImage);
    }

    public BImageChooserDialog(BFileSpace space, String dir, BWidget parent, String title, BImage curImage) {
        super(parent, title, (BWidget)new BNullWidget(), 7, null, null);
        this.space = space;
        this.dir = dir;
        this.init(curImage);
    }

    public static BImage open(BFileSpace space, BWidget parent, BImage curImage) {
        return new BImageChooserDialog(space, parent, curImage).doOpen();
    }

    public static BImage open(BFileSpace space, BWidget parent, String title, BImage curImage) {
        return new BImageChooserDialog(space, parent, title, curImage).doOpen();
    }

    public static BImage open(BFileSpace space, String dir, BWidget parent, String title, BImage curImage) {
        return new BImageChooserDialog(space, dir, parent, title, curImage).doOpen();
    }

    public BImage doOpen() {
        this.open();
        return this.getImage();
    }

    public BImage getImage() {
        if (this.getResult() == 1 && this.model.getSelectedFiles().length > 0) {
            return BImage.make((BOrd)this.model.getSelectedFiles()[0].getAbsoluteOrd());
        }
        return BImage.NULL;
    }

    private void init(BImage current) {
        this.setContent(this.buildPopup());
        this.setBoundsCenteredOnOwner();
        this.upload = new BTransferButton();
        this.upload.setFilter(BImageChooserDialog.makeFilter());
        this.upload.setText(lex.getText("upload.image.label"));
        this.upload.setImage(BImage.make((String)lex.getText("upload.image.icon")));
        this.upload.setDestinationDirectory(BOrd.make((String)"file:^images"));
        this.upload.setMaxFileSize(200);
        this.upload.setBase((BObject)this.space);
        this.linkTo((BComponent)this.upload, (Slot)BTransferButton.fileUploaded, (Slot)imageUploaded);
        this.setYesButton(this.upload);
        if (current != null && current != BImage.NULL) {
            try {
                this.listView.select((BIFile)current.getAbsoluteOrdList().get(0).get((BObject)this.space));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private final BWidget buildPopup() {
        this.model = new FileChooserModel((BSpace)this.space);
        this.model.setSupport((FileChooserModel.Support)new FileChooserSupport());
        this.model.setFilter(BImageChooserDialog.makeFilter().getFilters()[0]);
        this.model.setDirectory(this.space.getNavChild(this.dir));
        this.listView = new BListView(this.model);
        this.preview = new BFilePreview(this.model);
        this.listView.setMultipleSelection(false);
        this.listView.setShowDirectories(false);
        BSplitPane split = new BSplitPane();
        split.setDividerPosition(40.0);
        split.setWidget1((BWidget)new BBorderPane((BWidget)this.listView, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        split.setWidget2((BWidget)new BBorderPane((BWidget)this.preview, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        BConstrainedPane pane = new BConstrainedPane((BWidget)split);
        pane.setMinSize(450.0, 325.0);
        return pane;
    }

    public void doImageUploaded(BString file) {
        ImageManager.trimAll();
        this.listView.populateChildren();
        this.listView.relayout();
        this.listView.repaint();
        String path = file.getString();
        path = path.substring(path.indexOf(94));
        this.listView.getSelection().deselectAll();
        this.listView.select(this.space.findFile(new FilePath(path)));
    }

    private static BTransferFilter makeFilter() {
        BTransferFilter filter = new BTransferFilter();
        filter.setExtensionFilterDescription(lex.getText("upload.image.extDesc"));
        filter.setExtensionFilterList(lex.getText("upload.image.extList"));
        return filter;
    }

    public BTransferButton getTransferButton() {
        return this.upload;
    }

    class FileChooserSupport
    extends FileChooserModel.Support {
        public void selectionModified() {
            BIFile[] abifile = BImageChooserDialog.this.model.getSelectedFiles();
            for (int i = 0; i < abifile.length; ++i) {
                BImageChooserDialog.this.listView.select(abifile[i]);
            }
            if (BImageChooserDialog.this.preview.isVisible()) {
                BImageChooserDialog.this.preview.relayout();
            }
        }
    }
}

