/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.ui.profile;

import com.tridium.fox.sys.broker.BFoxStationSpace;
import com.tridium.fox.sys.file.BFoxFileSpace;
import com.tridium.ui.theme.Theme;
import com.tridium.util.ThrowableUtil;
import com.tridium.workbench.bookmark.BookmarkEvents;
import com.tridium.workbench.shell.BNiagaraWbShell;
import com.tridium.workbench.shell.WbMain;
import java.util.HashMap;
import java.util.Set;
import javax.baja.file.BIFile;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavRoot;
import javax.baja.nav.NavEvent;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.BSpySpace;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BMenu;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.bookmark.BBookmark;
import javax.baja.ui.bookmark.BBookmarkFolder;
import javax.baja.ui.bookmark.BBookmarkOptions;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.list.BList;
import javax.baja.ui.list.DefaultListModel;
import javax.baja.ui.list.ListModel;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.pane.BTreePane;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.tree.BTree;
import javax.baja.ui.tree.TreeController;
import javax.baja.ui.tree.TreeModel;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.nav.tree.BNavTree;
import javax.baja.workbench.nav.tree.DefaultNavTreeModel;
import javax.baja.workbench.nav.tree.NavTreeController;
import javax.baja.workbench.nav.tree.NavTreeModel;
import javax.baja.workbench.nav.tree.NavTreeNode;
import javax.baja.workbench.nav.tree.NavTreeSubject;
import javax.baja.workbench.sidebar.BWbSideBar;

@NiagaraType
@NiagaraAction(name="updateTree")
public class BSimpleNavSideBar
extends BWbSideBar {
    public static final Action updateTree = BSimpleNavSideBar.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BSimpleNavSideBar.class);
    private static BImage errorIcon = BImage.make((String)"module://icons/x32/error.png");
    private static BImage newTreeIcon = BImage.make((String)"module://icons/x16/newFile.png");
    private static BImage closeIcon = BImage.make((String)"module://icons/x16/close.png");
    private static Lexicon lex = Lexicon.make((String)"workbench");
    private boolean init = false;
    private BEdgePane content;
    private BTreePane treePane;
    private BListDropDown openTrees;
    private Close close;
    private BNavTree tree;
    private BINavNode root;
    private boolean inError = false;
    private HashMap hash = new HashMap();

    public void updateTree() {
        this.invoke(updateTree, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        if (!this.init) {
            BOrd ord = this.getWbShell().getProfile().getNavRootOrd();
            this.root = (BINavNode)ord.resolve().get();
            this.loadNavTrees();
            this.openTrees.getList().setSelectedIndex(0);
            this.doUpdateTree();
            this.init = true;
        }
    }

    public void stopped() throws Exception {
        super.stopped();
    }

    public void activeViewChanged() {
        if (!this.inError) {
            return;
        }
        this.doUpdateTree();
    }

    public void goInto(BINavNode navnode) {
        BBookmarkOptions opt = this.getOptions();
        BBookmark mark = new BBookmark(navnode.getNavDisplayName(null), navnode.getNavOrd(), navnode.getNavIcon());
        this.getGoInto().add(null, (BValue)mark);
        opt.save();
        this.addTreeToList(mark);
        this.openTrees.getList().setSelectedIndex(this.openTrees.getList().getItemCount() - 1);
        this.doUpdateTree();
        BookmarkEvents.fireBookmarkChanged();
    }

    public void syncTree() {
        new SyncCommand((BWidget)this.tree).invoke();
    }

    public void bookmarkChanged() {
        int i = this.openTrees.getList().getSelectedIndex();
        this.loadNavTrees();
        BList list = this.openTrees.getList();
        Set set = this.hash.keySet();
        NavWrapper[] anav = set.toArray(new NavWrapper[set.size()]);
        block0: for (int j = 0; j < anav.length; ++j) {
            for (int k = 0; k < list.getItemCount(); ++k) {
                NavWrapper nav = (NavWrapper)list.getItem(k);
                if ((anav[j].bookmark.getName() != null || nav.bookmark.getName() != null) && !anav[j].bookmark.getName().equals(nav.bookmark.getName()) || !anav[j].bookmark.getBookmarkOrd().equals((Object)nav.bookmark.getBookmarkOrd())) continue;
                this.hash.put(nav, this.hash.remove(anav[j]));
                continue block0;
            }
        }
        if (i >= this.openTrees.getList().getItemCount()) {
            i = 0;
        }
        this.openTrees.getList().setSelectedIndex(i);
        this.doUpdateTree();
    }

    public void paint(Graphics g) {
        super.paint(g);
        g.setBrush(BColor.black);
        g.strokeRect(0.0, 0.0, this.getWidth() - 1.0, this.getHeight() - 1.0);
    }

    public void doUpdateTree() {
        this.inError = false;
        NavWrapper nav = (NavWrapper)this.openTrees.getSelectedItem();
        this.close.setEnabled(nav.isRoot ^ true);
        try {
            Object obj = (NavTreeModel)this.hash.get(nav);
            if (obj == null) {
                BNiagaraWbShell shell = (BNiagaraWbShell)this.getWbShell();
                BOrd ord1 = nav.bookmark.getBookmarkOrd();
                BObject bobj = this.openTrees.getSelectedIndex() != 0 ? shell.resolve(ord1, null).get() : ord1.resolve().get();
                nav.bookmark.setIcon(bobj.getIcon());
                obj = new Model((BINavNode)bobj);
                this.hash.put(nav, obj);
            } else {
                BOrd ord = nav.bookmark.getBookmarkOrd();
                try {
                    ord.resolve(null);
                }
                catch (Exception exception1) {
                    this.hash.remove(nav);
                    BNiagaraWbShell shell1 = (BNiagaraWbShell)this.getWbShell();
                    BObject bobj1 = shell1.resolve(ord, null).get();
                    obj = new Model((BINavNode)bobj1);
                    this.hash.put(nav, obj);
                }
            }
            this.tree.setModel((TreeModel)obj);
            this.tree.relayout();
            if (!(this.content.getCenter() instanceof BTreePane)) {
                this.content.setCenter((BWidget)this.treePane);
            }
        }
        catch (Exception exception) {
            this.hash.remove(nav);
            this.displayError(nav.bookmark.getText(), exception);
        }
    }

    private final void displayError(String s, Exception exception) {
        this.inError = true;
        BGridPane grid = new BGridPane(1);
        grid.setRowGap(1.0);
        grid.add(null, (BValue)new BLabel(lex.getText("NavSideBar.couldNotFind"), Theme.widget().getBoldText()));
        grid.add(null, (BValue)new BLabel(s));
        BGridPane grid1 = new BGridPane(2);
        grid1.add(null, (BValue)new BLabel(errorIcon, ""));
        grid1.add(null, (BValue)grid);
        BGridPane grid2 = new BGridPane(1);
        grid2.setRowGap(5.0);
        grid2.setColumnAlign(BHalign.center);
        grid2.add(null, (BValue)grid1);
        grid2.add(null, (BValue)new BButton((Command)new Details((BWidget)this, s, exception)));
        this.content.setCenter((BWidget)grid2);
    }

    public BBookmarkOptions getOptions() {
        return BBookmarkOptions.make();
    }

    public BBookmarkFolder getGoInto() {
        BBookmarkFolder into = (BBookmarkFolder)this.getOptions().getRootFolder().get("goInto");
        if (into == null) {
            into = new BBookmarkFolder("Go Into");
            this.getOptions().getRootFolder().add("goInto", (BValue)into);
        }
        return into;
    }

    private final void loadNavTrees() {
        this.openTrees.getList().removeAllItems();
        this.openTrees.getList().addItem((Object)new NavWrapper(this.makeRoot(), true));
        BBookmarkFolder into = this.getGoInto();
        BBookmark[] marks = (BBookmark[])into.getChildren(BBookmark.class);
        for (int i = 0; i < marks.length; ++i) {
            this.addTreeToList(marks[i]);
        }
    }

    private final BBookmark makeRoot() {
        BNavRoot obj = this.root != null ? this.root : BNavRoot.INSTANCE;
        BBookmark mark = new BBookmark(((BINavNode)obj).getNavDisplayName(null), ((BINavNode)obj).getNavOrd(), ((BINavNode)obj).getNavIcon());
        return mark;
    }

    private final void addTreeToList(BBookmark mark) {
        NavWrapper nav = new NavWrapper(mark);
        this.openTrees.getList().addItem(BImage.make((BIcon)mark.getIcon()), (Object)nav);
    }

    public BSimpleNavSideBar() {
        this.tree = new BNavTree();
        this.tree.setMultipleSelection(true);
        this.tree.setController((TreeController)new Controller());
        this.openTrees = new BListDropDown();
        this.openTrees.getList().setModel((ListModel)new NavListModel());
        this.linkTo(null, (BComponent)this.openTrees, (Slot)BListDropDown.listActionPerformed, (Slot)updateTree);
        BButton button = new BButton((Command)new NewTree((BWidget)this), false, true);
        this.close = new Close((BWidget)this);
        BButton button1 = new BButton((Command)this.close, false, true);
        button.setButtonStyle(BButtonStyle.toolBar);
        button.setFocusTraversable(false);
        button1.setButtonStyle(BButtonStyle.toolBar);
        button1.setFocusTraversable(false);
        BGridPane grid = new BGridPane(3);
        grid.setColumnAlign(BHalign.fill);
        grid.setRowAlign(BValign.fill);
        grid.add(null, (BValue)button);
        grid.add(null, (BValue)button1);
        BEdgePane edge = new BEdgePane();
        edge.setLeft((BWidget)grid);
        edge.setCenter((BWidget)new BBorderPane((BWidget)this.openTrees, 0.0, 0.0, 0.0, 5.0));
        this.treePane = new BTreePane((BTree)this.tree);
        this.content = new BEdgePane();
        this.content.setTop((BWidget)new BBorderPane((BWidget)edge, 5.0, 5.0, 5.0, 5.0));
        this.content.setCenter((BWidget)this.treePane);
        this.setContent((BWidget)this.content);
    }

    class RefreshCommand
    extends Command {
        public CommandArtifact doInvoke() throws Exception {
            Model model = (Model)BSimpleNavSideBar.this.tree.getModel();
            model.setRootVisible(true);
            NavTreeNode treenode = (NavTreeNode)model.getRoot(0);
            model.setRootVisible(false);
            treenode.refresh();
            return null;
        }

        RefreshCommand(BWidget bwidget) {
            super(bwidget, UiLexicon.bajaui.module, "tree.refresh");
        }
    }

    class GoIntoCommand
    extends Command {
        BSimpleNavSideBar owner;
        NavTreeNode node;

        public CommandArtifact doInvoke() throws Exception {
            this.owner.goInto(this.node.getNavNode());
            return null;
        }

        GoIntoCommand(BSimpleNavSideBar bar, NavTreeNode treenode) {
            super((BWidget)bar, UiLexicon.bajaui.module, "tree.goInto");
            this.owner = bar;
            this.node = treenode;
        }
    }

    class NewTree
    extends Command {
        private int count;

        public BImage getIcon() {
            return newTreeIcon;
        }

        public CommandArtifact doInvoke() {
            BBookmarkOptions opt = BSimpleNavSideBar.this.getOptions();
            BBookmark mark = BSimpleNavSideBar.this.makeRoot();
            mark.setText(mark.getText() + " (" + this.count++ + ')');
            BSimpleNavSideBar.this.getGoInto().add(null, (BValue)mark);
            opt.save();
            BSimpleNavSideBar.this.addTreeToList(mark);
            BSimpleNavSideBar.this.openTrees.getList().setSelectedIndex(BSimpleNavSideBar.this.openTrees.getList().getItemCount() - 1);
            BSimpleNavSideBar.this.doUpdateTree();
            BookmarkEvents.fireBookmarkChanged();
            return null;
        }

        public NewTree(BWidget bwidget) {
            super(bwidget, lex.getText("NavSideBar.newTree"));
            this.count = 1;
        }
    }

    class NavListModel
    extends DefaultListModel {
        public BImage getItemIcon(int i) {
            NavWrapper nav = (NavWrapper)this.getItem(i);
            return BImage.make((BIcon)nav.bookmark.getIcon());
        }

        NavListModel() {
        }
    }

    class Controller
    extends NavTreeController {
        protected BMenu makePopup(NavTreeSubject subj) {
            BMenu bmenu = super.makePopup(subj);
            BNavTree tree = (BNavTree)this.getTree();
            if (tree.getReadonly()) {
                return null;
            }
            if (subj.size() == 0) {
                if (bmenu == null) {
                    bmenu = new BMenu();
                }
                BSimpleNavSideBar bSimpleNavSideBar = BSimpleNavSideBar.this;
                ((Object)((Object)bSimpleNavSideBar)).getClass();
                bmenu.add(null, (Command)bSimpleNavSideBar.new RefreshCommand((BWidget)tree));
                BSimpleNavSideBar bSimpleNavSideBar2 = BSimpleNavSideBar.this;
                ((Object)((Object)bSimpleNavSideBar2)).getClass();
                bmenu.add(null, (Command)bSimpleNavSideBar2.new SyncCommand((BWidget)tree));
                return bmenu;
            }
            NavTreeNode treenode = (NavTreeNode)subj.getActiveNode();
            if (subj.size() == 1 && treenode != null && !(treenode.getNavNode() instanceof BSpySpace)) {
                if (bmenu == null) {
                    bmenu = new BMenu();
                }
                BSimpleNavSideBar bSimpleNavSideBar = BSimpleNavSideBar.this;
                ((Object)((Object)bSimpleNavSideBar)).getClass();
                bmenu.add(null, (Command)bSimpleNavSideBar.new GoIntoCommand(BSimpleNavSideBar.this, treenode));
            }
            return bmenu;
        }

        Controller() {
        }
    }

    class Details
    extends Command {
        private Exception e;

        public CommandArtifact doInvoke() {
            BTextEditor btexteditor = new BTextEditor(ThrowableUtil.dumpToString((Throwable)this.e), false);
            BTextEditorPane btexteditorpane = new BTextEditorPane(btexteditor, 25, 80);
            BDialog.open((BWidget)this.getOwner(), (String)lex.getText("NavSideBar.details"), (Object)btexteditorpane, (int)1);
            return null;
        }

        public Details(BWidget bwidget, String s, Exception exception) {
            super(bwidget, lex.getText("NavSideBar.details"));
            this.e = exception;
        }
    }

    class Model
    extends DefaultNavTreeModel {
        protected void added(NavEvent event) {
            super.added(event);
            this.updateAll(event);
        }

        protected void removed(NavEvent event) {
            NavWrapper nav = (NavWrapper)BSimpleNavSideBar.this.openTrees.getSelectedItem();
            BOrd ord = nav.bookmark.getBookmarkOrd();
            if (WbMain.isRemoved((NavEvent)event, (BOrd)ord)) {
                BSimpleNavSideBar.this.displayError(nav.bookmark.getText(), new Exception("Parent node removed"));
                BSimpleNavSideBar.this.hash.remove(nav);
            } else {
                super.removed(event);
                this.updateAll(event);
            }
        }

        protected void reordered(NavEvent event) {
            super.reordered(event);
            this.updateAll(event);
        }

        private final void updateAll(NavEvent event) {
            if (this != BSimpleNavSideBar.this.hash.get(BSimpleNavSideBar.this.openTrees.getSelectedItem())) {
                return;
            }
            for (int i = 0; i < BSimpleNavSideBar.this.openTrees.getList().getItemCount(); ++i) {
                NavWrapper nav = (NavWrapper)BSimpleNavSideBar.this.openTrees.getList().getItem(i);
                NavTreeModel navmodel = (NavTreeModel)BSimpleNavSideBar.this.hash.get(nav);
                if (navmodel == null || this == navmodel) continue;
                navmodel.navEvent(event);
            }
        }

        public NavTreeNode makeNavTreeNode(NavTreeNode treenode, BINavNode navnode) {
            if (navnode instanceof BSpySpace) {
                return null;
            }
            if (navnode instanceof BFoxFileSpace) {
                return null;
            }
            if (navnode instanceof BFoxStationSpace) {
                return null;
            }
            if (navnode instanceof BIFile && navnode.getNavName().endsWith(".lock")) {
                return null;
            }
            return super.makeNavTreeNode(treenode, navnode);
        }

        public Model(BINavNode navnode) {
            super(navnode);
        }
    }

    class Close
    extends Command {
        public BImage getIcon() {
            return closeIcon;
        }

        public CommandArtifact doInvoke() {
            NavWrapper nav = (NavWrapper)BSimpleNavSideBar.this.openTrees.getList().getSelectedItem();
            nav.bookmark.getParent().asComponent().remove((BComplex)nav.bookmark);
            BSimpleNavSideBar.this.getOptions().save();
            BSimpleNavSideBar.this.openTrees.getList().removeItem((Object)nav);
            BSimpleNavSideBar.this.hash.remove(nav);
            BSimpleNavSideBar.this.openTrees.getList().setSelectedIndex(0);
            BSimpleNavSideBar.this.doUpdateTree();
            BookmarkEvents.fireBookmarkChanged();
            return null;
        }

        public Close(BWidget bwidget) {
            super(bwidget, lex.getText("NavSideBar.closeTree"));
        }
    }

    class NavWrapper {
        public BBookmark bookmark;
        public boolean isRoot = false;

        public String toString() {
            return this.bookmark.getText();
        }

        public NavWrapper(BBookmark mark) {
            this(mark, false);
        }

        public NavWrapper(BBookmark mark, boolean flag) {
            this.bookmark = mark;
            this.isRoot = flag;
        }
    }

    class SyncCommand
    extends Command {
        public CommandArtifact doInvoke() {
            try {
                BObject bobj = BSimpleNavSideBar.this.getWbShell().getActiveOrdTarget().get();
                BSimpleNavSideBar.this.tree.expandToNavNode((BINavNode)bobj);
            }
            catch (Exception exception) {
                BGridPane grid = new BGridPane(1);
                grid.setHalign(BHalign.left);
                grid.add(null, (BValue)new BLabel(lex.getText("NavSideBar.nodeNotFound")));
                grid.add(null, (BValue)new BLabel(BSimpleNavSideBar.this.getWbShell().getActiveOrd().toString()));
                BDialog.open((BWidget)this.getOwner(), (String)BDialog.TITLE_ERROR, (Object)grid, (int)1, (BImage)BDialog.ERROR_ICON, (Throwable)exception);
            }
            return null;
        }

        SyncCommand(BWidget bwidget) {
            super(bwidget, UiLexicon.bajaui.module, "tree.sync");
        }
    }
}

