/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.px.editor;

import com.tridium.ui.theme.Theme;
import java.io.IOException;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BInsets;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="visibleRows", type="int", defaultValue="10", facets={@Facet(value="BFacets.make(BFacets.MIN, BInteger.make(0))")}), @NiagaraProperty(name="visibleColumns", type="int", defaultValue="40", facets={@Facet(value="BFacets.make(BFacets.MIN, BInteger.make(0))")}), @NiagaraProperty(name="replaceCarriageReturns", type="String", defaultValue=";", facets={@Facet(value="BFacets.make(BFacets.MAX, BInteger.make(1))")})})
public class BMultiLineValueEditor
extends BWbFieldEditor {
    public static final Property visibleRows = BMultiLineValueEditor.newProperty((int)0, (int)10, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0)));
    public static final Property visibleColumns = BMultiLineValueEditor.newProperty((int)0, (int)40, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0)));
    public static final Property replaceCarriageReturns = BMultiLineValueEditor.newProperty((int)0, (String)";", (BFacets)BFacets.make((String)"max", (BIDataValue)BInteger.make((int)1)));
    public static final Type TYPE = Sys.loadType(BMultiLineValueEditor.class);

    public int getVisibleRows() {
        return this.getInt(visibleRows);
    }

    public void setVisibleRows(int v) {
        this.setInt(visibleRows, v, null);
    }

    public int getVisibleColumns() {
        return this.getInt(visibleColumns);
    }

    public void setVisibleColumns(int v) {
        this.setInt(visibleColumns, v, null);
    }

    public String getReplaceCarriageReturns() {
        return this.getString(replaceCarriageReturns);
    }

    public void setReplaceCarriageReturns(String v) {
        this.setString(replaceCarriageReturns, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BMultiLineValueEditor() {
        this.linkTo("linkA", (BComponent)this.getEditor(), (Slot)BTextEditor.textModified, (Slot)setModified);
    }

    public void changed(Property p, Context cx) {
        if (p == visibleRows) {
            this.getPane().setVisibleRows(this.getVisibleRows());
        } else if (p == visibleColumns) {
            this.getPane().setVisibleColumns(this.getVisibleColumns());
        }
    }

    protected void doSetReadonly(boolean readonly) {
        this.getEditor().setEditable(!readonly);
    }

    protected void doLoadValue(BObject value, Context context) {
        try {
            String fixed = value.asSimple().encodeToString();
            if (this.getReplaceCarriageReturns().length() > 0) {
                BInsets insets = Theme.textEditorPane().getInsets();
                double cellWidth = this.getEditor().getRenderer().getColumnWidth(null, 0);
                int visibleColumns = (int)((this.getWidth() - insets.left - insets.right) / cellWidth);
                char c = this.getReplaceCarriageReturns().charAt(0);
                String[] list = TextUtil.split((String)fixed, (char)c);
                fixed = "";
                int length = 0;
                if (list.length > 0) {
                    length = list[0].length() + 1;
                }
                for (int i = 0; i < list.length; ++i) {
                    if (length + list[i].length() >= visibleColumns) {
                        fixed = fixed + '\n';
                        length = list[i].length() + 1;
                    } else if (fixed.length() > 0) {
                        fixed = fixed + c;
                        length += list[i].length() + 1;
                    }
                    fixed = fixed + list[i];
                }
            }
            this.getEditor().setText(fixed);
        }
        catch (IOException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        String str = this.getEditor().getText();
        if (this.getReplaceCarriageReturns().length() > 0) {
            char c = this.getReplaceCarriageReturns().charAt(0);
            str = TextUtil.replace((String)TextUtil.join((String[])TextUtil.split((String)str, (char)'\n'), (char)c), (String)("" + c + c), (String)("" + c));
        }
        try {
            return value.asSimple().decodeFromString(str);
        }
        catch (IOException e) {
            Object[] args = new Object[]{str, value.getType()};
            String msg = UiLexicon.bajaui().getText("defaultSimplePlugin.error", args);
            throw new CannotSaveException(msg);
        }
    }

    private BTextEditorPane getPane() {
        if (!(this.getContent() instanceof BTextEditorPane)) {
            this.setContent((BWidget)new BTextEditorPane());
        }
        return (BTextEditorPane)this.getContent();
    }

    private BTextEditor getEditor() {
        return (BTextEditor)this.getPane().getContent();
    }
}

