/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.px.editor;

import com.lynxspring.util.BImageChooserDialog;
import javax.baja.file.BFileSpace;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="maxFileSize", type="int", defaultValue="100"), @NiagaraProperty(name="destinationDirectory", type="BOrd", defaultValue="BOrd.make(\"file:^images\")"), @NiagaraProperty(name="forcedFileName", type="String", defaultValue="")})
public class BImageUploadFE
extends BWbFieldEditor {
    private static final Lexicon lex = Lexicon.make(BImageUploadFE.class);
    public static final Property maxFileSize = BImageUploadFE.newProperty((int)0, (int)100, null);
    public static final Property destinationDirectory = BImageUploadFE.newProperty((int)0, (BValue)BOrd.make((String)"file:^images"), null);
    public static final Property forcedFileName = BImageUploadFE.newProperty((int)0, (String)"", null);
    public static final Type TYPE = Sys.loadType(BImageUploadFE.class);
    private BFileSpace base;
    private BImage image;
    private BLabel preview;

    public int getMaxFileSize() {
        return this.getInt(maxFileSize);
    }

    public void setMaxFileSize(int v) {
        this.setInt(maxFileSize, v, null);
    }

    public BOrd getDestinationDirectory() {
        return (BOrd)this.get(destinationDirectory);
    }

    public void setDestinationDirectory(BOrd v) {
        this.set(destinationDirectory, (BValue)v, null);
    }

    public String getForcedFileName() {
        return this.getString(forcedFileName);
    }

    public void setForcedFileName(String v) {
        this.setString(forcedFileName, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void loadValue(BFileSpace base, BObject value, Context cx) {
        this.base = base;
        super.loadValue(value, cx);
    }

    public BObject doSaveValue(BObject value, Context cx) {
        return BImage.make((BOrd)this.image.getOrdList().get(0).relativizeToSession());
    }

    protected void doLoadValue(BObject value, Context cx) throws Exception {
        this.loadImage((BImage)value);
    }

    private void loadImage(BImage image) {
        this.image = image;
        image.setBaseOrd(this.getCurrentValueSession().getAbsoluteOrd());
        this.preview.setImage(image);
        this.preview.relayout();
        this.preview.repaint();
        this.preview.getParentWidget().repaint();
    }

    public BImageUploadFE() {
        BGridPane pane = new BGridPane(1);
        pane.add(null, (BValue)new BButton((Command)new NewImage()));
        this.preview = new BLabel();
        pane.add(null, (BValue)this.preview);
        this.setContent((BWidget)pane);
    }

    private class NewImage
    extends Command {
        public NewImage() {
            super((BWidget)BImageUploadFE.this, lex, "select.image");
        }

        public CommandArtifact doInvoke() {
            BImageChooserDialog dlg = new BImageChooserDialog(BImageUploadFE.this.base, (BWidget)BImageUploadFE.this, BImageUploadFE.this.image);
            dlg.getTransferButton().setMaxFileSize(BImageUploadFE.this.getMaxFileSize());
            dlg.getTransferButton().setDestinationDirectory(BImageUploadFE.this.getDestinationDirectory());
            dlg.getTransferButton().setForcedFileName(BImageUploadFE.this.getForcedFileName());
            BImage chosen = dlg.doOpen();
            if (chosen != BImage.NULL) {
                if (!BImageUploadFE.this.image.getAbsoluteOrdList().equivalent((Object)chosen.getAbsoluteOrdList())) {
                    BImageUploadFE.this.setModified();
                }
                BImageUploadFE.this.loadImage(chosen);
            }
            return null;
        }
    }
}

