/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.px.bindings;

import com.lynxspring.px.BHistoryTable;
import com.lynxspring.px.BLynxChartParameterSelector;
import com.lynxspring.px.bindings.BLynxParameterTableBinding;
import com.tridium.bql.util.BDynamicTimeRange;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Sys;
import javax.baja.ui.BWidget;
import javax.baja.workbench.view.BWbView;

public class LynxParameterTableBindingImpl {
    BComponent parent;
    BLynxParameterTableBinding binding;

    public BOrd getOrd(BOrd ord) {
        if (this.binding.getWidget() instanceof BHistoryTable) {
            BComponent parent = (BComponent)this.binding.getWidget().getParent();
            BLynxChartParameterSelector selector = null;
            if (parent != null) {
                BComponent[] kids = (BComponent[])parent.getChildren(BComponent.class);
                for (int i = 0; i < kids.length; ++i) {
                    if (!(kids[i] instanceof BLynxChartParameterSelector)) continue;
                    selector = (BLynxChartParameterSelector)kids[i];
                }
            }
            long interval = 86400000L;
            if (selector != null) {
                String out;
                if (selector.getRange().equals((Object)BDynamicTimeRange.LAST_24_HOURS)) {
                    interval = 600000L;
                } else if (selector.getRange().equals((Object)BDynamicTimeRange.LAST_7_DAYS)) {
                    interval = 900000L;
                } else if (selector.getRange().equals((Object)BDynamicTimeRange.LAST_MONTH)) {
                    interval = 3600000L;
                } else if (selector.getRange().equals((Object)BDynamicTimeRange.LAST_WEEK)) {
                    interval = 900000L;
                } else if (selector.getRange().equals((Object)BDynamicTimeRange.LAST_WEEK)) {
                    interval = 900000L;
                } else if (selector.getRange().equals((Object)BDynamicTimeRange.LAST_YEAR)) {
                    interval = 86400000L;
                } else if (selector.getRange().equals((Object)BDynamicTimeRange.MONTH_TO_DATE)) {
                    interval = 1800000L;
                } else if (selector.getRange().equals((Object)BDynamicTimeRange.TODAY)) {
                    interval = 300000L;
                } else if (selector.getRange().equals((Object)BDynamicTimeRange.WEEK_TO_DATE)) {
                    interval = 600000L;
                } else if (selector.getRange().equals((Object)BDynamicTimeRange.YEAR_TO_DATE)) {
                    interval = 86400000L;
                } else if (selector.getRange().equals((Object)BDynamicTimeRange.YESTERDAY)) {
                    interval = 300000L;
                } else {
                    BAbsTime start = selector.getRange().getFixedStartTime();
                    BAbsTime end = selector.getRange().getFixedEndTime();
                    BRelTime duration = start.delta(end);
                    interval = 300000L;
                    if (duration.abs().getMillis() > 86400000L) {
                        interval = 900000L;
                    } else if (duration.abs().getMillis() > 2592000000L) {
                        interval = 86400000L;
                    }
                }
                if (!ord.isNull() && !TextUtil.replace((String)ord.encodeToString(), (String)"history:", (String)"").startsWith("/")) {
                    out = TextUtil.replace((String)ord.encodeToString(), (String)"history:", (String)("history:/" + this.getDeviceName() + "/"));
                    out = out + "?" + selector.getRange().toOrdParams() + "|bql:historyFunc:HistoryRollup.rollup(baja:RelTime '" + interval + "')|bql:select timestamp, endTimestamp, min, max, avg";
                    ord = BOrd.make((String)out);
                    return ord;
                }
                out = ord.encodeToString();
                out = out + "?" + selector.getRange().toOrdParams() + "|bql:historyFunc:HistoryRollup.rollup(baja:RelTime '" + interval + "')|bql:select timestamp, endTimestamp, min, max, avg";
                ord = BOrd.make((String)out);
                return ord;
            }
        }
        return ord;
    }

    private String getDeviceName() {
        if (this.parent != null) {
            return this.parent.getName();
        }
        BWbView view = LynxParameterTableBindingImpl.getMainView(this.binding.getWidget());
        if (view == null) {
            return "NOT_UNDER_WBVIEW";
        }
        if (view.getCurrentValue() == null) {
            return "NO_CURRENT_VALUE_ON_VIEW";
        }
        if (view.getCurrentValue().isComponent()) {
            this.parent = view.getCurrentValue().asComponent();
        }
        while (this.parent != null && !this.parent.getType().is(Sys.getType((String)"driver:Device"))) {
            this.parent = this.parent.getParent().asComponent();
        }
        if (this.parent != null) {
            return this.parent.getName();
        }
        return "NOT_UNDER_DEVICE";
    }

    public static BWbView getMainView(BWidget wid) {
        BWbView view = null;
        for (BWidget tmp = wid; tmp != null; tmp = tmp.getParent()) {
            if (!(tmp instanceof BWbView)) continue;
            view = (BWbView)tmp;
        }
        return view;
    }

    public LynxParameterTableBindingImpl(BLynxParameterTableBinding binding) {
        this.binding = binding;
    }
}

