/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.px.bindings;

import com.tridium.kitpx.BPopupBinding;
import com.tridium.kitpx.BPopupProfile;
import com.tridium.ui.UiEnv;
import com.tridium.workbench.shell.BNiagaraWbDialog;
import java.lang.reflect.InvocationTargetException;
import javax.baja.gx.BPoint;
import javax.baja.gx.BSize;
import javax.baja.history.ext.BHistoryExt;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBinding;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.util.Lexicon;
import javax.baja.virtual.BVirtualComponent;
import javax.baja.workbench.BWbShell;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="title", type="String", defaultValue="Pop up"), @NiagaraProperty(name="position", type="BPoint", defaultValue="BPoint.make(100, 100)"), @NiagaraProperty(name="size", type="BSize", defaultValue="BSize.make(800, 600)"), @NiagaraProperty(name="modal", type="boolean", defaultValue="false")})
@NiagaraAction(name="mouseEvent", parameterType="BMouseEvent", defaultValue="new BMouseEvent()")
public class BLynxPointHistoryPopupBinding
extends BBinding {
    public static final Property title = BLynxPointHistoryPopupBinding.newProperty((int)0, (String)"Pop up", null);
    public static final Property position = BLynxPointHistoryPopupBinding.newProperty((int)0, (BValue)BPoint.make((double)100.0, (double)100.0), null);
    public static final Property size = BLynxPointHistoryPopupBinding.newProperty((int)0, (BValue)BSize.make((double)800.0, (double)600.0), null);
    public static final Property modal = BLynxPointHistoryPopupBinding.newProperty((int)0, (boolean)false, null);
    public static final Action mouseEvent = BLynxPointHistoryPopupBinding.newAction((int)0, (BValue)new BMouseEvent(), null);
    public static final Type TYPE = Sys.loadType(BLynxPointHistoryPopupBinding.class);
    private MouseCursor restoreCursor;
    private boolean isOver = false;
    private static final Lexicon lex = Lexicon.make(BPopupBinding.class);

    public String getTitle() {
        return this.getString(title);
    }

    public void setTitle(String v) {
        this.setString(title, v, null);
    }

    public BPoint getPosition() {
        return (BPoint)this.get(position);
    }

    public void setPosition(BPoint v) {
        this.set(position, (BValue)v, null);
    }

    public BSize getSize() {
        return (BSize)this.get(size);
    }

    public void setSize(BSize v) {
        this.set(size, (BValue)v, null);
    }

    public boolean getModal() {
        return this.getBoolean(modal);
    }

    public void setModal(boolean v) {
        this.setBoolean(modal, v, null);
    }

    public void mouseEvent(BMouseEvent event) {
        this.invoke(mouseEvent, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        if (this.getWidget() != null) {
            this.linkTo((BComponent)this.getWidget(), (Slot)BWidget.mouseEvent, (Slot)mouseEvent);
        }
        super.started();
    }

    public void doMouseEvent(BMouseEvent event) {
        if (!this.getWidget().isEnabled()) {
            return;
        }
        switch (event.getId()) {
            case 504: {
                this.entered(event);
                break;
            }
            case 505: {
                this.exited(event);
                break;
            }
            case 502: {
                this.released(event);
            }
        }
    }

    private void entered(BMouseEvent event) {
        BWidgetShell shell = this.getShell();
        this.isOver = true;
        if (shell != null) {
            shell.showStatus(this.toShowStatus());
            this.restoreCursor = !this.getOrd().isNull() && UiEnv.get().hasMouse() ? this.getWidget().setMouseCursor(MouseCursor.hand) : null;
        }
    }

    private void exited(BMouseEvent event) {
        BWidgetShell shell = this.getShell();
        this.isOver = false;
        if (shell != null) {
            shell.showStatus("");
        }
        if (this.restoreCursor != null) {
            this.getWidget().setMouseCursor(this.restoreCursor);
        }
    }

    private void released(BMouseEvent event) {
        if (this.isOver && !this.getOrd().isNull() && event.isButton1Down()) {
            this.popup();
        }
    }

    String toShowStatus() {
        BOrd ord = this.getOrd();
        if (ord.isNull()) {
            return "";
        }
        return lex.getText("popupBinding.summary") + " " + ord;
    }

    private void popup() {
        try {
            BWbShell shell = BWbShell.getWbShell((BWidget)this.getWidget());
            BOrd o = BOrd.make((BOrd)shell.getActiveOrd(), (BOrd)this.getOrd()).normalize();
            if (o.toString().endsWith("/out/value")) {
                o = BOrd.make((String)o.toString().substring(0, o.toString().length() - 10));
            }
            BObject obj = o.resolve((BObject)BWbShell.getApplication().getSession()).get();
            BOrd outOrd = null;
            if (obj instanceof BHistoryExt) {
                BHistoryExt ext = (BHistoryExt)obj;
                ext.lease(1);
                outOrd = BOrd.make((String)("history:" + ext.getHistoryConfig().getId().encodeToString()));
            } else if (obj instanceof BComponent) {
                BHistoryExt[] exts;
                BComponent c = (BComponent)obj;
                if (c instanceof BVirtualComponent) {
                    String cTypeSpec = (String)c.getClass().getMethod("getNiagaraVirtualCompInfo", null).invoke((Object)c, null).getClass().getMethod("getTypeSpec", null).invoke(c.getClass().getMethod("getNiagaraVirtualCompInfo", null).invoke((Object)c, null), null);
                    if (cTypeSpec.startsWith("control")) {
                        BINavNode[] n = c.getNavChildren();
                        for (int i = 0; i < n.length; ++i) {
                            ((BVirtualComponent)n[i]).lease(2);
                            String niTypeSpec = (String)n[i].getClass().getMethod("getNiagaraVirtualCompInfo", null).invoke((Object)n[i], null).getClass().getMethod("getTypeSpec", null).invoke(n[i].getClass().getMethod("getNiagaraVirtualCompInfo", null).invoke((Object)n[i], null), null);
                            if (!niTypeSpec.startsWith("history")) continue;
                            BINavNode[] historyExtSlots = n[i].getNavChildren();
                            for (int s = 0; s < historyExtSlots.length; ++s) {
                                BVirtualComponent cc = (BVirtualComponent)historyExtSlots[s];
                                cc.lease(2);
                                String ccTypeSpec = (String)cc.getClass().getMethod("getNiagaraVirtualCompInfo", null).invoke((Object)cc, null).getClass().getMethod("getTypeSpec", null).invoke(cc.getClass().getMethod("getNiagaraVirtualCompInfo", null).invoke((Object)cc, null), null);
                                if (!ccTypeSpec.equals("history:HistoryConfig")) continue;
                                DialogThread thread = new DialogThread(cc);
                                thread.run();
                                return;
                            }
                        }
                    } else if (cTypeSpec.startsWith("history")) {
                        BINavNode[] historyExtSlots = c.getNavChildren();
                        for (int s = 0; s < historyExtSlots.length; ++s) {
                            BVirtualComponent cc = (BVirtualComponent)historyExtSlots[s];
                            cc.lease(2);
                            String ccTypeSpec = (String)cc.getClass().getMethod("getNiagaraVirtualCompInfo", null).invoke((Object)cc, null).getClass().getMethod("getTypeSpec", null).invoke(cc.getClass().getMethod("getNiagaraVirtualCompInfo", null).invoke((Object)cc, null), null);
                            if (!ccTypeSpec.equals("history:HistoryConfig")) continue;
                            DialogThread thread = new DialogThread(cc);
                            thread.run();
                            return;
                        }
                    }
                }
                if ((exts = (BHistoryExt[])c.getChildren(BHistoryExt.class)).length > 0) {
                    exts[0].lease(1);
                    outOrd = BOrd.make((String)("history:" + exts[0].getHistoryConfig().getId().encodeToString()));
                }
            }
            if (outOrd != null) {
                outOrd = BOrd.make((BOrd)shell.getActiveOrd(), outOrd).normalize();
                BNiagaraWbDialog dlg = new BNiagaraWbDialog(BPopupProfile.TYPE, (BWidget)shell, outOrd, this.getTitle(), this.getPosition(), this.getSize(), this.getModal());
                dlg.open();
            }
        }
        catch (Exception e) {
            System.out.println("Could not resolve pop up binding ORD...");
            e.printStackTrace();
        }
    }

    private class DialogThread
    extends Thread {
        BVirtualComponent vc;

        public DialogThread(BVirtualComponent c) {
            this.vc = c;
        }

        @Override
        public void run() {
            String out = "";
            Property[] props = this.vc.getPropertiesArray();
            int loopCount = 0;
            try {
                while (((BStatus)this.vc.getClass().getMethod("getStatus", null).invoke((Object)this.vc, null)).isStale()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (++loopCount <= 50) continue;
                    System.out.println("Could not resolve virtual pop up binding ORD...");
                    return;
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            for (int p = 0; p < props.length; ++p) {
                if (!props[p].toString().endsWith("history:HistoryId")) continue;
                out = this.vc.get(props[p]).toString();
            }
            BOrd outOrd = BOrd.make((String)("history:" + out));
            if (outOrd != null) {
                BWbShell shell = BWbShell.getWbShell((BWidget)BLynxPointHistoryPopupBinding.this.getWidget());
                outOrd = BOrd.make((BOrd)shell.getActiveOrd(), (BOrd)outOrd).normalize();
                BNiagaraWbDialog dlg = new BNiagaraWbDialog(BPopupProfile.TYPE, (BWidget)shell, outOrd, BLynxPointHistoryPopupBinding.this.getTitle(), BLynxPointHistoryPopupBinding.this.getPosition(), BLynxPointHistoryPopupBinding.this.getSize(), BLynxPointHistoryPopupBinding.this.getModal());
                dlg.open();
            }
            super.run();
        }
    }
}

