/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.px;

import com.lynxspring.px.editor.BFileUploadFE;
import com.lynxspring.util.BLynxKitPxLicenseService;
import com.lynxspring.util.BTransferFilter;
import com.tridium.ui.BOptionDialog;
import com.tridium.ui.file.BNDirectoryChooser;
import com.tridium.ui.file.BNFileChooser;
import java.io.InputStream;
import java.io.OutputStream;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.IFileFilter;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.FileUtil;
import javax.baja.space.BSpace;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BBinding;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BLayout;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BProgressDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.file.BDirectoryChooser;
import javax.baja.ui.file.BFileChooser;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="allowBrowsingDestination", type="boolean", defaultValue="false"), @NiagaraProperty(name="allowMultipleFiles", type="boolean", defaultValue="false"), @NiagaraProperty(name="startingLocalDirectory", type="BOrd", defaultValue="BOrd.make(\"local:|file:\")"), @NiagaraProperty(name="defaultFileName", type="String", defaultValue=""), @NiagaraProperty(name="filter", type="BTransferFilter", defaultValue="new BTransferFilter()"), @NiagaraProperty(name="maxFileSize", type="int", defaultValue="100"), @NiagaraProperty(name="destinationDirectory", type="BOrd", defaultValue="BOrd.make(\"file:^\")"), @NiagaraProperty(name="forcedFileName", type="String", defaultValue=""), @NiagaraProperty(name="text", type="String", defaultValue="lex.getText(\"upload.label\")"), @NiagaraProperty(name="image", type="BImage", defaultValue="BImage.make(lex.getText(\"upload.icon\"))")})
@NiagaraAction(name="invokeTransfer")
@NiagaraTopic(name="fileUploaded", eventType="BString")
public class BTransferButton
extends BButton {
    public static final BOrd bindOrd = BOrd.make((String)"slot:");
    private static final Lexicon lex = Lexicon.make(BTransferButton.class);
    public static final Property allowBrowsingDestination = BTransferButton.newProperty((int)0, (boolean)false, null);
    public static final Property allowMultipleFiles = BTransferButton.newProperty((int)0, (boolean)false, null);
    public static final Property startingLocalDirectory = BTransferButton.newProperty((int)0, (BValue)BOrd.make((String)"local:|file:"), null);
    public static final Property defaultFileName = BTransferButton.newProperty((int)0, (String)"", null);
    public static final Property filter = BTransferButton.newProperty((int)0, (BValue)new BTransferFilter(), null);
    public static final Property maxFileSize = BTransferButton.newProperty((int)0, (int)100, null);
    public static final Property destinationDirectory = BTransferButton.newProperty((int)0, (BValue)BOrd.make((String)"file:^"), null);
    public static final Property forcedFileName = BTransferButton.newProperty((int)0, (String)"", null);
    public static final Property text = BTransferButton.newProperty((int)0, (String)lex.getText("upload.label"), null);
    public static final Property image = BTransferButton.newProperty((int)0, (BValue)BImage.make((String)lex.getText("upload.icon")), null);
    public static final Action invokeTransfer = BTransferButton.newAction((int)0, null);
    public static final Topic fileUploaded = BTransferButton.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BTransferButton.class);
    BObject base;
    BFileUploadFE editor;

    public boolean getAllowBrowsingDestination() {
        return this.getBoolean(allowBrowsingDestination);
    }

    public void setAllowBrowsingDestination(boolean v) {
        this.setBoolean(allowBrowsingDestination, v, null);
    }

    public boolean getAllowMultipleFiles() {
        return this.getBoolean(allowMultipleFiles);
    }

    public void setAllowMultipleFiles(boolean v) {
        this.setBoolean(allowMultipleFiles, v, null);
    }

    public BOrd getStartingLocalDirectory() {
        return (BOrd)this.get(startingLocalDirectory);
    }

    public void setStartingLocalDirectory(BOrd v) {
        this.set(startingLocalDirectory, (BValue)v, null);
    }

    public String getDefaultFileName() {
        return this.getString(defaultFileName);
    }

    public void setDefaultFileName(String v) {
        this.setString(defaultFileName, v, null);
    }

    public BTransferFilter getFilter() {
        return (BTransferFilter)this.get(filter);
    }

    public void setFilter(BTransferFilter v) {
        this.set(filter, (BValue)v, null);
    }

    public int getMaxFileSize() {
        return this.getInt(maxFileSize);
    }

    public void setMaxFileSize(int v) {
        this.setInt(maxFileSize, v, null);
    }

    public BOrd getDestinationDirectory() {
        return (BOrd)this.get(destinationDirectory);
    }

    public void setDestinationDirectory(BOrd v) {
        this.set(destinationDirectory, (BValue)v, null);
    }

    public String getForcedFileName() {
        return this.getString(forcedFileName);
    }

    public void setForcedFileName(String v) {
        this.setString(forcedFileName, v, null);
    }

    public String getText() {
        return this.getString(text);
    }

    public void setText(String v) {
        this.setString(text, v, null);
    }

    public BImage getImage() {
        return (BImage)this.get(image);
    }

    public void setImage(BImage v) {
        this.set(image, (BValue)v, null);
    }

    public void invokeTransfer() {
        this.invoke(invokeTransfer, null, null);
    }

    public void fireFileUploaded(BString event) {
        this.fire(fileUploaded, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void changed(Property p, Context cx) {
        if (p == allowMultipleFiles) {
            if (this.getAllowMultipleFiles() && this.getText().equals(lex.getText("upload.label"))) {
                this.setText(lex.getText("upload.label.multiple"));
            } else if (!this.getAllowMultipleFiles() && this.getText().equals(lex.getText("upload.label.multiple"))) {
                this.setText(lex.getText("upload.label"));
            }
        }
    }

    public void doInvokeTransfer() {
        BDirectory selDir;
        BOrd destDir;
        BIFile[] file;
        long size;
        block13: {
            BOrd[] selected;
            if (this.base == null) {
                int i;
                BBinding[] bindings = this.getBindings();
                for (i = 0; i < bindings.length && bindings[i].getOrd().isNull(); ++i) {
                }
                if (i == bindings.length) {
                    this.error(lex.getText("upload.error.bind"));
                    return;
                }
                this.base = bindings[i].get();
            }
            BNFileChooser chooser = (BNFileChooser)BFileChooser.makeOpen((BWidget)this.getShell());
            chooser.setSpaces(new BSpace[]{BFileSystem.INSTANCE});
            chooser.setCurrentDirectory(this.getStartingLocalDirectory());
            chooser.setTitle(lex.getText("upload.title"));
            BBorderPane border = (BBorderPane)chooser.getContent();
            BSplitPane shell = (BSplitPane)border.getContent();
            BWidget widget = shell.getWidget2();
            shell.setWidget2((BWidget)new BNullWidget());
            border.setContent(widget);
            IFileFilter[] filters = this.getFilter().getFilters();
            if (filters.length > 0) {
                chooser.addFilters(filters);
            }
            if ((selected = chooser.show(this.getAllowMultipleFiles())).length == 0) {
                return;
            }
            size = 0L;
            file = new BIFile[selected.length];
            for (int i = 0; i < selected.length; ++i) {
                file[i] = (BIFile)selected[i].get();
                size += file[i].getSize();
                if (this.getMaxFileSize() <= 0 || file[i].getSize() / 1024L <= (long)this.getMaxFileSize()) continue;
                this.error(lex.getText("upload.error.filesize", new Object[]{file[i].getFileName(), new Integer(this.getMaxFileSize())}));
                return;
            }
            destDir = this.getDestinationDirectory();
            selDir = null;
            try {
                selDir = (BDirectory)destDir.get(this.base);
            }
            catch (Exception e) {
                if (this.getAllowBrowsingDestination()) break block13;
                this.error(lex.getText("upload.error.destination"));
                return;
            }
        }
        if (selDir == null || this.getAllowBrowsingDestination()) {
            BOrd tmpDir = BOrd.make((String)"file:^");
            if (selDir != null) {
                tmpDir = destDir;
            }
            BNDirectoryChooser dirChooser = (BNDirectoryChooser)BDirectoryChooser.make((BWidget)this.getShell());
            dirChooser.setTitle(lex.getText("upload.dir.title"));
            dirChooser.setCurrentDirectory(((BDirectory)tmpDir.get(this.base)).getAbsoluteOrd());
            dirChooser.setSpaceListVisible(false);
            dirChooser.setBookmarksVisible(false);
            BOrd dir = dirChooser.show();
            if (dir != null && !dir.isNull()) {
                selDir = (BDirectory)dir.get(this.base);
            } else {
                return;
            }
        }
        if (!BLynxKitPxLicenseService.isLicensed((BWidget)this)) {
            return;
        }
        BProgressDialog.open((BWidget)this, (String)lex.getText("upload.uploading"), (BProgressDialog.Worker)new UploadWorker(file, selDir, size));
    }

    private void error(String msg, Throwable t) {
        BDialog.error((BWidget)this, (String)lex.getText("upload.error.title"), (Object)new BLabel(msg), (Throwable)t);
    }

    private void error(String msg) {
        BDialog.error((BWidget)this, (String)lex.getText("upload.error.title"), (Object)new BLabel(msg));
    }

    public BTransferButton() {
        this.setLayout(BLayout.make((double)0.0, (int)0, (double)0.0, (int)0, (double)0.0, (int)2, (double)0.0, (int)2));
        this.setPadding(BInsets.make((double)3.0));
        this.linkTo((BComponent)this, (Slot)actionPerformed, (Slot)invokeTransfer);
    }

    public BTransferButton(BImage bimage, String s) {
        this();
        this.setImage(bimage);
        this.setText(s);
    }

    public BTransferButton(BImage bimage) {
        this();
        this.setImage(bimage);
    }

    public BTransferButton(String s) {
        this();
        this.setText(s);
    }

    public void setBase(BObject base) {
        this.base = base;
    }

    class UploadWorker
    extends BProgressDialog.Worker {
        boolean cancel = false;
        BIFile[] file;
        BDirectory dir;
        long size;

        UploadWorker(BIFile[] file, BDirectory dir, long size) {
            this.file = file;
            this.dir = dir;
            this.size = size;
        }

        public void doCancel() {
            this.cancel = true;
        }

        public void doRun() {
            boolean multipleErrors = false;
            Throwable lastError = null;
            long transferred = 0L;
            boolean replaceAll = false;
            for (int i = 0; !this.cancel && i < this.file.length; ++i) {
                try {
                    String fileName = this.file[i].getFileName();
                    if (!BTransferButton.this.getAllowMultipleFiles() && BTransferButton.this.getForcedFileName().trim().length() > 0) {
                        fileName = BTransferButton.this.getForcedFileName() + "." + this.file[i].getExtension();
                    }
                    this.updateProgress(lex.getText("upload.transferring", new Object[]{this.file[i].getFileName()}));
                    transferred += this.file[i].getSize();
                    boolean upload = true;
                    if (!replaceAll && this.dir.getNavChild(fileName) != null) {
                        int buttons = 12;
                        if (i < this.file.length - 1) {
                            buttons += 2;
                        }
                        BOptionDialog dialog = new BOptionDialog((BWidget)BTransferButton.this, lex.getText("upload.replace.title"), (BWidget)new BLabel(lex.getText("upload.replace.msg", new Object[]{fileName})), buttons, BDialog.QUESTION_ICON, null);
                        dialog.setBoundsCenteredOnOwner();
                        dialog.getCancelButton().setText(lex.getText("upload.replace.all"));
                        dialog.getYesButton().setText(lex.getText("upload.replace.yes"));
                        dialog.getNoButton().setText(lex.getText("upload.replace.no"));
                        dialog.open();
                        dialog.relayoutSync();
                        int result = dialog.getResult();
                        if (result == 8) {
                            upload = false;
                        } else if (result == 2) {
                            replaceAll = true;
                        }
                    }
                    if (upload) {
                        BIFile newFile = this.dir.getFileSpace().makeFile(this.dir.getFilePath().merge(fileName), null);
                        FileUtil.pipe((InputStream)this.file[i].getInputStream(), (OutputStream)newFile.getOutputStream());
                        BTransferButton.this.fireFileUploaded(BString.make((String)newFile.getFilePath().toString()));
                    }
                    this.updateProgress((int)(transferred * 100L / this.size));
                    continue;
                }
                catch (Throwable t) {
                    if (lastError != null) {
                        multipleErrors = true;
                    }
                    lastError = t;
                }
            }
            if (multipleErrors) {
                BTransferButton.this.error(lex.getText("upload.error.multiples"), lastError);
            } else if (lastError != null) {
                BTransferButton.this.error(lastError.getMessage(), lastError);
            }
            this.updateProgress(100);
        }
    }
}

