/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.px;

import com.lynxspring.px.BPanZoomPane;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;

public class BPanZoomThumbnail
extends BWidget {
    public static final Type TYPE = Sys.loadType(BPanZoomThumbnail.class);
    private BPanZoomPane pane;
    private BImage buffer;

    public Type getType() {
        return TYPE;
    }

    public BPanZoomThumbnail(BPanZoomPane pane) {
        this.pane = pane;
    }

    public BPanZoomThumbnail() {
    }

    void postLoad() {
        this.repaintBuffer();
    }

    void repaintBuffer() {
        if (this.buffer != null) {
            this.buffer.dispose();
        }
        double contentWidth = this.pane.highX - this.pane.lowX;
        double contentHeight = this.pane.highY - this.pane.lowY;
        double divisor = 1.0;
        divisor = contentWidth > contentHeight ? 100.0 / contentWidth : 100.0 / contentHeight;
        double thumbW = contentWidth * divisor;
        double thumbY = contentHeight * divisor;
        if (thumbW == Double.NaN || thumbY == Double.NaN || thumbW <= 0.0 || thumbY <= 0.0) {
            return;
        }
        this.buffer = BImage.make((double)(thumbW + 2.0), (double)(thumbY + 2.0));
        Graphics g = this.buffer.getGraphics();
        g.setBrush(BColor.make((int)230, (int)230, (int)230, (int)210));
        g.fillRect(1.0, 1.0, thumbW, thumbY);
        double x = this.pane.curX;
        if (this.pane.lowX < 0.0) {
            x -= this.pane.lowX;
        }
        double y = this.pane.curY;
        if (this.pane.lowY < 0.0) {
            y -= this.pane.lowY;
        }
        double w = this.pane.getViewSize().width;
        double h = this.pane.getViewSize().height;
        g.setBrush(BColor.make((int)142, (int)6, (int)198, (int)50));
        g.fillRect(1.0 + (x *= divisor), 1.0 + (y *= divisor), w *= divisor, h *= divisor);
        g.setBrush(BColor.make((int)0));
        g.strokeRect(0.0, 0.0, thumbW + 1.0, thumbY + 1.0);
        g.dispose();
    }

    public void computePreferredSize() {
        this.setPreferredSize(102.0, 102.0);
    }

    public void doLayout(BWidget[] abwidget) {
    }

    public void paint(Graphics g) {
        if (this.buffer != null) {
            g.drawImage(this.buffer, 0.0, 0.0);
        }
    }
}

