/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.px;

import com.lynxspring.px.enums.BPanDirection;
import com.tridium.gx.GraphPaper;
import com.tridium.gx.GxEnv;
import com.tridium.gx.Hatching;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BSize;
import javax.baja.gx.BTransform;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.gx.IPoint;
import javax.baja.gx.Point;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLayout;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BCanvasPane;
import javax.baja.ui.pane.BLabelPane;
import javax.baja.ui.pane.BTabbedPane;
import javax.baja.ui.shape.BShape;
import javax.baja.units.BUnit;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="viewSize", type="BSize", defaultValue="BSize.make(600, 350)"), @NiagaraProperty(name="halign", type="BHalign", defaultValue="BHalign.center"), @NiagaraProperty(name="valign", type="BValign", defaultValue="BValign.center"), @NiagaraProperty(name="background", type="BBrush", defaultValue="BBrush.NULL"), @NiagaraProperty(name="zoomRatio", type="int", defaultValue="100", facets={@Facet(value="BFacets.make(\"units\", BUnit.getUnit(\"percent\"))")}), @NiagaraProperty(name="initX", type="int", defaultValue="0"), @NiagaraProperty(name="initY", type="int", defaultValue="0")})
public class BPanZoomPane
extends BCanvasPane {
    public static final Property viewSize = BPanZoomPane.newProperty((int)0, (BValue)BSize.make((double)600.0, (double)350.0), null);
    public static final Property halign = BPanZoomPane.newProperty((int)0, (BValue)BHalign.center, null);
    public static final Property valign = BPanZoomPane.newProperty((int)0, (BValue)BValign.center, null);
    public static final Property background = BPanZoomPane.newProperty((int)0, (BValue)BBrush.NULL, null);
    public static final Property zoomRatio = BPanZoomPane.newProperty((int)0, (int)100, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"percent")));
    public static final Property initX = BPanZoomPane.newProperty((int)0, (int)0, null);
    public static final Property initY = BPanZoomPane.newProperty((int)0, (int)0, null);
    public static final Type TYPE = Sys.loadType(BPanZoomPane.class);
    private static final BIcon icon = BIcon.std((String)"widgets/canvasPane.png");
    private BTransform viewTranform = BTransform.DEFAULT;
    private double dx;
    private double dy;
    int curZoomRatio;
    int curX;
    int curY;
    double lowX = 0.0;
    double lowY = 0.0;
    double highX = 0.0;
    double highY = 0.0;
    double maxW = 0.0;
    double maxH = 0.0;
    private boolean paintGraphPaper;
    private boolean paintHatching;
    private GraphPaper graphPaper;
    private Hatching hatching;

    public BSize getViewSize() {
        return (BSize)this.get(viewSize);
    }

    public void setViewSize(BSize v) {
        this.set(viewSize, (BValue)v, null);
    }

    public BHalign getHalign() {
        return (BHalign)this.get(halign);
    }

    public void setHalign(BHalign v) {
        this.set(halign, (BValue)v, null);
    }

    public BValign getValign() {
        return (BValign)this.get(valign);
    }

    public void setValign(BValign v) {
        this.set(valign, (BValue)v, null);
    }

    public BBrush getBackground() {
        return (BBrush)this.get(background);
    }

    public void setBackground(BBrush v) {
        this.set(background, (BValue)v, null);
    }

    public int getZoomRatio() {
        return this.getInt(zoomRatio);
    }

    public void setZoomRatio(int v) {
        this.setInt(zoomRatio, v, null);
    }

    public int getInitX() {
        return this.getInt(initX);
    }

    public void setInitX(int v) {
        this.setInt(initX, v, null);
    }

    public int getInitY() {
        return this.getInt(initY);
    }

    public void setInitY(int v) {
        this.setInt(initY, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.curZoomRatio = this.getZoomRatio();
        this.curX = this.getInitX();
        this.curY = this.getInitY();
    }

    public void changed(Property p, Context cx) {
        if (p == zoomRatio) {
            if (this.getZoomRatio() < 10) {
                this.setZoomRatio(10);
                return;
            }
            this.curZoomRatio = this.getZoomRatio();
            this.relayout();
        } else if (p == initX) {
            this.curX = this.getInitX();
            this.relayout();
        } else if (p == initY) {
            this.curY = this.getInitY();
            this.relayout();
        }
    }

    public void reset() {
        this.curZoomRatio = this.getZoomRatio();
        this.curX = this.getInitX();
        this.curY = this.getInitY();
        this.relayout();
    }

    public void zoom(boolean zoomIn) {
        this.curZoomRatio = zoomIn ? (this.curZoomRatio += 10) : (this.curZoomRatio -= 10);
        this.relayout();
    }

    public void pan(BPanDirection dir) {
        switch (dir.getOrdinal()) {
            case 0: {
                this.curY -= 100;
                break;
            }
            case 1: {
                this.curX += 100;
                break;
            }
            case 2: {
                this.curY += 100;
                break;
            }
            case 3: {
                this.curX -= 100;
            }
        }
        if ((double)this.curX < this.lowX) {
            this.curX = (int)Math.floor(this.lowX);
        }
        if ((double)this.curY < this.lowY) {
            this.curY = (int)Math.floor(this.lowY);
        }
        this.relayout();
    }

    public void doLayout(BWidget[] kids) {
        double w = this.getWidth();
        double h = this.getHeight();
        double vw = this.getViewSize().width;
        double vh = this.getViewSize().height;
        System.out.println("Pref: " + this.getPreferredWidth() + ", " + this.getPreferredHeight());
        System.out.println("Act: " + w + ", " + h);
        System.out.println("View: " + vw + ", " + vh);
        this.dx = Math.floor(this.doHalign(w, vw));
        this.dy = Math.floor(this.doValign(h, vh));
        this.viewTranform = BTransform.make((BTransform.Transform[])new BTransform.Transform[]{new BTransform.Translate(this.dx, this.dy), new BTransform.Scale(this.getScaleFactor(), this.getScaleFactor())});
        for (int i = 0; i < kids.length; ++i) {
            BLayout layout = kids[i].getLayout();
            if (layout.isNull()) continue;
            kids[i].computePreferredSize();
            double cx = layout.getX();
            double cy = layout.getY();
            double cw = layout.getWidth();
            double ch = layout.getHeight();
            if (cx < this.lowX) {
                this.lowX = cx;
            }
            if (cy < this.lowY) {
                this.lowY = cy;
            }
            if (cx + cw > this.highX) {
                this.highX = cx + cw;
                this.maxW = cw;
            }
            if (cy + ch > this.highY) {
                this.highY = cy + ch;
                this.maxH = ch;
            }
            if (layout.getXUnit() == 1) {
                cx = cx / 100.0 * vw;
            }
            if (layout.getYUnit() == 1) {
                cy = cy / 100.0 * vh;
            }
            if (layout.getWidthUnit() == 1) {
                cw = cw / 100.0 * vw;
            } else if (layout.getWidthUnit() == 2) {
                cw = kids[i].getPreferredWidth();
            }
            if (layout.getHeightUnit() == 1) {
                ch = ch / 100.0 * vh;
            } else if (layout.getHeightUnit() == 2) {
                ch = kids[i].getPreferredHeight();
            }
            if (this.curX != 0) {
                cx -= (double)this.curX * this.getScaleFactor();
            }
            if (this.curY != 0) {
                cy -= (double)this.curY * this.getScaleFactor();
            }
            kids[i].setBounds(cx, cy, cw, ch);
        }
    }

    private double doHalign(double w, double dw) {
        BHalign halign = this.getHalign();
        if (halign == BHalign.left) {
            return 0.0;
        }
        if (halign == BHalign.center) {
            return (w - dw) / 2.0;
        }
        return w - dw - 1.0;
    }

    private double doValign(double h, double dh) {
        BValign valign = this.getValign();
        if (valign == BValign.top) {
            return 0.0;
        }
        if (valign == BValign.center) {
            return (h - dh) / 2.0;
        }
        return h - dh - 1.0;
    }

    public BWidget childAt(Point pt) {
        return super.childAt(this.viewTranform.getInverse().transform((IPoint)pt, null));
    }

    public BWidget[] childrenAt(Point pt) {
        pt = this.viewTranform.getInverse().transform((IPoint)pt, null);
        Array arr = new Array(BWidget.class);
        BWidget[] children = this.getChildWidgets();
        for (int i = children.length - 1; i >= 0; --i) {
            BWidget child = children[i];
            if (!child.isVisible() || !child.contains(pt.x - child.getX(), pt.y - child.getY())) continue;
            arr.add((Object)child);
        }
        if (arr.size() == 0) {
            return null;
        }
        return (BWidget[])arr.trim();
    }

    public Point translateToChild(BWidget child, Point pt) {
        pt = this.viewTranform.getInverse().transform((IPoint)pt, pt);
        return super.translateToChild(child, pt);
    }

    public Point translateFromChild(BWidget child, Point pt) {
        pt.x += child.getX();
        pt.y += child.getY();
        pt = this.viewTranform.transform((IPoint)pt, pt);
        return pt;
    }

    public void paint(Graphics g) {
        BBrush brush = this.getBackground();
        if (!brush.isNull()) {
            g.setBrush(brush);
            g.fillRect(0.0, 0.0, this.getWidth(), this.getHeight());
        }
        g.push();
        try {
            g.transform(this.viewTranform);
            g.clip(0.0, 0.0, (this.getViewSize().width + 1.0) / ((double)this.curZoomRatio / 100.0), (this.getViewSize().height + 1.0) / ((double)this.curZoomRatio / 100.0));
            if (this.paintGraphPaper) {
                this.graphPaper.fillRect(g, this.dx < 0.0 ? -this.dx * this.getScaleFactor() : 0.0, this.dy < 0.0 ? -this.dy * this.getScaleFactor() : 0.0, this.getWidth() / this.getScaleFactor(), this.getHeight() / this.getScaleFactor());
            }
            this.paintKids(g, this.paintHatching && this.hatchable());
        }
        finally {
            g.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintKids(Graphics g, boolean hatch) {
        IGeom clip = g.getClip();
        BWidget[] children = this.getChildWidgets();
        for (int i = 0; i < children.length; ++i) {
            double height;
            double width;
            double y;
            double x;
            BWidget child = children[i];
            if (!child.isVisible() || !clip.intersects(x = child.getX(), y = child.getY(), width = child.getWidth(), height = child.getHeight())) continue;
            g.push();
            try {
                g.clip(x, y, width, height);
                g.translate(x, y);
                child.paint(g);
                if (!hatch || child instanceof BShape) continue;
                g.transform(BTransform.makeScale((double)this.getScaleFactor(), (double)this.getScaleFactor()));
                this.hatching.fillRect(g, this.dx + x < 0.0 ? -(this.dx + x) * this.getScaleFactor() : 0.0, this.dy + y < 0.0 ? -(this.dy + y) * this.getScaleFactor() : 0.0, width / this.getScaleFactor(), height / this.getScaleFactor());
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace();
                continue;
            }
            finally {
                g.pop();
            }
        }
    }

    private boolean hatchable() {
        for (BWidget parent = this.getParentWidget(); parent != null; parent = parent.getParentWidget()) {
            BLabelPane tab;
            BTabbedPane pane;
            if (parent instanceof BCanvasPane) {
                return false;
            }
            if (!(parent instanceof BLabelPane) || !(parent.getParentWidget() instanceof BTabbedPane) || (pane = (BTabbedPane)(tab = (BLabelPane)parent).getParentWidget()).getSelectedLabelPane() == tab) continue;
            return false;
        }
        return true;
    }

    public Object fw(int x, Object a, Object b, Object c, Object d) {
        if (x == 304) {
            Object[] gp = (Object[])a;
            this.paintGraphPaper = (Boolean)gp[0];
            if (this.paintGraphPaper) {
                if (this.graphPaper == null) {
                    this.graphPaper = GxEnv.get().makeGraphPaper();
                }
                this.graphPaper.setSize(((Integer)gp[1]).intValue());
                this.graphPaper.setColor((BColor)gp[2]);
            }
            Object[] ha = (Object[])b;
            this.paintHatching = (Boolean)ha[0];
            if (this.paintHatching) {
                if (this.hatching == null) {
                    this.hatching = GxEnv.get().makeHatching();
                }
                this.hatching.setColor((BColor)ha[1]);
            }
        }
        return super.fw(x, a, b, c, d);
    }

    public BIcon getIcon() {
        return icon;
    }

    public double getScaleFactor() {
        return (double)this.curZoomRatio / 100.0;
    }
}

