/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.px;

import com.lynxspring.px.BPanZoomPane;
import com.lynxspring.px.enums.BPanDirection;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.BTransform;
import javax.baja.gx.Graphics;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;

@NiagaraType
@NiagaraProperty(name="controls", type="BWidget", defaultValue="new BNullWidget()")
public class BPanZoomControls
extends BWidget {
    public static final Property controls = BPanZoomControls.newProperty((int)0, (BValue)new BNullWidget(), null);
    public static final Type TYPE = Sys.loadType(BPanZoomControls.class);
    BPanZoomPane pane;
    boolean isHorz = false;
    double w;
    double h;
    BGridPane grid;
    private BImage buffer;
    private boolean bufferDirty = true;
    private BButton zoomIn = new BButton((Command)new Zoom(true));
    private BButton zoomOut = new BButton((Command)new Zoom(false));
    private BButton panUp = new BButton((Command)new Pan(BPanDirection.up));
    private BButton panRight = new BButton((Command)new Pan(BPanDirection.right));
    private BButton panDown = new BButton((Command)new Pan(BPanDirection.down));
    private BButton panLeft = new BButton((Command)new Pan(BPanDirection.left));
    private BButton revert = new BButton((Command)new Revert());

    public BWidget getControls() {
        return (BWidget)this.get(controls);
    }

    public void setControls(BWidget v) {
        this.set(controls, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        if (this.getPropertyInParent() == BEdgePane.top || this.getPropertyInParent() == BEdgePane.bottom) {
            this.buildHorz();
        } else {
            this.buildVert();
        }
    }

    void postLoad() {
        this.repaintBuffer();
    }

    void repaintBuffer() {
        double contentWidth = this.pane().highX - this.pane().lowX;
        double contentHeight = this.pane().highY - this.pane().lowY;
        double divisor = 1.0;
        if (contentWidth <= 0.0 || contentHeight <= 0.0) {
            return;
        }
        if (this.buffer != null) {
            this.buffer.dispose();
        }
        divisor = contentWidth > contentHeight ? 100.0 / contentWidth : 100.0 / contentHeight;
        double thumbW = contentWidth * divisor;
        double thumbY = contentHeight * divisor;
        this.buffer = BImage.make((double)(thumbW + 2.0), (double)(thumbY + 2.0));
        Graphics g = this.buffer.getGraphics();
        g.setBrush(BColor.make((int)230, (int)230, (int)230, (int)210));
        g.fillRect(1.0, 1.0, thumbW, thumbY);
        g.setBrush(BColor.make((int)0));
        g.strokeRect(0.0, 0.0, thumbW + 1.0, thumbY + 1.0);
        double x = this.pane().curX;
        if (this.pane().lowX < 0.0) {
            x -= this.pane().lowX;
        }
        double y = this.pane().curY;
        if (this.pane().lowY < 0.0) {
            y -= this.pane().lowY;
        }
        double w = this.pane().getViewSize().width;
        double h = this.pane().getViewSize().height;
        g.transform(BTransform.makeScale((double)this.pane().getScaleFactor(), (double)this.pane().getScaleFactor()));
        g.setBrush(BColor.make((int)142, (int)6, (int)198, (int)50));
        g.fillRect(1.0 + (x *= divisor), 1.0 + (y *= divisor), w *= divisor, h *= divisor);
        this.panLeft.setEnabled(x > 0.0);
        this.panRight.setEnabled(x + w * divisor < thumbW);
        this.panUp.setEnabled(y > 0.0);
        this.panDown.setEnabled(y + h * divisor < thumbY);
        g.dispose();
    }

    public void computePreferredSize() {
        this.grid.computePreferredSize();
        this.w = this.grid.getPreferredWidth();
        this.h = this.grid.getPreferredHeight();
        if (this.isHorz) {
            if (this.h < 102.0) {
                this.h = 102.0;
            }
            this.w += 112.0;
        } else {
            if (this.w < 102.0) {
                this.w = 102.0;
            }
            this.h += 112.0;
        }
        this.setPreferredSize(this.w, this.h);
    }

    public void doLayout(BWidget[] kids) {
        this.grid.computePreferredSize();
        this.grid.setBounds(0.0, 0.0, this.grid.getPreferredWidth(), this.grid.getPreferredHeight());
        this.grid.layout();
    }

    public void paint(Graphics g) {
        if (this.bufferDirty) {
            this.repaintBuffer();
        }
        if (this.buffer != null) {
            if (this.isHorz) {
                double y = 0.0;
                if (this.h > this.buffer.getHeight()) {
                    y = (this.h - this.buffer.getHeight()) / 2.0;
                }
                g.drawImage(this.buffer, this.grid.getPreferredWidth() + 10.0, y);
            } else {
                double x = 0.0;
                if (this.w > this.buffer.getWidth()) {
                    x = (this.w - this.buffer.getWidth()) / 2.0;
                }
                g.drawImage(this.buffer, x, this.grid.getPreferredHeight() + 10.0);
            }
        }
        this.grid.paint(g);
    }

    private void buildHorz() {
        this.isHorz = true;
        this.getControls().removeAll();
        this.grid = new BGridPane(7);
        this.setControls((BWidget)this.grid);
        this.grid.add(null, (BValue)new BNullWidget());
        this.grid.add(null, (BValue)new BNullWidget());
        this.grid.add(null, (BValue)new BNullWidget());
        this.grid.add(null, (BValue)this.panUp);
        this.grid.add(null, (BValue)new BNullWidget());
        this.grid.add(null, (BValue)new BNullWidget());
        this.grid.add(null, (BValue)new BNullWidget());
        this.grid.add(null, (BValue)this.zoomOut);
        this.grid.add(null, (BValue)new BNullWidget());
        this.grid.add(null, (BValue)this.panLeft);
        this.grid.add(null, (BValue)this.revert);
        this.grid.add(null, (BValue)this.panRight);
        this.grid.add(null, (BValue)new BNullWidget());
        this.grid.add(null, (BValue)this.zoomIn);
        this.grid.add(null, (BValue)new BNullWidget());
        this.grid.add(null, (BValue)new BNullWidget());
        this.grid.add(null, (BValue)new BNullWidget());
        this.grid.add(null, (BValue)this.panDown);
        this.grid.add(null, (BValue)new BNullWidget());
        this.grid.add(null, (BValue)new BNullWidget());
        this.grid.add(null, (BValue)new BNullWidget());
    }

    private void buildVert() {
        this.isHorz = false;
        this.getControls().removeAll();
        this.grid = new BGridPane(3);
        this.setControls((BWidget)this.grid);
        this.grid.add(null, (BValue)new BNullWidget());
        this.grid.add(null, (BValue)this.zoomIn);
        this.grid.add(null, (BValue)new BNullWidget());
        this.grid.add(null, (BValue)new BNullWidget());
        this.grid.add(null, (BValue)new BNullWidget());
        this.grid.add(null, (BValue)new BNullWidget());
        this.grid.add(null, (BValue)new BNullWidget());
        this.grid.add(null, (BValue)this.panUp);
        this.grid.add(null, (BValue)new BNullWidget());
        this.grid.add(null, (BValue)this.panLeft);
        this.grid.add(null, (BValue)this.revert);
        this.grid.add(null, (BValue)this.panRight);
        this.grid.add(null, (BValue)new BNullWidget());
        this.grid.add(null, (BValue)this.panDown);
        this.grid.add(null, (BValue)new BNullWidget());
        this.grid.add(null, (BValue)new BNullWidget());
        this.grid.add(null, (BValue)new BNullWidget());
        this.grid.add(null, (BValue)new BNullWidget());
        this.grid.add(null, (BValue)new BNullWidget());
        this.grid.add(null, (BValue)this.zoomOut);
        this.grid.add(null, (BValue)new BNullWidget());
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BEdgePane || parent instanceof BPanZoomPane;
    }

    private BPanZoomPane pane() {
        if (this.pane == null) {
            this.pane = this.getParentWidget() instanceof BPanZoomPane ? (BPanZoomPane)this.getParentWidget() : (BPanZoomPane)((BEdgePane)this.getParentWidget()).getCenter();
        }
        return this.pane;
    }

    private class Pan
    extends Command {
        private BPanDirection dir;

        public Pan(BPanDirection dir) {
            super((BWidget)BPanZoomControls.this, "");
            switch (dir.getOrdinal()) {
                case 0: {
                    this.icon = BImage.make((BIcon)BIcon.std((String)"arrowUp.png"));
                    break;
                }
                case 1: {
                    this.icon = BImage.make((BIcon)BIcon.std((String)"arrowRight.png"));
                    break;
                }
                case 2: {
                    this.icon = BImage.make((BIcon)BIcon.std((String)"arrowDown.png"));
                    break;
                }
                case 3: {
                    this.icon = BImage.make((BIcon)BIcon.std((String)"arrowLeft.png"));
                }
            }
            this.dir = dir;
        }

        public CommandArtifact doInvoke() {
            BPanZoomControls.this.pane().pan(this.dir);
            BPanZoomControls.this.bufferDirty = true;
            return null;
        }
    }

    private class Zoom
    extends Command {
        private boolean zoomIn;

        public Zoom(boolean zoomIn) {
            super((BWidget)BPanZoomControls.this, "");
            this.icon = BImage.make((BIcon)BIcon.std((String)(zoomIn ? "zoomIn.png" : "zoomOut.png")));
            this.zoomIn = zoomIn;
        }

        public CommandArtifact doInvoke() {
            BPanZoomControls.this.pane().zoom(this.zoomIn);
            BPanZoomControls.this.bufferDirty = true;
            return null;
        }
    }

    private class Revert
    extends Command {
        public Revert() {
            super((BWidget)BPanZoomControls.this, "");
            this.icon = BImage.make((BIcon)BIcon.std((String)"fitToWindow.png"));
        }

        public CommandArtifact doInvoke() {
            BPanZoomControls.this.pane().reset();
            BPanZoomControls.this.bufferDirty = true;
            return null;
        }
    }
}

