/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.px;

import com.lynxspring.px.bindings.BLynxChartBinding;
import com.lynxspring.px.bindings.BLynxTableChartBinding;
import com.tridium.bql.util.BDynamicTimeRange;
import com.tridium.history.ui.BHistoryChart;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.baja.chart.BAbsTimeAxis;
import javax.baja.chart.BAxis;
import javax.baja.chart.BChart;
import javax.baja.chart.BDiscreteAxis;
import javax.baja.chart.BLineChart;
import javax.baja.chart.BNumericAxis;
import javax.baja.chart.ChartModel;
import javax.baja.chart.ChartSpec;
import javax.baja.chart.Series;
import javax.baja.chart.SimpleChartModel;
import javax.baja.chart.TableSeries;
import javax.baja.collection.BIRandomAccessTable;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.collection.Tables;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.history.BIHistory;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.IntHashMap;
import javax.baja.nre.util.SortUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.ui.BBinding;
import javax.baja.ui.BLabel;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BTextField;
import javax.baja.ui.BToolBar;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="defaultTimeRange", type="BDynamicTimeRange", defaultValue="BDynamicTimeRange.TODAY"), @NiagaraProperty(name="chartTitle", type="String", defaultValue=""), @NiagaraProperty(name="costPerUnit", type="double", defaultValue="0.0")})
public class BLynxUsageHistoryChart
extends BHistoryChart {
    public static final Property defaultTimeRange = BLynxUsageHistoryChart.newProperty((int)0, (BValue)BDynamicTimeRange.TODAY, null);
    public static final Property chartTitle = BLynxUsageHistoryChart.newProperty((int)0, (String)"", null);
    public static final Property costPerUnit = BLynxUsageHistoryChart.newProperty((int)0, (double)0.0, null);
    public static final Type TYPE = Sys.loadType(BLynxUsageHistoryChart.class);
    BAbsTime lastTime;
    boolean flag;
    boolean firstLoad = true;
    BDynamicTimeRange timeRange = null;
    BTextField txtCostPerUnit = new BTextField();
    BLabel lblUsage = new BLabel();
    BLabel lblUsageCost = new BLabel();
    double usage = 0.0;

    public BDynamicTimeRange getDefaultTimeRange() {
        return (BDynamicTimeRange)this.get(defaultTimeRange);
    }

    public void setDefaultTimeRange(BDynamicTimeRange v) {
        this.set(defaultTimeRange, (BValue)v, null);
    }

    public String getChartTitle() {
        return this.getString(chartTitle);
    }

    public void setChartTitle(String v) {
        this.setString(chartTitle, v, null);
    }

    public double getCostPerUnit() {
        return this.getDouble(costPerUnit);
    }

    public void setCostPerUnit(double v) {
        this.setDouble(costPerUnit, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void doQuery(boolean flag) {
        this.loadData();
    }

    public BLynxUsageHistoryChart() {
        this.addUsage();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (property == showTimeRangeEditor || property == showDeltaEditor || property == showLiveUpdates) {
            this.addUsage();
        }
    }

    public void addUsage() {
        BEdgePane epane = (BEdgePane)this.getContent();
        BBorderPane bPane = (BBorderPane)epane.getTop();
        BToolBar bar = (BToolBar)bPane.getContent();
        try {
            bar.add("sep?", (BValue)new BSeparator());
            this.lblUsage.setBackground(BBrush.makeSolid((BColor)BColor.make((int)255, (int)170, (int)38)));
            this.lblUsage.setFont(BFont.make((String)"tahoma", (double)11.0, (int)1));
            bar.add("label?", (BValue)this.lblUsage);
            bar.add("sep?", (BValue)new BSeparator());
            this.lblUsageCost.setBackground(BBrush.makeSolid((BColor)BColor.make((int)255, (int)170, (int)38)));
            this.lblUsageCost.setFont(BFont.make((String)"tahoma", (double)11.0, (int)1));
            bar.add("lable?", (BValue)this.lblUsageCost);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadData() {
        this.loadData(null, null);
    }

    public void loadData(BITable bitable, BIHistory bihistory) {
        if (this.getCurrentValue() == null) {
            return;
        }
        BBinding[] bindings = this.getBindings();
        BNumericAxis axis = null;
        BNumericAxis numAxis = new BNumericAxis();
        BAbsTimeAxis xAxis = null;
        BLineChart chart = null;
        chart = new BLineChart();
        SimpleChartModel simplechartmodel = new SimpleChartModel();
        BIHistory bhistory = null;
        for (int i = 0; i < bindings.length; ++i) {
            if (!bindings[i].getType().is(BLynxChartBinding.TYPE) && !bindings[i].getType().is(BLynxTableChartBinding.TYPE) || bindings[i].getOrd() == null || bindings[i].getOrd().isNull()) continue;
            try {
                bhistory = this.getHistory(bindings[i].getOrd().get(this.getCurrentValue()));
            }
            catch (UnresolvedException e) {
                e.printStackTrace();
                continue;
            }
            BDynamicTimeRange bdynamictimerange = null;
            try {
                if (this.firstLoad) {
                    bdynamictimerange = this.getTimeRange() == null ? this.getDefaultTimeRange() : this.getTimeRange();
                    this.firstLoad = false;
                } else {
                    bdynamictimerange = this.getTimeRange() == null ? this.getRange() : this.getTimeRange();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!this.flag && !BAbsTime.NULL.equals((Object)this.lastTime)) {
                BAbsTime babstime3;
                BAbsTime babstime1;
                BAbsTime babstime2;
                BAbsTime babstime = BAbsTime.DEFAULT;
                if (this.lastTime != null) {
                    babstime = this.lastTime.add(BRelTime.make((long)1L));
                }
                if ((BAbsTime.NULL.equals((Object)(babstime2 = bdynamictimerange.getStartTime(babstime1 = BAbsTime.make((long)System.currentTimeMillis(), (BTimeZone)bhistory.getConfig().getTimeZone())))) || babstime.isAfter(babstime2)) && (BAbsTime.NULL.equals((Object)(babstime3 = bdynamictimerange.getEndTime(babstime1))) || babstime.isBefore(babstime3))) {
                    bdynamictimerange = BDynamicTimeRange.make((BAbsTime)babstime, (BAbsTime)babstime3);
                }
            }
            BITable data = null;
            if (bindings[i].getOrd() != null && !bindings[i].getOrd().isNull()) {
                BOrd bord1 = BOrd.make((String)(bindings[i].getOrd().toString() + '?' + bdynamictimerange.toOrdParams() + ";delta=" + String.valueOf(this.getDefaultDelta())));
                BOrd bord2 = BOrd.make((BOrd)bhistory.getAbsoluteOrd(), (BOrd)bord1).normalize();
                data = (BITable)bord2.get(this.getCurrentValueSession().asObject());
            }
            if (data == null || Tables.slurp((BITable)data).size() <= 0) continue;
            ColumnList columnlist = ((BITable)data).getColumns();
            Column column = columnlist.get("value");
            Type type = column.getType();
            if (type.is(BINumeric.TYPE)) {
                axis = numAxis;
            } else {
                axis = new BDiscreteAxis();
                ((BDiscreteAxis)axis).setRange(this.getRange(data, column));
            }
            if (i == 0) {
                xAxis = new BAbsTimeAxis(bhistory.getConfig().getTimeZone());
            }
            TableSeries tableseries = new TableSeries(this.getPointName(bindings[i].getOrd()), data, "timestamp", "value");
            double max = Double.parseDouble(tableseries.getMax(1).toString());
            double min = Double.parseDouble(tableseries.getMin(1).toString());
            this.usage = max - min;
            try {
                DecimalFormat df = new DecimalFormat();
                df.setMaximumFractionDigits(2);
                df.setMinimumFractionDigits(2);
                double cost = this.usage * this.getCostPerUnit();
                this.lblUsage.setText("  Usage: " + df.format(this.usage) + " " + tableseries.getColumnFacets(1).get("units").toString() + "      ");
                this.lblUsageCost.setText("  Cost: $ " + df.format(cost) + "      ");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            tableseries.setBrush(null);
            simplechartmodel.add(new ChartSpec((Series)tableseries, (BAxis)xAxis, (BAxis)axis));
        }
        ((BChart)chart).setModel((ChartModel)simplechartmodel);
        if (this.getChartPane().get("chart") != null) {
            this.getChartPane().remove("chart");
        }
        this.getChartPane().add("chart", (BValue)chart);
        this.getChartPane().noZoom();
        this.getChartPane().getCanvas().setZoomed(false);
        this.getChartPane().getHeader().setTitle(this.getChartTitle());
        this.getChartPane().relayout();
        this.getChartPane().repaint();
    }

    public void bindingsChanged() {
        super.bindingsChanged();
        this.loadData();
    }

    private String getPointName(BOrd ord) {
        String sOrd = ord.encodeToString();
        String[] strings = TextUtil.split((String)sOrd, (char)'/');
        return SlotPath.unescape((String)strings[strings.length - 1]);
    }

    public void doLoadValue(BObject bobject, Context context) {
        super.doLoadValue(bobject, context);
        this.addUsage();
    }

    private final Object[] getRange(BITable bitable, Column column) {
        BEnumRange benumrange;
        BFacets bfacets = column.getFacets();
        BObject bobject = null;
        if (bfacets != null) {
            bobject = bfacets.get("range");
        }
        if (bobject != null && bobject instanceof BEnumRange && (benumrange = (BEnumRange)bobject).getOrdinals().length != 0) {
            return BLynxUsageHistoryChart.pullRange((BEnumRange)bobject, bitable, column);
        }
        BIRandomAccessTable rat = Tables.slurp((BITable)bitable);
        int i = rat.size();
        if (i != 0) {
            BObject bobject1 = (BObject)rat.get(0).cell(column);
            if (bobject1 instanceof BEnum) {
                BEnumRange benumrange1 = ((BEnum)bobject1).getRange();
                return BLynxUsageHistoryChart.pullRange(benumrange1, bitable, column);
            }
            return BLynxUsageHistoryChart.findRange(bitable, column);
        }
        Type type = column.getType();
        if (!type.isAbstract() && type.is(BFrozenEnum.TYPE)) {
            return BLynxUsageHistoryChart.pullRange(((BEnum)type.getInstance()).getRange(), bitable, column);
        }
        return new Object[0];
    }

    private static final Object[] pullRange(BEnumRange benumrange, BITable bitable, Column column) {
        int[] ai = benumrange.getOrdinals();
        IntHashMap inthashmap = new IntHashMap(Math.max(7, ai.length));
        for (int i = 0; i < ai.length; ++i) {
            inthashmap.put(ai[i], (Object)benumrange.get(ai[i]));
        }
        BIRandomAccessTable rat = Tables.slurp((BITable)bitable);
        int j = rat.size();
        for (int k = 0; k < j; ++k) {
            BEnum benum = (BEnum)rat.get(k).cell(column);
            if (inthashmap.get(benum.getOrdinal()) != null) continue;
            inthashmap.put(benum.getOrdinal(), (Object)benum);
        }
        Object[] abenum = (BEnum[])inthashmap.toArray((Object[])new BEnum[inthashmap.size()]);
        SortUtil.sort((Object[])abenum);
        return abenum;
    }

    private static final Object[] findRange(BITable bitable, Column column) {
        BIRandomAccessTable rat = Tables.slurp((BITable)bitable);
        int i = rat.size();
        ArrayList<BObject> arraylist = new ArrayList<BObject>(i);
        for (int j = 0; j < i; ++j) {
            BObject bobject = (BObject)rat.get(j).cell(column);
            if (arraylist.contains(bobject)) continue;
            arraylist.add(bobject);
        }
        Object[] aobj = arraylist.toArray();
        if (aobj[0] instanceof Comparable) {
            SortUtil.sort((Object[])aobj);
        }
        return aobj;
    }

    public BDynamicTimeRange getTimeRange() {
        return this.timeRange;
    }

    public void setTimeRange(BDynamicTimeRange timeRange) {
        this.timeRange = timeRange;
    }
}

