/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.px;

import com.lynxspring.util.BLynxKitPxLicenseService;
import javax.baja.gx.BImage;
import javax.baja.gx.BSize;
import javax.baja.gx.Graphics;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandEvent;
import javax.baja.ui.enums.BAlign;
import javax.baja.ui.enums.BButtonStyle;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="buttonStyle", type="BButtonStyle", defaultValue="BButtonStyle.none"), @NiagaraProperty(name="textToIconAlign", type="BAlign", defaultValue="BAlign.center"), @NiagaraProperty(name="mouseOver", type="BImage", defaultValue="BImage.NULL"), @NiagaraProperty(name="pressed", type="BImage", defaultValue="BImage.NULL"), @NiagaraProperty(name="disabled", type="BImage", defaultValue="BImage.NULL")})
public class BLynxImageButton
extends BButton {
    public static final Property buttonStyle = BLynxImageButton.newProperty((int)0, (BValue)BButtonStyle.none, null);
    public static final Property textToIconAlign = BLynxImageButton.newProperty((int)0, (BValue)BAlign.center, null);
    public static final Property mouseOver = BLynxImageButton.newProperty((int)0, (BValue)BImage.NULL, null);
    public static final Property pressed = BLynxImageButton.newProperty((int)0, (BValue)BImage.NULL, null);
    public static final Property disabled = BLynxImageButton.newProperty((int)0, (BValue)BImage.NULL, null);
    public static final Type TYPE = Sys.loadType(BLynxImageButton.class);
    private boolean oloaded = false;
    private boolean ploaded = false;
    private boolean dloaded = false;

    public BButtonStyle getButtonStyle() {
        return (BButtonStyle)this.get(buttonStyle);
    }

    public void setButtonStyle(BButtonStyle v) {
        this.set(buttonStyle, (BValue)v, null);
    }

    public BAlign getTextToIconAlign() {
        return (BAlign)this.get(textToIconAlign);
    }

    public void setTextToIconAlign(BAlign v) {
        this.set(textToIconAlign, (BValue)v, null);
    }

    public BImage getMouseOver() {
        return (BImage)this.get(mouseOver);
    }

    public void setMouseOver(BImage v) {
        this.set(mouseOver, (BValue)v, null);
    }

    public BImage getPressed() {
        return (BImage)this.get(pressed);
    }

    public void setPressed(BImage v) {
        this.set(pressed, (BValue)v, null);
    }

    public BImage getDisabled() {
        return (BImage)this.get(disabled);
    }

    public void setDisabled(BImage v) {
        this.set(disabled, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void computePreferredSize() {
        super.computePreferredSize();
        BSize size = this.getMaxImageSize();
        double pw = Math.max(size.width, this.getPreferredWidth());
        double ph = Math.max(size.height, this.getPreferredHeight());
        if (pw > 0.0 && ph > 0.0) {
            this.setPreferredSize(pw, ph);
        }
    }

    public void paintBackground(Graphics g) {
        super.paintBackground(g);
        if (!this.isEnabled()) {
            BImage img = this.getDisabled();
            if (img.isNull() && !this.getImage().isNull()) {
                img = this.getImage().getDisabledImage();
            }
            this.paintImage(g, img);
        } else if (this.isPressed() && this.isMouseOver() && !this.getPressed().isNull()) {
            this.paintImage(g, this.getPressed());
        } else if (this.isMouseOver() && !this.getMouseOver().isNull()) {
            this.paintImage(g, this.getMouseOver());
        } else if (!this.getImage().isNull()) {
            this.paintImage(g, this.getImage());
        }
    }

    protected void paintIcon(Graphics g, BImage image, double x, double y) {
    }

    private void paintImage(Graphics g, BImage img) {
        double x = (this.getWidth() - img.getWidth()) / 2.0;
        double y = (this.getHeight() - img.getHeight()) / 2.0;
        g.drawImage(img, x, y);
    }

    public void animate() {
        if (!this.getMouseOver().isNull() && !this.oloaded && this.getMouseOver().isLoaded()) {
            this.oloaded = true;
            this.relayout();
        }
        if (!this.getPressed().isNull() && !this.ploaded && this.getPressed().isLoaded()) {
            this.ploaded = true;
            this.relayout();
        }
        if (!this.getDisabled().isNull() && !this.dloaded && this.getDisabled().isLoaded()) {
            this.dloaded = true;
            this.relayout();
        }
    }

    public void doInvokeAction(CommandEvent event) {
        if (!BLynxKitPxLicenseService.isLicensed((BWidget)this)) {
            return;
        }
        super.doInvokeAction(event);
    }

    private BSize getMaxImageSize() {
        double iw = 0.0;
        double ih = 0.0;
        BImage img = this.getImage();
        if (!img.isNull()) {
            iw = img.getWidth();
            ih = img.getHeight();
        }
        if (!(img = this.getMouseOver()).isNull()) {
            iw = Math.max(iw, img.getWidth());
            ih = Math.max(ih, img.getHeight());
        }
        if (!(img = this.getPressed()).isNull()) {
            iw = Math.max(iw, img.getWidth());
            ih = Math.max(ih, img.getHeight());
        }
        if (!(img = this.getDisabled()).isNull()) {
            iw = Math.max(iw, img.getWidth());
            ih = Math.max(ih, img.getHeight());
        }
        return BSize.make((double)iw, (double)ih);
    }
}

