/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.px;

import com.tridium.history.fox.BFoxHistoryDevice;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nav.BINavNode;
import javax.baja.space.BISpaceNode;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;

public class BLynxHistorySelector
extends BWidget {
    public static final Type TYPE = Sys.loadType(BLynxHistorySelector.class);
    private AddCommand addCommand;
    private RemoveCommand removeCommand;
    private ClearCommand clearCommand;
    private BList list;
    private BList histList;
    private BPane buttonPane;

    public Type getType() {
        return TYPE;
    }

    public BLynxHistorySelector() {
    }

    public BLynxHistorySelector(BFoxHistoryDevice device) {
        this.histList = new BList();
        this.add("histList", (BValue)this.histList);
        this.addCommand = new AddCommand(this, ">>");
        this.removeCommand = new RemoveCommand(this, "<<");
        this.clearCommand = new ClearCommand(this, "Clear");
        BGridPane bgridpane = new BGridPane(1);
        bgridpane.setColumnAlign(BHalign.fill);
        bgridpane.add("add", (BValue)new BButton((Command)this.addCommand));
        bgridpane.add("remove", (BValue)new BButton((Command)this.removeCommand));
        bgridpane.add("clear", (BValue)new BButton((Command)this.clearCommand));
        this.buttonPane = new BBorderPane((BWidget)bgridpane, 4.0, 4.0, 4.0, 4.0);
        this.add("buttons", (BValue)this.buttonPane);
        this.list = new BList();
        this.add("list", (BValue)this.list);
        if (device != null) {
            for (int i = 0; i < device.getNavChildren().length; ++i) {
                this.histList.addItem(BImage.make((BIcon)device.getNavChildren()[i].getNavIcon()), (Object)new Item(device.getNavChildren()[i]));
            }
        }
    }

    public void addExisting(BINavNode node) {
        this.list.addItem(BImage.make((BIcon)node.getNavIcon()), (Object)new Item(node));
    }

    public void computePreferredSize() {
        this.histList.computePreferredSize();
        this.buttonPane.computePreferredSize();
        this.list.computePreferredSize();
        double d = this.buttonPane.getPreferredWidth();
        double d1 = this.list.getPreferredWidth();
        double d2 = Math.max(this.buttonPane.getPreferredHeight(), 200.0);
        this.setPreferredSize(d += Math.max(d1, 200.0) * 2.0, d2);
    }

    public void doLayout(BWidget[] abwidget) {
        this.buttonPane.computePreferredSize();
        double d = (this.getWidth() - this.buttonPane.getPreferredWidth()) / 2.0;
        this.histList.setBounds(0.0, 0.0, d, this.getHeight());
        this.buttonPane.setBounds(d, (this.getHeight() - this.buttonPane.getPreferredHeight()) / 2.0, this.buttonPane.getPreferredWidth(), this.buttonPane.getPreferredHeight());
        double d1 = d + this.buttonPane.getPreferredWidth();
        this.list.setBounds(d1, 0.0, this.getWidth() - d1, this.getHeight());
    }

    public BOrd[] getResult() {
        int i = this.list.getItemCount();
        BOrd[] abord = new BOrd[i];
        for (int j = 0; j < i; ++j) {
            abord[j] = ((Item)this.list.getItem(j)).getOrd();
        }
        return abord;
    }

    public class RemoveCommand
    extends Command {
        public RemoveCommand(BWidget owner, String label) {
            super(owner, label);
        }

        public CommandArtifact doInvoke() {
            BLynxHistorySelector.this.list.removeSelectedItems();
            return null;
        }
    }

    public class AddCommand
    extends Command {
        public AddCommand(BWidget owner, String label) {
            super(owner, label);
        }

        public CommandArtifact doInvoke() {
            for (int i = 0; i < BLynxHistorySelector.this.histList.getSelectedItems().length; ++i) {
                BLynxHistorySelector.this.list.addItem(BImage.make((BIcon)((Item)BLynxHistorySelector.this.histList.getSelectedItems()[i]).getIcon()), BLynxHistorySelector.this.histList.getSelectedItems()[i]);
            }
            BLynxHistorySelector.this.histList.setSelectedIndex(-1);
            return null;
        }
    }

    private class Item {
        BINavNode node;
        String display;

        public BOrd getOrd() {
            return ((BISpaceNode)this.node).getOrdInSpace();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Item) {
                return ((Item)obj).display.equals(this.display);
            }
            return false;
        }

        public String toString() {
            return SlotPath.unescape((String)this.display);
        }

        public Item(BINavNode binavnode) {
            this.node = binavnode;
            this.display = this.node.getNavName();
        }

        public BIcon getIcon() {
            return this.node.getNavIcon();
        }
    }

    public class ClearCommand
    extends Command {
        public ClearCommand(BWidget owner, String label) {
            super(owner, label);
        }

        public CommandArtifact doInvoke() {
            BLynxHistorySelector.this.list.getModel().removeAllItems();
            return null;
        }
    }
}

