/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.px;

import com.lynxspring.px.BLynxHistoryChart;
import com.lynxspring.px.BLynxHistorySelector;
import com.lynxspring.px.bindings.BLynxTableChartBinding;
import com.tridium.bql.util.BDynamicTimeRange;
import com.tridium.history.fox.BFoxHistoryDevice;
import com.tridium.history.fox.BFoxHistorySpace;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.OutputStream;
import javax.baja.chart.BChart;
import javax.baja.chart.BChartPane;
import javax.baja.chart.binding.BAxisSpec;
import javax.baja.chart.binding.BColumnIdentifier;
import javax.baja.chart.binding.BTableChartBinding;
import javax.baja.file.BExporter;
import javax.baja.file.ExportOp;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.history.BHistorySpace;
import javax.baja.history.HistoryQuery;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.IFilter;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBinding;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.view.BWbView;

@NiagaraType
@NiagaraAction(name="fieldEditorModified")
public final class BLynxChartExPane
extends BEdgePane {
    public static final Action fieldEditorModified = BLynxChartExPane.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BLynxChartExPane.class);
    private BDynamicTimeRange range = BDynamicTimeRange.TODAY;
    private BWbFieldEditor fe = null;
    public static final Lexicon lex = Lexicon.make(BLynxChartExPane.class);
    private Log log = Log.getLog((String)"chartExPane");
    private BColor[] colors = new BColor[]{BColor.red, BColor.cyan, BColor.purple, BColor.green, BColor.pink, BColor.skyBlue, BColor.aquamarine, BColor.gold, BColor.brown, BColor.darkGray};
    private BComponent parentDevice;
    private BWbView mainView;

    public void fieldEditorModified() {
        this.invoke(fieldEditorModified, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        BWbView view;
        BGridPane pane = new BGridPane();
        this.fe = BWbFieldEditor.makeFor((BObject)BDynamicTimeRange.TODAY);
        this.fe.loadValue((BObject)this.range);
        this.linkTo("link0", (BComponent)this.fe, (Slot)BWbFieldEditor.setModified, (Slot)fieldEditorModified);
        BComponent parent = null;
        while (!((parent = parent == null ? (BComponent)this.getParent() : (BComponent)parent.getParent()) instanceof BWbView)) {
        }
        this.mainView = view = (BWbView)parent;
        for (parent = (BComponent)((BComponent)view.getCurrentValue()).getParent(); !parent.getType().is(Sys.getType((String)"driver:Device")) && parent != null; parent = (BComponent)parent.getParent()) {
        }
        this.parentDevice = parent;
        boolean access = this.isUserHistoryAccess();
        BInsets insets = BInsets.make((double)4.0, (double)2.0, (double)4.0, (double)2.0);
        BButton addBinding = new BButton((Command)new AddBindingCommand());
        addBinding.setEnabled(access);
        pane.add(null, (BValue)new BBorderPane((BWidget)addBinding, insets));
        BButton removeBinding = new BButton((Command)new RemoveBindingCommand());
        removeBinding.setEnabled(access);
        pane.add(null, (BValue)new BBorderPane((BWidget)removeBinding, insets));
        BButton configBinding = new BButton((Command)new ConfigYAxisCommand());
        pane.add(null, (BValue)new BBorderPane((BWidget)configBinding, insets));
        BButton refresh = new BButton((Command)new RefreshCommand());
        pane.add(null, (BValue)new BBorderPane((BWidget)refresh, insets));
        BButton exportAndOpen = new BButton((Command)new ExportAndOpenCommand());
        pane.add(null, (BValue)new BBorderPane((BWidget)exportAndOpen, insets));
        pane.add(null, (BValue)new BBorderPane((BWidget)this.fe, insets));
        pane.setColumnCount(((BComponent[])this.getChildren(BComponent.class)).length + 1);
        this.setTop((BWidget)pane);
    }

    public void stopped() {
        this.setTop((BWidget)new BNullWidget());
    }

    public void doFieldEditorModified() {
        this.saveChart(this.isViewModified());
    }

    private BTableChartBinding[] findBindings() {
        Array a = new Array(BTableChartBinding.class);
        this.findTableChartBindings((BWidget)this.getParent(), a);
        return (BTableChartBinding[])a.trim();
    }

    private void findTableChartBindings(BWidget w, Array a) {
        BWidget[] kids = (BWidget[])w.getChildren(BWidget.class);
        BBinding[] bindings = null;
        for (int i = 0; i < kids.length; ++i) {
            bindings = kids[i].getBindings();
            for (int x = 0; x < bindings.length; ++x) {
                if (!(bindings[x] instanceof BTableChartBinding)) continue;
                a.add((Object)bindings[x]);
            }
            this.findTableChartBindings(kids[i], a);
        }
    }

    private BChartPane getChartPane() throws Exception {
        BChartPane chartPane = null;
        if (this.getCenter().getType().is(BChartPane.TYPE)) {
            chartPane = (BChartPane)this.getCenter();
        } else if (this.getCenter().getType().is(BLynxHistoryChart.TYPE)) {
            chartPane = ((BLynxHistoryChart)this.getCenter()).getChartPane();
        } else {
            throw new Exception("Could not find chart pane!");
        }
        return chartPane;
    }

    private boolean isViewModified() {
        BWbShell shell = BWbShell.getWbShell((BWidget)this);
        if (shell != null) {
            BWbView activeView = BWbShell.getWbShell((BWidget)this).getActiveView();
            return activeView.isModified();
        }
        return false;
    }

    private String getTimeRangeParamStr() throws Exception {
        this.range = (BDynamicTimeRange)this.fe.saveValue((BObject)this.range, null);
        return "?" + this.range.toOrdParams();
    }

    private void saveChart(boolean alreadyModified) {
        block15: {
            if (this.getCenter().getType().is(BLynxHistoryChart.TYPE)) {
                try {
                    ((BLynxHistoryChart)this.getCenter()).setTimeRange((BDynamicTimeRange)this.fe.saveValue(null));
                }
                catch (CannotSaveException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ((BLynxHistoryChart)this.getCenter()).doLoadValue(this.mainView.getCurrentValue(), null);
                return;
            }
            if (this.fe != null) {
                try {
                    String timeRangeStr = this.getTimeRangeParamStr();
                    if (this.log.isTraceOn()) {
                        this.log.trace("Got this time range: " + this.range);
                    }
                    BTableChartBinding[] bindings = this.findBindings();
                    BChartPane chartPane = this.getChartPane();
                    for (int i = 0; i < bindings.length; ++i) {
                        if (this.log.isTraceOn()) {
                            this.log.trace("Found this binding: " + bindings[i].getOrd());
                        }
                        OrdQuery[] queries = bindings[i].getOrd().parse();
                        for (int x = 0; x < queries.length; ++x) {
                            if (!(queries[x] instanceof HistoryQuery)) continue;
                            String bodyStr = queries[x].getBody();
                            int paramIndex = bodyStr.lastIndexOf("?");
                            if (paramIndex > -1) {
                                bodyStr = bodyStr.substring(0, paramIndex);
                            }
                            bodyStr = bodyStr + timeRangeStr;
                            queries[x] = new HistoryQuery(bodyStr);
                        }
                        bindings[i].setOrd(BOrd.make((OrdQuery[])queries));
                        if (!this.log.isTraceOn()) continue;
                        this.log.trace("Parsed to this Ord: " + BOrd.make((OrdQuery[])queries));
                    }
                    if (chartPane != null) {
                        BChartPane newPane = (BChartPane)chartPane.newCopy();
                        this.setCenter((BWidget)newPane);
                        if (alreadyModified) {
                            BWbView activeView = BWbShell.getWbShell((BWidget)this).getActiveView();
                            activeView.clearModified();
                        }
                        if (this.log.isTraceOn()) {
                            this.log.trace("Cleared the modified view");
                        }
                    }
                }
                catch (Exception e) {
                    if (!this.log.isTraceOn()) break block15;
                    this.log.trace("Error attempting to save chart", (Throwable)e);
                }
            }
        }
    }

    private BColor getColor(int index) {
        if (index + 1 > this.colors.length) {
            return this.colors[0];
        }
        return this.colors[index];
    }

    private boolean isUserHistoryAccess() {
        BWbShell shell = BWbShell.getWbShell((BWidget)this);
        if (shell == null) {
            return true;
        }
        BHistorySpace space = (BHistorySpace)BOrd.make((BOrd)shell.getActiveOrd(), (String)"history:").get();
        return space.listDevices().length > 0;
    }

    private static String formatPath(File file) throws Exception {
        String path = "";
        String[] s = TextUtil.split((String)file.getCanonicalPath(), (char)'\\');
        for (int i = 0; i < s.length; ++i) {
            if (i > 0) {
                path = path + "\\";
            }
            path = s[i].indexOf(" ") != -1 ? path + "\"" + s[i] + "\"" : path + s[i];
        }
        return path;
    }

    public static void main(String[] args) {
    }

    private class ExportAndOpenCommand
    extends Command {
        private BImage icon;

        ExportAndOpenCommand() {
            super((BWidget)BLynxChartExPane.this, "");
            this.icon = BImage.make((BIcon)BIcon.std((String)"export.png"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CommandArtifact doInvoke() {
            BTableChartBinding[] bindings = BLynxChartExPane.this.findBindings();
            if (bindings.length == 0) {
                BDialog.error((BWidget)this.getOwner(), (Object)lex.getText("chartEx.exportAndOpen.noPlots"));
                return null;
            }
            BEdgePane pane = new BEdgePane();
            pane.setTop((BWidget)new BBorderPane((BWidget)new BLabel(lex.getText("chartEx.exportAndOpen.selectPlot"), BHalign.left), BInsets.make((double)4.0, (double)4.0, (double)0.0, (double)4.0)));
            BListDropDown list = new BListDropDown();
            for (int i = 0; i < bindings.length; ++i) {
                list.getList().addItem((Object)bindings[i].getOrd().toString());
            }
            list.setSelectedIndex(0);
            pane.setCenter((BWidget)new BBorderPane((BWidget)list));
            if (BDialog.open((BWidget)this.getOwner(), (String)lex.getText("chartEx.exportAndOpen"), (Object)pane, (int)3) == 1) {
                BWbShell shell = BWbShell.getWbShell((BWidget)this.getOwner());
                BOrd exportOrd = BOrd.make((BOrd)shell.getActiveOrd(), (BOrd)BOrd.make((String)(list.getSelectedItem().toString() + "|bql:select"))).normalize();
                OrdTarget target = exportOrd.resolve();
                BExporter exporter = (BExporter)Sys.getType((String)"file:ITableToCsv").getInstance();
                FilterOutputStream out = null;
                try {
                    File dir = new File(Sys.getBajaHome(), "temp");
                    dir.mkdirs();
                    File file = File.createTempFile("temp", "." + exporter.getFileExtension(), dir);
                    file.deleteOnExit();
                    out = new BufferedOutputStream(new FileOutputStream(file));
                    exporter.export(ExportOp.make((OrdTarget)target, (OutputStream)out));
                    Runtime.getRuntime().exec("cmd.exe /c start " + BLynxChartExPane.formatPath(file));
                }
                catch (Exception e) {
                    BLynxChartExPane.this.log.error("Could not export to temporary file!", (Throwable)e);
                    BDialog.error((BWidget)this.getOwner(), (String)lex.getText("chartEx.exportAndOpen.couldNotCreateTempFile"), (Object)e);
                }
                finally {
                    try {
                        if (out != null) {
                            out.close();
                        }
                    }
                    catch (Exception e2) {
                        BLynxChartExPane.this.log.error("Fatal error attempting to shut output stream for exporting data", (Throwable)e2);
                    }
                }
            }
            return null;
        }

        public BImage getIcon() {
            return this.icon;
        }
    }

    private class RefreshCommand
    extends Command {
        private BImage icon;

        RefreshCommand() {
            super((BWidget)BLynxChartExPane.this, "");
            this.icon = BImage.make((BIcon)BIcon.std((String)"refresh.png"));
        }

        public CommandArtifact doInvoke() {
            BLynxChartExPane.this.saveChart(BLynxChartExPane.this.isViewModified());
            return null;
        }

        public BImage getIcon() {
            return this.icon;
        }
    }

    private class ConfigYAxisCommand
    extends Command {
        private BImage icon;

        ConfigYAxisCommand() {
            super((BWidget)BLynxChartExPane.this, lex.getText("chartEx.yAxis"));
            this.icon = BImage.make((BIcon)BIcon.std((String)"grid.png"));
        }

        public CommandArtifact doInvoke() {
            BTableChartBinding[] bindings = BLynxChartExPane.this.findBindings();
            if (bindings.length <= 0) {
                return null;
            }
            BList list = new BList();
            for (int i = 0; i < bindings.length; ++i) {
                list.addItem((Object)bindings[i].getOrd().toString());
            }
            list.setMultipleSelection(true);
            list.setSelectedIndex(0);
            BDialog.open((BWidget)this.getOwner(), (String)lex.getText("chartEx.yAxis.selectPlots"), (Object)list, (int)1);
            int[] selectionIndices = list.getSelectedIndices();
            if (selectionIndices.length == 0) {
                return null;
            }
            BAxisSpec spec = bindings[0].getYAxis();
            spec.setValueType(BINumeric.TYPE.getTypeSpec());
            BWbFieldEditor editor = BWbFieldEditor.makeFor((BObject)spec);
            editor.loadValue((BObject)spec);
            if (BDialog.open((BWidget)this.getOwner(), (String)lex.getText("chartEx.configYAxis"), (Object)editor, (int)3) == 1) {
                try {
                    boolean viewModified = BLynxChartExPane.this.isViewModified();
                    spec = (BAxisSpec)editor.saveValue();
                    for (int i = 0; i < selectionIndices.length; ++i) {
                        bindings[selectionIndices[i]].setYAxis((BAxisSpec)spec.newCopy());
                    }
                    BLynxChartExPane.this.saveChart(viewModified);
                }
                catch (NumberFormatException e) {
                    BLynxChartExPane.this.log.error("Could not format input text to a number", (Throwable)e);
                    BDialog.error((BWidget)this.getOwner(), (Object)lex.getText("chartEx.configYAxis.numberFormat"));
                }
                catch (Exception e) {
                    BLynxChartExPane.this.log.error("Cannot adjust Y axis", (Throwable)e);
                }
            }
            return null;
        }

        public BImage getIcon() {
            return this.icon;
        }
    }

    private class RemoveBindingCommand
    extends Command {
        private BImage icon;

        RemoveBindingCommand() {
            super((BWidget)BLynxChartExPane.this, "");
            this.icon = BImage.make((BIcon)BIcon.std((String)"subtract.png"));
        }

        public CommandArtifact doInvoke() {
            BTableChartBinding[] bindings = BLynxChartExPane.this.findBindings();
            BList list = new BList();
            for (int i = 0; i < bindings.length; ++i) {
                list.addItem((Object)bindings[i].getOrd().newCopy());
            }
            if (BDialog.open((BWidget)this.getOwner(), (String)lex.getText("chartEx.removeBinding"), (Object)list, (int)3) == 1) {
                Object[] selectedItems = list.getSelectedItems();
                BTableChartBinding b = null;
                BOrd ord = null;
                boolean viewModified = BLynxChartExPane.this.isViewModified();
                for (int i = 0; i < selectedItems.length; ++i) {
                    ord = (BOrd)selectedItems[i];
                    for (int x = 0; x < bindings.length; ++x) {
                        if (!bindings[x].getOrd().equals((Object)ord)) continue;
                        b = bindings[x];
                        break;
                    }
                    BComponent comp = (BComponent)b.getParent();
                    comp.remove(b);
                }
                BLynxChartExPane.this.saveChart(viewModified);
            }
            return null;
        }

        public BImage getIcon() {
            return this.icon;
        }
    }

    private class AddBindingCommand
    extends Command {
        private BImage icon;

        AddBindingCommand() {
            super((BWidget)BLynxChartExPane.this, "");
            this.icon = BImage.make((BIcon)BIcon.std((String)"add.png"));
        }

        public CommandArtifact doInvoke() {
            block10: {
                try {
                    BWbShell shell = BWbShell.getWbShell((BWidget)this.getOwner());
                    BFoxHistorySpace space = null;
                    try {
                        space = (BFoxHistorySpace)BOrd.make((BOrd)shell.getActiveOrd(), (String)"history:").get();
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                    }
                    BFoxHistoryDevice history = null;
                    history = new BFoxHistoryDevice(space, BLynxChartExPane.this.parentDevice.getName(), null);
                    BLynxHistorySelector histSelector = new BLynxHistorySelector(history);
                    final BTableChartBinding[] bindings = BLynxChartExPane.this.findBindings();
                    for (int i = 0; i < bindings.length; ++i) {
                        histSelector.addExisting((BINavNode)bindings[i].getOrd().resolve(BLynxChartExPane.this.mainView.getCurrentValue()).get());
                    }
                    if (BDialog.open((BWidget)this.getOwner(), (String)"Add Chart Binding", (Object)((Object)histSelector), (int)3) != 1) break block10;
                    Array histArray = new Array(BOrd.class);
                    histArray.addAll((Object[])histSelector.getResult());
                    histArray = histArray.filter(new IFilter(){

                        public boolean accept(Object obj) {
                            BOrd histOrd = (BOrd)obj;
                            for (int i = 0; i < bindings.length; ++i) {
                                if (!bindings[i].getOrd().equals((Object)histOrd)) continue;
                                return false;
                            }
                            return true;
                        }
                    });
                    BOrd[] hists = (BOrd[])histArray.trim();
                    boolean viewModified = BLynxChartExPane.this.isViewModified();
                    BChartPane chart = BLynxChartExPane.this.getChartPane();
                    BChart[] charts = chart.getCharts();
                    if (BLynxChartExPane.this.getCenter().getType().is(BLynxHistoryChart.TYPE)) {
                        BLynxTableChartBinding b = null;
                        for (int x = 0; x < hists.length; ++x) {
                            b = new BLynxTableChartBinding();
                            b.setOrd(hists[x]);
                            b.setColumn0(BColumnIdentifier.makeTableColumn((String)"timestamp"));
                            b.setColumn1(BColumnIdentifier.makeTableColumn((String)"value"));
                            b.setBrush(BLynxChartExPane.this.getColor(x).toBrush());
                            ((BLynxHistoryChart)BLynxChartExPane.this.getCenter()).add("binding?", (BValue)b);
                        }
                    } else {
                        BTableChartBinding b = null;
                        for (int i = 0; i < charts.length; ++i) {
                            for (int x = 0; x < hists.length; ++x) {
                                b = new BTableChartBinding();
                                b.setOrd(hists[x]);
                                b.setColumn0(BColumnIdentifier.makeTableColumn((String)"timestamp"));
                                b.setColumn1(BColumnIdentifier.makeTableColumn((String)"value"));
                                b.setBrush(BLynxChartExPane.this.getColor(x).toBrush());
                                charts[i].add("binding?", (BValue)b);
                            }
                        }
                    }
                    BLynxChartExPane.this.saveChart(viewModified);
                }
                catch (Exception e) {
                    BLynxChartExPane.this.log.error("Could not add binding!", (Throwable)e);
                    BDialog.error((BWidget)this.getOwner(), (String)lex.getText("chartEx.addBinding.error"), (Object)e);
                }
            }
            return null;
        }

        public BImage getIcon() {
            return this.icon;
        }
    }
}

