/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.px;

import com.lynxspring.util.BLynxKitPxLicenseService;
import com.tridium.ui.UiEnv;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.theme.WidgetTheme;
import com.tridium.workbench.shell.BNiagaraWbShell;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.baja.file.BIFile;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.gx.RectGeom;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BIHyperlinkShell;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.enums.BAlign;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BInputEvent;
import javax.baja.ui.event.BMouseEvent;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="border", type="BBorder", defaultValue="BBorder.DEFAULT"), @NiagaraProperty(name="padding", type="BInsets", defaultValue="BInsets.make(0,0,0,0)"), @NiagaraProperty(name="text", type="String", defaultValue="BString.DEFAULT"), @NiagaraProperty(name="image", type="BImage", defaultValue="BImage.NULL"), @NiagaraProperty(name="font", type="BFont", defaultValue="BFont.NULL"), @NiagaraProperty(name="foreground", type="BColor", defaultValue="BColor.NULL"), @NiagaraProperty(name="background", type="BColor", defaultValue="BColor.NULL"), @NiagaraProperty(name="halign", type="BHalign", defaultValue="BHalign.center"), @NiagaraProperty(name="valign", type="BValign", defaultValue="BValign.center"), @NiagaraProperty(name="textToIconAlign", type="BAlign", defaultValue="BAlign.right"), @NiagaraProperty(name="textIconGap", type="double", defaultValue="4"), @NiagaraProperty(name="ord", type="BOrd", defaultValue="BOrd.NULL"), @NiagaraProperty(name="highlight", type="BColor", defaultValue="BColor.make(0xFF, 0xFF, 0x00, 0x80)"), @NiagaraProperty(name="popupText", type="String", defaultValue=""), @NiagaraProperty(name="displayPopUp", type="boolean", defaultValue="true")})
public class BHighlightHyperlinkLabel
extends BWidget {
    public static final Property border = BHighlightHyperlinkLabel.newProperty((int)0, (BValue)BBorder.DEFAULT, null);
    public static final Property padding = BHighlightHyperlinkLabel.newProperty((int)0, (BValue)BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0), null);
    public static final Property text = BHighlightHyperlinkLabel.newProperty((int)0, (BValue)BString.DEFAULT, null);
    public static final Property image = BHighlightHyperlinkLabel.newProperty((int)0, (BValue)BImage.NULL, null);
    public static final Property font = BHighlightHyperlinkLabel.newProperty((int)0, (BValue)BFont.NULL, null);
    public static final Property foreground = BHighlightHyperlinkLabel.newProperty((int)0, (BValue)BColor.NULL, null);
    public static final Property background = BHighlightHyperlinkLabel.newProperty((int)0, (BValue)BColor.NULL, null);
    public static final Property halign = BHighlightHyperlinkLabel.newProperty((int)0, (BValue)BHalign.center, null);
    public static final Property valign = BHighlightHyperlinkLabel.newProperty((int)0, (BValue)BValign.center, null);
    public static final Property textToIconAlign = BHighlightHyperlinkLabel.newProperty((int)0, (BValue)BAlign.right, null);
    public static final Property textIconGap = BHighlightHyperlinkLabel.newProperty((int)0, (int)4, null);
    public static final Property ord = BHighlightHyperlinkLabel.newProperty((int)0, (BValue)BOrd.NULL, null);
    public static final Property highlight = BHighlightHyperlinkLabel.newProperty((int)0, (BValue)BColor.make((int)255, (int)255, (int)0, (int)128), null);
    public static final Property popupText = BHighlightHyperlinkLabel.newProperty((int)0, (String)"", null);
    public static final Property displayPopUp = BHighlightHyperlinkLabel.newProperty((int)0, (boolean)true, null);
    public static final Type TYPE = Sys.loadType(BHighlightHyperlinkLabel.class);
    private static final BIcon icon = BIcon.std((String)"widgets/label.png");
    Layout layout = new Layout();
    boolean forceLayout;
    String popup;
    private boolean mouseOver = false;
    private boolean popupActive = false;
    private RectGeom geom = new RectGeom();

    public BBorder getBorder() {
        return (BBorder)this.get(border);
    }

    public void setBorder(BBorder v) {
        this.set(border, (BValue)v, null);
    }

    public BInsets getPadding() {
        return (BInsets)this.get(padding);
    }

    public void setPadding(BInsets v) {
        this.set(padding, (BValue)v, null);
    }

    public String getText() {
        return this.getString(text);
    }

    public void setText(String v) {
        this.setString(text, v, null);
    }

    public BImage getImage() {
        return (BImage)this.get(image);
    }

    public void setImage(BImage v) {
        this.set(image, (BValue)v, null);
    }

    public BFont getFont() {
        return (BFont)this.get(font);
    }

    public void setFont(BFont v) {
        this.set(font, (BValue)v, null);
    }

    public BColor getForeground() {
        return (BColor)this.get(foreground);
    }

    public void setForeground(BColor v) {
        this.set(foreground, (BValue)v, null);
    }

    public BColor getBackground() {
        return (BColor)this.get(background);
    }

    public void setBackground(BColor v) {
        this.set(background, (BValue)v, null);
    }

    public BHalign getHalign() {
        return (BHalign)this.get(halign);
    }

    public void setHalign(BHalign v) {
        this.set(halign, (BValue)v, null);
    }

    public BValign getValign() {
        return (BValign)this.get(valign);
    }

    public void setValign(BValign v) {
        this.set(valign, (BValue)v, null);
    }

    public BAlign getTextToIconAlign() {
        return (BAlign)this.get(textToIconAlign);
    }

    public void setTextToIconAlign(BAlign v) {
        this.set(textToIconAlign, (BValue)v, null);
    }

    public double getTextIconGap() {
        return this.getDouble(textIconGap);
    }

    public void setTextIconGap(double v) {
        this.setDouble(textIconGap, v, null);
    }

    public BOrd getOrd() {
        return (BOrd)this.get(ord);
    }

    public void setOrd(BOrd v) {
        this.set(ord, (BValue)v, null);
    }

    public BColor getHighlight() {
        return (BColor)this.get(highlight);
    }

    public void setHighlight(BColor v) {
        this.set(highlight, (BValue)v, null);
    }

    public String getPopupText() {
        return this.getString(popupText);
    }

    public void setPopupText(String v) {
        this.setString(popupText, v, null);
    }

    public boolean getDisplayPopUp() {
        return this.getBoolean(displayPopUp);
    }

    public void setDisplayPopUp(boolean v) {
        this.setBoolean(displayPopUp, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void computePreferredSize() {
        Layout temp = new Layout();
        temp.computeBounds();
        BInsets padding = this.getPadding();
        temp.aw += padding.left + padding.right;
        temp.ah += padding.top + padding.bottom;
        BBorder b = this.getBorder();
        double pw = temp.aw + b.leftWidth + b.rightWidth;
        double ph = temp.ah + b.topWidth + b.bottomWidth;
        this.setPreferredSize(pw, ph);
    }

    public void doLayout(BWidget[] kids) {
        this.forceLayout = false;
        double w = this.getWidth();
        double h = this.getHeight();
        BBorder b = this.getBorder();
        double cx = b.leftWidth;
        double cy = b.topWidth;
        double cw = w - (b.leftWidth + b.rightWidth);
        double ch = h - (b.topWidth + b.bottomWidth);
        double bx = 0.0;
        double by = 0.0;
        double bw = w;
        double bh = h;
        if (b.leftWidth > 0.0) {
            bx += 1.0;
            bw -= 1.0;
        }
        if (b.topWidth > 0.0) {
            by += 1.0;
            bh -= 1.0;
        }
        if (b.rightWidth > 0.0) {
            bw -= 1.0;
        }
        if (b.bottomWidth > 0.0) {
            bh -= 1.0;
        }
        BInsets padding = this.getPadding();
        this.layout.lines = null;
        this.layout.computeBounds();
        this.layout.computeAlignment(cw -= padding.left + padding.right, ch -= padding.top + padding.bottom);
        this.layout.xo += padding.left + cx;
        this.layout.yo += padding.top + cy;
        this.geom.set(bx, by, bw, bh);
    }

    public void changed(Property p, Context context) {
        if (p.equals(text)) {
            this.forceLayout = true;
            this.relayout();
        } else if (p == highlight) {
            BColor c = this.getHighlight();
            if (c.getAlpha() > 128) {
                this.setHighlight(BColor.make((int)c.getRed(), (int)c.getGreen(), (int)c.getBlue(), (int)128));
            } else {
                this.repaint();
            }
        } else {
            this.repaint();
        }
    }

    public void paint(Graphics g) {
        BColor fill;
        if (this.forceLayout) {
            this.forceLayout = false;
            this.relayoutSync();
        }
        Layout q = this.layout;
        double tx = q.tx;
        double ty = q.ty;
        double tw = q.tw;
        double ix = q.ix;
        double iy = q.iy;
        double xo = q.xo;
        double yo = q.yo;
        BFont font = this.getFont();
        if (font.isNull()) {
            font = this.theme().getTextFont();
        }
        if (!(fill = this.getBackground()).isNull()) {
            g.setBrush(fill);
            g.fill((IGeom)this.geom);
        }
        BImage image = this.getImage();
        if (this.layout.ipaint && !image.isNull()) {
            if (!this.isEnabled()) {
                image = image.getDisabledImage();
            }
            this.paintIcon(g, image, ix + xo, iy + yo);
        }
        String text = this.getText();
        WidgetTheme theme = this.theme();
        if (text.length() > 0 && q.lines != null) {
            BBrush brush = this.getForeground().toBrush();
            if (brush.isNull()) {
                brush = theme.getTextBrush();
            }
            g.setBrush(brush);
            g.setFont(font);
            BHalign ha = this.getHalign();
            for (int i = 0; i < q.lines.length; ++i) {
                double ax = 0.0;
                if (ha == BHalign.center) {
                    ax = (tw - q.widths[i]) / 2.0;
                } else if (ha == BHalign.right) {
                    ax = tw - q.widths[i];
                }
                if (this.isEnabled()) {
                    this.paintText(g, q.lines[i], tx + xo + ax, ty + yo + (double)i * q.lineHeight);
                    continue;
                }
                theme.paintDisabledText(g, q.lines[i], tx + xo + ax, ty + yo + (double)i * q.lineHeight);
            }
        }
        RectGeom r = this.geom;
        this.getBorder().paint(g, r.x, r.y, r.width, r.height);
        if (this.mouseOver && !this.getHighlight().equals((Object)BColor.NULL)) {
            double hw = this.getWidth() - this.getBorder().leftWidth - this.getBorder().rightWidth;
            double hh = this.getHeight() - this.getBorder().topWidth - this.getBorder().bottomWidth;
            g.setBrush(this.getHighlight());
            g.fillRect(this.getBorder().leftWidth, this.getBorder().topWidth, hw, hh);
        }
    }

    protected void paintIcon(Graphics g, BImage image, double x, double y) {
        g.drawImage(image, x, y);
    }

    protected void paintText(Graphics g, String text, double tx, double ty) {
        g.drawString(text, tx, ty);
    }

    public void animate() {
        BImage image = this.getImage();
        if (!image.isNull()) {
            if (!this.layout.iloaded && image.isLoaded()) {
                this.layout.iloaded = true;
                this.relayout();
            }
            if (image.animate()) {
                this.repaint();
            }
        }
    }

    public void mousePressed(BMouseEvent event) {
        if (!BLynxKitPxLicenseService.isLicensed(this)) {
            return;
        }
        BWidgetShell shell = this.getShell();
        BOrd ord = this.getOrd();
        if (this.mouseOver && !ord.isNull() && shell instanceof BIHyperlinkShell) {
            ((BIHyperlinkShell)shell).hyperlink(new HyperlinkInfo(ord, (BInputEvent)event));
        }
    }

    public void mouseEntered(BMouseEvent event) {
        BWidgetShell shell = this.getShell();
        BOrd ord = this.getOrd();
        if (shell != null && !ord.isNull()) {
            shell.showStatus(ord.toString());
            this.setMouseCursor(MouseCursor.hand);
        }
        this.mouseOver = true;
        this.repaint();
    }

    public void mouseMoved(BMouseEvent event) {
        if (this.popupActive) {
            this.popup(event);
        }
    }

    public void mouseExited(BMouseEvent event) {
        BWidgetShell shell = this.getShell();
        if (shell != null) {
            shell.showStatus(null);
        }
        this.mouseOver = false;
        this.setMouseCursor(MouseCursor.normal);
        UiEnv.get().closeBubbleHelp();
        this.popupActive = false;
        this.repaint();
    }

    public void mouseHover(BMouseEvent event) {
        if (!this.getDisplayPopUp()) {
            return;
        }
        this.popup = this.getPopupText();
        if (this.popup == null || this.popup.trim().length() == 0) {
            if (this.getBindings().length > 0 && !this.getBindings()[0].getOrd().equals((Object)BOrd.DEFAULT)) {
                this.popup = this.getDisplayName(this.getBindings()[0].getOrd());
            } else if (!this.getOrd().equals((Object)BOrd.DEFAULT)) {
                this.popup = this.getDisplayName(this.getOrd());
            }
        }
        this.popup(event);
    }

    private void popup(BMouseEvent event) {
        if (this.popup != null) {
            double x = event.getX() + 13.0;
            double y = event.getY() + 2.0;
            if (this.popupActive) {
                UiEnv.get().updateBubbleHelp((BWidget)this, x, y, this.popup);
            } else {
                UiEnv.get().openBubbleHelp((BWidget)this, x, y, this.popup);
            }
            this.popupActive = true;
        }
    }

    private String getDisplayName(BOrd ord) {
        try {
            BWidgetShell shell = this.getShell();
            BISession session = ((BNiagaraWbShell)shell).tab().getView().getCurrentValueSession();
            BObject obj = session.asObject();
            BObject res = ord.resolve(obj).get();
            if (res.isComplex()) {
                return res.asComplex().getDisplayName(null);
            }
            if (res instanceof BIFile) {
                String name = ((BIFile)res).getFileName();
                if (name.indexOf(46) > 1) {
                    String ext = '.' + ((BIFile)res).getExtension();
                    name = name.substring(0, name.length() - ext.length());
                }
                return name;
            }
            return res.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    WidgetTheme theme() {
        return Theme.label();
    }

    public BIcon getIcon() {
        return icon;
    }

    public BINavNode getNavChild(String navName) {
        return super.getNavChild(navName);
    }

    class Layout {
        boolean valid;
        double tx;
        double ty;
        double tw;
        double th;
        double ix;
        double iy;
        double iw;
        double ih;
        double aw;
        double ah;
        double xo;
        double yo;
        boolean ipaint;
        boolean iloaded;
        double lineHeight;
        String[] lines = null;
        double[] widths = null;

        Layout() {
        }

        void computeAlignment(double w, double h) {
            switch (BHighlightHyperlinkLabel.this.getHalign().getOrdinal()) {
                case 0: {
                    this.xo = 0.0;
                    break;
                }
                case 1: {
                    this.xo = (w - this.aw) / 2.0;
                    break;
                }
                case 2: {
                    this.xo = w - this.aw;
                    break;
                }
                case 3: {
                    this.xo = (w - this.aw) / 2.0;
                }
            }
            switch (BHighlightHyperlinkLabel.this.getValign().getOrdinal()) {
                case 0: {
                    this.yo = 0.0;
                    break;
                }
                case 1: {
                    this.yo = (h - this.ah) / 2.0;
                    break;
                }
                case 2: {
                    this.yo = h - this.ah;
                    break;
                }
                case 3: {
                    this.yo = (h - this.ah) / 2.0;
                }
            }
        }

        void computeBounds() {
            this.computeTextBounds();
            this.computeImageBounds();
            if (this.tw > 0.0 && this.iw > 0.0) {
                this.computeCompoundLayout();
            } else {
                this.aw = Math.max(this.tw, this.iw);
                this.ah = Math.max(this.th, this.ih);
            }
        }

        private void computeTextBounds() {
            BFont font = BHighlightHyperlinkLabel.this.getFont();
            if (font.isNull()) {
                font = BHighlightHyperlinkLabel.this.theme().getTextFont();
            }
            double fontHeight = font.getHeight();
            double fontDescent = font.getDescent();
            this.lineHeight = fontHeight;
            String text = BHighlightHyperlinkLabel.this.getText();
            if (text.length() == 0) {
                this.tw = 0.0;
                this.th = fontHeight;
                return;
            }
            if (this.lines == null) {
                this.parse();
                this.widths = new double[this.lines.length];
            }
            this.tx = 0.0;
            this.ty = fontHeight - fontDescent;
            this.tw = 0.0;
            this.th = this.lineHeight * (double)this.lines.length;
            for (int i = 0; i < this.lines.length; ++i) {
                this.widths[i] = font.width(this.lines[i]);
                this.tw = Math.max(this.tw, this.widths[i]);
            }
        }

        private void computeImageBounds() {
            BImage image = BHighlightHyperlinkLabel.this.getImage();
            if (image.isNull() || !image.isLoaded()) {
                this.ipaint = false;
                this.iloaded = false;
                this.iy = 0.0;
                this.ix = 0.0;
            } else {
                this.ipaint = true;
                this.iloaded = true;
                this.iw = image.getWidth();
                this.ih = image.getHeight();
            }
        }

        private void computeCompoundLayout() {
            double gap = BHighlightHyperlinkLabel.this.getTextIconGap();
            this.aw = Math.max(this.tw, this.iw);
            this.ah = Math.max(this.th, this.ih);
            switch (BHighlightHyperlinkLabel.this.getTextToIconAlign().getOrdinal()) {
                case 0: {
                    this.tx += (this.aw - this.tw) / 2.0;
                    this.ix = (this.aw - this.iw) / 2.0;
                    this.iy = this.th + gap;
                    this.ah = this.th + gap + this.ih;
                    break;
                }
                case 2: {
                    this.tx += (this.aw - this.tw) / 2.0;
                    this.ix = (this.aw - this.iw) / 2.0;
                    this.ty += this.ih + gap;
                    this.ah = this.th + gap + this.ih;
                    break;
                }
                case 1: {
                    this.ty += (this.ah - this.th) / 2.0;
                    this.iy = (this.ah - this.ih) / 2.0;
                    this.ix = this.tw + gap;
                    this.aw = this.tw + gap + this.iw;
                    break;
                }
                case 3: {
                    this.ty += (this.ah - this.th) / 2.0;
                    this.iy = (this.ah - this.ih) / 2.0;
                    this.tx += this.iw + gap;
                    this.aw = this.tw + gap + this.iw;
                    break;
                }
                case 4: {
                    this.tx += (this.aw - this.tw) / 2.0;
                    this.ty += (this.ah - this.th) / 2.0;
                    this.ix = (this.aw - this.iw) / 2.0;
                    this.iy = (this.ah - this.ih) / 2.0;
                }
            }
        }

        private void parse() {
            String text = BHighlightHyperlinkLabel.this.getText();
            if (text.length() == 0) {
                this.lines = new String[0];
                return;
            }
            StringTokenizer st = new StringTokenizer(text, "\n\r");
            Vector<String> temp = new Vector<String>(2);
            while (st.hasMoreTokens()) {
                temp.addElement(st.nextToken());
            }
            this.lines = new String[temp.size()];
            temp.copyInto(this.lines);
        }

        void dump() {
            System.out.println("  text: " + this.tx + "," + this.ty + "," + this.tw + "," + this.th);
            System.out.println("  icon: " + this.ix + "," + this.iy + "," + this.iw + "," + this.ih);
            System.out.println("  aggr: " + this.aw + "," + this.ah);
            System.out.println("  off:  " + this.xo + "," + this.yo);
        }
    }
}

