/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.px;

import java.text.NumberFormat;
import javax.baja.agent.AgentList;
import javax.baja.control.BControlPoint;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BPen;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.gx.PathGeom;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBinding;
import javax.baja.ui.BLayout;
import javax.baja.ui.BWidget;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="max", type="double", defaultValue="1.0"), @NiagaraProperty(name="min", type="double", defaultValue="-1.0"), @NiagaraProperty(name="value", type="double", defaultValue="0.0"), @NiagaraProperty(name="valueFont", type="BFont", defaultValue="BFont.NULL"), @NiagaraProperty(name="rangeFont", type="BFont", defaultValue="BFont.NULL"), @NiagaraProperty(name="background", type="BBrush", defaultValue="BColor.make(0xcccccc).toBrush()"), @NiagaraProperty(name="foreground", type="BBrush", defaultValue="BColor.black.toBrush()"), @NiagaraProperty(name="borderPen", type="BPen", defaultValue="BPen.make(1.0)"), @NiagaraProperty(name="needleBrush", type="BBrush", defaultValue="BColor.red.toBrush()"), @NiagaraProperty(name="needlePen", type="BPen", defaultValue="BPen.make(1.0)"), @NiagaraProperty(name="tickSpacing", type="double", defaultValue="0.1"), @NiagaraProperty(name="tickBrush", type="BBrush", defaultValue="BColor.black.toBrush()"), @NiagaraProperty(name="tickPen", type="BPen", defaultValue="BPen.DEFAULT"), @NiagaraProperty(name="tickLength", type="double", defaultValue="5.0"), @NiagaraProperty(name="textBrush", type="BBrush", defaultValue="BColor.black.toBrush()"), @NiagaraProperty(name="showMaxMin", type="boolean", defaultValue="true"), @NiagaraProperty(name="showValue", type="boolean", defaultValue="true")})
public class BGaugeControl
extends BWidget {
    public static final Property max = BGaugeControl.newProperty((int)0, (double)1.0, null);
    public static final Property min = BGaugeControl.newProperty((int)0, (double)-1.0, null);
    public static final Property value = BGaugeControl.newProperty((int)0, (double)0.0, null);
    public static final Property valueFont = BGaugeControl.newProperty((int)0, (BValue)BFont.NULL, null);
    public static final Property rangeFont = BGaugeControl.newProperty((int)0, (BValue)BFont.NULL, null);
    public static final Property background = BGaugeControl.newProperty((int)0, (BValue)BColor.make((int)0xCCCCCC).toBrush(), null);
    public static final Property foreground = BGaugeControl.newProperty((int)0, (BValue)BColor.black.toBrush(), null);
    public static final Property borderPen = BGaugeControl.newProperty((int)0, (BValue)BPen.make((double)1.0), null);
    public static final Property needleBrush = BGaugeControl.newProperty((int)0, (BValue)BColor.red.toBrush(), null);
    public static final Property needlePen = BGaugeControl.newProperty((int)0, (BValue)BPen.make((double)1.0), null);
    public static final Property tickSpacing = BGaugeControl.newProperty((int)0, (double)0.1, null);
    public static final Property tickBrush = BGaugeControl.newProperty((int)0, (BValue)BColor.black.toBrush(), null);
    public static final Property tickPen = BGaugeControl.newProperty((int)0, (BValue)BPen.DEFAULT, null);
    public static final Property tickLength = BGaugeControl.newProperty((int)0, (double)5.0, null);
    public static final Property textBrush = BGaugeControl.newProperty((int)0, (BValue)BColor.black.toBrush(), null);
    public static final Property showMaxMin = BGaugeControl.newProperty((int)0, (boolean)true, null);
    public static final Property showValue = BGaugeControl.newProperty((int)0, (boolean)true, null);
    public static final Type TYPE = Sys.loadType(BGaugeControl.class);
    private int precision = 2;
    private String units = "";
    private double fontBaseGap = 0.0;
    private double size;
    private double midpointX;
    private double midpointY;
    private double bottomY;
    private double midValue = 0.0;
    private IGeom geom = null;
    private static final double TO_RAD = Math.PI / 180;
    static BIcon icon = BIcon.make((String)"module://lynxKitPx/icons/gaugeIcon.png");

    public double getMax() {
        return this.getDouble(max);
    }

    public void setMax(double v) {
        this.setDouble(max, v, null);
    }

    public double getMin() {
        return this.getDouble(min);
    }

    public void setMin(double v) {
        this.setDouble(min, v, null);
    }

    public double getValue() {
        return this.getDouble(value);
    }

    public void setValue(double v) {
        this.setDouble(value, v, null);
    }

    public BFont getValueFont() {
        return (BFont)this.get(valueFont);
    }

    public void setValueFont(BFont v) {
        this.set(valueFont, (BValue)v, null);
    }

    public BFont getRangeFont() {
        return (BFont)this.get(rangeFont);
    }

    public void setRangeFont(BFont v) {
        this.set(rangeFont, (BValue)v, null);
    }

    public BBrush getBackground() {
        return (BBrush)this.get(background);
    }

    public void setBackground(BBrush v) {
        this.set(background, (BValue)v, null);
    }

    public BBrush getForeground() {
        return (BBrush)this.get(foreground);
    }

    public void setForeground(BBrush v) {
        this.set(foreground, (BValue)v, null);
    }

    public BPen getBorderPen() {
        return (BPen)this.get(borderPen);
    }

    public void setBorderPen(BPen v) {
        this.set(borderPen, (BValue)v, null);
    }

    public BBrush getNeedleBrush() {
        return (BBrush)this.get(needleBrush);
    }

    public void setNeedleBrush(BBrush v) {
        this.set(needleBrush, (BValue)v, null);
    }

    public BPen getNeedlePen() {
        return (BPen)this.get(needlePen);
    }

    public void setNeedlePen(BPen v) {
        this.set(needlePen, (BValue)v, null);
    }

    public double getTickSpacing() {
        return this.getDouble(tickSpacing);
    }

    public void setTickSpacing(double v) {
        this.setDouble(tickSpacing, v, null);
    }

    public BBrush getTickBrush() {
        return (BBrush)this.get(tickBrush);
    }

    public void setTickBrush(BBrush v) {
        this.set(tickBrush, (BValue)v, null);
    }

    public BPen getTickPen() {
        return (BPen)this.get(tickPen);
    }

    public void setTickPen(BPen v) {
        this.set(tickPen, (BValue)v, null);
    }

    public double getTickLength() {
        return this.getDouble(tickLength);
    }

    public void setTickLength(double v) {
        this.setDouble(tickLength, v, null);
    }

    public BBrush getTextBrush() {
        return (BBrush)this.get(textBrush);
    }

    public void setTextBrush(BBrush v) {
        this.set(textBrush, (BValue)v, null);
    }

    public boolean getShowMaxMin() {
        return this.getBoolean(showMaxMin);
    }

    public void setShowMaxMin(boolean v) {
        this.setBoolean(showMaxMin, v, null);
    }

    public boolean getShowValue() {
        return this.getBoolean(showValue);
    }

    public void setShowValue(boolean v) {
        this.setBoolean(showValue, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BGaugeControl() {
        this.setLayout(BLayout.make((double)0.0, (int)0, (double)0.0, (int)0, (double)100.0, (int)0, (double)80.0, (int)0));
    }

    public void computePreferredSize() {
        this.setPreferredSize(100.0, 80.0);
    }

    public void doLayout(BWidget[] children) {
        double w = this.getWidth();
        double h = this.getHeight();
        BBinding[] b = this.getBindings();
        for (int i = 0; i < b.length; ++i) {
            if (!b[i].isBound() || !(b[i].getTarget().get() instanceof BControlPoint)) continue;
            BControlPoint comp = (BControlPoint)b[i].getTarget().get();
            BFacets facets = comp.getFacets();
            try {
                this.precision = Integer.parseInt(facets.get("precision").toString());
                this.units = facets.get("units").toString();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        BFont vfont = this.getValueFont();
        BFont rfont = this.getRangeFont();
        if (vfont.isNull()) {
            vfont = BFont.make((String)"Tahoma", (double)8.0);
        }
        if (rfont.isNull()) {
            rfont = BFont.make((String)"Tahoma", (double)8.0);
        }
        double gaugeHeight = h - this.getBorderPen().getWidth() * 2.0 - (this.fontBaseGap + rfont.getHeight() * 2.0);
        this.size = Math.min(w - this.getBorderPen().getWidth(), gaugeHeight * 2.0);
        this.midpointX = w / 2.0;
        this.midpointY = h / 2.0;
        this.bottomY = this.midpointY + this.size / 2.0 / 2.0 - this.getBorderPen().getWidth() / 2.0;
        PathGeom path = new PathGeom();
        path.moveTo(true, w / 2.0 - this.size / 2.0, this.bottomY);
        path.lineTo(false, this.size, 0.0);
        path.arcTo(false, 1.0, 1.0, 0.0, true, false, -this.size, 0.0);
        this.geom = path;
        this.midValue = this.getMax() - (this.getMax() - this.getMin()) / 2.0;
    }

    public void paint(Graphics g) {
        double lendy;
        double lendx;
        double ddy;
        double ddx;
        double dangle;
        int i;
        BPen defaultPen = null;
        g.setBrush(this.getBackground());
        if (this.geom != null) {
            g.fill(this.geom);
        }
        g.setBrush(this.getNeedleBrush());
        double angle = 90.0 * (this.getMax() - this.getValue());
        BFont vfont = this.getValueFont();
        BFont rfont = this.getRangeFont();
        if (vfont.isNull()) {
            vfont = BFont.make((String)"Tahoma", (double)8.0);
        }
        if (rfont.isNull()) {
            rfont = BFont.make((String)"Tahoma", (double)8.0);
        }
        double dx = 0.0;
        double dy = 0.0;
        if (this.getValue() > this.getMax()) {
            this.setValue(this.getMax());
        } else if (this.getValue() < this.getMin()) {
            this.setValue(this.getMin());
        }
        double arcSize = this.size;
        if (this.getValue() == this.midValue) {
            dy = this.bottomY - arcSize / 2.0;
            dx = this.midpointX;
        } else if (this.getValue() < this.midValue) {
            angle = 90.0 * ((this.getValue() - this.getMin()) / (this.midValue - this.getMin()));
            dx = (int)(Math.cos(angle *= Math.PI / 180) * (arcSize / 2.0));
            dy = (int)(Math.sin(angle) * (arcSize / 2.0));
            dx = this.midpointX - dx;
            dy = this.bottomY - dy;
        } else if (this.getValue() > this.midValue) {
            angle = 90.0 * ((this.getValue() - this.midValue) / (this.getMax() - this.midValue));
            angle = 90.0 - angle;
            dx = (int)(Math.cos(angle *= Math.PI / 180) * (arcSize / 2.0));
            dy = (int)(Math.sin(angle) * (arcSize / 2.0));
            dx = this.midpointX + dx;
            dy = this.bottomY - dy;
        }
        defaultPen = g.getPen();
        g.setPen(this.getNeedlePen());
        g.strokeLine(this.midpointX, this.bottomY, dx, dy);
        g.setPen(defaultPen);
        double tickCountd = (this.getMax() - this.midValue) / this.getTickSpacing();
        int tickCount = (int)tickCountd;
        g.setBrush(this.getTickBrush());
        g.setPen(this.getTickPen());
        g.strokeLine(this.midpointX, this.bottomY - arcSize / 2.0, this.midpointX, this.bottomY - arcSize / 2.0 + this.getTickLength());
        for (i = 1; i < tickCount; ++i) {
            dangle = 90.0 * ((this.getMax() - (double)i * this.getTickSpacing() - this.midValue) / (this.getMax() - this.midValue));
            dangle = 90.0 - dangle;
            ddx = (int)(Math.cos(dangle *= Math.PI / 180) * (arcSize / 2.0));
            ddy = (int)(Math.sin(dangle) * (arcSize / 2.0));
            ddx = this.midpointX + ddx;
            ddy = this.bottomY - ddy;
            lendx = (int)(Math.cos(dangle) * (arcSize / 2.0 - this.getTickLength()));
            lendy = (int)(Math.sin(dangle) * (arcSize / 2.0 - this.getTickLength()));
            lendx = this.midpointX + lendx;
            lendy = this.bottomY - lendy;
            g.strokeLine(lendx, lendy, ddx, ddy);
        }
        tickCountd = (this.midValue - this.getMin()) / this.getTickSpacing();
        tickCount = (int)tickCountd;
        g.setBrush(this.getTickBrush());
        for (i = 1; i < tickCount; ++i) {
            dangle = 90.0 * (((double)i * this.getTickSpacing() + this.getMin() - this.getMin()) / (this.midValue - this.getMin()));
            ddx = (int)(Math.cos(dangle *= Math.PI / 180) * (arcSize / 2.0));
            ddy = (int)(Math.sin(dangle) * (arcSize / 2.0));
            ddx = this.midpointX - ddx;
            ddy = this.bottomY - ddy;
            lendx = (int)(Math.cos(dangle) * (arcSize / 2.0 - this.getTickLength()));
            lendy = (int)(Math.sin(dangle) * (arcSize / 2.0 - this.getTickLength()));
            lendx = this.midpointX - lendx;
            lendy = this.bottomY - lendy;
            g.strokeLine(lendx, lendy, ddx, ddy);
        }
        if (this.getShowMaxMin()) {
            g.setBrush(this.getTextBrush());
            g.setFont(rfont);
            String str = this.getMin() + "";
            g.drawString(str, this.midpointX - this.size / 2.0, this.bottomY + this.getBorderPen().getWidth() / 2.0 + this.fontBaseGap + rfont.getHeight());
            str = this.getMax() + "";
            g.drawString(str, this.midpointX + this.size / 2.0 - rfont.width(str), this.bottomY + this.getBorderPen().getWidth() / 2.0 + this.fontBaseGap + rfont.getHeight());
            str = this.midValue + "";
            g.drawString(str, this.midpointX - rfont.width(str) / 2.0, this.bottomY - this.size / 2.0 - this.getBorderPen().getWidth() * 1.5 - this.fontBaseGap);
        }
        if (this.getShowValue()) {
            g.setFont(vfont);
            NumberFormat nf = NumberFormat.getInstance();
            nf.setMaximumFractionDigits(this.precision);
            String str = this.units.equalsIgnoreCase("") ? nf.format(this.getValue()) + "" : nf.format(this.getValue()) + " " + this.units;
            g.drawString(str, this.midpointX - vfont.width(str) / 2.0, this.bottomY - this.size / 4.0 + vfont.getHeight());
        }
        g.setPen(defaultPen);
        g.setBrush(this.getForeground());
        defaultPen = g.getPen();
        g.setPen(this.getBorderPen());
        if (this.geom != null) {
            g.stroke(this.geom);
        }
        g.setPen(defaultPen);
    }

    public AgentList getAgents(Context cx) {
        AgentList agents = super.getAgents(cx);
        agents.toTop("lynxKitPx:GaugeValueBinding");
        return agents;
    }

    public BIcon getIcon() {
        BValue dynamic = this.get("icon");
        if (dynamic instanceof BIcon) {
            return (BIcon)dynamic;
        }
        return icon;
    }
}

