/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.px;

import com.lynxspring.util.BLynxKitPxLicenseService;
import com.tridium.data.BDataRow;
import com.tridium.data.BDataTable;
import com.tridium.util.ArrayUtil;
import com.tridium.workbench.shell.BNiagaraWbShell;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.collection.TableCursor;
import javax.baja.gx.BImage;
import javax.baja.gx.BSize;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BHyperlinkMode;
import javax.baja.ui.BLayout;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.commands.HyperlinkCommand;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BCanvasPane;
import javax.baja.workbench.BWbPlugin;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="query", type="BOrd", defaultValue="BOrd.DEFAULT"), @NiagaraProperty(name="sortByNames", type="boolean", defaultValue="true"), @NiagaraProperty(name="viewOverride", type="String", defaultValue="BString.DEFAULT"), @NiagaraProperty(name="hyperlinkMode", type="BHyperlinkMode", defaultValue="BHyperlinkMode.replace"), @NiagaraProperty(name="buttonWidth", type="int", defaultValue="24"), @NiagaraProperty(name="buttonHeight", type="int", defaultValue="18"), @NiagaraProperty(name="buttonText", type="String", defaultValue="Go")})
@NiagaraActions(value={@NiagaraAction(name="goClicked", flags=260), @NiagaraAction(name="listChanged", flags=260)})
public class BBqlHyperlink
extends BWbPlugin {
    public static final Property query = BBqlHyperlink.newProperty((int)0, (BValue)BOrd.DEFAULT, null);
    public static final Property sortByNames = BBqlHyperlink.newProperty((int)0, (boolean)true, null);
    public static final Property viewOverride = BBqlHyperlink.newProperty((int)0, (BValue)BString.DEFAULT, null);
    public static final Property hyperlinkMode = BBqlHyperlink.newProperty((int)0, (BValue)BHyperlinkMode.replace, null);
    public static final Property buttonWidth = BBqlHyperlink.newProperty((int)0, (int)24, null);
    public static final Property buttonHeight = BBqlHyperlink.newProperty((int)0, (int)18, null);
    public static final Property buttonText = BBqlHyperlink.newProperty((int)0, (String)"Go", null);
    public static final Action goClicked = BBqlHyperlink.newAction((int)260, null);
    public static final Action listChanged = BBqlHyperlink.newAction((int)260, null);
    public static final Type TYPE = Sys.loadType(BBqlHyperlink.class);
    private static final BIcon icon = BIcon.std((String)"hyperlink.png");
    private BListDropDown listBox;
    private BCanvasPane goCanvas;
    private BButton go;
    private BWidget wrapper;
    private BNiagaraWbShell shell;
    private BOrd[] ords;
    private BList list;
    private static final String listSlot = "list";
    private static final String buttonSlot = "button";

    public BOrd getQuery() {
        return (BOrd)this.get(query);
    }

    public void setQuery(BOrd v) {
        this.set(query, (BValue)v, null);
    }

    public boolean getSortByNames() {
        return this.getBoolean(sortByNames);
    }

    public void setSortByNames(boolean v) {
        this.setBoolean(sortByNames, v, null);
    }

    public String getViewOverride() {
        return this.getString(viewOverride);
    }

    public void setViewOverride(String v) {
        this.setString(viewOverride, v, null);
    }

    public BHyperlinkMode getHyperlinkMode() {
        return (BHyperlinkMode)this.get(hyperlinkMode);
    }

    public void setHyperlinkMode(BHyperlinkMode v) {
        this.set(hyperlinkMode, (BValue)v, null);
    }

    public int getButtonWidth() {
        return this.getInt(buttonWidth);
    }

    public void setButtonWidth(int v) {
        this.setInt(buttonWidth, v, null);
    }

    public int getButtonHeight() {
        return this.getInt(buttonHeight);
    }

    public void setButtonHeight(int v) {
        this.setInt(buttonHeight, v, null);
    }

    public String getButtonText() {
        return this.getString(buttonText);
    }

    public void setButtonText(String v) {
        this.setString(buttonText, v, null);
    }

    public void goClicked() {
        this.invoke(goClicked, null, null);
    }

    public void listChanged() {
        this.invoke(listChanged, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BBqlHyperlink() {
        this.setLayout(BLayout.make((double)0.0, (int)0, (double)0.0, (int)0, (double)0.0, (int)2, (double)0.0, (int)2));
        this.wrapper = new BWidget();
        this.wrapper.setLayout(BLayout.make((double)0.0, (int)0, (double)0.0, (int)0, (double)0.0, (int)2, (double)0.0, (int)2));
        this.listBox = new BListDropDown();
        this.wrapper.add(listSlot, (BValue)this.listBox);
        this.linkTo((BComponent)this.listBox, (Slot)BListDropDown.valueModified, (Slot)listChanged);
        this.list = this.listBox.getList();
        this.goCanvas = new BCanvasPane();
        this.go = new BButton(this.getButtonText());
        this.goCanvas.add(buttonSlot, (BValue)this.go);
        this.linkTo((BComponent)this.go, (Slot)BButton.actionPerformed, (Slot)goClicked);
        this.wrapper.add(buttonSlot, (BValue)this.goCanvas);
        this.setContent(this.wrapper);
    }

    public void started() throws Exception {
        this.shell = (BNiagaraWbShell)this.getWbShell();
        this.redrawButton();
        this.rebuildListBox();
    }

    public void changed(Property p, Context cx) {
        if (p == buttonWidth || p == buttonHeight) {
            this.redrawButton();
        } else if (p == buttonText) {
            this.go.setText(this.getButtonText());
        } else if (p == query || p == sortByNames) {
            this.rebuildListBox();
        } else {
            super.changed(p, cx);
        }
    }

    private void rebuildListBox() {
        if (this.shell == null) {
            return;
        }
        this.list.removeAllItems();
        this.ords = new BOrd[0];
        Object[] rows = new BDataRow[]{};
        Object[] names = new String[]{};
        BObject base = this.shell.getActiveView().getCurrentValue();
        OrdTarget t = this.getQuery().resolve(base);
        ColumnList cols = null;
        if (t != null) {
            BDataTable result = (BDataTable)t.get();
            cols = result.getColumns();
            TableCursor c = result.cursor();
            while (c.next()) {
                Column col = cols.get("isComponent");
                if (col != null && !((BBoolean)c.cell(col)).getBoolean()) continue;
                rows = (BDataRow[])ArrayUtil.addOne((Object[])rows, (Object)((BDataRow)c.get()).safeCopy());
                col = cols.get("displayName");
                if (col == null) continue;
                names = (String[])ArrayUtil.addOne((Object[])names, (Object)((BString)c.cell(col)).getString());
            }
        }
        if (this.getSortByNames() && names.length > 0) {
            SortUtil.sort((Object[])names, (Object[])rows);
        }
        for (int i = 0; i < rows.length; ++i) {
            Column col = cols.get("slotPathOrd");
            if (col == null) {
                col = cols.get("slotPath");
            }
            if (col == null) continue;
            String slotPath = ((BString)rows[i].cell(col)).getString();
            this.ords = (BOrd[])ArrayUtil.addOne((Object[])this.ords, (Object)BOrd.make((String)slotPath));
            col = cols.get("navIcon");
            if (col == null) {
                col = cols.get("icon");
            }
            String strIcon = null;
            BImage icon = null;
            if (col != null) {
                strIcon = ((BString)rows[i].cell(col)).getString();
            }
            if (strIcon != null && strIcon.trim().length() > 0) {
                icon = BImage.make((String)strIcon);
            }
            Object name = names.length > i ? names[i] : slotPath.substring(slotPath.lastIndexOf("/") + 1);
            this.list.addItem(icon, name);
        }
        this.go.setEnabled(false);
    }

    private void redrawButton() {
        this.goCanvas.setViewSize(BSize.make((double)this.getButtonWidth(), (double)this.getButtonHeight()));
        this.go.setLayout(BLayout.make((double)0.0, (int)0, (double)0.0, (int)0, (double)this.getButtonWidth(), (int)0, (double)this.getButtonHeight(), (int)0));
    }

    public void doGoClicked() throws Exception {
        if (!BLynxKitPxLicenseService.isLicensed((BWidget)this)) {
            return;
        }
        BOrd link = this.ords[this.listBox.getSelectedIndex()];
        if (this.getViewOverride().trim().length() > 0) {
            link = BOrd.make((BOrd)link, (String)("view:" + this.getViewOverride()));
        }
        new HyperlinkCommand((BWidget)this, null, link).invoke();
    }

    public void doListChanged() {
        if (!this.go.getEnabled()) {
            this.go.setEnabled(true);
        }
    }

    public void computePreferredSize() {
        this.listBox.computePreferredSize();
        double h = this.listBox.getPreferredHeight();
        if (h < (double)this.getButtonHeight()) {
            h = this.getButtonHeight();
        }
        this.setPreferredSize(this.listBox.getPreferredWidth() + 3.0 + (double)this.getButtonWidth(), h);
    }

    public void doLayout(BWidget[] kids) {
        this.computePreferredSize();
        double w = this.getWidth();
        double bw = this.getButtonWidth();
        double lw = w - 3.0 - bw;
        this.wrapper.setBounds(0.0, 0.0, w, this.getHeight());
        this.listBox.setBounds(0.0, 0.0, lw, this.listBox.getPreferredHeight());
        this.goCanvas.setBounds(w - bw, 0.0, bw, (double)this.getButtonHeight());
    }

    public BIcon getIcon() {
        BValue bvalue = this.get("icon");
        if (bvalue instanceof BIcon) {
            return (BIcon)bvalue;
        }
        return icon;
    }
}

