/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platSerial.uc;

import com.tridium.platSerial.npsdk.BSerialPortPlatformServiceNpsdk;
import com.tridium.platSerial.uc.BSerialPortUbuntuCore;
import com.tridium.sys.Nre;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BSerialPortPlatformServiceUbuntuCore
extends BSerialPortPlatformServiceNpsdk {
    @Generated
    public static final Type TYPE = Sys.loadType(BSerialPortPlatformServiceUbuntuCore.class);
    private static final String U_MAP_FILE_PATH = "/tmp/u_map";
    private static final String U_MAP_ERROR_FILE_PATH = "/tmp/u_map_error";
    public static final int NUM_U_MAP_SPACE_DELIMITED_FIELDS = 6;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public boolean isValidPlatform() {
        String serialLibPath = Nre.getNiagaraHome() + File.separator + "bin" + File.separator + "libserialnpsdk.so";
        if (!AccessController.doPrivileged(() -> new File(serialLibPath).exists()).booleanValue()) {
            return false;
        }
        return AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.use.snap.serial")) != false;
    }

    @Override
    protected String[] loadPortIdentifiers() {
        return this.loadPortIdentifiers(U_MAP_FILE_PATH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] loadPortIdentifiers(String filePath) {
        LOG.fine("Loading comm port identifiers...");
        if (!this.loadLibraries()) {
            LOG.severe("Failed to load serial native library");
            return null;
        }
        BufferedReader bufferedReader = this.accessFile(U_MAP_ERROR_FILE_PATH, false);
        if (bufferedReader != null) {
            try {
                String err = bufferedReader.readLine();
                LOG.severe("***** Unable to initialise serial platform: *****\n\t" + err);
            }
            catch (Exception exception) {
                LOG.log(Level.SEVERE, "Failed to read serial error file", exception);
            }
            finally {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {}
            }
        }
        if ((bufferedReader = this.accessFile(filePath, true)) == null) {
            LOG.severe("Unable to read serial port map file");
            return null;
        }
        ArrayList<String> slotNamesAR = new ArrayList<String>();
        ArrayList<BSerialPortUbuntuCore> portAR = new ArrayList<BSerialPortUbuntuCore>();
        try {
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                if (!line.startsWith("COM")) continue;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Parsing map line: '" + line + "'");
                }
                int vendorParenStart = line.indexOf(" (");
                String vendorStr = this.extractFromParens(vendorParenStart, line);
                int vendorStrEnd = line.indexOf(vendorStr) + vendorStr.length() + 2;
                String productStr = this.extractFromParens(vendorStrEnd, line);
                String infoLine = line.substring(0, vendorParenStart);
                StringTokenizer st = new StringTokenizer(infoLine);
                if (st.countTokens() != 6) {
                    LOG.severe("Unexpected map file format, cannot enumerate serial ports");
                    String[] stringArray = null;
                    return stringArray;
                }
                String name = st.nextToken();
                String osName = st.nextToken();
                st.nextToken();
                int position = Integer.parseInt(st.nextToken());
                String vendorId = st.nextToken();
                String productId = st.nextToken();
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Validating '" + vendorId + ":" + productId + ":" + vendorStr + ":" + productStr + "'...");
                }
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Validated '" + vendorId + ":" + productId + ":" + vendorStr + ":" + productStr + "'");
                }
                int ndx = Integer.parseInt(name.substring("COM".length()));
                portAR.add(new BSerialPortUbuntuCore(osName, ndx, position, vendorStr, productStr));
                slotNamesAR.add("COM" + ndx);
            }
        }
        catch (IOException ioException) {
            LOG.log(Level.SEVERE, "Exception occurred parsing map file, cannot enumerate serial ports", ioException);
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {}
        }
        BSerialPortUbuntuCore[] ports = portAR.toArray(new BSerialPortUbuntuCore[0]);
        Object[] slotNames = slotNamesAR.toArray(new String[0]);
        SortUtil.sort((Object[])slotNames, (Object[])ports, (Comparator)this.SERIAL_PORT_COMPARATOR);
        for (int i = 0; i < slotNames.length; ++i) {
            this.add(SlotPath.escape((String)slotNames[i]), (BValue)ports[i], 3);
        }
        return slotNames;
    }

    private String extractFromParens(int startNdx, String line) {
        StringCharacterIterator characterIterator = new StringCharacterIterator(line, startNdx, line.length(), startNdx);
        char c = characterIterator.first();
        int leftParenCount = 0;
        boolean reading = false;
        StringBuilder sb = new StringBuilder();
        while (c != '\uffff') {
            if (c == '(') {
                if (++leftParenCount == 1) {
                    reading = true;
                    c = characterIterator.next();
                    continue;
                }
            } else if (c == ')' && leftParenCount > 0 && --leftParenCount == 0) break;
            if (reading) {
                sb.append(c);
            }
            c = characterIterator.next();
        }
        return sb.toString();
    }

    private BufferedReader accessFile(String fileName, boolean reportError) {
        BufferedReader bufferedReader;
        block3: {
            bufferedReader = null;
            try {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Accessing file '" + fileName + "'...");
                }
                bufferedReader = AccessController.doPrivileged(() -> new BufferedReader(new InputStreamReader(Files.newInputStream(Paths.get(fileName, new String[0]), new OpenOption[0]), StandardCharsets.UTF_8)));
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (!reportError) break block3;
                LOG.log(Level.SEVERE, "Cannot access file '" + fileName + "'", privilegedActionException);
            }
        }
        return bufferedReader;
    }
}

