/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platSerial;

import com.tridium.platSerial.BSerialPort;
import com.tridium.platSerial.BSerialPortHandle;
import com.tridium.platSerial.BSerialPortParameters;
import com.tridium.platform.BPlatformService;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.license.Feature;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.serial.BBaudRate;
import javax.baja.serial.BISerialPort;
import javax.baja.serial.BISerialService;
import javax.baja.serial.BSerialBaudRate;
import javax.baja.serial.BSerialDataBits;
import javax.baja.serial.BSerialFlowControlMode;
import javax.baja.serial.BSerialParity;
import javax.baja.serial.BSerialStopBits;
import javax.baja.serial.PortDeniedException;
import javax.baja.serial.PortNotFoundException;
import javax.baja.sys.Action;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraAction(name="testCommDriver", parameterType="BSerialPortParameters", defaultValue="new BSerialPortParameters()", flags=20)
public abstract class BSerialPortPlatformService
extends BPlatformService
implements BISerialService {
    @Generated
    public static final Action testCommDriver = BSerialPortPlatformService.newAction((int)20, (BValue)new BSerialPortParameters(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BSerialPortPlatformService.class);
    private static final BIcon icon = BIcon.std((String)"navOnly/serialPortService.png");
    protected final Comparator<String> SERIAL_PORT_COMPARATOR = (port1Name, port2Name) -> {
        if (port1Name.indexOf(SERIAL_PORT_PREFIX) == 0 && port2Name.indexOf(SERIAL_PORT_PREFIX) == 0) {
            int port1Id = Integer.parseInt(port1Name.substring(SERIAL_PORT_PREFIX.length()));
            int port2Id = Integer.parseInt(port2Name.substring(SERIAL_PORT_PREFIX.length()));
            return Integer.compare(port1Id, port2Id);
        }
        return port1Name.compareTo((String)port2Name);
    };
    public static final String SERIAL_PORT_PREFIX = "COM";
    String[] names = null;
    public static final Logger LOG = Logger.getLogger("plat.serial");
    boolean licenseChecked = false;
    boolean licenseOk = false;
    BSerialDataBits[] serialDataBits = new BSerialDataBits[]{BSerialDataBits.dataBits5, BSerialDataBits.dataBits6, BSerialDataBits.dataBits7, BSerialDataBits.dataBits8};
    BSerialBaudRate[] serialBaudRates = new BSerialBaudRate[]{BSerialBaudRate.baud50, BSerialBaudRate.baud75, BSerialBaudRate.baud110, BSerialBaudRate.baud134, BSerialBaudRate.baud150, BSerialBaudRate.baud200, BSerialBaudRate.baud300, BSerialBaudRate.baud600, BSerialBaudRate.baud1200, BSerialBaudRate.baud1800, BSerialBaudRate.baud2400, BSerialBaudRate.baud4800, BSerialBaudRate.baud9600, BSerialBaudRate.baud19200, BSerialBaudRate.baud38400, BSerialBaudRate.baud57600, BSerialBaudRate.baud76800, BSerialBaudRate.baud115200};
    BSerialStopBits[] serialStopBits = new BSerialStopBits[]{BSerialStopBits.stopBit1, BSerialStopBits.stopBits2};
    BSerialParity[] serialParities = new BSerialParity[]{BSerialParity.even, BSerialParity.odd, BSerialParity.mark, BSerialParity.none, BSerialParity.space};
    BSerialFlowControlMode[] serialFlowControlModes = new BSerialFlowControlMode[]{BSerialFlowControlMode.none, BSerialFlowControlMode.rtsCtsOnInput, BSerialFlowControlMode.rtsCtsOnOutput, BSerialFlowControlMode.xonXoffOnInput, BSerialFlowControlMode.xonXoffOnOutput};

    @Generated
    public void testCommDriver(BSerialPortParameters parameter) {
        this.invoke(testCommDriver, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BSerialPortPlatformService() {
        this.setPlatformServiceDescription(this.getLexicon().getText("SerialPortPlatformService.description"));
    }

    public BIcon getIcon() {
        return icon;
    }

    public void loadPlatformServiceProperties() {
        try {
            this.names = this.loadPortIdentifiers();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    protected abstract String[] loadPortIdentifiers() throws Exception;

    public BISerialPort openPort(String name, String owner) throws PortNotFoundException, PortDeniedException {
        if (!this.licenseChecked) {
            this.licenseChecked = true;
            Feature f = Sys.getLicenseManager().getFeature("tridium", "serial");
            if (f != null) {
                f.check();
            }
            this.licenseOk = true;
        }
        if (!this.licenseOk) {
            throw new FeatureNotLicensedException("serial");
        }
        BSerialPort p = (BSerialPort)this.get(name);
        if (p == null) {
            throw new PortNotFoundException(name + " is not a valid port");
        }
        p.lock(owner);
        try {
            p.openPort();
            return new BSerialPortHandle(p);
        }
        catch (RuntimeException | PortDeniedException e) {
            p.unlock();
            throw e;
        }
    }

    public String[] getPortNames() {
        return this.names;
    }

    public String getCurrentOwner(String portName) throws PortNotFoundException {
        BSerialPort p = (BSerialPort)this.get(portName);
        if (p == null) {
            throw new PortNotFoundException(portName + " is not a valid port");
        }
        p.checkOwner();
        return p.getOwner();
    }

    public void doTestCommDriver(final BSerialPortParameters portParameters) {
        new Thread("TestCommDriver"){

            @Override
            public void run() {
                BSerialPortPlatformService.this.doTestCommDriverEntry(portParameters);
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTestCommDriverEntry(BSerialPortParameters portParameters) {
        block24: {
            BSerialPort port;
            LOG.info("[TestCommDriver] Start");
            boolean testAll = false;
            String portSlotName = portParameters.getSerialPort();
            if (portSlotName == null || portSlotName.trim().isEmpty()) {
                testAll = true;
            }
            LOG.info("[TestCommDriver] Ports available:");
            SlotCursor c = this.loadSlots().getProperties();
            while (c.next(BSerialPort.class)) {
                port = (BSerialPort)c.get();
                LOG.info("[TestCommDriver]   os port name = '" + port.getOsPortName() + "' port slot name = '" + port.getName() + "' port owner = '" + port.getOwner() + "'");
            }
            if (testAll) {
                LOG.info("[TestCommDriver] Provided slot name empty, listing interfaces...");
            } else {
                LOG.info("[TestCommDriver] Exercising provided slot name: " + portSlotName);
            }
            try {
                if (testAll) {
                    c = this.loadSlots().getProperties();
                    while (c.next(BSerialPort.class)) {
                        port = (BSerialPort)c.get();
                        try {
                            this.testPort(port, portParameters);
                        }
                        finally {
                            try {
                                if (!port.locked || !"test".equalsIgnoreCase(port.getOwner())) continue;
                                port.closePort();
                            }
                            catch (Exception exception) {}
                        }
                    }
                    break block24;
                }
                BSerialPort port2 = (BSerialPort)this.get(portSlotName);
                if (port2 == null) {
                    LOG.severe("[TestCommDriver] Port '" + portSlotName + "' not found, can not test");
                    break block24;
                }
                try {
                    this.testPort(port2, portParameters);
                }
                finally {
                    try {
                        if (port2.locked && "test".equalsIgnoreCase(port2.getOwner())) {
                            port2.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Throwable t) {
                LOG.log(Level.SEVERE, "[TestCommDriver] Unhandled throwable caught", t);
            }
        }
        LOG.info("[TestCommDriver] End");
    }

    void testPort(BSerialPort port, BSerialPortParameters portParameters) {
        if (port == null) {
            LOG.severe("[TestCommDriver] Can not test null port");
            throw new NullPointerException("Null Serial Port provided to test");
        }
        port.checkOwner();
        LOG.info("[TestCommDriver] Port: " + port.getName() + " -> " + port.getOsPortName() + ", owner = " + port.getOwner());
        if (port.getOwner() == null || port.getOwner().trim().isEmpty()) {
            LOG.warning("[TestCommDriver] Owner for port " + port.getName() + " is not initialized");
        }
        if (!port.locked && !port.getOwner().trim().equalsIgnoreCase("none")) {
            LOG.warning("[TestCommDriver] Port is not locked but owner is not set to \"none\"");
        }
        if (port.locked && port.getOwner().trim().equalsIgnoreCase("none")) {
            LOG.warning("[TestCommDriver] Port is locked but owner is set to \"none\"");
        }
        if (!port.locked || "test".equalsIgnoreCase(port.getOwner())) {
            BSerialPortHandle serialPortHandle;
            LOG.info("[TestCommDriver] Testing lock mechanism for port " + port.getName() + "...");
            try {
                port.lock("test");
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "[TestCommDriver] Exception occurred while attempting to lock port", e);
            }
            if (!port.locked) {
                LOG.warning("[TestCommDriver] Locked port but port doesn't show locked");
            }
            if (!port.getOwner().equalsIgnoreCase("test")) {
                LOG.warning("[TestCommDriver] Locked port but port doesn't show owner \"test\"");
            }
            try {
                port.unlock();
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "[TestCommDriver] Exception occurred while attempting to unlock port", e);
            }
            if (port.locked) {
                LOG.warning("[TestCommDriver] Unlocked port but port doesn't show unlocked");
            }
            if (!port.getOwner().equalsIgnoreCase("none")) {
                LOG.warning("[TestCommDriver] Unlocked port but port doesn't show owner \"none\"");
            }
            LOG.info("[TestCommDriver] Lock tests complete");
            LOG.info("[TestCommDriver] Testing open/close mechanism for port " + port.getName() + "...");
            try {
                port.lock("test");
                port.openPort();
                serialPortHandle = new BSerialPortHandle(port);
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "[TestCommDriver] Exception occurred while attempting to open port", e);
                try {
                    port.unlock();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return;
            }
            if (!port.locked) {
                LOG.warning("[TestCommDriver] Opened port but port doesn't show opened");
            }
            if (!port.getOwner().equalsIgnoreCase("test")) {
                LOG.warning("[TestCommDriver] Opened port but port doesn't show owner \"test\"");
            }
            try {
                OutputStream out;
                int i;
                Object object;
                LOG.info("[TestCommDriver] getOwner: " + serialPortHandle.getOwner());
                LOG.info("[TestCommDriver] getOsPortName: " + serialPortHandle.getOsPortName());
                BSerialBaudRate desiredBaudRate = portParameters.getBaudRate();
                BSerialDataBits desiredDataBits = portParameters.getDataBits();
                BSerialParity desiredParity = portParameters.getParity();
                BSerialStopBits desiredStopBits = portParameters.getStopBits();
                BSerialFlowControlMode desiredFlowControlMode = portParameters.getFlowControl();
                LOG.info("[TestCommDriver] Testing serial port configuration changes...");
                BSerialBaudRate currentSerialBaudRate = null;
                BSerialDataBits currentSerialDataBit = null;
                BSerialStopBits currentSerialStopBit = null;
                BSerialParity currentSerialParity = null;
                BSerialFlowControlMode currentSerialFlowControlMode = null;
                try {
                    BSerialBaudRate[] bSerialBaudRateArray = this.serialBaudRates;
                    int n = bSerialBaudRateArray.length;
                    for (int j = 0; j < n; ++j) {
                        BSerialBaudRate serialBaudRate;
                        currentSerialBaudRate = serialBaudRate = bSerialBaudRateArray[j];
                        BSerialDataBits[] bSerialDataBitsArray = this.serialDataBits;
                        int n2 = bSerialDataBitsArray.length;
                        for (int k = 0; k < n2; ++k) {
                            BSerialDataBits serialDataBit;
                            currentSerialDataBit = serialDataBit = bSerialDataBitsArray[k];
                            object = this.serialStopBits;
                            int n3 = ((BSerialStopBits[])object).length;
                            for (int i2 = 0; i2 < n3; ++i2) {
                                BSerialStopBits serialStopBit;
                                currentSerialStopBit = serialStopBit = object[i2];
                                BSerialParity[] bSerialParityArray = this.serialParities;
                                int n4 = bSerialParityArray.length;
                                for (int i3 = 0; i3 < n4; ++i3) {
                                    BSerialParity serialParity;
                                    currentSerialParity = serialParity = bSerialParityArray[i3];
                                    BSerialFlowControlMode[] bSerialFlowControlModeArray = this.serialFlowControlModes;
                                    int n5 = bSerialFlowControlModeArray.length;
                                    for (int i4 = 0; i4 < n5; ++i4) {
                                        BSerialFlowControlMode serialFlowControlMode;
                                        currentSerialFlowControlMode = serialFlowControlMode = bSerialFlowControlModeArray[i4];
                                        serialPortHandle.setSerialPortParams((BBaudRate)serialBaudRate, serialDataBit, serialStopBit, serialParity);
                                        serialPortHandle.setFlowControlMode(serialFlowControlMode);
                                        assert (serialPortHandle.getBaudRate() == serialBaudRate);
                                        assert (serialPortHandle.getDataBits() == serialDataBit);
                                        assert (serialPortHandle.getStopBits() == serialStopBit);
                                        assert (serialPortHandle.getParity() == serialParity);
                                        assert (serialPortHandle.getFlowControlMode() == serialFlowControlMode);
                                    }
                                }
                            }
                        }
                    }
                }
                catch (Throwable t) {
                    String config = currentSerialBaudRate + " " + currentSerialDataBit + " " + currentSerialStopBit + " " + currentSerialParity + " " + currentSerialFlowControlMode;
                    LOG.log(Level.SEVERE, "[TestCommDriver] Throwable occurred while setting port configuration to [" + config + "]:", t);
                }
                String config = desiredBaudRate + " " + desiredDataBits + " " + desiredParity + " " + desiredStopBits + " " + desiredFlowControlMode;
                LOG.info("[TestCommDriver] Testing provided port parameters [" + config + "]...");
                serialPortHandle.setSerialPortParams((BBaudRate)desiredBaudRate, desiredDataBits, desiredStopBits, desiredParity);
                serialPortHandle.setFlowControlMode(desiredFlowControlMode);
                assert (serialPortHandle.getBaudRate() == desiredBaudRate);
                assert (serialPortHandle.getDataBits() == desiredDataBits);
                assert (serialPortHandle.getStopBits() == desiredStopBits);
                assert (serialPortHandle.getParity() == desiredParity);
                assert (serialPortHandle.getFlowControlMode() == desiredFlowControlMode);
                LOG.info("[TestCommDriver] Testing receive threshold...");
                boolean defaultReceiveThresholdEnabled = serialPortHandle.isReceiveThresholdEnabled();
                int defaultReceiveThresholdValue = serialPortHandle.getReceiveThreshold();
                LOG.info("[TestCommDriver] Default receive threshold enabled: " + defaultReceiveThresholdEnabled);
                LOG.info("[TestCommDriver] Default receive threshold value: " + defaultReceiveThresholdValue);
                try {
                    if (defaultReceiveThresholdEnabled) {
                        serialPortHandle.disableReceiveThreshold();
                        assert (!serialPortHandle.isReceiveThresholdEnabled());
                        LOG.info("[TestCommDriver] Resetting receive threshold...");
                        serialPortHandle.enableReceiveThreshold(defaultReceiveThresholdValue);
                        assert (serialPortHandle.isReceiveThresholdEnabled());
                        assert (serialPortHandle.getReceiveThreshold() == defaultReceiveThresholdValue);
                    } else {
                        serialPortHandle.enableReceiveThreshold(10);
                        assert (serialPortHandle.isReceiveThresholdEnabled());
                        assert (serialPortHandle.getReceiveThreshold() == 10);
                        LOG.info("[TestCommDriver] Resetting receive threshold...");
                        serialPortHandle.disableReceiveThreshold();
                        assert (!serialPortHandle.isReceiveThresholdEnabled());
                        assert (serialPortHandle.getReceiveThreshold() == defaultReceiveThresholdValue);
                    }
                }
                catch (Throwable t) {
                    LOG.log(Level.SEVERE, "[TestCommDriver] Throwable occurred while exercising receive threshold:", t);
                }
                LOG.info("[TestCommDriver] Testing receive timeout...");
                boolean defaultReceiveTimeoutEnabled = serialPortHandle.isReceiveTimeoutEnabled();
                int defaultReceiveTimeoutValue = serialPortHandle.getReceiveTimeout();
                LOG.info("[TestCommDriver] Default receive timeout enabled: " + defaultReceiveTimeoutEnabled);
                LOG.info("[TestCommDriver] Default receive timeout value: " + defaultReceiveTimeoutValue);
                try {
                    if (defaultReceiveTimeoutEnabled) {
                        serialPortHandle.disableReceiveTimeout();
                        assert (!serialPortHandle.isReceiveTimeoutEnabled());
                        LOG.info("[TestCommDriver] Resetting receive timeout...");
                        serialPortHandle.enableReceiveTimeout(defaultReceiveTimeoutValue);
                        assert (serialPortHandle.isReceiveTimeoutEnabled());
                        assert (serialPortHandle.getReceiveTimeout() == defaultReceiveTimeoutValue);
                    } else {
                        serialPortHandle.enableReceiveTimeout(this.getMinTimeout());
                        assert (serialPortHandle.isReceiveTimeoutEnabled());
                        assert (serialPortHandle.getReceiveTimeout() == this.getMinTimeout());
                        LOG.info("[TestCommDriver] Resetting receive timeout...");
                        serialPortHandle.disableReceiveTimeout();
                        assert (!serialPortHandle.isReceiveTimeoutEnabled());
                        assert (serialPortHandle.getReceiveTimeout() == defaultReceiveTimeoutValue);
                    }
                }
                catch (Throwable t) {
                    LOG.log(Level.SEVERE, "[TestCommDriver] Throwable occurred while exercising receive timeout:", t);
                }
                try {
                    LOG.info("[TestCommDriver] Sending 1000ms break...");
                    serialPortHandle.sendBreak(1000);
                    LOG.info("[TestCommDriver] Break ok");
                }
                catch (Throwable t) {
                    LOG.log(Level.SEVERE, "[TestCommDriver] Throwable occurred while sending break:", t);
                }
                LOG.info("[TestCommDriver] Testing Data Terminal Ready / Request To Send...");
                boolean defaultDTR = serialPortHandle.isDTR();
                boolean defaultRTS = serialPortHandle.isRTS();
                LOG.info("[TestCommDriver] Data Terminal Ready: " + defaultDTR);
                LOG.info("[TestCommDriver] Request To Send: " + defaultRTS);
                try {
                    serialPortHandle.setDTR(!defaultDTR);
                    serialPortHandle.setRTS(!defaultRTS);
                    assert (serialPortHandle.isDTR() == !defaultDTR);
                    assert (serialPortHandle.isRTS() == !defaultRTS);
                }
                catch (Throwable t) {
                    LOG.log(Level.SEVERE, "[TestCommDriver] Throwable occurred while exercising RTS/DTR state:", t);
                }
                LOG.info("[TestCommDriver] Resetting to default DTR/RTS...");
                serialPortHandle.setDTR(defaultDTR);
                serialPortHandle.setRTS(defaultRTS);
                assert (serialPortHandle.isDTR() == defaultDTR);
                assert (serialPortHandle.isRTS() == defaultRTS);
                LOG.info("[TestCommDriver] Carrier Detect: " + serialPortHandle.isCD());
                LOG.info("[TestCommDriver] Ring Indicator: " + serialPortHandle.isRI());
                LOG.info("[TestCommDriver] Clear To Send: " + serialPortHandle.isCTS());
                LOG.info("[TestCommDriver] Data Set Ready: " + serialPortHandle.isDSR());
                LOG.info("[TestCommDriver] Testing output stream to port...");
                for (i = 0; i < 5; ++i) {
                    try {
                        out = serialPortHandle.getOutputStream();
                        Throwable throwable = null;
                        try {
                            out.write(0);
                            out.flush();
                            continue;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (out != null) {
                                if (throwable != null) {
                                    try {
                                        out.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                } else {
                                    out.close();
                                }
                            }
                        }
                    }
                    catch (Throwable t) {
                        LOG.log(Level.SEVERE, "[TestCommDriver] Throwable occurred while exercising output stream to port:", t);
                    }
                }
                for (i = 0; i < 5; ++i) {
                    try {
                        out = serialPortHandle.getOutputStream();
                        Throwable throwable = null;
                        try {
                            out.write(new byte[2048]);
                            out.flush();
                            continue;
                        }
                        catch (Throwable throwable4) {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (out != null) {
                                if (throwable != null) {
                                    try {
                                        out.close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable.addSuppressed(throwable5);
                                    }
                                } else {
                                    out.close();
                                }
                            }
                        }
                    }
                    catch (Throwable t) {
                        LOG.log(Level.SEVERE, "[TestCommDriver] Throwable occurred while exercising output stream to port:", t);
                    }
                }
                LOG.info("[TestCommDriver] Testing input stream to port...");
                try {
                    InputStream in = serialPortHandle.getInputStream();
                    object = null;
                    try {
                        int availableBytes = in.available();
                        LOG.info("[TestCommDriver] Input stream bytes available = " + availableBytes);
                        if (availableBytes <= 0) {
                            serialPortHandle.enableReceiveTimeout(2000);
                            LOG.info("[TestCommDriver] No bytes available from stream, testing receive timeout of 2000ms...");
                            int valueRead = in.read();
                            LOG.info("[TestCommDriver] Read value: " + valueRead);
                        } else {
                            LOG.info("[TestCommDriver] " + availableBytes + " byte(s) available, test 1 byte receive threshold...");
                            serialPortHandle.enableReceiveThreshold(1);
                            int numberRead = in.read(new byte[32]);
                            if (numberRead != 1) {
                                LOG.severe("[TestCommDriver] Failed to enforce receive threshold of 1, read " + numberRead + " bytes!");
                            } else {
                                LOG.info("[TestCommDriver] Correctly enforced receive threshold of 1 byte");
                            }
                            if (availableBytes > 1) {
                                int remainingBytes = availableBytes - 1;
                                LOG.info("[TestCommDriver] Reading remaining bytes with matching threshold (" + remainingBytes + " available bytes remaining)");
                                serialPortHandle.enableReceiveThreshold(remainingBytes);
                                numberRead = in.read(new byte[remainingBytes]);
                                if (numberRead != remainingBytes) {
                                    LOG.severe("[TestCommDriver] Failed to read remaining available bytes, " + numberRead + " bytes read instead");
                                } else {
                                    LOG.info("[TestCommDriver] Correctly read " + numberRead + " available bytes");
                                }
                            }
                        }
                        if (defaultReceiveThresholdEnabled) {
                            serialPortHandle.enableReceiveThreshold(defaultReceiveThresholdValue);
                        } else {
                            serialPortHandle.disableReceiveThreshold();
                        }
                        if (defaultReceiveTimeoutEnabled) {
                            serialPortHandle.enableReceiveTimeout(defaultReceiveTimeoutValue);
                        } else {
                            serialPortHandle.disableReceiveTimeout();
                        }
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (in != null) {
                            if (object != null) {
                                try {
                                    in.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                in.close();
                            }
                        }
                    }
                }
                catch (Throwable t) {
                    LOG.log(Level.SEVERE, "[TestCommDriver] Throwable occurred while exercising input stream to port:", t);
                }
            }
            catch (Throwable t) {
                LOG.log(Level.SEVERE, "[TestCommDriver] Throwable occurred while exercising serial port configuration:", t);
            }
            try {
                port.close();
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "[TestCommDriver] Exception occurred while attempting to close port", e);
            }
            if (port.locked) {
                LOG.warning("[TestCommDriver] Closed port but port doesn't show closed");
            }
            if (!port.getOwner().equalsIgnoreCase("none")) {
                LOG.warning("[TestCommDriver] Closed port but port doesn't show owner \"none\"");
            }
            LOG.info("[TestCommDriver] Open/close tests complete");
        } else {
            System.out.println("[TestCommDriver] Port is locked by " + port.getOwner() + ", skipping tests...");
        }
    }

    public int getMinTimeout() {
        return 10;
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE, BISerialService.TYPE};
    }
}

