/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platSerial;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.serial.BBaudRate;
import javax.baja.serial.BSerialDataBits;
import javax.baja.serial.BSerialFlowControlMode;
import javax.baja.serial.BSerialParity;
import javax.baja.serial.BSerialStopBits;
import javax.baja.serial.PortDeniedException;
import javax.baja.serial.PortNotFoundException;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="owner", type="String", defaultValue="none", flags=3), @NiagaraProperty(name="osPortName", type="String", defaultValue="", flags=3), @NiagaraProperty(name="portIndex", type="int", defaultValue="-1", flags=3)})
public abstract class BSerialPort
extends BComponent {
    @Generated
    public static final Property owner = BSerialPort.newProperty((int)3, (String)"none", null);
    @Generated
    public static final Property osPortName = BSerialPort.newProperty((int)3, (String)"", null);
    @Generated
    public static final Property portIndex = BSerialPort.newProperty((int)3, (int)-1, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BSerialPort.class);
    public static final Logger LOG = Logger.getLogger("plat.serial");
    protected boolean locked = false;

    @Generated
    public String getOwner() {
        return this.getString(owner);
    }

    @Generated
    public void setOwner(String v) {
        this.setString(owner, v, null);
    }

    @Generated
    public String getOsPortName() {
        return this.getString(osPortName);
    }

    @Generated
    public void setOsPortName(String v) {
        this.setString(osPortName, v, null);
    }

    @Generated
    public int getPortIndex() {
        return this.getInt(portIndex);
    }

    @Generated
    public void setPortIndex(int v) {
        this.setInt(portIndex, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public String toString(Context context) {
        return this.getOwner();
    }

    public void close() {
        try {
            this.unlock();
            this.closePort();
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public synchronized void lock(String owner) throws PortNotFoundException, PortDeniedException {
        this.checkOwner();
        if (!this.getOwner().equals("none")) {
            throw new PortDeniedException(this.getName() + " is already owned by " + this.getOwner());
        }
        this.locked = true;
        this.setOwner(owner);
    }

    public synchronized void unlock() throws PortDeniedException {
        if (!this.locked) {
            throw new PortDeniedException(this.getName() + " does not have the port lock");
        }
        this.setOwner("none");
        this.locked = false;
    }

    public synchronized void checkOwner() {
    }

    protected abstract void openPort() throws PortDeniedException;

    protected abstract void closePort();

    public abstract void sendBreak(int var1);

    public abstract void setFlowControlMode(BSerialFlowControlMode var1) throws UnsupportedOperationException;

    public abstract BSerialFlowControlMode getFlowControlMode();

    public abstract BBaudRate getBaudRate();

    public abstract BSerialDataBits getDataBits();

    public abstract BSerialStopBits getStopBits();

    public abstract BSerialParity getParity();

    public abstract void setSerialPortParams(BBaudRate var1, BSerialDataBits var2, BSerialStopBits var3, BSerialParity var4) throws UnsupportedOperationException;

    public abstract void setDTR(boolean var1);

    public abstract boolean isDTR();

    public abstract void setRTS(boolean var1);

    public abstract boolean isRTS();

    public abstract boolean isCTS();

    public abstract boolean isDSR();

    public abstract boolean isRI();

    public abstract boolean isCD();

    public abstract void enableReceiveThreshold(int var1) throws UnsupportedOperationException;

    public abstract void disableReceiveThreshold();

    public abstract boolean isReceiveThresholdEnabled();

    public abstract int getReceiveThreshold() throws UnsupportedOperationException;

    public abstract void enableReceiveTimeout(int var1) throws UnsupportedOperationException;

    public abstract void disableReceiveTimeout();

    public abstract boolean isReceiveTimeoutEnabled();

    public abstract int getReceiveTimeout() throws UnsupportedOperationException;

    public abstract InputStream getInputStream() throws IOException;

    public abstract OutputStream getOutputStream() throws IOException;

    public void doResetPort() {
    }
}

