/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.tools;

import com.tridium.ui.theme.Theme;
import com.tridium.ui.theme.custom.nss.StyleUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BTextDropDown;
import javax.baja.ui.BTextField;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.list.BList;
import javax.baja.ui.options.BOptions;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.style.IStylable;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.table.TableSubject;
import javax.baja.util.Lexicon;
import javax.baja.workbench.view.BWbView;

@NiagaraType(agent={@AgentOn(types={"wbutil:TodoListTool"})})
@NiagaraActions(value={@NiagaraAction(name="filter"), @NiagaraAction(name="refreshTable"), @NiagaraAction(name="setEnabledStates")})
public class BTodoList
extends BWbView {
    @Generated
    public static final Action filter = BTodoList.newAction((int)0, null);
    @Generated
    public static final Action refreshTable = BTodoList.newAction((int)0, null);
    @Generated
    public static final Action setEnabledStates = BTodoList.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BTodoList.class);
    static final int MODE_FULL = 1;
    static final int MODE_COMPACT = 2;
    static BImage addIcon = BImage.make((String)"module://icons/x16/add.png");
    static BImage editIcon = BImage.make((String)"module://icons/x16/edit.png");
    static BImage completeIcon = BImage.make((String)"module://icons/x16/ok.png");
    static BImage moveToTopIcon = BImage.make((String)"module://icons/x16/moveToTop.png");
    static BImage moveUpIcon = BImage.make((String)"module://icons/x16/moveUp.png");
    static BImage moveDownIcon = BImage.make((String)"module://icons/x16/moveDown.png");
    static BImage moveToBottomIcon = BImage.make((String)"module://icons/x16/moveToBottom.png");
    static BImage removeIcon = BImage.make((String)"module://icons/x16/delete.png");
    static BImage taskIcon = BImage.make((String)"module://icons/x16/task.png");
    static Lexicon lex = Lexicon.make((String)"wbutil");
    Model model;
    BOptions tasks;
    BTextDropDown filterSummary;
    BTextDropDown filterGroup;
    String lastGroup = "General";
    int mode;
    Command cmdAdd;
    Command cmdEdit;
    Command cmdComplete;
    Command cmdMoveToTop;
    Command cmdMoveUp;
    Command cmdMoveDown;
    Command cmdMoveToBottom;
    Command cmdRemove;

    @Generated
    public void filter() {
        this.invoke(filter, null, null);
    }

    @Generated
    public void refreshTable() {
        this.invoke(refreshTable, null, null);
    }

    @Generated
    public void setEnabledStates() {
        this.invoke(setEnabledStates, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BTodoList() {
        this(1);
    }

    public BTodoList(int mode) {
        this.mode = mode;
        this.tasks = BOptions.load((String)"wbutil-TodoList", (Type)BOptions.TYPE);
        this.cmdAdd = new Add((BWidget)this);
        this.cmdEdit = new Edit((BWidget)this);
        this.cmdComplete = new Completed((BWidget)this);
        this.cmdMoveToTop = new MoveToTop((BWidget)this);
        this.cmdMoveUp = new MoveUp((BWidget)this);
        this.cmdMoveDown = new MoveDown((BWidget)this);
        this.cmdMoveToBottom = new MoveToBottom((BWidget)this);
        this.cmdRemove = new Remove((BWidget)this);
        this.filterSummary = new BTextDropDown("", 15, true);
        this.filterGroup = new BTextDropDown("", 15, true);
        this.linkTo((BComponent)this.filterSummary.getEditor(), (Slot)BTextField.textModified, (Slot)filter);
        this.linkTo((BComponent)this.filterGroup.getEditor(), (Slot)BTextField.textModified, (Slot)filter);
        this.model = new Model();
        BTable table = new BTable((TableModel)this.model);
        table.setStyleClasses("sidebar-table");
        table.setController((TableController)new TodoController());
        table.setCellRenderer((TableCellRenderer)new TodoRenderer());
        table.setSelection(new TableSelection());
        if (this.isCompact()) {
            table.setHeaderVisible(false);
        }
        this.linkTo((BComponent)table, (Slot)BTable.selectionModified, (Slot)setEnabledStates);
        this.linkTo((BComponent)this.tasks, (Slot)BOptions.optionsSaved, (Slot)refreshTable);
        BToolBar tools = new BToolBar();
        tools.add(null, this.cmdAdd);
        if (!this.isCompact()) {
            tools.add(null, this.cmdComplete);
            tools.add(null, this.cmdEdit);
            tools.add(null, (BValue)new BSeparator());
            tools.add(null, this.cmdMoveToTop);
            tools.add(null, this.cmdMoveUp);
            tools.add(null, this.cmdMoveDown);
            tools.add(null, this.cmdMoveToBottom);
            tools.add(null, (BValue)new BSeparator());
            tools.add(null, this.cmdRemove);
        }
        BGridPane filters = null;
        if (!this.isCompact()) {
            filters = new BGridPane(4);
            filters.setRowAlign(BValign.fill);
            filters.add(null, (BValue)new BBorderPane((BWidget)new BLabel(BTodoList.text("summary"), Theme.widget().getBoldText()), 0.0, 0.0, 0.0, 5.0));
            filters.add(null, (BValue)this.filterSummary);
            filters.add(null, (BValue)new BBorderPane((BWidget)new BLabel(BTodoList.text("group"), Theme.widget().getBoldText()), 0.0, 0.0, 0.0, 5.0));
            filters.add(null, (BValue)this.filterGroup);
        }
        BEdgePane top = new BEdgePane();
        top.setLeft((BWidget)tools);
        if (this.isCompact()) {
            top.setCenter((BWidget)new BBorderPane((BWidget)this.filterGroup, 0.0, 0.0, 0.0, 5.0));
        } else {
            top.setRight((BWidget)filters);
        }
        BEdgePane pane = new BEdgePane();
        if (this.isCompact()) {
            pane.setTop((BWidget)new BBorderPane((BWidget)top, 5.0, 5.0, 5.0, 5.0));
            pane.setCenter((BWidget)table);
        } else {
            pane.setTop((BWidget)new BBorderPane((BWidget)top, 0.0, 0.0, 5.0, 0.0));
            pane.setCenter((BWidget)new BBorderPane((BWidget)table, BBorder.none, BInsets.DEFAULT));
        }
        StyleUtils.addStyleClass((IStylable)pane.getTop(), (String)"sidebar-header");
        this.setContent((BWidget)pane);
        this.updateView();
        this.model.sortByColumn(2, true);
        this.model.updateTable(true);
        this.model.getSelection().updateTable();
    }

    BButton makeButton(Command c) {
        BButton b = new BButton(c);
        b.setButtonStyle(BButtonStyle.toolBar);
        return b;
    }

    boolean isCompact() {
        return this.mode == 2;
    }

    int getIndexOf(BComponent c) {
        SlotCursor cur = this.tasks.getSlots();
        int i = 0;
        while (cur.next()) {
            if (cur.slot().getName().equals(c.getName())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    void doReorder(int target) {
        if (this.model.kids.size() == 0) {
            return;
        }
        int[] rows = this.model.getSelection().getRows();
        BComponent c = this.model.kids.get(rows[0]);
        Property slot = c.getPropertyInParent();
        switch (target) {
            case -3: {
                this.tasks.reorderToTop(slot);
                this.model.getSelection().deselectAll();
                this.model.getSelection().select(0);
                break;
            }
            case -2: {
                this.tasks.reorderToBottom(slot);
                this.model.getSelection().deselectAll();
                this.model.getSelection().select(this.model.kids.size() - 1);
                break;
            }
            case -1: {
                Property[] slots = this.tasks.getPropertiesArray();
                for (int i = 0; i < slots.length; ++i) {
                    if (slots[i] != slot || i <= 0) continue;
                    Property temp = slots[i - 1];
                    slots[i - 1] = slots[i];
                    slots[i] = temp;
                    this.tasks.reorder(slots);
                    this.model.getSelection().deselectAll();
                    this.model.getSelection().select(rows[0] - 1);
                }
                break;
            }
            case 1: {
                Property[] slots = this.tasks.getPropertiesArray();
                for (int i = slots.length - 1; i >= 0; --i) {
                    if (slots[i] != slot || i >= slots.length - 1) continue;
                    Property temp = slots[i + 1];
                    slots[i + 1] = slots[i];
                    slots[i] = temp;
                    this.tasks.reorder(slots);
                    this.model.getSelection().deselectAll();
                    this.model.getSelection().select(rows[0] + 1);
                }
                break;
            }
        }
        this.updateView();
    }

    void updateView() {
        this.tasks.save();
        this.model.refresh();
        this.loadGroups(this.filterGroup.getList());
    }

    void loadGroups(BList list) {
        list.removeAllItems();
        Property[] props = this.tasks.getPropertiesArray();
        for (int i = 0; i < props.length; ++i) {
            BComponent c = this.tasks.get(props[i]).asComponent();
            String v = ((BString)c.get("group")).getString();
            if (list.indexOfItem((Object)v) != -1) continue;
            list.addItem((Object)v);
        }
    }

    public void doFilter() {
        this.model.refresh();
    }

    public void doSetEnabledStates() {
        boolean sel = this.model.getSelection().getRows().length > 0;
        this.cmdComplete.setEnabled(sel);
        this.cmdEdit.setEnabled(sel);
        this.cmdRemove.setEnabled(sel);
        boolean multiple = this.model.getRowCount() > 1;
        this.cmdMoveToTop.setEnabled(sel && multiple);
        this.cmdMoveUp.setEnabled(sel && multiple);
        this.cmdMoveDown.setEnabled(sel && multiple);
        this.cmdMoveToBottom.setEnabled(sel && multiple);
    }

    public void doRefreshTable() {
        this.model.refresh();
        this.loadGroups(this.filterGroup.getList());
        if (this.model.getRowCount() == 0) {
            this.model.getSelection().deselectAll();
        }
    }

    static String text(String key) {
        return lex.getText("todoList." + key);
    }

    class TodoRenderer
    extends TableCellRenderer {
        BBrush completedColor = BBrush.make((String)"#999");

        TodoRenderer() {
        }

        public BBrush getForeground(TableCellRenderer.Cell cell) {
            BComponent c = BTodoList.this.model.kids.get(cell.row);
            if (c.get("completed") == BBoolean.TRUE) {
                return this.completedColor;
            }
            return super.getForeground(cell);
        }

        public void paintCell(Graphics g, TableCellRenderer.Cell cell) {
            super.paintCell(g, cell);
            BComponent c = BTodoList.this.model.kids.get(cell.row);
            if (c.get("completed") == BBoolean.TRUE) {
                String s = this.getCellText(cell);
                BFont font = this.getFont(cell);
                double x = cell.column == 0 ? 21.0 : 1.0;
                double y = cell.height / 2.0;
                double w = font.width(s);
                g.setBrush(cell.selected ? BColor.white.toBrush() : this.completedColor);
                g.strokeLine(x, y, x + w + 1.0, y);
            }
        }
    }

    class TodoController
    extends TableController {
        TodoController() {
        }

        public void keyPressed(BKeyEvent event) {
            super.keyPressed(event);
            switch (event.getKeyCode()) {
                case 65: {
                    BTodoList.this.cmdAdd.invoke();
                    break;
                }
                case 127: {
                    BTodoList.this.cmdRemove.invoke();
                }
            }
        }

        protected void cellDoubleClicked(BMouseEvent event, int row, int column) {
            BTodoList.this.cmdEdit.invoke();
        }

        protected BMenu makePopup(TableSubject subject) {
            BMenu menu = new BMenu();
            menu.add(null, BTodoList.this.cmdAdd);
            menu.add(null, BTodoList.this.cmdComplete);
            menu.add(null, BTodoList.this.cmdEdit);
            menu.add(null, (BValue)new BSeparator());
            menu.add(null, BTodoList.this.cmdMoveToTop);
            menu.add(null, BTodoList.this.cmdMoveUp);
            menu.add(null, BTodoList.this.cmdMoveDown);
            menu.add(null, BTodoList.this.cmdMoveToBottom);
            menu.add(null, (BValue)new BSeparator());
            menu.add(null, BTodoList.this.cmdRemove);
            return menu;
        }
    }

    class Remove
    extends Command {
        public Remove(BWidget owner) {
            super(owner, BTodoList.text("remove"));
        }

        public BImage getIcon() {
            return removeIcon;
        }

        public CommandArtifact doInvoke() {
            if (BTodoList.this.model.kids.size() == 0) {
                return null;
            }
            int[] rows = BTodoList.this.model.getSelection().getRows();
            if (rows.length == 0) {
                return null;
            }
            if (4 == BDialog.confirm((BWidget)this.getOwner(), (String)BTodoList.text("remove"), (Object)BTodoList.text("removeQuery"))) {
                for (int i = rows.length - 1; i >= 0; --i) {
                    BComponent c = BTodoList.this.model.kids.get(rows[i]);
                    BTodoList.this.tasks.remove(c.getPropertyInParent());
                }
                BTodoList.this.updateView();
                BTodoList.this.model.getSelection().deselectAll();
            }
            return null;
        }
    }

    class MoveToBottom
    extends Command {
        public MoveToBottom(BWidget owner) {
            super(owner, BTodoList.text("moveToBottom"));
        }

        public BImage getIcon() {
            return moveToBottomIcon;
        }

        public CommandArtifact doInvoke() {
            BTodoList.this.doReorder(-2);
            return null;
        }
    }

    class MoveDown
    extends Command {
        public MoveDown(BWidget owner) {
            super(owner, BTodoList.text("moveDown"));
        }

        public BImage getIcon() {
            return moveDownIcon;
        }

        public CommandArtifact doInvoke() {
            BTodoList.this.doReorder(1);
            return null;
        }
    }

    class MoveUp
    extends Command {
        public MoveUp(BWidget owner) {
            super(owner, BTodoList.text("moveUp"));
        }

        public BImage getIcon() {
            return moveUpIcon;
        }

        public CommandArtifact doInvoke() {
            BTodoList.this.doReorder(-1);
            return null;
        }
    }

    class MoveToTop
    extends Command {
        public MoveToTop(BWidget owner) {
            super(owner, BTodoList.text("moveToTop"));
        }

        public BImage getIcon() {
            return moveToTopIcon;
        }

        public CommandArtifact doInvoke() {
            BTodoList.this.doReorder(-3);
            return null;
        }
    }

    class Completed
    extends Command {
        public Completed(BWidget owner) {
            super(owner, BTodoList.text("completed"));
        }

        public BImage getIcon() {
            return completeIcon;
        }

        public CommandArtifact doInvoke() {
            if (BTodoList.this.model.kids.size() == 0) {
                return null;
            }
            int[] rows = BTodoList.this.model.getSelection().getRows();
            for (int i = 0; i < rows.length; ++i) {
                BComponent c = BTodoList.this.model.kids.get(rows[i]);
                BBoolean v = (BBoolean)c.get("completed");
                if (v == null) {
                    c.add("completed", (BValue)BBoolean.TRUE);
                    c.add("dateCompleted", (BValue)BAbsTime.now());
                    continue;
                }
                if (v == BBoolean.FALSE) {
                    c.set("completed", (BValue)BBoolean.TRUE);
                    c.add("dateCompleted", (BValue)BAbsTime.now());
                    continue;
                }
                if (v != BBoolean.TRUE) continue;
                c.set("completed", (BValue)BBoolean.FALSE);
                c.remove("dateCompleted");
            }
            BTodoList.this.updateView();
            return null;
        }
    }

    class Edit
    extends Command {
        public Edit(BWidget owner) {
            super(owner, BTodoList.text("edit"));
        }

        public BImage getIcon() {
            return editIcon;
        }

        public CommandArtifact doInvoke() {
            if (BTodoList.this.model.kids.size() == 0) {
                return null;
            }
            int row = BTodoList.this.model.getSelection().getRow();
            BComponent c = BTodoList.this.model.kids.get(row);
            BTextField field = new BTextField(c.get("summary").toString(), 50);
            BTextDropDown group = new BTextDropDown(c.get("group").toString(), 30, true);
            BTodoList.this.loadGroups(group.getList());
            BGridPane grid = new BGridPane(2);
            grid.add(null, (BValue)new BLabel(BTodoList.text("summary")));
            grid.add(null, (BValue)field);
            grid.add(null, (BValue)new BLabel(BTodoList.text("group")));
            grid.add(null, (BValue)group);
            if (1 == BDialog.open((BWidget)this.getOwner(), (String)BTodoList.text("edit"), (Object)new BBorderPane((BWidget)grid), (int)3)) {
                c.set("summary", (BValue)BString.make((String)field.getText()));
                c.set("group", (BValue)BString.make((String)group.getText()));
                BTodoList.this.updateView();
                BTodoList.this.model.getSelection().deselectAll();
            }
            return null;
        }
    }

    class Add
    extends Command {
        public Add(BWidget owner) {
            super(owner, BTodoList.text("add"));
        }

        public BImage getIcon() {
            return addIcon;
        }

        public CommandArtifact doInvoke() {
            BTextField field = new BTextField("", 50);
            BTextDropDown group = new BTextDropDown(BTodoList.this.lastGroup, 30, true);
            BTodoList.this.loadGroups(group.getList());
            BGridPane grid = new BGridPane(2);
            grid.add(null, (BValue)new BLabel(BTodoList.text("summary")));
            grid.add(null, (BValue)field);
            grid.add(null, (BValue)new BLabel(BTodoList.text("group")));
            grid.add(null, (BValue)group);
            if (1 == BDialog.open((BWidget)this.getOwner(), (String)BTodoList.text("add"), (Object)new BBorderPane((BWidget)grid), (int)3)) {
                BComponent c = new BComponent();
                c.add("summary", (BValue)BString.make((String)field.getText()));
                c.add("group", (BValue)BString.make((String)group.getText()));
                c.add("date", (BValue)BAbsTime.now());
                BTodoList.this.tasks.add(null, (BValue)c);
                BTodoList.this.updateView();
                BTodoList.this.lastGroup = group.getText();
                BTodoList.this.model.getSelection().deselectAll();
            }
            return null;
        }
    }

    class ClearFilters
    extends Command {
        public ClearFilters(BWidget owner) {
            super(owner, "");
        }

        public String getLabel() {
            return null;
        }

        public BImage getIcon() {
            return removeIcon;
        }

        public CommandArtifact doInvoke() {
            BTodoList.this.filterSummary.getEditor().setText("");
            BTodoList.this.filterGroup.getEditor().setText("");
            BTodoList.this.doFilter();
            return null;
        }
    }

    class Sorter
    implements Comparator<BComponent> {
        int col = 0;
        boolean ascend = true;

        public Sorter(int col, boolean ascend) {
            this.col = col;
            this.ascend = ascend;
        }

        @Override
        public int compare(BComponent o1, BComponent o2) {
            BComponent c1 = o1;
            BComponent c2 = o2;
            switch (this.col) {
                case 0: {
                    String a = c1.get("summary").toString();
                    String b = c2.get("summary").toString();
                    return this.ascend ? a.compareToIgnoreCase(b) : b.compareToIgnoreCase(a);
                }
                case 1: {
                    String a = c1.get("group").toString();
                    String b = c2.get("group").toString();
                    return this.ascend ? a.compareToIgnoreCase(b) : b.compareToIgnoreCase(a);
                }
                case 2: {
                    int ia = BTodoList.this.getIndexOf(c1);
                    int ib = BTodoList.this.getIndexOf(c2);
                    if (ia < ib) {
                        return this.ascend ? -1 : 1;
                    }
                    if (ia > ib) {
                        return this.ascend ? 1 : -1;
                    }
                    return 0;
                }
                case 3: {
                    BAbsTime ta = (BAbsTime)c1.get("date");
                    BAbsTime tb = (BAbsTime)c2.get("date");
                    return this.ascend ? ta.compareTo((Object)tb) : tb.compareTo((Object)ta);
                }
                case 4: {
                    BAbsTime tc = (BAbsTime)c1.get("dateCompleted");
                    BAbsTime td = (BAbsTime)c2.get("dateCompleted");
                    if (tc != null && td != null) {
                        return this.ascend ? tc.compareTo((Object)td) : td.compareTo((Object)tc);
                    }
                    if (tc == null && td == null) {
                        return 0;
                    }
                    if (tc != null && td == null) {
                        return this.ascend ? 1 : -1;
                    }
                    if (tc != null || td == null) break;
                    return this.ascend ? -1 : 1;
                }
            }
            return 0;
        }
    }

    class Model
    extends TableModel {
        ArrayList<BComponent> kids = new ArrayList();

        Model() {
        }

        public int getRowCount() {
            return this.kids.size();
        }

        public int getColumnCount() {
            return BTodoList.this.isCompact() ? 1 : 5;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return BTodoList.text("summary");
                }
                case 1: {
                    return BTodoList.text("group");
                }
                case 2: {
                    return BTodoList.text("priority");
                }
                case 3: {
                    return BTodoList.text("date");
                }
                case 4: {
                    return BTodoList.text("dateCompleted");
                }
            }
            return "";
        }

        public Object getValueAt(int row, int col) {
            BComponent c = this.kids.get(row);
            switch (col) {
                case 0: {
                    return c.get("summary");
                }
                case 1: {
                    return c.get("group");
                }
                case 2: {
                    return Integer.toString(BTodoList.this.getIndexOf(c));
                }
                case 3: {
                    return c.get("date");
                }
                case 4: {
                    return c.get("dateCompleted") == null ? new String("Task Still Open") : c.get("dateCompleted");
                }
            }
            return "";
        }

        public Object getSubject(int row) {
            return this.kids.get(row);
        }

        public BImage getRowIcon(int row) {
            return taskIcon;
        }

        public boolean isColumnSortable(int col) {
            return true;
        }

        public void sortByColumn(int col, boolean ascending) {
            BComponent[] c = this.kids.toArray(new BComponent[0]);
            Arrays.sort(c, new Sorter(col, ascending));
            this.kids.clear();
            for (int i = 0; i < c.length; ++i) {
                this.kids.add(c[i]);
            }
        }

        public void refresh() {
            this.kids.clear();
            Property[] props = BTodoList.this.tasks.getPropertiesArray();
            for (int i = 0; i < props.length; ++i) {
                BComponent c = BTodoList.this.tasks.get(props[i]).asComponent();
                String filter = BTodoList.this.filterGroup.getText().toLowerCase();
                String g = ((BString)c.get("group")).getString().toLowerCase();
                if (filter.length() != 0 && g.indexOf(filter) == -1) continue;
                filter = BTodoList.this.filterSummary.getText().toLowerCase();
                g = ((BString)c.get("summary")).getString().toLowerCase();
                if (filter.length() != 0 && g.indexOf(filter) == -1) continue;
                this.kids.add(c);
            }
            this.updateTable(true);
        }
    }
}

