/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.role;

import com.tridium.workbench.category.Category;
import com.tridium.workbench.fieldeditors.BStringFE;
import com.tridium.workbench.fieldeditors.BStringMgrColFE;
import com.tridium.workbench.role.BRoleMgrTable;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.role.BIRole;
import javax.baja.role.BRole;
import javax.baja.role.BRoleService;
import javax.baja.security.BPermissions;
import javax.baja.security.BPermissionsMap;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.BMgrTable;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEdit;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrTagDictionary;
import javax.baja.workbench.mgr.MgrTypeInfo;

@NiagaraType(agent={@AgentOn(types={"baja:RoleService"}, requiredPermissions="W")})
public class BRoleManager
extends BAbstractManager {
    @Generated
    public static final Type TYPE = Sys.loadType(BRoleManager.class);
    static final Lexicon lex = Lexicon.make(BRoleManager.class);
    private static final String NO_PERMISSIONS = lex.getText("roleManager.noPermissions");
    MgrColumn colName = new RoleNameColumn();
    MgrColumn colPermissions = new PermissionsColumn(1);
    protected MgrColumn[] cols = new MgrColumn[]{this.colName, this.colPermissions};
    BRoleService service;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void doLoadValue(BObject value, Context cx) {
        this.service = (BRoleService)value;
        super.doLoadValue(value, cx);
    }

    protected MgrTagDictionary makeTagDictionary() {
        return null;
    }

    protected MgrModel makeModel() {
        return new Model(this);
    }

    protected MgrController makeController() {
        return new Controller(this);
    }

    void validate(MgrEditRow row) throws Exception {
    }

    class PermissionsColumn
    extends UserProp {
        PermissionsColumn(int flags) {
            super(BRole.permissions, flags);
        }

        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) {
            BWbFieldEditor editor;
            BValue val = rows[0].getCell(colIndex);
            BFacets facets = rows.length == 1 && this.props.length == 1 ? rows[0].getTarget().getSlotFacets((Slot)this.props[0]) : this.props[this.props.length - 1].getFacets();
            Context cx = rows[0].getManager().getCurrentContext();
            if (!facets.isNull()) {
                cx = new BasicContext(cx, facets);
            }
            if ((editor = BWbFieldEditor.makeFor((BObject)val, (Context)cx)) instanceof BStringFE) {
                editor = new BStringMgrColFE(colIndex);
            }
            if (currentEditor != null && currentEditor.getClass() == editor.getClass()) {
                editor = (BWbFieldEditor)currentEditor;
            }
            editor.loadValue((BObject)val, cx);
            return editor;
        }

        public void save(MgrEditRow row, BValue value, Context cx) {
            BComponent target = row.getTarget();
            BValue old = target.get(this.prop);
            if (!old.equivalent((Object)value)) {
                if (target.getParent() != null) {
                    BIRole role = (BIRole)target;
                    BPermissionsMap oldPm = (BPermissionsMap)old;
                    BPermissionsMap newPm = (BPermissionsMap)value;
                    if (BDialog.confirm((BWidget)this.getManager().getShell(), (String)lex.getText("roleManager.suConfirmTitle"), (Object)this.getLexPerms(role, oldPm, newPm, cx)) != 4) {
                        return;
                    }
                }
                target.set(this.prop, value.newCopy(), cx);
            }
        }

        public String toDisplayString(Object row, Object value, Context cx) {
            return this.getPermissionDisplayString((BPermissionsMap)value, cx);
        }

        private String getLexPerms(BIRole role, BPermissionsMap oldPerms, BPermissionsMap newPerms, Context cx) {
            return lex.getText("roleManager.suConfirmText", new Object[]{SlotPath.unescape((String)role.getRoleIdentifier()), this.getPermissionDisplayString(oldPerms, cx), this.getPermissionDisplayString(newPerms, cx)});
        }

        private String getPermissionDisplayString(BPermissionsMap map, Context cx) {
            if (map.isSuperUser()) {
                return lex.getText("superUser");
            }
            Category[] categories = Category.load((BWbShell)BRoleManager.this.getWbShell(), (int)map.size()).categories;
            StringBuilder s = new StringBuilder();
            for (int i = 1; i < map.size(); ++i) {
                BPermissions p = map.getPermissions(i);
                if (p == null || p.getMask() == 0) continue;
                if (s.length() > 0) {
                    s.append("; ");
                }
                s.append(categories[i].display).append('=').append(p.encodeToString());
            }
            if (s.length() == 0) {
                return NO_PERMISSIONS;
            }
            return s.toString();
        }
    }

    class RoleNameColumn
    extends MgrColumn.Name {
        RoleNameColumn() {
        }

        public Object get(Object target) {
            String s = (String)super.get(target);
            if (s.equals("Admin")) {
                return BString.make((String)"admin");
            }
            if (s.equals("Guest")) {
                return BString.make((String)"guest");
            }
            return s;
        }
    }

    static class UserProp
    extends MgrColumn.Prop {
        public UserProp(Property prop, int flags) {
            super(prop, flags);
        }

        public Property getProperty() {
            return this.prop;
        }
    }

    class Edit
    extends MgrEdit {
        Edit(BAbstractManager mgr, String label) {
            super(mgr, label);
        }

        public void validate(MgrEditRow row) throws Exception {
            BRoleManager.this.validate(row);
        }

        public boolean isReadonly(MgrEditRow[] selectedRows, MgrColumn col) {
            return false;
        }
    }

    class Controller
    extends MgrController {
        Controller(BRoleManager mgr) {
            super((BAbstractManager)mgr);
        }

        public MgrEdit makeEdit(String label) {
            return new Edit(this.getManager(), label);
        }
    }

    class Model
    extends MgrModel {
        Model(BRoleManager mgr) {
            super((BAbstractManager)mgr);
        }

        protected BMgrTable makeTable() {
            return new BRoleMgrTable(this);
        }

        protected String makeTableTitle() {
            return TYPE.getDisplayName(null);
        }

        protected MgrColumn[] makeColumns() {
            return this.appendMixInColumns(BRoleManager.this.cols, BRole.TYPE);
        }

        public int getSubscribeDepth() {
            return 3;
        }

        public Type[] getIncludeTypes() {
            return new Type[]{BRole.TYPE};
        }

        public MgrTypeInfo[] getNewTypes() {
            return new MgrTypeInfo[]{MgrTypeInfo.make((BComponent)new BRole())};
        }

        public BComponent newInstance(MgrTypeInfo type) {
            BRole def = new BRole();
            return def;
        }
    }
}

