/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.metadata;

import com.tridium.workbench.metadata.BAddDialog;
import com.tridium.workbench.metadata.BMetadataBrowser;
import com.tridium.workbench.metadata.BRemoveDialog;
import com.tridium.workbench.metadata.BSetDialog;
import javax.baja.sys.BModule;
import javax.baja.sys.Sys;
import javax.baja.ui.BMenu;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.util.Lexicon;

public class MetadataCommands {
    private static BModule module = Sys.getModuleForClass(BMetadataBrowser.class);
    private static Lexicon lex = Lexicon.make(BMetadataBrowser.class);
    private BMetadataBrowser editor;
    SlotAdd slotAdd;
    SlotEdit slotEdit;
    SlotRemove slotRemove;

    public MetadataCommands(BMetadataBrowser editor) {
        this.editor = editor;
        this.slotAdd = new SlotAdd();
        this.slotEdit = new SlotEdit();
        this.slotRemove = new SlotRemove();
    }

    public void updateCommands() {
        boolean b = this.editor.table.getSelection().getRows().length > 0;
        String[] allCols = this.editor.model.getAllColumns();
        String[] dynamicCols = this.editor.model.getAllColumns(false);
        this.slotAdd.setEnabled(b);
        this.slotEdit.setEnabled(b && allCols != null && allCols.length > 0);
        this.slotRemove.setEnabled(b && dynamicCols != null && dynamicCols.length > 0);
    }

    public BMenu buildMenu() {
        BMenu menu = new BMenu(lex.getText("metadataBrowser"));
        menu.add(null, (Command)this.slotAdd);
        menu.add(null, (Command)this.slotEdit);
        menu.add(null, (Command)this.slotRemove);
        return menu;
    }

    class SlotRemove
    extends MetadataCommand {
        public SlotRemove() {
            super("slotRemove");
        }

        public CommandArtifact doInvoke() {
            BRemoveDialog.open(MetadataCommands.this.editor);
            return null;
        }
    }

    class SlotEdit
    extends MetadataCommand {
        public SlotEdit() {
            super("slotEdit");
        }

        public CommandArtifact doInvoke() {
            BSetDialog.open(MetadataCommands.this.editor);
            return null;
        }
    }

    class SlotAdd
    extends MetadataCommand {
        public SlotAdd() {
            super("slotAdd");
        }

        public CommandArtifact doInvoke() {
            BAddDialog.open(MetadataCommands.this.editor);
            return null;
        }
    }

    abstract class MetadataCommand
    extends Command {
        public MetadataCommand(String lex) {
            super((BWidget)MetadataCommands.this.editor, module, "metadataBrowser.commands." + lex);
        }
    }
}

