/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.colorchooser;

import com.tridium.ui.theme.Theme;
import com.tridium.workbench.colorchooser.BBrushSwatch;
import com.tridium.workbench.colorchooser.BColorChooser;
import com.tridium.workbench.colorchooser.BGradientEditor;
import java.util.Arrays;
import java.util.Comparator;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.gx.PolygonGeom;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="setModified"), @NiagaraAction(name="offsetChanged")})
public class BStopEditor
extends BWidget {
    @Generated
    public static final Action setModified = BStopEditor.newAction((int)0, null);
    @Generated
    public static final Action offsetChanged = BStopEditor.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BStopEditor.class);
    private static BImage removeIcon = BImage.make((String)"module://icons/x16/delete.png");
    private Sorter sorter = new Sorter();
    private static BBrush selectionBrush = BColor.make((int)65280).toBrush();
    private static Lexicon lexicon = Lexicon.make((String)"wbutil");
    private BBrush.Stop[] stops;
    private PolygonGeom[] markers = null;
    private PolygonGeom selection = new PolygonGeom();
    private boolean drag = false;
    private int focus = 0;
    private boolean out = false;
    private BBrushSwatch bar;
    private BWidget controls;
    private BTextField offsetField;
    private BBrushSwatch colorSwatch;
    private RemoveCommand removeCommand;

    @Generated
    public void setModified() {
        this.invoke(setModified, null, null);
    }

    @Generated
    public void offsetChanged() {
        this.invoke(offsetChanged, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BStopEditor() {
        throw new IllegalStateException();
    }

    public BStopEditor(BBrush.Stop[] stops) {
        this.colorSwatch = new BBrushSwatch();
        this.colorSwatch.setController(new Controller());
        BGridPane a = new BGridPane(3);
        a.add(null, (BValue)new BLabel(BStopEditor.getText("offset")));
        this.offsetField = new BTextField("", 6);
        a.add(null, (BValue)this.offsetField);
        a.add(null, (BValue)new BLabel("%"));
        a.add(null, (BValue)new BLabel(BStopEditor.getText("color")));
        a.add(null, (BValue)new BBorderPane((BWidget)this.colorSwatch, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        a.add(null, (BValue)new BNullWidget());
        this.removeCommand = new RemoveCommand(this);
        BButton b = new BButton((Command)this.removeCommand);
        b.setButtonStyle(BButtonStyle.toolBar);
        BGridPane c = new BGridPane(1);
        c.add(null, (BValue)a);
        c.add(null, (BValue)b);
        this.bar = new BBrushSwatch();
        this.add(null, (BValue)this.bar);
        this.controls = c;
        this.add(null, (BValue)this.controls);
        this.setStops(stops);
        this.linkTo((BComponent)this.offsetField, (Slot)BTextField.textModified, (Slot)offsetChanged);
    }

    public void computePreferredSize() {
        this.offsetField.computePreferredSize();
        this.colorSwatch.setPreferredSize(this.offsetField.getPreferredWidth() - 2.0, this.offsetField.getPreferredHeight() - 2.0);
        this.controls.computePreferredSize();
        double pw = 320.0 + this.controls.getPreferredWidth();
        double ph = Math.max(40.0, this.controls.getPreferredHeight());
        this.setPreferredSize(pw, ph);
    }

    public void doLayout(BWidget[] children) {
        double w = this.getWidth();
        double h = this.getHeight();
        this.offsetField.computePreferredSize();
        this.colorSwatch.setPreferredSize(this.offsetField.getPreferredWidth() - 2.0, this.offsetField.getPreferredHeight() - 2.0);
        BWidget c = this.controls;
        c.computePreferredSize();
        c.setBounds(w - c.getPreferredWidth(), 0.0, c.getPreferredWidth(), c.getPreferredHeight());
        this.bar.setBounds(5.0, 0.0, (w -= c.getPreferredWidth() + 20.0) - 11.0, h - 21.0);
    }

    public void paint(Graphics g) {
        double w = this.getWidth();
        double h = this.getHeight();
        this.bar.setBrush(BBrush.makeLinearGradient((BBrush.Stop[])this.stops));
        this.paintChild(g, this.bar);
        if (this.markers == null) {
            this.makeMarkers();
        }
        for (int i = 0; i < this.markers.length; ++i) {
            if (i == this.focus && this.out) continue;
            g.setBrush(this.stops[i].getColor());
            g.fill((IGeom)this.markers[i]);
            g.setBrush(Theme.widget().getControlForeground());
            g.stroke((IGeom)this.markers[i]);
            double[] x = this.markers[i].x();
            double[] y = this.markers[i].y();
            g.setBrush(Theme.widget().getControlHighlight());
            g.strokeLine(x[0], y[0] + 1.0, x[4] + 1.0, y[4]);
            g.strokeLine(x[4] + 1.0, y[4], x[3] + 1.0, y[3] - 1.0);
            g.setBrush(Theme.widget().getControlShadow());
            g.strokeLine(x[3] + 1.0, y[3] - 1.0, x[2] - 1.0, y[2] - 1.0);
            g.strokeLine(x[2] - 1.0, y[2] - 1.0, x[1] - 1.0, y[1]);
            g.strokeLine(x[1] - 1.0, y[1], x[0], y[0] + 1.0);
            if (i != this.focus) continue;
            y[0] = y[0] - 1.0;
            x[1] = x[1] + 1.0;
            x[2] = x[2] + 1.0;
            y[2] = y[2] + 1.0;
            x[3] = x[3] - 1.0;
            y[3] = y[3] + 1.0;
            x[4] = x[4] - 1.0;
            this.selection.set(x, y, 5);
            g.setBrush(selectionBrush);
            g.stroke((IGeom)this.selection);
        }
        this.paintChild(g, this.controls);
    }

    private void makeMarkers() {
        this.markers = new PolygonGeom[this.stops.length];
        for (int i = 0; i < this.stops.length; ++i) {
            BBrush.Stop stop = this.stops[i];
            double x = this.toScreen(stop.getOffset());
            double y = this.bar.getHeight() + 2.0;
            double[] px = new double[]{x, x + 5.0, x + 5.0, x - 5.0, x - 5.0};
            double[] py = new double[]{y, y + 5.0, y + 15.0, y + 15.0, y + 5.0};
            this.markers[i] = new PolygonGeom(px, py, 5);
        }
    }

    public BBrush.Stop[] getStops() {
        return this.stops;
    }

    public void setStops(BBrush.Stop[] stops) {
        this.stops = stops;
        this.updateControls();
    }

    public void mousePressed(BMouseEvent event) {
        this.focus = this.indexOf(event.getX(), event.getY());
        if (this.focus == -1) {
            this.focus = this.addStop(this.toPercent(event.getX()));
        }
        this.updateControls();
        this.repaint();
    }

    public void mouseReleased(BMouseEvent event) {
        this.out = false;
        if (this.drag && !this.contains(0.0, event.getY())) {
            this.drag = false;
            this.removeCommand.invoke();
        } else {
            this.setModified();
        }
    }

    public void mouseDragged(BMouseEvent event) {
        if (this.focus == -1) {
            return;
        }
        this.out = this.stops.length > 2 && !this.contains(0.0, event.getY());
        this.drag = true;
        this.stops[this.focus] = BBrush.stop((double)this.toPercent(event.getX()), (BColor)this.stops[this.focus].getColor());
        BBrush.Stop temp = this.stops[this.focus];
        Arrays.sort(this.stops, this.sorter);
        for (int i = 0; i < this.stops.length; ++i) {
            if (this.stops[i] != temp) continue;
            this.focus = i;
        }
        this.markers = null;
        this.updateControls();
        this.repaint();
    }

    private void updateControls() {
        if (this.focus == -1 || this.focus >= this.stops.length) {
            return;
        }
        this.offsetField.setText(Double.toString(this.stops[this.focus].getOffset()));
        this.colorSwatch.setBrush(this.stops[this.focus].getColor().toBrush());
    }

    private int addStop(double v) {
        int i;
        BBrush.Stop newStop = BBrush.stop((double)v, (BColor)BColor.red);
        BBrush.Stop[] s = new BBrush.Stop[this.stops.length + 1];
        for (i = 0; i < this.stops.length; ++i) {
            s[i] = this.stops[i];
        }
        s[s.length - 1] = newStop;
        Arrays.sort(s, this.sorter);
        this.setStops(s);
        this.markers = null;
        for (i = 0; i < s.length; ++i) {
            if (this.stops[i] != newStop) continue;
            BBrush.Stop prev = i > 0 ? this.stops[i - 1] : this.stops[i + 1];
            this.stops[i] = BBrush.stop((double)this.stops[i].getOffset(), (BColor)prev.getColor());
            return i;
        }
        return -1;
    }

    private void removeStop(int index) {
        BBrush.Stop[] s = new BBrush.Stop[this.stops.length - 1];
        for (int i = 0; i < this.stops.length; ++i) {
            if (i < index) {
                s[i] = this.stops[i];
                continue;
            }
            if (i <= index) continue;
            s[i - 1] = this.stops[i];
        }
        this.setStops(s);
        this.markers = null;
    }

    private int indexOf(double x, double y) {
        for (int i = 0; i < this.markers.length; ++i) {
            if (!this.markers[i].contains(x, y)) continue;
            return i;
        }
        return -1;
    }

    private double toPercent(double v) {
        if (v < this.bar.getX()) {
            return 0.0;
        }
        if (v > this.bar.getX() + this.bar.getWidth()) {
            return 100.0;
        }
        v = (v - this.bar.getX()) / this.bar.getWidth() * 100.0;
        return BGradientEditor.round(v);
    }

    private double toScreen(double v) {
        return this.bar.getX() + v / 100.0 * this.bar.getWidth();
    }

    public void doSetModified() {
        this.repaint();
    }

    public void doOffsetChanged() {
        try {
            double offset = Double.parseDouble(this.offsetField.getText());
            if (offset < 0.0) {
                offset = 0.0;
            }
            if (offset > 100.0) {
                offset = 100.0;
            }
            this.stops[this.focus] = BBrush.stop((double)offset, (BColor)this.stops[this.focus].getColor());
            BBrush.Stop temp = this.stops[this.focus];
            Arrays.sort(this.stops, this.sorter);
            for (int i = 0; i < this.stops.length; ++i) {
                if (this.stops[i] != temp) continue;
                this.focus = i;
            }
            this.markers = null;
            this.setModified();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String getText(String attr) {
        return lexicon.getText("gradientEditor." + attr);
    }

    class Controller
    extends BBrushSwatch.Controller {
        Controller() {
        }

        @Override
        public void mousePressed(BMouseEvent event) {
            if (BStopEditor.this.focus == -1) {
                return;
            }
            BColor c = BColorChooser.openInDialog(BStopEditor.this, BStopEditor.this.stops[BStopEditor.this.focus].getColor());
            if (c != null) {
                ((BStopEditor)BStopEditor.this).stops[((BStopEditor)BStopEditor.this).focus] = BBrush.stop((double)BStopEditor.this.stops[BStopEditor.this.focus].getOffset(), (BColor)c);
                BStopEditor.this.colorSwatch.setBrush(c.toBrush());
                BStopEditor.this.setModified();
            }
        }

        @Override
        public void mouseEntered(BMouseEvent event) {
            this.swatch.setMouseCursor(MouseCursor.dropper);
        }

        @Override
        public void mouseExited(BMouseEvent event) {
            this.swatch.setMouseCursor(MouseCursor.normal);
        }
    }

    class Sorter
    implements Comparator<BBrush.Stop> {
        Sorter() {
        }

        @Override
        public boolean equals(Object obj) {
            return false;
        }

        public int hashCode() {
            return System.identityHashCode(this);
        }

        @Override
        public int compare(BBrush.Stop o1, BBrush.Stop o2) {
            double b;
            double a = o1.getOffset();
            if (a < (b = o2.getOffset())) {
                return -1;
            }
            if (a == b) {
                return 0;
            }
            return 1;
        }
    }

    class RemoveCommand
    extends Command {
        RemoveCommand(BWidget owner) {
            super(owner, BStopEditor.getText("remove"));
        }

        public BImage getIcon() {
            return removeIcon;
        }

        public CommandArtifact doInvoke() {
            if (BStopEditor.this.focus != -1 && BStopEditor.this.stops.length > 2) {
                BStopEditor.this.removeStop(BStopEditor.this.focus);
                BStopEditor.this.focus--;
                if (BStopEditor.this.focus < 0) {
                    BStopEditor.this.focus = 0;
                }
                BStopEditor.this.updateControls();
                BStopEditor.this.setModified();
            }
            return null;
        }
    }
}

