/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.celleditors;

import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BInteger;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.workbench.celleditor.BTextFieldCE;

@NiagaraType(agent={@AgentOn(types={"baja:Integer"})})
public class BIntegerCE
extends BTextFieldCE {
    @Generated
    public static final Type TYPE = Sys.loadType(BIntegerCE.class);
    private int min = Integer.MIN_VALUE;
    private int max = Integer.MAX_VALUE;

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected void doLoadValue(BObject value, Context cx) throws Exception {
        super.doLoadValue(value, cx);
        if (cx != null) {
            BNumber maxFacet;
            BNumber minFacet = (BNumber)cx.getFacet("min");
            if (minFacet != null) {
                this.min = minFacet.getInt();
            }
            if ((maxFacet = (BNumber)cx.getFacet("max")) != null) {
                this.max = maxFacet.getInt();
            }
        }
    }

    protected String valueToString(BObject value, Context cx) {
        return value.toString();
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        int i;
        String text = this.getTextField().getText();
        if ("min".equals(text)) {
            i = Integer.MIN_VALUE;
        } else if ("max".equals(text)) {
            i = Integer.MAX_VALUE;
        } else if (text.isEmpty()) {
            i = 0;
        } else {
            try {
                i = Integer.valueOf(text);
            }
            catch (NumberFormatException e) {
                System.out.println("BIntegerCE: NumberFormatException (" + text + ')');
                return value;
            }
        }
        if (i < this.min) {
            System.out.println("BIntegerCE: CannotSaveException (" + i + " is less than " + this.min + ')');
            return value;
        }
        if (i > this.max) {
            System.out.println("BIntegerCE: CannotSaveException (" + i + " is greater than " + this.max + ')');
            return value;
        }
        return BInteger.make((int)i);
    }
}

