/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.alarm.ext.offnormal;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.baja.alarm.ext.fault.BTwoStateFaultAlgorithm;
import javax.baja.control.BStringPoint;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComponent;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="expression", type="String", defaultValue=".*"), @NiagaraProperty(name="normalOnMatch", type="boolean", defaultValue="true"), @NiagaraProperty(name="caseSensitive", type="boolean", defaultValue="true")})
public class BStringChangeOfStateFaultAlgorithm
extends BTwoStateFaultAlgorithm {
    @Generated
    public static final Property expression = BStringChangeOfStateFaultAlgorithm.newProperty((int)0, (String)".*", null);
    @Generated
    public static final Property normalOnMatch = BStringChangeOfStateFaultAlgorithm.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property caseSensitive = BStringChangeOfStateFaultAlgorithm.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BStringChangeOfStateFaultAlgorithm.class);
    protected static Logger log = Logger.getLogger("control");
    private Pattern pattern;

    @Generated
    public String getExpression() {
        return this.getString(expression);
    }

    @Generated
    public void setExpression(String v) {
        this.setString(expression, v, null);
    }

    @Generated
    public boolean getNormalOnMatch() {
        return this.getBoolean(normalOnMatch);
    }

    @Generated
    public void setNormalOnMatch(boolean v) {
        this.setBoolean(normalOnMatch, v, null);
    }

    @Generated
    public boolean getCaseSensitive() {
        return this.getBoolean(caseSensitive);
    }

    @Generated
    public void setCaseSensitive(boolean v) {
        this.setBoolean(caseSensitive, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public boolean isGrandparentLegal(BComponent grandparent) {
        return grandparent instanceof BStringPoint;
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(expression) || p.equals(caseSensitive)) {
            this.init();
        }
        this.executePoint();
    }

    @Override
    public void started() {
        this.init();
        super.started();
    }

    private void init() {
        try {
            int flags = 32;
            if (!this.getCaseSensitive()) {
                flags |= 2;
            }
            this.pattern = Pattern.compile(this.getExpression(), flags);
        }
        catch (PatternSyntaxException e) {
            log.log(Level.SEVERE, "Invalid Expression: " + this.getExpression(), e);
            this.pattern = null;
        }
    }

    @Override
    protected boolean isNormal(BStatusValue o) {
        BStatusString out = (BStatusString)o;
        if (out.getStatus().isNull() || this.pattern == null) {
            return true;
        }
        Matcher matcher = this.pattern.matcher(out.getValue());
        boolean found = matcher.find();
        return this.getNormalOnMatch() ? found : !found;
    }

    @Override
    public void writeAlarmData(BStatusValue out, Map map) {
        map.put("status", BString.make((String)out.getStatus().toString(null)));
    }
}

