/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.alarm.ext.offnormal;

import java.util.Map;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.alarm.ext.BAlarmState;
import javax.baja.alarm.ext.BLimitEnable;
import javax.baja.alarm.ext.BOffnormalAlgorithm;
import javax.baja.control.BNumericPoint;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.util.BFormat;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="setpoint", type="BStatusNumeric", defaultValue="new BStatusNumeric()"), @NiagaraProperty(name="lastValidSetpoint", type="double", defaultValue="0.0", flags=1), @NiagaraProperty(name="lowDiffLimit", type="double", defaultValue="0.0", facets={@Facet(name="BFacets.MIN", value="BDouble.make(0.0)")}), @NiagaraProperty(name="highDiffLimit", type="double", defaultValue="0.0", facets={@Facet(name="BFacets.MIN", value="BDouble.make(0.0)")}), @NiagaraProperty(name="deadband", type="double", defaultValue="0.0", facets={@Facet(name="BFacets.MIN", value="BDouble.make(0.0)")}), @NiagaraProperty(name="lowLimitText", type="BFormat", defaultValue="BFormat.DEFAULT", facets={@Facet(name="BFacets.MULTI_LINE", value="true")}), @NiagaraProperty(name="highLimitText", type="BFormat", defaultValue="BFormat.DEFAULT", facets={@Facet(name="BFacets.MULTI_LINE", value="true")}), @NiagaraProperty(name="limitEnable", type="BLimitEnable", defaultValue="new BLimitEnable()")})
public final class BFloatingLimitAlgorithm
extends BOffnormalAlgorithm {
    @Generated
    public static final Property setpoint = BFloatingLimitAlgorithm.newProperty((int)0, (BValue)new BStatusNumeric(), null);
    @Generated
    public static final Property lastValidSetpoint = BFloatingLimitAlgorithm.newProperty((int)1, (double)0.0, null);
    @Generated
    public static final Property lowDiffLimit = BFloatingLimitAlgorithm.newProperty((int)0, (double)0.0, (BFacets)BFacets.make((String)"min", (BIDataValue)BDouble.make((double)0.0)));
    @Generated
    public static final Property highDiffLimit = BFloatingLimitAlgorithm.newProperty((int)0, (double)0.0, (BFacets)BFacets.make((String)"min", (BIDataValue)BDouble.make((double)0.0)));
    @Generated
    public static final Property deadband = BFloatingLimitAlgorithm.newProperty((int)0, (double)0.0, (BFacets)BFacets.make((String)"min", (BIDataValue)BDouble.make((double)0.0)));
    @Generated
    public static final Property lowLimitText = BFloatingLimitAlgorithm.newProperty((int)0, (BValue)BFormat.DEFAULT, (BFacets)BFacets.make((String)"multiLine", (boolean)true));
    @Generated
    public static final Property highLimitText = BFloatingLimitAlgorithm.newProperty((int)0, (BValue)BFormat.DEFAULT, (BFacets)BFacets.make((String)"multiLine", (boolean)true));
    @Generated
    public static final Property limitEnable = BFloatingLimitAlgorithm.newProperty((int)0, (BValue)new BLimitEnable(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BFloatingLimitAlgorithm.class);
    private FloatingLimitState algorithmState = NORMAL_STATE;
    private static final FloatingLimitState NORMAL_STATE = new NormalState(){

        @Override
        public BAlarmState evaluate(BFloatingLimitAlgorithm algorithm, BStatusNumeric out, long toAlarmTimeDelay, long toNormalTimeDelay) {
            if (out.getStatus().isNull()) {
                return null;
            }
            double outValue = out.getValue();
            if (outValue < algorithm.getLowLimit()) {
                if (algorithm.isLowLimitEnabled()) {
                    return 1.handleLowLimit(algorithm, toAlarmTimeDelay, toNormalTimeDelay);
                }
            } else if (outValue > algorithm.getHighLimit() && algorithm.isHighLimitEnabled()) {
                return 1.handleHighLimit(algorithm, toAlarmTimeDelay, toNormalTimeDelay);
            }
            return null;
        }
    };
    private static final FloatingLimitState DELAY_TO_LOW_ALARM_STATE = new NormalState(){

        @Override
        public void enterState(BFloatingLimitAlgorithm algorithm, long toAlarmTimeDelay, long toNormalTimeDelay) {
            algorithm.startTimer(toAlarmTimeDelay);
        }

        @Override
        public BAlarmState evaluate(BFloatingLimitAlgorithm algorithm, BStatusNumeric out, long toAlarmTimeDelay, long toNormalTimeDelay) {
            if (out.getStatus().isNull()) {
                algorithm.transition(NORMAL_STATE, toAlarmTimeDelay, toNormalTimeDelay);
                return null;
            }
            double outValue = out.getValue();
            if (outValue < algorithm.getLowLimit()) {
                if (!algorithm.isLowLimitEnabled()) {
                    algorithm.transition(NORMAL_STATE, toAlarmTimeDelay, toNormalTimeDelay);
                } else if (toAlarmTimeDelay == 0L || algorithm.isTimerExpired()) {
                    algorithm.transition(LOW_ALARM_STATE, toAlarmTimeDelay, toNormalTimeDelay);
                    return BAlarmState.lowLimit;
                }
            } else {
                if (algorithm.isHighLimitEnabled() && outValue > algorithm.getHighLimit()) {
                    return 2.handleHighLimit(algorithm, toAlarmTimeDelay, toNormalTimeDelay);
                }
                algorithm.transition(NORMAL_STATE, toAlarmTimeDelay, toNormalTimeDelay);
            }
            return null;
        }
    };
    private static final FloatingLimitState DELAY_TO_HIGH_ALARM_STATE = new NormalState(){

        @Override
        public void enterState(BFloatingLimitAlgorithm algorithm, long toAlarmTimeDelay, long toNormalTimeDelay) {
            algorithm.startTimer(toAlarmTimeDelay);
        }

        @Override
        public BAlarmState evaluate(BFloatingLimitAlgorithm algorithm, BStatusNumeric out, long toAlarmTimeDelay, long toNormalTimeDelay) {
            if (out.getStatus().isNull()) {
                algorithm.transition(NORMAL_STATE, toAlarmTimeDelay, toNormalTimeDelay);
                return null;
            }
            double outValue = out.getValue();
            if (outValue > algorithm.getHighLimit()) {
                if (!algorithm.isHighLimitEnabled()) {
                    algorithm.transition(NORMAL_STATE, toAlarmTimeDelay, toNormalTimeDelay);
                } else if (toAlarmTimeDelay == 0L || algorithm.isTimerExpired()) {
                    algorithm.transition(HIGH_ALARM_STATE, toAlarmTimeDelay, toNormalTimeDelay);
                    return BAlarmState.highLimit;
                }
            } else {
                if (algorithm.isLowLimitEnabled() && outValue < algorithm.getLowLimit()) {
                    return 3.handleLowLimit(algorithm, toAlarmTimeDelay, toNormalTimeDelay);
                }
                algorithm.transition(NORMAL_STATE, toAlarmTimeDelay, toNormalTimeDelay);
            }
            return null;
        }
    };
    private static final FloatingLimitState LOW_ALARM_STATE = new LowAlarmState(){

        @Override
        public BAlarmState evaluate(BFloatingLimitAlgorithm algorithm, BStatusNumeric out, long toAlarmTimeDelay, long toNormalTimeDelay) {
            if (!algorithm.isLowLimitEnabled()) {
                algorithm.transition(NORMAL_STATE, toAlarmTimeDelay, toNormalTimeDelay);
                return BAlarmState.normal;
            }
            if (out.getStatus().isNull() || out.getValue() >= algorithm.getLowLimit() + algorithm.getDeadband()) {
                if (toNormalTimeDelay == 0L) {
                    algorithm.transition(NORMAL_STATE, toAlarmTimeDelay, 0L);
                    return BAlarmState.normal;
                }
                algorithm.transition(DELAY_FROM_LOW_ALARM_STATE, toAlarmTimeDelay, toNormalTimeDelay);
            }
            return null;
        }
    };
    private static final FloatingLimitState DELAY_FROM_LOW_ALARM_STATE = new LowAlarmState(){

        @Override
        public void enterState(BFloatingLimitAlgorithm algorithm, long toAlarmTimeDelay, long toNormalTimeDelay) {
            algorithm.startTimer(toNormalTimeDelay);
        }

        @Override
        public BAlarmState evaluate(BFloatingLimitAlgorithm algorithm, BStatusNumeric out, long toAlarmTimeDelay, long toNormalTimeDelay) {
            if (!algorithm.isLowLimitEnabled()) {
                algorithm.transition(NORMAL_STATE, toAlarmTimeDelay, toNormalTimeDelay);
                return BAlarmState.normal;
            }
            if (out.getStatus().isNull() || out.getValue() >= algorithm.getLowLimit() + algorithm.getDeadband()) {
                if (toNormalTimeDelay == 0L || algorithm.isTimerExpired()) {
                    algorithm.transition(NORMAL_STATE, toAlarmTimeDelay, toNormalTimeDelay);
                    return BAlarmState.normal;
                }
            } else {
                algorithm.transition(LOW_ALARM_STATE, toAlarmTimeDelay, toNormalTimeDelay);
            }
            return null;
        }
    };
    private static final FloatingLimitState HIGH_ALARM_STATE = new HighAlarmState(){

        @Override
        public BAlarmState evaluate(BFloatingLimitAlgorithm algorithm, BStatusNumeric out, long toAlarmTimeDelay, long toNormalTimeDelay) {
            if (!algorithm.isHighLimitEnabled()) {
                algorithm.transition(NORMAL_STATE, toAlarmTimeDelay, toNormalTimeDelay);
                return BAlarmState.normal;
            }
            if (out.getStatus().isNull() || out.getValue() <= algorithm.getHighLimit() - algorithm.getDeadband()) {
                if (toNormalTimeDelay == 0L) {
                    algorithm.transition(NORMAL_STATE, toAlarmTimeDelay, 0L);
                    return BAlarmState.normal;
                }
                algorithm.transition(DELAY_FROM_HIGH_ALARM_STATE, toAlarmTimeDelay, toNormalTimeDelay);
            }
            return null;
        }
    };
    private static final FloatingLimitState DELAY_FROM_HIGH_ALARM_STATE = new HighAlarmState(){

        @Override
        public void enterState(BFloatingLimitAlgorithm algorithm, long toAlarmTimeDelay, long toNormalTimeDelay) {
            algorithm.startTimer(toNormalTimeDelay);
        }

        @Override
        public BAlarmState evaluate(BFloatingLimitAlgorithm algorithm, BStatusNumeric out, long toAlarmTimeDelay, long toNormalTimeDelay) {
            if (!algorithm.isHighLimitEnabled()) {
                algorithm.transition(NORMAL_STATE, toAlarmTimeDelay, toNormalTimeDelay);
                return BAlarmState.normal;
            }
            if (out.getStatus().isNull() || out.getValue() <= algorithm.getHighLimit() - algorithm.getDeadband()) {
                if (toNormalTimeDelay == 0L || algorithm.isTimerExpired()) {
                    algorithm.transition(NORMAL_STATE, toAlarmTimeDelay, toNormalTimeDelay);
                    return BAlarmState.normal;
                }
            } else {
                algorithm.transition(HIGH_ALARM_STATE, toAlarmTimeDelay, toNormalTimeDelay);
            }
            return null;
        }
    };

    @Generated
    public BStatusNumeric getSetpoint() {
        return (BStatusNumeric)this.get(setpoint);
    }

    @Generated
    public void setSetpoint(BStatusNumeric v) {
        this.set(setpoint, (BValue)v, null);
    }

    @Generated
    public double getLastValidSetpoint() {
        return this.getDouble(lastValidSetpoint);
    }

    @Generated
    public void setLastValidSetpoint(double v) {
        this.setDouble(lastValidSetpoint, v, null);
    }

    @Generated
    public double getLowDiffLimit() {
        return this.getDouble(lowDiffLimit);
    }

    @Generated
    public void setLowDiffLimit(double v) {
        this.setDouble(lowDiffLimit, v, null);
    }

    @Generated
    public double getHighDiffLimit() {
        return this.getDouble(highDiffLimit);
    }

    @Generated
    public void setHighDiffLimit(double v) {
        this.setDouble(highDiffLimit, v, null);
    }

    @Generated
    public double getDeadband() {
        return this.getDouble(deadband);
    }

    @Generated
    public void setDeadband(double v) {
        this.setDouble(deadband, v, null);
    }

    @Generated
    public BFormat getLowLimitText() {
        return (BFormat)this.get(lowLimitText);
    }

    @Generated
    public void setLowLimitText(BFormat v) {
        this.set(lowLimitText, (BValue)v, null);
    }

    @Generated
    public BFormat getHighLimitText() {
        return (BFormat)this.get(highLimitText);
    }

    @Generated
    public void setHighLimitText(BFormat v) {
        this.set(highLimitText, (BValue)v, null);
    }

    @Generated
    public BLimitEnable getLimitEnable() {
        return (BLimitEnable)this.get(limitEnable);
    }

    @Generated
    public void setLimitEnable(BLimitEnable v) {
        this.set(limitEnable, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public boolean isGrandparentLegal(BComponent grandparent) {
        return grandparent instanceof BNumericPoint;
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot.equals((Object)setpoint) || slot.equals((Object)lastValidSetpoint)) {
            return this.getPointFacets();
        }
        if (slot.equals((Object)highDiffLimit) || slot.equals((Object)lowDiffLimit) || slot.equals((Object)deadband)) {
            BFacets facets = this.getPointFacets();
            BUnit unit = (BUnit)facets.getFacet("units");
            if (unit != null) {
                facets = BFacets.make((BFacets)facets, (String)"units", (BIDataValue)unit.getDifferentialUnit());
            }
            return BFacets.make((BFacets)facets, (BFacets)super.getSlotFacets(slot));
        }
        return super.getSlotFacets(slot);
    }

    public void started() {
        this.updateLastValidSetpoint();
        BAlarmState alarmState = this.getParentAlarmState();
        if (alarmState.equals((Object)BAlarmState.highLimit)) {
            this.transition(HIGH_ALARM_STATE, 0L, 0L);
        } else if (alarmState.equals((Object)BAlarmState.lowLimit)) {
            this.transition(LOW_ALARM_STATE, 0L, 0L);
        }
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(setpoint)) {
            this.updateLastValidSetpoint();
        } else {
            this.executePoint();
        }
    }

    @Override
    public BAlarmState checkAlarms(BStatusValue out, long toAlarmTimeDelay, long toNormalTimeDelay) {
        this.algorithmState.synchronizeWithAlarmState(this, this.getParentAlarmState());
        return this.algorithmState.evaluate(this, (BStatusNumeric)out, toAlarmTimeDelay, toNormalTimeDelay);
    }

    @Override
    public void writeAlarmData(BStatusValue out, Map map) {
        BFacets pointFacets = this.getPointFacets();
        BFacets diffFacets = this.getSlotFacets((Slot)deadband);
        map.put("status", BString.make((String)out.getStatus().toString(null)));
        map.put("deadband", BString.make((String)BDouble.toString((double)this.getDeadband(), (Context)diffFacets)));
        map.put("setptValue", BString.make((String)BDouble.toString((double)this.getLastValidSetpoint(), (Context)pointFacets)));
        map.put("setpointNumeric", BDouble.make((double)this.getLastValidSetpoint()));
        if (this.algorithmState == HIGH_ALARM_STATE) {
            if (!this.getHighLimitText().equals((Object)BFormat.DEFAULT)) {
                map.put("msgText", BString.make((String)this.getHighLimitText().getFormat()));
            }
            map.put("highLimit", BString.make((String)BDouble.toString((double)this.getHighLimit(), (Context)pointFacets)));
            map.put("highDiffLimit", BString.make((String)BDouble.toString((double)this.getHighDiffLimit(), (Context)diffFacets)));
            if (this.isLowLimitEnabled()) {
                map.put("lowLimit", BString.make((String)BDouble.toString((double)this.getLowLimit(), (Context)pointFacets)));
                map.put("lowDiffLimit", BString.make((String)BDouble.toString((double)this.getLowDiffLimit(), (Context)diffFacets)));
            }
        } else if (this.algorithmState == LOW_ALARM_STATE) {
            if (!this.getLowLimitText().equals((Object)BFormat.DEFAULT)) {
                map.put("msgText", BString.make((String)this.getLowLimitText().getFormat()));
            }
            if (this.isHighLimitEnabled()) {
                map.put("highLimit", BString.make((String)BDouble.toString((double)this.getHighLimit(), (Context)pointFacets)));
                map.put("highDiffLimit", BString.make((String)BDouble.toString((double)this.getHighDiffLimit(), (Context)diffFacets)));
            }
            map.put("lowLimit", BString.make((String)BDouble.toString((double)this.getLowLimit(), (Context)pointFacets)));
            map.put("lowDiffLimit", BString.make((String)BDouble.toString((double)this.getLowDiffLimit(), (Context)diffFacets)));
        }
    }

    private void transition(FloatingLimitState newState, long toAlarmTimeDelay, long toNormalTimeDelay) {
        this.cancelTimer();
        this.algorithmState = newState;
        newState.enterState(this, toAlarmTimeDelay, toNormalTimeDelay);
    }

    private BAlarmState getParentAlarmState() {
        return ((BAlarmSourceExt)this.getParent()).getAlarmState();
    }

    private double getLowLimit() {
        return this.getLastValidSetpoint() - this.getLowDiffLimit();
    }

    private double getHighLimit() {
        return this.getLastValidSetpoint() + this.getHighDiffLimit();
    }

    private boolean isLowLimitEnabled() {
        return this.getLimitEnable().getLowLimitEnable();
    }

    private boolean isHighLimitEnabled() {
        return this.getLimitEnable().getHighLimitEnable();
    }

    private void updateLastValidSetpoint() {
        BStatusNumeric setpoint = this.getSetpoint();
        if (!setpoint.getStatus().isValid()) {
            return;
        }
        double value = setpoint.getNumeric();
        if (!Double.isNaN(value) && !Double.isInfinite(value)) {
            this.setLastValidSetpoint(value);
        }
    }

    private static abstract class HighAlarmState
    extends FloatingLimitState {
        private HighAlarmState() {
        }

        @Override
        public void synchronizeWithAlarmState(BFloatingLimitAlgorithm algorithm, BAlarmState alarmState) {
            if (alarmState.equals((Object)BAlarmState.lowLimit)) {
                algorithm.transition(LOW_ALARM_STATE, 0L, 0L);
            } else if (!alarmState.equals((Object)BAlarmState.highLimit)) {
                algorithm.transition(NORMAL_STATE, 0L, 0L);
            }
        }
    }

    private static abstract class LowAlarmState
    extends FloatingLimitState {
        private LowAlarmState() {
        }

        @Override
        public void synchronizeWithAlarmState(BFloatingLimitAlgorithm algorithm, BAlarmState alarmState) {
            if (alarmState.equals((Object)BAlarmState.highLimit)) {
                algorithm.transition(HIGH_ALARM_STATE, 0L, 0L);
            } else if (!alarmState.equals((Object)BAlarmState.lowLimit)) {
                algorithm.transition(NORMAL_STATE, 0L, 0L);
            }
        }
    }

    private static abstract class NormalState
    extends FloatingLimitState {
        private NormalState() {
        }

        @Override
        public void synchronizeWithAlarmState(BFloatingLimitAlgorithm algorithm, BAlarmState alarmState) {
            if (alarmState.equals((Object)BAlarmState.highLimit)) {
                algorithm.transition(HIGH_ALARM_STATE, 0L, 0L);
            } else if (alarmState.equals((Object)BAlarmState.lowLimit)) {
                algorithm.transition(LOW_ALARM_STATE, 0L, 0L);
            }
        }

        protected static BAlarmState handleLowLimit(BFloatingLimitAlgorithm algorithm, long toAlarmTimeDelay, long toNormalTimeDelay) {
            if (toAlarmTimeDelay == 0L) {
                algorithm.transition(LOW_ALARM_STATE, 0L, toNormalTimeDelay);
                return BAlarmState.lowLimit;
            }
            algorithm.transition(DELAY_TO_LOW_ALARM_STATE, toAlarmTimeDelay, toNormalTimeDelay);
            return null;
        }

        protected static BAlarmState handleHighLimit(BFloatingLimitAlgorithm algorithm, long toAlarmTimeDelay, long toNormalTimeDelay) {
            if (toAlarmTimeDelay == 0L) {
                algorithm.transition(HIGH_ALARM_STATE, 0L, toNormalTimeDelay);
                return BAlarmState.highLimit;
            }
            algorithm.transition(DELAY_TO_HIGH_ALARM_STATE, toAlarmTimeDelay, toNormalTimeDelay);
            return null;
        }
    }

    private static abstract class FloatingLimitState {
        private FloatingLimitState() {
        }

        public abstract void synchronizeWithAlarmState(BFloatingLimitAlgorithm var1, BAlarmState var2);

        public void enterState(BFloatingLimitAlgorithm algorithm, long toAlarmTimeDelay, long toNormalTimeDelay) {
        }

        public abstract BAlarmState evaluate(BFloatingLimitAlgorithm var1, BStatusNumeric var2, long var3, long var5);
    }
}

