/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.alarm;

import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmRecipient;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.data.BIDataValue;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BLocalFileStore;
import javax.baja.file.FilePath;
import javax.baja.io.ValueDocDecoder;
import javax.baja.io.ValueDocEncoder;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BLink;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Queue;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.DEFAULT", flags=1), @NiagaraProperty(name="lastSendTime", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1, facets={@Facet(value="BFacets.make(BFacets.SHOW_MILLISECONDS, BBoolean.TRUE)")}), @NiagaraProperty(name="lastAckSendTime", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=4), @NiagaraProperty(name="lastFailureTime", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1, facets={@Facet(value="BFacets.make(BFacets.SHOW_MILLISECONDS, BBoolean.TRUE)")}), @NiagaraProperty(name="lastFailureCause", type="String", defaultValue="", flags=1), @NiagaraProperty(name="retryInterval", type="BRelTime", defaultValue="BRelTime.make(15000)", facets={@Facet(value="BFacets.make(BFacets.MIN, BRelTime.make(1000))")}), @NiagaraProperty(name="queuedAlarmCount", type="int", defaultValue="0", flags=3), @NiagaraProperty(name="persistent", type="boolean", defaultValue="true")})
@NiagaraAction(name="clearAlarmQueue")
public abstract class BRecoverableRecipient
extends BAlarmRecipient
implements BIStatus {
    @Generated
    public static final Property status = BRecoverableRecipient.newProperty((int)1, (BValue)BStatus.DEFAULT, null);
    @Generated
    public static final Property lastSendTime = BRecoverableRecipient.newProperty((int)1, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property lastAckSendTime = BRecoverableRecipient.newProperty((int)4, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property lastFailureTime = BRecoverableRecipient.newProperty((int)1, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property lastFailureCause = BRecoverableRecipient.newProperty((int)1, (String)"", null);
    @Generated
    public static final Property retryInterval = BRecoverableRecipient.newProperty((int)0, (BValue)BRelTime.make((long)15000L), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)1000L)));
    @Generated
    public static final Property queuedAlarmCount = BRecoverableRecipient.newProperty((int)3, (int)0, null);
    @Generated
    public static final Property persistent = BRecoverableRecipient.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Action clearAlarmQueue = BRecoverableRecipient.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BRecoverableRecipient.class);
    private static final BIcon icon = BIcon.std((String)"alarm.png");
    public static final Logger logger = Logger.getLogger("alarm.recoverableRecipient");
    private RetryThread retryThread;
    private final Queue q = new Queue();
    private BOrd persistenceDirectory;

    @Generated
    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    @Generated
    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    @Generated
    public BAbsTime getLastSendTime() {
        return (BAbsTime)this.get(lastSendTime);
    }

    @Generated
    public void setLastSendTime(BAbsTime v) {
        this.set(lastSendTime, (BValue)v, null);
    }

    @Generated
    public BAbsTime getLastAckSendTime() {
        return (BAbsTime)this.get(lastAckSendTime);
    }

    @Generated
    public void setLastAckSendTime(BAbsTime v) {
        this.set(lastAckSendTime, (BValue)v, null);
    }

    @Generated
    public BAbsTime getLastFailureTime() {
        return (BAbsTime)this.get(lastFailureTime);
    }

    @Generated
    public void setLastFailureTime(BAbsTime v) {
        this.set(lastFailureTime, (BValue)v, null);
    }

    @Generated
    public String getLastFailureCause() {
        return this.getString(lastFailureCause);
    }

    @Generated
    public void setLastFailureCause(String v) {
        this.setString(lastFailureCause, v, null);
    }

    @Generated
    public BRelTime getRetryInterval() {
        return (BRelTime)this.get(retryInterval);
    }

    @Generated
    public void setRetryInterval(BRelTime v) {
        this.set(retryInterval, (BValue)v, null);
    }

    @Generated
    public int getQueuedAlarmCount() {
        return this.getInt(queuedAlarmCount);
    }

    @Generated
    public void setQueuedAlarmCount(int v) {
        this.setInt(queuedAlarmCount, v, null);
    }

    @Generated
    public boolean getPersistent() {
        return this.getBoolean(persistent);
    }

    @Generated
    public void setPersistent(boolean v) {
        this.setBoolean(persistent, v, null);
    }

    @Generated
    public void clearAlarmQueue() {
        this.invoke(clearAlarmQueue, null, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        this.persistenceDirectory = BOrd.make((String)("file:^^alarm/" + this.getName() + "AlarmQueue"));
        this.retryThread = new RetryThread();
        this.retryThread.start();
    }

    public void stopped() throws Exception {
        if (this.retryThread != null) {
            this.retryThread.kill();
            this.retryThread = null;
        }
    }

    public void spy(SpyWriter out) throws Exception {
        out.startProps("RecoverableRecipient");
        out.prop((Object)"persistenceDirectory", (Object)this.persistenceDirectory);
        out.endProps();
        super.spy(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleAlarm(BAlarmRecord alarmRecord) {
        block17: {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("RecoverableRecipient: handleAlarm " + alarmRecord.getTimestamp());
            }
            try {
                boolean sucess;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("RecoverableRecipient: sending ... " + alarmRecord.getTimestamp());
                }
                if (!(sucess = this.sendAlarm(alarmRecord))) {
                    return;
                }
                this.setLastSendTime(BAbsTime.make());
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("RecoverableRecipient: sent @ " + this.getLastSendTime());
                }
                this.setStatus(BStatus.ok);
            }
            catch (Exception e) {
                this.setStatus(BStatus.fault);
                this.setLastFailureTime(BAbsTime.make());
                if (e instanceof BajaRuntimeException) {
                    this.setLastFailureCause(e.getCause().toString());
                } else {
                    this.setLastFailureCause(e.toString());
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("RecoverableRecipient: failed @ " + this.getLastFailureTime() + " -> " + this.getLastFailureCause());
                }
                if (this.getPersistent()) {
                    try {
                        File file;
                        BRecoverableRecipient bRecoverableRecipient = this;
                        synchronized (bRecoverableRecipient) {
                            file = new File(this.dirFile(), alarmRecord.getUuid().toString() + ".xml");
                        }
                        File f = file;
                        AccessController.doPrivileged(() -> {
                            try (ValueDocEncoder encoder = new ValueDocEncoder(f);){
                                encoder.encodeDocument((BValue)alarmRecord);
                            }
                            return null;
                        });
                        this.setQueuedAlarmCount(AccessController.doPrivileged(() -> this.dirFile().listFiles().length));
                    }
                    catch (IOException | PrivilegedActionException f) {
                        Throwable t = f;
                        if (f instanceof PrivilegedActionException) {
                            t = f.getCause();
                        }
                        logger.log(Level.WARNING, "RecoverableRecipient: failed to persist alarm " + alarmRecord.getUuid(), logger.isLoggable(Level.FINE) ? t : null);
                    }
                } else {
                    this.q.enqueue((Object)alarmRecord);
                    this.setQueuedAlarmCount(this.q.size());
                }
                if (this.retryThread != null) break block17;
                this.retryThread = new RetryThread();
                this.retryThread.start();
            }
        }
    }

    public void doClearAlarmQueue() {
        if (this.getPersistent() && this.getQueuedAlarmCount() > 0) {
            try {
                File[] kids;
                File dir = this.dirFile();
                for (File kid : kids = AccessController.doPrivileged(() -> dir.listFiles())) {
                    boolean deleted = AccessController.doPrivileged(() -> kid.delete());
                    if (!deleted && logger.isLoggable(Level.FINE)) {
                        logger.fine("RecoverableRecipient: Failed to delete queue file " + kid.getName() + " during clear");
                    }
                    this.setQueuedAlarmCount(this.getQueuedAlarmCount() - 1);
                }
            }
            catch (Exception e) {
                return;
            }
            this.setQueuedAlarmCount(0);
        } else {
            this.q.clear();
            this.setQueuedAlarmCount(0);
        }
    }

    private File dirFile() throws IOException {
        BFileSystem fs = BFileSystem.INSTANCE;
        FilePath path = (FilePath)this.persistenceDirectory.parse()[0];
        try {
            BDirectory bdir = AccessController.doPrivileged(() -> fs.makeDir(path));
            return ((BLocalFileStore)bdir.getStore()).getLocalFile();
        }
        catch (SecurityException | PrivilegedActionException e) {
            Throwable rootException = e.getCause();
            if (rootException instanceof IOException) {
                throw (IOException)rootException;
            }
            throw new IOException(rootException);
        }
    }

    protected abstract boolean sendAlarm(BAlarmRecord var1) throws Exception;

    @Override
    public BIcon getIcon() {
        return icon;
    }

    @Override
    public String[] getSubscribedAlarmClasses() {
        ArrayList<String> classes = new ArrayList<String>();
        try {
            SlotCursor c = this.getProperties();
            while (c.next(BLink.class)) {
                BLink link = (BLink)c.get();
                if (!(link.getSourceComponent() instanceof BAlarmClass)) continue;
                classes.add(link.getSourceComponent().getName());
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return classes.toArray(new String[0]);
    }

    private class RetryThread
    extends Thread {
        private boolean alive;

        public RetryThread() {
            super("alarm:RecipRetryThread");
        }

        void kill() {
            this.alive = false;
            this.interrupt();
        }

        @Override
        public void run() {
            this.alive = true;
            while (this.alive) {
                try {
                    RetryThread.sleep(Math.max(BRecoverableRecipient.this.getRetryInterval().getMillis(), 1000L));
                }
                catch (InterruptedException e) {
                    this.alive = false;
                    break;
                }
                try {
                    this.poll();
                }
                catch (Exception e) {
                    logger.log(Level.FINE, "RecoverableRecipient: poll failed", e);
                }
            }
        }

        private void poll() {
            try {
                if (BRecoverableRecipient.this.getPersistent() && BRecoverableRecipient.this.getQueuedAlarmCount() > 0) {
                    this.dequeueDisk();
                } else {
                    this.dequeueMemory();
                }
            }
            catch (Exception e) {
                logger.log(Level.FINE, "RecoverableRecipient: poll failed", e);
            }
            if (BRecoverableRecipient.this.getQueuedAlarmCount() == 0) {
                BRecoverableRecipient.this.retryThread.kill();
                BRecoverableRecipient.this.retryThread = null;
            }
        }

        private void dequeueMemory() throws Exception {
            int size = BRecoverableRecipient.this.q.size();
            for (int i = 0; i < size; ++i) {
                try {
                    BRecoverableRecipient.this.handleAlarm((BAlarmRecord)((Object)BRecoverableRecipient.this.q.dequeue()));
                    continue;
                }
                finally {
                    BRecoverableRecipient.this.setQueuedAlarmCount(BRecoverableRecipient.this.q.size());
                }
            }
        }

        private void dequeueDisk() throws Exception {
            File dir = BRecoverableRecipient.this.dirFile();
            File[] kids = AccessController.doPrivileged(() -> dir.listFiles());
            Arrays.sort(kids, (o1, o2) -> {
                File f1 = o1;
                File f2 = o2;
                return AccessController.doPrivileged(() -> (int)(f1.lastModified() - f2.lastModified()));
            });
            try {
                for (File kid : kids) {
                    BAlarmRecord alarm = AccessController.doPrivileged(() -> {
                        try (ValueDocDecoder decoder = new ValueDocDecoder(kid);){
                            BAlarmRecord bAlarmRecord = (BAlarmRecord)decoder.decodeDocument();
                            return bAlarmRecord;
                        }
                    });
                    boolean deleted = AccessController.doPrivileged(() -> kid.delete());
                    if (!deleted && logger.isLoggable(Level.FINE)) {
                        logger.fine("RecoverableRecipient: Failed to delete queue file " + kid.getName() + " after dequeue");
                    }
                    BRecoverableRecipient.this.handleAlarm(alarm);
                }
                BRecoverableRecipient.this.setQueuedAlarmCount(AccessController.doPrivileged(() -> dir.listFiles().length));
            }
            catch (Exception e) {
                logger.log(Level.FINE, "RecoverableRecipient: Dequeue from disk failed", e);
            }
        }

        public boolean isRunning() {
            return this.alive;
        }
    }
}

