/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.alarm;

import com.tridium.alarm.db.BAckPendingAlarmTable;
import com.tridium.alarm.db.BAlarmDbQueryResult;
import com.tridium.alarm.db.BOpenAlarmTable;
import java.io.IOException;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.AgentList;
import javax.baja.alarm.AlarmDbConnection;
import javax.baja.alarm.AlarmException;
import javax.baja.alarm.AlarmSpaceConnection;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmArchive;
import javax.baja.alarm.BAlarmDbConfig;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BIAlarmSpace;
import javax.baja.alarm.BSourceState;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.bql.BIRelational;
import javax.baja.bql.BqlQuery;
import javax.baja.bql.Queryable;
import javax.baja.category.BCategoryMask;
import javax.baja.category.BCategoryService;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.space.BSpace;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;
import javax.baja.util.LexiconText;

@NiagaraType
public abstract class BAlarmDatabase
extends BSpace
implements Queryable,
BIRelational,
BIProtected,
BIAlarmSpace {
    @Generated
    public static final Type TYPE = Sys.loadType(BAlarmDatabase.class);
    private static final BIcon icon = BIcon.std((String)"alarm.png");
    private static BOrd ordInSession = BOrd.make((String)"alarm:");
    public static final Logger log = Logger.getLogger("alarm.database");
    private boolean open;
    private static final BOrd ALARM_SERVICE_ORD = BOrd.make((String)"service:alarm:AlarmService");
    private BAlarmService cachedAlarmService;

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BAlarmDatabase() {
        super("alarm", LexiconText.make((String)"alarm", (String)"space.alarm"));
    }

    protected BAlarmDatabase(String name, LexiconText lexiconText) {
        super(name, lexiconText);
    }

    @Override
    public AlarmSpaceConnection getConnection(Context cx) {
        return this.getDbConnection(cx);
    }

    public abstract AlarmDbConnection getDbConnection(Context var1);

    public final synchronized void open() throws IOException {
        this.doOpen();
        this.open = true;
    }

    protected void doOpen() throws IOException {
    }

    public boolean isOpen() {
        return this.open;
    }

    public final synchronized void save() throws IOException {
        if (!this.isOpen()) {
            return;
        }
        this.flush();
        this.doSave();
    }

    protected void doSave() throws IOException {
    }

    public final synchronized void flush() throws IOException {
        if (!this.isOpen()) {
            return;
        }
        this.doFlush();
    }

    protected void doFlush() throws IOException {
    }

    protected synchronized void assertOpen() {
        if (!this.isOpen()) {
            throw new AlarmException("Operation not allowed while database is closed.");
        }
    }

    public final synchronized void close() {
        if (!this.isOpen()) {
            return;
        }
        try {
            this.doClose();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Cannot close alarm database.", e);
        }
        this.open = false;
    }

    protected void doClose() {
    }

    public abstract void updateConfig(BAlarmDbConfig var1, Property var2) throws AlarmException;

    public void toNormal(BAlarmRecord normalRecord) {
        BOrdList list;
        BObject obj;
        BAlarmRecord last;
        BAlarmService alarmService;
        block24: {
            if (log.isLoggable(Level.FINE) && Thread.currentThread().getName().equals("Nre:Engine")) {
                try {
                    throw new AlarmException("BAlarmDatabase.toNormal called from Nre:Engine Thread");
                }
                catch (AlarmException ae) {
                    log.log(Level.FINE, "Potential Performance Degradation", (Throwable)((Object)ae));
                }
            }
            alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
            last = null;
            StringBuilder queryStr = new StringBuilder("alarm:|bql:select * from openAlarms where ");
            queryStr.append("source = OrdList '");
            queryStr.append(SlotPath.escape((String)normalRecord.getSource().encodeToString()));
            queryStr.append("' and sourceState != alarm:SourceState.normal and sourceState != alarm:SourceState.alert");
            BOrd query = BOrd.make((String)queryStr.toString());
            try (TableCursor result = ((BITable)query.resolve((BObject)alarmService).get()).cursor();){
                if (!result.next()) break block24;
                do {
                    BAlarmRecord record;
                    if ((record = (BAlarmRecord)((BValue)result.get()).newCopy(true)).getSourceState() == BSourceState.alert) continue;
                    record.setSource(normalRecord.getSource());
                    record.setAlarmClass(normalRecord.getAlarmClass());
                    record.setNormalTime(Clock.time());
                    record.setSourceState(BSourceState.normal);
                    record.setAckRequired(record.getAckRequired() || normalRecord.getAckRequired());
                    record.setAlarmData(BFacets.make((BFacets)record.getAlarmData(), (BFacets)normalRecord.getAlarmData()));
                    if (normalRecord.getAckRequired()) {
                        record.setAckState(BAckState.unacked);
                    }
                    try {
                        alarmService.doRouteAlarm(record);
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, "Unable to route alarm", e);
                    }
                    last = record;
                } while (result.next());
            }
        }
        if (last == null) {
            BAlarmRecord record = new BAlarmRecord(BUuid.make());
            if (normalRecord.getAckRequired()) {
                record.setAckState(BAckState.unacked);
            }
            record.setSource(normalRecord.getSource());
            record.setAlarmClass(normalRecord.getAlarmClass());
            record.setNormalTime(Clock.time());
            record.setSourceState(BSourceState.normal);
            record.setAckRequired(normalRecord.getAckRequired());
            record.setAlarmData(normalRecord.getAlarmData());
            try {
                alarmService.doRouteAlarm(record);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Unable to route alarm", e);
            }
            last = record;
        }
        if ((obj = (list = normalRecord.getSource()).get(0).resolve().get()) instanceof BAlarmSourceExt) {
            BAlarmSourceExt ext = (BAlarmSourceExt)obj;
            ext.fireToNormal(last);
        }
    }

    public BObject bqlQuery(OrdTarget base, OrdQuery query) {
        if (log.isLoggable(Level.FINE) && Thread.currentThread().getName().equals("Nre:Engine")) {
            try {
                throw new AlarmException("BAlarmDatabase.bqlQuery called from Nre;Engine Thread");
            }
            catch (AlarmException ae) {
                log.log(Level.FINE, "Potential Performance Degradation", (Throwable)((Object)ae));
            }
        }
        return new BAlarmDbQueryResult(this, (BqlQuery)query);
    }

    public BITable getRelation(String id, Context cx) {
        if (id.equals("openAlarms")) {
            return new BOpenAlarmTable(this);
        }
        if (id.equals("ackPendingAlarms")) {
            return new BAckPendingAlarmTable(this);
        }
        return null;
    }

    protected BAlarmService getAlarmService() {
        if (this.cachedAlarmService == null || this.cachedAlarmService.getComponentSpace() == null) {
            this.cachedAlarmService = (BAlarmService)ALARM_SERVICE_ORD.get((BObject)this);
        }
        return this.cachedAlarmService;
    }

    public BOrd getOrdInSession() {
        return ordInSession;
    }

    public boolean hasNavChildren() {
        return this.getAlarmArchive().isPresent();
    }

    protected Optional<BAlarmArchive> getAlarmArchive() {
        return this.getAlarmService().getAlarmArchive();
    }

    public BINavNode[] getNavChildren() {
        Optional<BAlarmArchive> archive = this.getAlarmArchive();
        if (archive.isPresent()) {
            return new BINavNode[]{(BINavNode)archive.get()};
        }
        return new BINavNode[0];
    }

    public BINavNode getNavChild(String navName) {
        Optional<BAlarmArchive> archive;
        if (navName.equalsIgnoreCase("alarmArchive") && (archive = this.getAlarmArchive()).isPresent()) {
            return (BINavNode)archive.get();
        }
        return null;
    }

    public BCategoryMask getCategoryMask() {
        return BCategoryService.getService().getCategoryMask(this.getOrdInSession());
    }

    public BCategoryMask getAppliedCategoryMask() {
        return BCategoryService.getService().getAppliedCategoryMask(this.getOrdInSession());
    }

    public BPermissions getPermissions(Context cx) {
        if (cx != null && cx.getUser() != null) {
            return cx.getUser().getPermissionsFor((BIProtected)this);
        }
        return BPermissions.all;
    }

    public boolean canRead(OrdTarget cx) {
        return cx.getPermissionsForTarget().hasOperatorRead();
    }

    public boolean canWrite(OrdTarget cx) {
        return cx.getPermissionsForTarget().hasAdminWrite();
    }

    public boolean canInvoke(OrdTarget cx) {
        return false;
    }

    public BIcon getIcon() {
        return icon;
    }

    public AgentList getAgents(Context cx) {
        return BAlarmDatabase.filterAgents(super.getAgents(cx));
    }

    public static AgentList filterAgents(AgentList list) {
        int uxDb;
        int db = list.indexOf("alarm:AlarmDbMaintenance");
        if (db > -1 && (uxDb = list.indexOf("alarm:DatabaseMaintenance")) > -1) {
            list.add(db, "alarm:DatabaseMaintenance");
        }
        return list;
    }
}

