/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.fox;

import com.tridium.alarm.AlarmUtil;
import com.tridium.alarm.db.AlarmQuery;
import com.tridium.alarm.db.BIAlarmResolver;
import com.tridium.alarm.fox.BFoxAlarmArchive;
import com.tridium.alarm.fox.BFoxAlarmDatabase;
import com.tridium.fox.sys.BFoxSession;
import java.util.Optional;
import javax.baja.agent.BIAgent;
import javax.baja.alarm.BAlarmArchive;
import javax.baja.naming.BISession;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.BSingleton;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"fox:FoxSession"})})
@NiagaraSingleton
public class BFoxAlarmResolver
extends BSingleton
implements BIAlarmResolver,
BIAgent {
    @Generated
    public static final BFoxAlarmResolver INSTANCE = new BFoxAlarmResolver();
    @Generated
    public static final Type TYPE = Sys.loadType(BFoxAlarmResolver.class);

    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public OrdTarget resolve(BISession session, OrdTarget base, AlarmQuery query) {
        BFoxSession foxSession = (BFoxSession)session;
        BFoxAlarmDatabase foxAlarmDb = new BFoxAlarmDatabase(foxSession);
        boolean archiveQuery = query != null && query.getBody() != null && query.getBody().startsWith("archive");
        try {
            if (archiveQuery) {
                Optional<BAlarmArchive> foxAlarmArchive = foxAlarmDb.getAlarmArchive();
                if (!foxAlarmArchive.isPresent()) {
                    throw new UnresolvedException("Alarm archive is not present");
                }
                String queryBody = query.getBody().replace("archive", "");
                if (queryBody.isEmpty()) {
                    return new OrdTarget(base, (BObject)new BFoxAlarmArchive(foxSession));
                }
                query = new AlarmQuery(query.getBody().substring("archive".length() + 1));
                return AlarmUtil.resolveUuidQuery(base, query, foxAlarmArchive.get());
            }
            if (query.isDbQuery()) {
                return new OrdTarget(base, (BObject)new BFoxAlarmDatabase(foxSession));
            }
            return AlarmUtil.resolveUuidQuery(base, query, foxAlarmDb);
        }
        catch (Exception e) {
            StringBuilder message = new StringBuilder("Cannot access alarm ");
            message.append(archiveQuery ? "archive" : "database");
            throw new UnresolvedException(message.toString(), (Throwable)e);
        }
    }
}

