/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.fox;

import com.tridium.alarm.AlarmColumnSpec;
import com.tridium.alarm.AlarmInput;
import com.tridium.alarm.AlarmInputCursor;
import com.tridium.alarm.AlarmOutput;
import com.tridium.alarm.BAlarmInputTable;
import com.tridium.alarm.db.BAlarmDbQueryResult;
import com.tridium.alarm.fox.BFoxAlarmArchive;
import com.tridium.alarm.fox.FoxAlarmCodec;
import com.tridium.data.BToDataTable;
import com.tridium.data.DataTableDecoder;
import com.tridium.data.DataTableEncoder;
import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.FoxCircuit;
import com.tridium.fox.session.FoxRequest;
import com.tridium.fox.session.FoxResponse;
import com.tridium.fox.session.InvalidCommandException;
import com.tridium.fox.sys.BFoxChannel;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.util.HashMap;
import java.util.Optional;
import javax.baja.alarm.AlarmDbConnection;
import javax.baja.alarm.AlarmException;
import javax.baja.alarm.BAlarmArchive;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmDatabase;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.bql.BqlQuery;
import javax.baja.collection.AbstractCursor;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.data.BIDataTable;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.util.BUuid;
import javax.baja.util.Version;

@NiagaraType
public class BAlarmDbChannel
extends BFoxChannel {
    @Generated
    public static final Type TYPE = Sys.loadType(BAlarmDbChannel.class);
    private Version serverVersion;
    public static final Version VER_4_11 = new Version("4.11");
    private BAlarmDatabase db;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BAlarmDbChannel() {
        super("alarmdb");
    }

    protected BAlarmDbChannel(String name) {
        super(name);
    }

    public BAlarmDatabase getAlarmDb() {
        if (this.db == null) {
            BAlarmService service = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
            this.db = service.getAlarmDb();
        }
        return this.db;
    }

    public FoxResponse process(FoxRequest request) throws Exception {
        String command = request.command;
        if (command == "append") {
            return this.append(request);
        }
        if (command == "update") {
            return this.update(request);
        }
        if (command == "getRecordCount") {
            return this.getRecordCount(request);
        }
        if (command == "getRecord") {
            return this.getRecord(request);
        }
        if (command == "clearAll") {
            return this.clearAllRecords(request);
        }
        if (command == "clearOld") {
            return this.clearOldRecords(request);
        }
        if (command == "getVersion") {
            return this.getVersion(request);
        }
        if (command == "getPermissions") {
            return this.getPermissions(request);
        }
        if (command == "getArchive") {
            return this.getArchive(request);
        }
        throw new InvalidCommandException(command);
    }

    public void circuitOpened(FoxCircuit circuit) throws Exception {
        String command = circuit.command;
        if (command == "resolve") {
            this.resolve(circuit);
            return;
        }
        if (command == "resolve34") {
            this.resolve34(circuit);
            return;
        }
        if (command == "scan") {
            this.scan(circuit);
            return;
        }
        if (command == "timeQuery") {
            this.timeQuery(circuit);
            return;
        }
        if (command == "bqlQuery") {
            this.bqlQuery(circuit);
            return;
        }
        throw new InvalidCommandException(command);
    }

    public Version checkVersion() {
        if (this.serverVersion == null) {
            try {
                this.serverVersion = this.getVersion();
            }
            catch (Exception ex) {
                this.serverVersion = Version.ZERO;
            }
        }
        return this.serverVersion;
    }

    public Version getVersion() throws Exception {
        FoxRequest req = this.makeRequest("getVersion");
        FoxResponse resp = this.sendSync(req);
        return new Version(resp.getString("version", ""));
    }

    public FoxResponse getVersion(FoxRequest req) throws Exception {
        BAlarmService as = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        FoxResponse resp = new FoxResponse(req);
        resp.add("version", TYPE.getVendorVersion().toString());
        return resp;
    }

    public BPermissions getPermissions() throws Exception {
        FoxRequest req = this.makeRequest("getPermissions");
        FoxResponse resp = this.sendSync(req);
        return BPermissions.make((String)resp.getString("permissions", ""));
    }

    public FoxResponse getPermissions(FoxRequest req) throws Exception {
        FoxResponse resp = new FoxResponse(req);
        resp.add("permissions", this.getAlarmDb().getPermissions(this.getSessionContext()).toString());
        return resp;
    }

    public void append(BAlarmRecord rec) throws Exception {
        FoxRequest req = this.makeRequest("append");
        req.add("rec", FoxAlarmCodec.encodeAlarm(rec));
        this.sendSync(req);
    }

    private FoxResponse append(FoxRequest req) throws Exception {
        BAlarmRecord alarm = FoxAlarmCodec.decodeAlarm(req.getMessage("rec"));
        BAlarmService as = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        BUser user = this.getSessionContext().getUser();
        BAlarmClass alarmClass = as.lookupAlarmClass(alarm.getAlarmClass());
        if (alarmClass == null) {
            alarmClass = as.getDefaultAlarmClass();
        }
        user.check((BIProtected)alarmClass, BPermissions.operatorWrite);
        try (AlarmDbConnection conn = this.getAlarmDb().getDbConnection(null);){
            conn.append(alarm);
        }
        return null;
    }

    public void update(BAlarmRecord rec) throws Exception {
        FoxRequest req = this.makeRequest("update");
        req.add("rec", FoxAlarmCodec.encodeAlarm(rec));
        this.sendSync(req);
    }

    private FoxResponse update(FoxRequest req) throws Exception {
        BAlarmRecord alarm = FoxAlarmCodec.decodeAlarm(req.getMessage("rec"));
        BAlarmService as = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        BUser user = this.getSessionContext().getUser();
        BAlarmClass alarmClass = as.lookupAlarmClass(alarm.getAlarmClass());
        if (alarmClass == null) {
            alarmClass = as.getDefaultAlarmClass();
        }
        user.check((BIProtected)alarmClass, BPermissions.operatorWrite);
        try (AlarmDbConnection conn = this.getAlarmDb().getDbConnection(null);){
            conn.update(alarm);
        }
        return null;
    }

    public int getRecordCount() throws Exception {
        FoxRequest req = this.makeRequest("getRecordCount");
        FoxResponse resp = this.sendSync(req);
        return resp.getInt("count");
    }

    private FoxResponse getRecordCount(FoxRequest req) throws Exception {
        FoxResponse resp = new FoxResponse(req);
        try (AlarmDbConnection conn = this.getAlarmDb().getDbConnection(null);){
            resp.add("count", conn.getRecordCount());
        }
        return resp;
    }

    public BAlarmRecord getRecord(BUuid uuid) throws Exception {
        FoxRequest req = this.makeRequest("getRecord");
        req.add("uuid", uuid.encodeToString());
        FoxResponse resp = this.sendSync(req);
        return FoxAlarmCodec.decodeAlarm(resp.getMessage("rec"));
    }

    private FoxResponse getRecord(FoxRequest req) throws Exception {
        BUser user = this.getSessionContext().getUser();
        BUuid uuid = (BUuid)BUuid.DEFAULT.decodeFromString(req.getString("uuid"));
        BAlarmService as = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        BAlarmRecord alarm = null;
        try (AlarmDbConnection conn = this.getAlarmDb().getDbConnection(null);){
            alarm = conn.getRecord(uuid);
        }
        if (alarm == null) {
            throw new AlarmException("Alarm " + uuid + " not found.");
        }
        BAlarmClass alarmClass = as.lookupAlarmClass(alarm.getAlarmClass());
        if (alarmClass == null) {
            alarmClass = as.getDefaultAlarmClass();
        }
        user.check((BIProtected)alarmClass, BPermissions.operatorRead);
        FoxResponse resp = new FoxResponse(req);
        resp.add("rec", FoxAlarmCodec.encodeAlarm(alarm));
        return resp;
    }

    public Optional<BAlarmArchive> getArchive() throws Exception {
        FoxResponse resp;
        if (this.getConnection().getRemoteVersion().compareTo(VER_4_11) >= 0 && (resp = this.sendSync(this.makeRequest("getArchive"))).getBoolean("hasArchive")) {
            return Optional.of(new BFoxAlarmArchive(this.getFoxSession()));
        }
        return Optional.empty();
    }

    private FoxResponse getArchive(FoxRequest req) throws Exception {
        FoxResponse resp = new FoxResponse(req);
        BAlarmService as = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        Optional<BAlarmArchive> alarmArchive = as.getAlarmArchive();
        resp.add("hasArchive", alarmArchive.isPresent() && alarmArchive.get().getPermissions(this.getSessionContext()).hasOperatorRead());
        return resp;
    }

    public void clearAllRecords() throws Exception {
        this.sendAsync(this.makeRequest("clearAll"));
    }

    private FoxResponse clearAllRecords(FoxRequest req) throws Exception {
        try (AlarmDbConnection conn = this.getAlarmDb().getDbConnection(null);){
            conn.clearAllRecords(this.getSessionContext());
        }
        return null;
    }

    public void clearOldRecords(BAbsTime before) throws Exception {
        FoxRequest req = this.makeRequest("clearOld");
        req.add("before", before.getMillis());
        this.sendAsync(req);
    }

    private FoxResponse clearOldRecords(FoxRequest req) throws Exception {
        BAbsTime t = BAbsTime.make((long)req.getTime("before"));
        try (AlarmDbConnection conn = this.getAlarmDb().getDbConnection(null);){
            conn.clearOldRecords(t, this.getSessionContext());
        }
        return null;
    }

    public void clearRecord(BUuid uuid) throws Exception {
        FoxRequest req = this.makeRequest("clear");
        req.add("uuid", uuid.encodeToString());
        this.sendAsync(req);
    }

    private FoxResponse clearRecord(FoxRequest req) throws Exception {
        BUuid uuid = (BUuid)BUuid.DEFAULT.decodeFromString(req.getString("uuid"));
        try (AlarmDbConnection conn = this.getAlarmDb().getDbConnection(null);){
            conn.clearRecord(uuid, this.getSessionContext());
        }
        return null;
    }

    public Cursor<BAlarmRecord> scan() throws Exception {
        FoxCircuit circuit = this.openCircuit("scan");
        AlarmInput alarmIn = new AlarmInput(new DataInputStream(circuit.getInputStream()));
        return new AlarmInputCursor(alarmIn, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scan(FoxCircuit circuit) throws Exception {
        try {
            BAlarmService service = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
            try (AlarmDbConnection conn = this.getAlarmDb().getDbConnection(null);
                 AlarmSecurityCursor result = new AlarmSecurityCursor(conn.scan(), service, BPermissions.operatorRead, this.getSessionContext());){
                DataOutputStream dOut = new DataOutputStream(circuit.getOutputStream());
                AlarmOutput out = new AlarmOutput(null, dOut);
                while (result.next()) {
                    out.write((BAlarmRecord)((Object)result.get()));
                }
                out.flush();
                out.close();
            }
        }
        finally {
            circuit.close();
        }
    }

    public Cursor<BAlarmRecord> timeQuery(BAbsTime startTime, BAbsTime endTime) throws Exception {
        FoxCircuit circuit = this.openCircuit("timeQuery");
        FoxMessage query = new FoxMessage();
        if (startTime != null && !startTime.isNull()) {
            query.add("startTime", startTime.getMillis());
        }
        if (endTime != null && !endTime.isNull()) {
            query.add("endTime", endTime.getMillis());
        }
        circuit.writeMessage(query);
        circuit.flush();
        AlarmInput alarmIn = new AlarmInput(new DataInputStream(circuit.getInputStream()));
        return new AlarmInputCursor(alarmIn, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timeQuery(FoxCircuit circuit) throws Exception {
        try {
            BAlarmService service = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
            FoxMessage query = circuit.readMessage();
            BAbsTime startTime = null;
            BAbsTime endTime = null;
            long millis = query.getTime("startTime", -1L);
            if (millis != -1L) {
                startTime = BAbsTime.make((long)millis);
            }
            if ((millis = query.getTime("endTime", -1L)) != -1L) {
                endTime = BAbsTime.make((long)millis);
            }
            try (AlarmDbConnection conn = this.getAlarmDb().getDbConnection(null);
                 Cursor<BAlarmRecord> cursor = conn.timeQuery(startTime, endTime);
                 AlarmSecurityCursor result = new AlarmSecurityCursor(cursor, service, BPermissions.operatorRead, this.getSessionContext());){
                DataOutputStream dOut = new DataOutputStream(circuit.getOutputStream());
                AlarmOutput out = new AlarmOutput(null, dOut);
                while (result.next()) {
                    out.write((BAlarmRecord)((Object)result.get()));
                }
                out.flush();
                out.close();
            }
        }
        finally {
            circuit.close();
        }
    }

    public Cursor<BAlarmRecord> bqlQuery(BqlQuery bql) throws Exception {
        Version stationVer = this.getVersion();
        if (stationVer.compareTo(new Version("3.4.23")) < 0) {
            throw new AlarmException("Incompatible Version: " + stationVer + " < 3.4.23");
        }
        FoxCircuit circuit = this.openCircuit("bqlQuery");
        FoxMessage query = new FoxMessage();
        if (bql != null) {
            query.add("bql", bql.getBody());
        }
        circuit.writeMessage(query);
        circuit.flush();
        AlarmInput alarmIn = new AlarmInput(new DataInputStream(circuit.getInputStream()));
        return new AlarmInputCursor(alarmIn, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bqlQuery(FoxCircuit circuit) throws Exception {
        try {
            BAlarmService service = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
            FoxMessage query = circuit.readMessage();
            BqlQuery bql = BqlQuery.make((String)query.getString("bql", ""));
            try (AlarmSecurityCursor result = new AlarmSecurityCursor((Cursor<BAlarmRecord>)((BAlarmDbQueryResult)this.getAlarmDb().bqlQuery(null, (OrdQuery)bql)).cursor(), service, BPermissions.operatorRead, this.getSessionContext());){
                DataOutputStream dOut = new DataOutputStream(circuit.getOutputStream());
                AlarmOutput out = new AlarmOutput(null, dOut);
                while (result.next()) {
                    out.write((BAlarmRecord)((Object)result.get()));
                }
                out.flush();
                out.close();
            }
        }
        finally {
            circuit.close();
        }
    }

    public BObject resolve(BOrd ord) throws Exception {
        Version serverVersion = this.checkVersion();
        boolean useResolve34 = false;
        useResolve34 = serverVersion.major() == 3 ? serverVersion.minor() >= 4 : serverVersion.major() >= 4;
        if (useResolve34) {
            ord = ord.relativizeToSession();
            FoxCircuit circuit = this.openCircuit("resolve34");
            FoxMessage query = new FoxMessage();
            query.add("ord", ord.toString());
            circuit.writeMessage(query);
            circuit.flush();
            FoxMessage resp = circuit.readMessage();
            String resultType = resp.getString("resultType", null);
            if (resultType.equals("records")) {
                DataInputStream in = new DataInputStream(circuit.getInputStream());
                AlarmColumnSpec[] projection = this.readColumns(in);
                AlarmInput alarmIn = new AlarmInput(in);
                return new BAlarmInputTable(projection, alarmIn);
            }
            if (resultType.equals("table")) {
                BIDataTable result = DataTableDecoder.decode((DataInput)new DataInputStream(circuit.getInputStream()));
                circuit.close();
                return (BObject)result;
            }
            throw new UnsupportedOperationException("Unsupported result type: " + resultType);
        }
        ord = ord.relativizeToSession();
        FoxCircuit circuit = this.openCircuit("resolve");
        FoxMessage query = new FoxMessage();
        query.add("ord", ord.toString());
        circuit.writeMessage(query);
        circuit.flush();
        DataInputStream in = new DataInputStream(circuit.getInputStream());
        AlarmInput alarmIn = new AlarmInput(in);
        return new BAlarmInputTable(null, alarmIn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolve(FoxCircuit circuit) throws Exception {
        block18: {
            BAlarmService service = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
            try {
                FoxMessage query = circuit.readMessage();
                BOrd ord = BOrd.make((String)query.getString("ord"));
                BObject result = ord.resolve((BObject)this).get();
                DataOutputStream dOut = new DataOutputStream(circuit.getOutputStream());
                if (result instanceof BITable) {
                    BITable table = (BITable)result;
                    AlarmOutput out = new AlarmOutput((BITable<BAlarmRecord>)table, dOut);
                    try (AlarmSecurityCursor c = new AlarmSecurityCursor((Cursor<BAlarmRecord>)table.cursor(), service, BPermissions.operatorRead, this.getSessionContext());){
                        while (c.next()) {
                            out.write((BAlarmRecord)((Object)c.get()));
                        }
                    }
                    out.flush();
                    out.close();
                    break block18;
                }
                throw new IllegalStateException("Unsupported result type: " + result.getClass().getName());
            }
            finally {
                circuit.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolve34(FoxCircuit circuit) throws Exception {
        block20: {
            BAlarmService service = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
            try {
                FoxMessage query = circuit.readMessage();
                FoxMessage resp = new FoxMessage("resp");
                BOrd ord = BOrd.make((String)query.getString("ord"));
                BObject result = ord.resolve((BObject)this).get();
                resp.add("resolved", true);
                DataOutputStream dOut = new DataOutputStream(circuit.getOutputStream());
                if (result instanceof BITable) {
                    BITable table = (BITable)result;
                    ColumnList columns = table.getColumns();
                    boolean sendRecords = true;
                    BAlarmRecord proto = new BAlarmRecord(BUuid.make());
                    for (int i = 0; i < columns.size(); ++i) {
                        Column col = columns.get(i);
                        if (proto.getProperty(col.getName()) != null) continue;
                        sendRecords = false;
                        break;
                    }
                    if (sendRecords) {
                        resp.add("resultType", "records");
                        circuit.writeMessage(resp);
                        circuit.flush();
                        this.writeColumns((BITable<BAlarmRecord>)table, dOut, this.getSessionContext());
                        AlarmOutput out = new AlarmOutput((BITable<BAlarmRecord>)table, dOut);
                        try (AlarmSecurityCursor c = new AlarmSecurityCursor((Cursor<BAlarmRecord>)table.cursor(), service, BPermissions.operatorRead, this.getSessionContext());){
                            while (c.next()) {
                                out.write((BAlarmRecord)((Object)c.get()));
                            }
                        }
                        out.flush();
                        out.close();
                        break block20;
                    }
                    resp.add("resultType", "table");
                    circuit.writeMessage(resp);
                    circuit.flush();
                    DataOutputStream out = new DataOutputStream(circuit.getOutputStream());
                    DataTableEncoder.encode((BIDataTable)BToDataTable.toDataTable((BITable)table), (DataOutput)out, (Context)this.getSessionContext());
                    out.flush();
                    out.close();
                    break block20;
                }
                throw new IllegalStateException("Unsupported result type: " + result.getClass().getName());
            }
            finally {
                circuit.close();
            }
        }
    }

    private AlarmColumnSpec[] readColumns(DataInput in) throws Exception {
        int count = in.readInt();
        AlarmColumnSpec[] specs = new AlarmColumnSpec[count];
        for (int i = 0; i < specs.length; ++i) {
            specs[i] = AlarmColumnSpec.read(in);
        }
        return specs;
    }

    private void writeColumns(BITable<BAlarmRecord> table, DataOutput out, Context cx) throws Exception {
        ColumnList columns = table.getColumns();
        out.writeInt(columns.size());
        for (int i = 0; i < columns.size(); ++i) {
            Column c = columns.get(i);
            new AlarmColumnSpec(c.getName(), c.getDisplayName(cx), c.getFacets()).write(out);
        }
    }

    private class AlarmSecurityCursor
    extends AbstractCursor<BAlarmRecord> {
        private BAlarmService service;
        private BUser user;
        private Context context;
        private BPermissions required;
        private Cursor<BAlarmRecord> inner;
        private BAlarmRecord rec;
        private HashMap<Object, BPermissions> classPermissions = new HashMap();

        public AlarmSecurityCursor(Cursor<BAlarmRecord> inner, BAlarmService service, BPermissions required, Context context) {
            this.inner = inner;
            this.service = service;
            this.required = required;
            this.context = context;
            this.user = context != null ? context.getUser() : null;
        }

        public Context getContext() {
            return this.context;
        }

        protected BAlarmRecord doGet() {
            return this.rec;
        }

        protected boolean advanceCursor() {
            while (this.inner.next()) {
                this.rec = (BAlarmRecord)((Object)this.inner.get());
                if (this.user != null) {
                    BPermissions cp = this.getClassPermissions(this.user, this.service.lookupAlarmClass(this.rec.getAlarmClass()));
                    if (!cp.has(this.required)) continue;
                    return true;
                }
                return true;
            }
            return false;
        }

        public boolean nextComponent() {
            while (this.inner.next()) {
            }
            return false;
        }

        public boolean next(Class<Object> cls) {
            if (BAlarmRecord.class.isAssignableFrom(cls)) {
                return this.next();
            }
            while (this.inner.next()) {
            }
            return false;
        }

        private BPermissions getClassPermissions(BUser user, BAlarmClass ac) {
            BPermissions p = this.classPermissions.get(ac.getHandle());
            if (p == null) {
                p = BAlarmDbChannel.this.getPermissionsFor((Object)ac);
                this.classPermissions.put(ac.getHandle(), p);
            }
            return p;
        }
    }
}

