/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.db.file;

import com.tridium.alarm.db.file.IndexEntry;
import com.tridium.alarm.db.file.SkipList;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Context;

public class TimestampIndex
extends SkipList {
    public TimestampIndex(double probability, int maxSize) {
        super(probability, maxSize);
    }

    @Override
    public IndexEntry find(Object t) {
        BAbsTime tstamp = (BAbsTime)t;
        IndexEntry result = super.find(t);
        if (result.timestamp == null) {
            return result;
        }
        if (!result.timestamp.equals((Object)tstamp)) {
            return result;
        }
        IndexEntry prev = this.getPrev(result);
        while (prev.timestamp != null && prev.timestamp.equals((Object)tstamp)) {
            result = prev;
            prev = this.getPrev(result);
        }
        return result;
    }

    @Override
    protected int compareToKey(IndexEntry entry, Object key) {
        return entry.timestamp.compareTo(key);
    }

    @Override
    protected int compare(IndexEntry entry1, IndexEntry entry2) {
        int tscomp = entry1.timestamp.compareTo((Object)entry2.timestamp);
        if (tscomp == 0) {
            return entry1.pageIndex - entry2.pageIndex;
        }
        return tscomp;
    }

    @Override
    protected int getLevel(IndexEntry entry) {
        return entry.nextTimestamp.length;
    }

    @Override
    protected void setLevel(IndexEntry entry, int level) {
        entry.nextTimestamp = new IndexEntry[level];
    }

    @Override
    protected IndexEntry getNext(IndexEntry entry, int level) {
        return entry.nextTimestamp[level];
    }

    @Override
    protected void setNext(IndexEntry entry, int level, IndexEntry value) {
        entry.nextTimestamp[level] = value;
    }

    @Override
    protected IndexEntry getPrev(IndexEntry entry) {
        return entry.prevTimestamp;
    }

    @Override
    protected void setPrev(IndexEntry entry, IndexEntry prevEntry) {
        entry.prevTimestamp = prevEntry;
    }

    @Override
    public String entryToString(IndexEntry entry) {
        return entry.timestamp.toString((Context)BAlarmRecord.TIMESTAMP_FACETS) + " => " + entry.pageIndex;
    }
}

