/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.db.file;

import com.tridium.alarm.db.file.AlarmStore;
import com.tridium.alarm.db.file.BFileAlarmDatabase;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.dataRecovery.DataRecoveryException;
import javax.baja.nre.util.ByteBuffer;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;

public abstract class DataRecoveryAlarmEvent {
    private int eventCode;
    static final byte EVENT_APPEND = 0;
    static final byte EVENT_UPDATE = 1;
    static final byte EVENT_CLEARALL = 2;
    static final byte EVENT_CLEAROLD = 3;
    static final byte EVENT_CLEARRECORD = 4;
    static final byte EVENT_CAPACITYCHANGE = 5;

    private DataRecoveryAlarmEvent(int code) {
        this.eventCode = code;
    }

    public static final DataRecoveryAlarmEvent make(byte[] in) throws Exception {
        ByteBuffer buffer = new ByteBuffer(in);
        int eventCode = -1;
        try {
            eventCode = buffer.readByte();
            switch (eventCode) {
                case 0: {
                    return new Append(buffer);
                }
                case 1: {
                    return new Update(buffer);
                }
                case 2: {
                    return new ClearAll(buffer);
                }
                case 3: {
                    return new ClearOld(buffer);
                }
                case 4: {
                    return new ClearRecord(buffer);
                }
                case 5: {
                    return new CapacityChange(buffer);
                }
            }
            throw new IllegalStateException("Unknown alarm event code: '" + eventCode + "'");
        }
        catch (IOException io) {
            throw new DataRecoveryException("Invalid alarm data (event=" + eventCode + ", length=" + in.length + ")", (Throwable)io);
        }
    }

    public abstract void execute(BFileAlarmDatabase var1) throws Exception;

    public byte[] encode() throws IOException {
        ByteBuffer buffer = new ByteBuffer();
        buffer.writeByte(this.eventCode);
        return buffer.toByteArray();
    }

    protected final AlarmStore getAlarmStore(BFileAlarmDatabase database) {
        return (AlarmStore)database.fw(602, null, null, null, null);
    }

    int getEventCode() {
        return this.eventCode;
    }

    public static class CapacityChange
    extends DataRecoveryAlarmEvent {
        int capacity;

        public CapacityChange(int capacity) {
            super(5);
            this.capacity = capacity;
        }

        public CapacityChange(ByteBuffer buffer) throws Exception {
            this(buffer.readInt());
        }

        @Override
        public void execute(BFileAlarmDatabase database) throws IOException {
            AlarmStore alarmStore = this.getAlarmStore(database);
            alarmStore.setCapacity(this.capacity);
            alarmStore.trimToCapacity();
        }

        @Override
        public byte[] encode() throws IOException {
            ByteBuffer buffer = new ByteBuffer();
            buffer.write(super.encode());
            buffer.writeInt(this.capacity);
            return buffer.toByteArray();
        }

        public String toString() {
            StringBuilder out = new StringBuilder();
            out.append("[Capacity ").append(this.capacity).append("]");
            return out.toString();
        }
    }

    public static class ClearRecord
    extends DataRecoveryAlarmEvent {
        BUuid uuid;

        public ClearRecord(BUuid uuid) {
            super(4);
            this.uuid = uuid;
        }

        public ClearRecord(ByteBuffer buffer) throws IOException {
            this((BUuid)BUuid.DEFAULT.decode((DataInput)buffer));
        }

        @Override
        public void execute(BFileAlarmDatabase database) throws IOException {
            this.getAlarmStore(database).clearRecord(this.uuid, null);
        }

        @Override
        public byte[] encode() throws IOException {
            ByteBuffer buffer = new ByteBuffer();
            buffer.write(super.encode());
            this.uuid.encode((DataOutput)buffer);
            return buffer.toByteArray();
        }

        public String toString() {
            StringBuilder out = new StringBuilder();
            out.append("[ClearRecord ").append(this.uuid).append("]");
            return out.toString();
        }
    }

    public static class ClearOld
    extends DataRecoveryAlarmEvent {
        BAbsTime before;

        public ClearOld(BAbsTime before) {
            super(3);
            this.before = before;
        }

        public ClearOld(ByteBuffer in) throws Exception {
            this((BAbsTime)BAbsTime.DEFAULT.decode48((DataInput)in));
        }

        @Override
        public void execute(BFileAlarmDatabase database) throws IOException {
            this.getAlarmStore(database).clearOldRecords(this.before, null);
        }

        @Override
        public byte[] encode() throws IOException {
            ByteBuffer buffer = new ByteBuffer();
            buffer.write(super.encode());
            this.before.encode48((DataOutput)buffer);
            return buffer.toByteArray();
        }

        public String toString() {
            StringBuilder out = new StringBuilder();
            out.append("[ClearOld ").append(this.before).append("]");
            return out.toString();
        }
    }

    public static class ClearAll
    extends DataRecoveryAlarmEvent {
        public ClearAll() {
            super(2);
        }

        public ClearAll(ByteBuffer in) {
            this();
        }

        @Override
        public void execute(BFileAlarmDatabase database) throws IOException {
            this.getAlarmStore(database).clearAllRecords(null);
        }

        public String toString() {
            return "[ClearAll]";
        }
    }

    public static class Update
    extends DataRecoveryAlarmEvent {
        BAlarmRecord record;

        public Update(BAlarmRecord record) {
            super(1);
            this.record = record;
        }

        public Update(ByteBuffer in) throws Exception {
            super(1);
            this.record = new BAlarmRecord(BUuid.DEFAULT);
            this.record.read((DataInput)in, BAlarmRecord.DATA_RECOVERY_CX);
        }

        @Override
        public void execute(BFileAlarmDatabase database) throws IOException {
            AlarmStore alarmStore = this.getAlarmStore(database);
            BAlarmRecord existingRecord = alarmStore.getRecord(this.record.getUuid());
            if (existingRecord == null || existingRecord.getLastUpdate().isBefore(this.record.getLastUpdate())) {
                this.getAlarmStore(database).update(this.record);
                if (existingRecord != null && existingRecord.getAckState().equals((Object)BAckState.ackPending)) {
                    ((BAlarmService)Sys.getService((Type)BAlarmService.TYPE)).ackAlarm(this.record);
                }
            }
        }

        @Override
        public byte[] encode() throws IOException {
            ByteBuffer out = new ByteBuffer();
            out.write(super.encode());
            this.record.write((DataOutput)out, BAlarmRecord.DATA_RECOVERY_CX);
            return out.toByteArray();
        }

        public String toString() {
            StringBuilder out = new StringBuilder();
            out.append("[Alarm Update] ");
            out.append((Object)this.record);
            return out.toString();
        }
    }

    public static class Append
    extends DataRecoveryAlarmEvent {
        BAlarmRecord record;

        public Append(BAlarmRecord record) {
            super(0);
            this.record = record;
        }

        public Append(ByteBuffer in) throws Exception {
            super(0);
            this.record = new BAlarmRecord(BUuid.DEFAULT);
            this.record.read((DataInput)in, BAlarmRecord.DATA_RECOVERY_CX);
        }

        @Override
        public void execute(BFileAlarmDatabase database) throws IOException {
            AlarmStore alarmStore = this.getAlarmStore(database);
            BAlarmRecord existingRecord = alarmStore.getRecord(this.record.getUuid());
            if (existingRecord == null || existingRecord.getLastUpdate().isBefore(this.record.getLastUpdate())) {
                this.getAlarmStore(database).append(this.record);
                if (this.record.getAckState().equals((Object)BAckState.ackPending)) {
                    ((BAlarmService)Sys.getService((Type)BAlarmService.TYPE)).ackAlarm(this.record);
                }
            }
        }

        @Override
        public byte[] encode() throws IOException {
            ByteBuffer out = new ByteBuffer();
            out.write(super.encode());
            this.record.write((DataOutput)out, BAlarmRecord.DATA_RECOVERY_CX);
            return out.toByteArray();
        }

        public String toString() {
            StringBuilder out = new StringBuilder();
            out.append("[Alarm Append] ");
            out.append((Object)this.record);
            return out.toString();
        }
    }
}

