/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm;

import com.tridium.alarm.BIAlarmRecordDecorator;
import com.tridium.alarm.db.AlarmQuery;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.baja.alarm.AlarmDbConnection;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmDatabase;
import javax.baja.alarm.BAlarmRecipient;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.security.PermissionException;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.user.BUser;
import javax.baja.util.BUuid;

public final class AlarmUtil {
    static final Set<BIAlarmRecordDecorator> DECORATORS = new LinkedHashSet<BIAlarmRecordDecorator>();
    private final BAlarmService service;

    public static AlarmUtil make(BAlarmService alarmService) {
        return new AlarmUtil(alarmService);
    }

    private AlarmUtil(BAlarmService alarmService) {
        this.service = alarmService;
    }

    public Set<String> getAllAlarmClassesFromAlarmService() {
        BAlarmClass[] allAlarmClasses = this.service.getAlarmClasses();
        HashSet<String> allAlarmClassNames = new HashSet<String>();
        for (BAlarmClass ac : allAlarmClasses) {
            allAlarmClassNames.add(ac.getName());
        }
        return allAlarmClassNames;
    }

    public String getInitialAlarmQuery(BAlarmRecipient recipient) {
        return this.getInitialAlarmQuery(recipient, null, false);
    }

    public String getInitialAlarmQuery(BAlarmRecipient recipient, BUser user, boolean includeSubscribedEscalatedAlarmClasses) {
        String defaultAlarmClassName = this.service.getDefaultAlarmClass().getName();
        String[] subscribedAlarmClasses = recipient.getSubscribedAlarmClasses();
        StringBuilder bqlQuery = new StringBuilder("alarm:|bql:select * from openAlarms");
        int count = 0;
        boolean isDefaultClassRecipient = false;
        StringBuilder whereClause = new StringBuilder();
        for (String ac : subscribedAlarmClasses) {
            try {
                if (user != null) {
                    user.check((BIProtected)this.service.lookupAlarmClass(ac), BPermissions.operatorRead);
                }
                if (!isDefaultClassRecipient && ac.equals(defaultAlarmClassName)) {
                    isDefaultClassRecipient = true;
                }
                if (count > 0) {
                    whereClause.append(" or ");
                } else {
                    whereClause.append('(');
                }
                ++count;
                whereClause.append("alarmClass = '").append(SlotPath.escape((String)ac)).append('\'');
            }
            catch (PermissionException permissionException) {
                // empty catch block
            }
        }
        if (isDefaultClassRecipient) {
            BAlarmClass[] allAlarmClasses = this.service.getAlarmClasses();
            whereClause.append(" or ");
            whereClause.append('(');
            int acCount = 0;
            for (BAlarmClass ac : allAlarmClasses) {
                if (acCount > 0) {
                    whereClause.append(" and ");
                }
                whereClause.append("alarmClass != '").append(SlotPath.escape((String)ac.getName())).append('\'');
                ++acCount;
            }
            whereClause.append(')');
        }
        if (count > 0) {
            whereClause.append(')');
        }
        if (includeSubscribedEscalatedAlarmClasses) {
            String escalatedAlarmQuery = this.getSubscribedEscalatedAlarmClassesQuery(recipient, user, this.service, count);
            whereClause.append(escalatedAlarmQuery);
        }
        if (whereClause.length() > 0) {
            bqlQuery.append(" where (");
            bqlQuery.append(whereClause.toString()).append(')');
        } else {
            bqlQuery.append(" where alarmClass = 'null'");
        }
        return bqlQuery.toString();
    }

    private String getSubscribedEscalatedAlarmClassesQuery(BAlarmRecipient recipient, BUser user, BAlarmService service, int count) {
        String[] subscribedEscalatedAlarmClasses;
        StringBuilder whereClause = new StringBuilder();
        for (String ac : subscribedEscalatedAlarmClasses = recipient.getSubscribedEscalatedAlarmClasses(1)) {
            try {
                if (user != null) {
                    user.check((BIProtected)service.lookupAlarmClass(ac), BPermissions.operatorRead);
                }
                if (count > 0) {
                    whereClause.append(" or ");
                }
                whereClause.append("(alarmClass = '").append(SlotPath.escape((String)ac)).append("' and (alarmData.").append("escalated").append(" != null and alarmData.").append("escalated").append(" = '").append("level3").append("' or alarmData.").append("escalated").append(" = '").append("level2").append("' or alarmData.").append("escalated").append(" = '").append("level1").append("'))");
                ++count;
            }
            catch (PermissionException permissionException) {
                // empty catch block
            }
        }
        for (String ac : subscribedEscalatedAlarmClasses = recipient.getSubscribedEscalatedAlarmClasses(2)) {
            try {
                if (user != null) {
                    user.check((BIProtected)service.lookupAlarmClass(ac), BPermissions.operatorRead);
                }
                if (count > 0) {
                    whereClause.append(" or ");
                }
                whereClause.append("(alarmClass = '").append(SlotPath.escape((String)ac)).append("' and (alarmData.").append("escalated").append(" != null and alarmData.").append("escalated").append(" = '").append("level3").append("' or alarmData.").append("escalated").append(" = '").append("level2").append("'))");
                ++count;
            }
            catch (PermissionException permissionException) {
                // empty catch block
            }
        }
        for (String ac : subscribedEscalatedAlarmClasses = recipient.getSubscribedEscalatedAlarmClasses(3)) {
            try {
                if (user != null) {
                    user.check((BIProtected)service.lookupAlarmClass(ac), BPermissions.operatorRead);
                }
                if (count > 0) {
                    whereClause.append(" or ");
                }
                whereClause.append("(alarmClass = '").append(SlotPath.escape((String)ac)).append("' and alarmData.").append("escalated").append(" != null and alarmData.").append("escalated").append(" = '").append("level3").append("')");
                ++count;
            }
            catch (PermissionException permissionException) {
                // empty catch block
            }
        }
        return whereClause.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static OrdTarget resolveUuidQuery(OrdTarget base, AlarmQuery query, BAlarmDatabase db) {
        String uuid = query.getQueryParameter("uuid", null);
        if (uuid == null) throw new UnresolvedException("Cannot resolve null uuid");
        try (AlarmDbConnection conn = db.getDbConnection(null);){
            BAlarmRecord rec = conn.getRecord(BUuid.make((String)uuid));
            if (rec == null) {
                throw new UnresolvedException(uuid);
            }
            OrdTarget ordTarget = new OrdTarget(base, (BObject)rec);
            return ordTarget;
        }
        catch (UnresolvedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UnresolvedException("Cannot access alarm database.", (Throwable)e);
        }
    }

    static class AlarmRecordDecoratorSpyPage
    extends Spy {
        AlarmRecordDecoratorSpyPage() {
        }

        public void write(SpyWriter out) throws Exception {
            if (DECORATORS.isEmpty()) {
                out.write("No alarm record decorators registered");
                return;
            }
            out.startTable(true);
            out.w((Object)"<tr>");
            out.thTitle((Object)"Registered Alarm Record Decorator");
            out.thTitle((Object)"Type");
            out.w((Object)"</tr>");
            DECORATORS.forEach(decorator -> {
                BComponent comp;
                String objString = decorator.toString();
                if (decorator instanceof BComponent && (comp = (BComponent)decorator).getSlotPath() != null) {
                    objString = comp.toDisplayPathString(null);
                }
                out.w((Object)"<tr>");
                out.w((Object)"<td align='left' nowrap='true'>").safe((Object)objString).w((Object)"</td>");
                out.w((Object)"<td align='left' nowrap='true'>").safe((Object)decorator.getType().toString()).w((Object)"</td>");
                out.w((Object)"</tr>");
            });
            out.endTable();
        }
    }
}

