/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ldap.v3;

import com.tridium.ldap.BConfigurableLdapConfig;
import com.tridium.ldap.v3.BAuthenticationMechanism;
import com.tridium.ldap.v3.BindNameFormatter;
import com.tridium.util.ArrayUtil;
import java.security.AccessController;
import javax.baja.license.Feature;
import javax.baja.license.LicenseException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.AuthenticationException;
import javax.baja.security.BICredentials;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.naming.directory.DirContext;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="bindFormat", type="BFormat", defaultValue="BFormat.make(\"%userName%\")"), @NiagaraProperty(name="connectionUser", type="String", defaultValue=""), @NiagaraProperty(name="connectionPassword", type="BPassword", defaultValue="BPassword.make(\"\")"), @NiagaraProperty(name="authenticationMechanism", type="BAuthenticationMechanism", defaultValue="BAuthenticationMechanism.simple")})
public class BLdapV3Config
extends BConfigurableLdapConfig {
    @Generated
    public static final Property bindFormat = BLdapV3Config.newProperty((int)0, (BValue)BFormat.make((String)"%userName%"), null);
    @Generated
    public static final Property connectionUser = BLdapV3Config.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property connectionPassword = BLdapV3Config.newProperty((int)0, (BValue)BPassword.make((String)""), null);
    @Generated
    public static final Property authenticationMechanism = BLdapV3Config.newProperty((int)0, (BValue)BAuthenticationMechanism.simple, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BLdapV3Config.class);
    private Feature ldapv3Feature = null;

    @Generated
    public BFormat getBindFormat() {
        return (BFormat)this.get(bindFormat);
    }

    @Generated
    public void setBindFormat(BFormat v) {
        this.set(bindFormat, (BValue)v, null);
    }

    @Generated
    public String getConnectionUser() {
        return this.getString(connectionUser);
    }

    @Generated
    public void setConnectionUser(String v) {
        this.setString(connectionUser, v, null);
    }

    @Generated
    public BPassword getConnectionPassword() {
        return (BPassword)this.get(connectionPassword);
    }

    @Generated
    public void setConnectionPassword(BPassword v) {
        this.set(connectionPassword, (BValue)v, null);
    }

    @Generated
    public BAuthenticationMechanism getAuthenticationMechanism() {
        return (BAuthenticationMechanism)this.get(authenticationMechanism);
    }

    @Generated
    public void setAuthenticationMechanism(BAuthenticationMechanism v) {
        this.set(authenticationMechanism, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    protected String getConnectionUser(String username) {
        if (!this.getConnectionUser().isEmpty()) {
            return this.getConnectionUser();
        }
        BindNameFormatter formatter = new BindNameFormatter(this);
        formatter.setUserName(username);
        return formatter.getFormattedBindName();
    }

    @Override
    protected String getConnectionPwd(String password) {
        if (!this.getConnectionUser().isEmpty()) {
            return AccessController.doPrivileged(() -> ((BPassword)this.getConnectionPassword()).getValue());
        }
        return password;
    }

    @Override
    protected void rebind(DirContext dir, BICredentials credentials, String userBase) throws Exception {
        if (!(credentials instanceof BUsernameAndPassword)) {
            throw new AuthenticationException("Invalid Credential Type");
        }
        BUsernameAndPassword creds = (BUsernameAndPassword)credentials;
        BindNameFormatter formatter = new BindNameFormatter(this);
        formatter.setUserName(creds.getUsername());
        formatter.setUserBase(userBase.substring(userBase.indexOf(44) + 1));
        formatter.setAttributes(dir.getAttributes(userBase));
        String bindName = formatter.getFormattedBindName();
        logger.fine(lex.getText("ldap.login.rebind", new Object[]{bindName}));
        dir.addToEnvironment("java.naming.security.principal", bindName);
        dir.addToEnvironment("java.naming.security.credentials", AccessController.doPrivileged(() -> ((BPassword)creds.getPassword()).getValue()));
    }

    @Override
    public void checkLicense() throws LicenseException {
        if (this.ldapv3Feature == null) {
            this.ldapv3Feature = Sys.getLicenseManager().getFeature("tridium", "ldapv3");
        }
        this.ldapv3Feature.check();
    }

    @Override
    protected String getAuthMech() {
        return this.getAuthenticationMechanism().getDisplayTag(null);
    }

    @Override
    public String[] listConfig() {
        return (String[])ArrayUtil.add((Object[])super.listConfig(), (Object[])new String[]{"bindFormat", "connectionUser", "connectionPassword", "authenticationMechanism"});
    }
}

