/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ldap.v3;

import com.sun.security.jgss.GSSUtil;
import com.tridium.authn.BAuthenticationService;
import com.tridium.fox.kerberos.KerberosCallbackHandler;
import com.tridium.fox.kerberos.KerberosConfig;
import com.tridium.ldap.BLdapConfig;
import com.tridium.ldap.v3.BKerberosAuthenticationScheme;
import com.tridium.ldap.v3.BKeytabFile;
import com.tridium.ldap.v3.KerberosKeytabConfig;
import com.tridium.ldap.v3.LdapKerberosAuthAction;
import com.tridium.nre.security.SecurityInitializer;
import com.tridium.nre.security.io.AESStreamEncryption;
import com.tridium.nre.security.io.KeyRingDecryptingInputStream;
import com.tridium.nre.security.io.KeyRingEncryptingInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.logging.Level;
import javax.baja.authn.BAuthenticationScheme;
import javax.baja.file.BFileSpace;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.license.Feature;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.license.LicenseException;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.FileUtil;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.security.AuthenticationException;
import javax.baja.security.BIUserCredentials;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.security.BUsernameCredential;
import javax.baja.security.PermissionException;
import javax.baja.security.kerberos.BKerberosCredentials;
import javax.baja.sys.Action;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.naming.directory.DirContext;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.kerberos.KeyTab;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSCredential;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="realm", type="String", defaultValue="BKerberosConfig.DEFAULT_REALM_VALUE"), @NiagaraProperty(name="keyDistributionCenter", type="String", defaultValue="BKerberosConfig.DEFAULT_KEY_DISTRIBUTION_CENTER_VALUE"), @NiagaraProperty(name="stationKerberosName", type="String", defaultValue="BKerberosConfig.DEFAULT_KERBEROS_NAME_VALUE"), @NiagaraProperty(name="stationKerberosPassword", type="BPassword", defaultValue="BPassword.DEFAULT"), @NiagaraProperty(name="keyTabFile", type="BKeytabFile", defaultValue="new BKeytabFile()", facets={@Facet(name="BFacets.FIELD_EDITOR", value="\"ldap:KeytabFE\""), @Facet(name="BFacets.UX_FIELD_EDITOR", value="\"ldap:KeytabEditor\"")})})
@NiagaraAction(name="getKeytabsAction", returnType="BOrdList", flags=4)
public class BKerberosConfig
extends BLdapConfig {
    @Generated
    public static final Property realm = BKerberosConfig.newProperty((int)0, (String)"EXAMPLE.COM", null);
    @Generated
    public static final Property keyDistributionCenter = BKerberosConfig.newProperty((int)0, (String)"kdc.example.com", null);
    @Generated
    public static final Property stationKerberosName = BKerberosConfig.newProperty((int)0, (String)"station name", null);
    @Generated
    public static final Property stationKerberosPassword = BKerberosConfig.newProperty((int)0, (BValue)BPassword.DEFAULT, null);
    @Generated
    public static final Property keyTabFile = BKerberosConfig.newProperty((int)0, (BValue)new BKeytabFile(), (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldEditor", (String)"ldap:KeytabFE"), (BFacets)BFacets.make((String)"uxFieldEditor", (String)"ldap:KeytabEditor")));
    @Generated
    public static final Action getKeytabsAction = BKerberosConfig.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BKerberosConfig.class);
    Subject subject = null;
    Date subjectExpiration = null;
    private Feature ldapv3Feature = null;
    private static final String DEFAULT_REALM_VALUE = "EXAMPLE.COM";
    private static final String DEFAULT_KEY_DISTRIBUTION_CENTER_VALUE = "kdc.example.com";
    private static final String DEFAULT_KERBEROS_NAME_VALUE = "station name";

    @Generated
    public String getRealm() {
        return this.getString(realm);
    }

    @Generated
    public void setRealm(String v) {
        this.setString(realm, v, null);
    }

    @Generated
    public String getKeyDistributionCenter() {
        return this.getString(keyDistributionCenter);
    }

    @Generated
    public void setKeyDistributionCenter(String v) {
        this.setString(keyDistributionCenter, v, null);
    }

    @Generated
    public String getStationKerberosName() {
        return this.getString(stationKerberosName);
    }

    @Generated
    public void setStationKerberosName(String v) {
        this.setString(stationKerberosName, v, null);
    }

    @Generated
    public BPassword getStationKerberosPassword() {
        return (BPassword)this.get(stationKerberosPassword);
    }

    @Generated
    public void setStationKerberosPassword(BPassword v) {
        this.set(stationKerberosPassword, (BValue)v, null);
    }

    @Generated
    public BKeytabFile getKeyTabFile() {
        return (BKeytabFile)this.get(keyTabFile);
    }

    @Generated
    public void setKeyTabFile(BKeytabFile v) {
        this.set(keyTabFile, (BValue)v, null);
    }

    @Generated
    public BOrdList getKeytabsAction() {
        return (BOrdList)this.invoke(getKeytabsAction, null, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BOrdList doGetKeytabsAction() {
        return (BOrdList)AccessController.doPrivileged(() -> {
            BOrd ldapOrd = BOrd.make((String)"file:^^ldap");
            BIFile[] keytabs = null;
            try {
                BIDirectory ldap = (BIDirectory)ldapOrd.get((BObject)this);
                keytabs = ldap.listFiles();
            }
            catch (ClassCastException | UnresolvedException ldap) {
                // empty catch block
            }
            if (keytabs == null) {
                keytabs = new BIFile[]{};
            }
            BOrdList fileOrds = BOrdList.NULL;
            fileOrds = BOrdList.add((BOrdList)fileOrds, (BOrd)BOrd.NULL);
            for (BIFile f : keytabs) {
                if (f.isDirectory() || f.getFileName().equals("krb5.conf")) continue;
                BOrd ord = BOrd.make((String)("file:^^ldap/" + f.getFileName()));
                fileOrds = BOrdList.add((BOrdList)fileOrds, (BOrd)ord);
            }
            return fileOrds;
        });
    }

    static void decryptFile(File f) throws IOException {
        try (FileInputStream fileInRaw = new FileInputStream(f);
             KeyRingDecryptingInputStream fileIn = new KeyRingDecryptingInputStream((InputStream)fileInRaw, SecurityInitializer.getInstance().getSecurityInfoProvider());){
            File decrypt = new File(f.getPath() + "_plain");
            try (FileOutputStream fileOutRaw = new FileOutputStream(decrypt);
                 BufferedOutputStream fileOut = new BufferedOutputStream(fileOutRaw);){
                FileUtil.pipe((InputStream)fileIn, (OutputStream)fileOut);
            }
        }
    }

    @Override
    public DirContext initialDirContext(BIUserCredentials credentials) throws Exception {
        Subject subject;
        this.requireKerberosFeature();
        if (credentials instanceof BUsernameAndPassword) {
            LoginContext lc;
            BUsernameAndPassword upCreds = (BUsernameAndPassword)credentials;
            logger.fine(lex.getText("ldap.kerberos.usernamePasswordCreds", new Object[]{upCreds.getUsername()}));
            KerberosConfig kerberosConfig = new KerberosConfig(upCreds.getUsername());
            try {
                lc = (LoginContext)AccessController.doPrivileged(() -> BKerberosConfig.lambda$initialDirContext$1(upCreds, (Configuration)kerberosConfig));
            }
            catch (Exception e) {
                BKerberosConfig.logException(lex.getText("ldap.error.couldNotAcquireCreds"), e, Level.SEVERE);
                throw new AuthenticationException("Invalid Credentials");
            }
            subject = lc.getSubject();
        } else if (credentials instanceof BUsernameCredential) {
            if (this.getKeytabLocation() == null) {
                throw new AuthenticationException("Cannot login with browser token without keytab.");
            }
            try {
                new LoginContext("com.tridium.workbench.auth.WbAuthenticationClient", null, null, (Configuration)new KerberosConfig(true, true)).login();
            }
            catch (Exception upCreds) {
                // empty catch block
            }
            logger.fine(lex.getText("ldap.kerberos.kerberosCreds", new Object[]{credentials.getUsername()}));
            subject = this.getStationSubject();
        } else if (credentials instanceof BKerberosCredentials) {
            try {
                new LoginContext("com.tridium.workbench.auth.WbAuthenticationClient", null, null, (Configuration)new KerberosConfig(true, true)).login();
            }
            catch (Exception upCreds) {
                // empty catch block
            }
            logger.fine(lex.getText("ldap.kerberos.kerberosCreds", new Object[]{credentials.getUsername()}));
            GSSCredential gssCred = ((BKerberosCredentials)credentials).getCredential();
            subject = GSSUtil.createSubject(gssCred.getName(), gssCred);
        } else {
            throw new AuthenticationException(lex.getText("ldap.error.unsupportedCred"));
        }
        logger.fine(lex.getText("ldap.kerberos.bind"));
        try {
            return (DirContext)AccessController.doPrivileged(() -> Subject.doAs(subject, new LdapKerberosAuthAction(this)));
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof PrivilegedActionException && e.getCause().getCause() instanceof Exception) {
                throw (Exception)e.getCause().getCause();
            }
            throw e;
        }
    }

    Subject getStationSubject() {
        Object kerberosConfig;
        Subject sub;
        String keytabLocation = this.getKeytabLocation();
        if (keytabLocation != null) {
            logger.fine(lex.getText("ldap.kerberos.keytabSuccess"));
            AccessController.doPrivileged(() -> {
                try {
                    if (!BKerberosConfig.ensureEncrypted(new File(keytabLocation))) {
                        this.subject = null;
                        this.subjectExpiration = null;
                    }
                }
                catch (Exception e) {
                    BLdapConfig.logException(lex.getText("ldap.error.keytabEncrypt"), e, Level.SEVERE);
                    this.subject = null;
                    this.subjectExpiration = null;
                }
                return null;
            });
        }
        if (this.subjectExpiration != null && this.subjectExpiration.before(new Date())) {
            logger.fine(lex.getText("ldap.kerberos.cachedSubjectExpired"));
            this.subject = null;
            this.subjectExpiration = null;
        }
        if ((sub = this.subject) != null) {
            logger.fine(lex.getText("ldap.kerberos.cachedSubject"));
            return sub;
        }
        String principal = this.getStationKerberosName();
        if (keytabLocation != null) {
            logger.fine(lex.getText("ldap.kerberos.keytabSubject"));
            kerberosConfig = new KerberosKeytabConfig(principal, keytabLocation + "_plain");
            AccessController.doPrivileged(() -> {
                try {
                    logger.fine(lex.getText("ldap.kerberos.keytabDecrypt"));
                    BKerberosConfig.decryptFile(new File(keytabLocation));
                }
                catch (IOException e) {
                    BLdapConfig.logException(lex.getText("ldap.error.keytabDecrypt"), e, Level.SEVERE);
                }
                return null;
            });
        } else {
            logger.fine(lex.getText("ldap.kerberos.passwordSubject"));
            kerberosConfig = new KerberosConfig(principal);
            kerberosConfig.setIsInitiator(false);
        }
        LoginContext lc = (LoginContext)AccessController.doPrivileged(() -> this.lambda$getStationSubject$5(principal, (Configuration)kerberosConfig));
        if (lc != null) {
            Subject temp = lc.getSubject();
            if (keytabLocation == null) {
                this.subject = null;
                this.subjectExpiration = null;
                return temp;
            }
            sub = (Subject)AccessController.doPrivileged(() -> {
                HashSet<Object> newCreds = new HashSet<Object>();
                for (Object credential : temp.getPrivateCredentials()) {
                    if (credential instanceof KeyTab) {
                        logger.fine(lex.getText("ldap.kerberos.obtainedKeytab"));
                        KerberosKey[] keys = ((KeyTab)credential).getKeys(((KeyTab)credential).getPrincipal());
                        Collections.addAll(newCreds, keys);
                        if (!logger.isLoggable(Level.FINE)) continue;
                        for (KerberosKey key : keys) {
                            logger.fine(lex.getText("ldap.kerberos.foundKey", new Object[]{key.getPrincipal().getName()}));
                            if (!logger.isLoggable(Level.FINE)) continue;
                            System.out.println(lex.getText("ldap.kerberos.keyAlg", new Object[]{key.getAlgorithm()}));
                            System.out.println(lex.getText("ldap.kerberos.keyType", new Object[]{key.getKeyType()}));
                            System.out.println(lex.getText("ldap.kerberos.kvno", new Object[]{key.getVersionNumber()}));
                        }
                        continue;
                    }
                    logger.fine(lex.getText("ldap.kerberos.foundCreds", new Object[]{credential.getClass()}));
                    if (credential instanceof KerberosTicket) {
                        Date expiration = ((KerberosTicket)credential).getEndTime();
                        this.subjectExpiration = new Date(expiration.getTime() - 30000L);
                    }
                    newCreds.add(credential);
                }
                if (!newCreds.isEmpty()) {
                    logger.fine(lex.getText("ldap.kerberos.creatingSubject"));
                    this.subject = new Subject(temp.isReadOnly(), temp.getPrincipals(), temp.getPublicCredentials(), newCreds);
                    return this.subject;
                }
                logger.warning(lex.getText("ldap.warning.noKeys"));
                this.subject = null;
                this.subjectExpiration = null;
                return null;
            });
        } else {
            this.subject = null;
            this.subjectExpiration = null;
        }
        if (keytabLocation != null) {
            AccessController.doPrivileged(() -> {
                new File(keytabLocation + "_plain").delete();
                return null;
            });
        }
        return sub;
    }

    private String getKeytabLocation() {
        BOrd keytabOrd = this.getKeyTabFile().getKeyTabLocation();
        if (keytabOrd != BOrd.NULL && !keytabOrd.isNull()) {
            return (String)AccessController.doPrivileged(() -> {
                try {
                    logger.fine(lex.getText("ldap.kerberos.gettingKeytab", new Object[]{keytabOrd}));
                    return BFileSystem.INSTANCE.pathToLocalFile(keytabOrd.resolve().getFilePath()).getPath();
                }
                catch (Exception e) {
                    BLdapConfig.logException(lex.getText("ldap.error.couldNotGetKeytab"), e, Level.SEVERE);
                    return null;
                }
            });
        }
        return null;
    }

    @Override
    protected BUser authCachedCredentials(BIUserCredentials credentials) throws LoginException {
        logger.fine(lex.getText("ldap.login.authCached"));
        if (credentials instanceof BKerberosCredentials) {
            String username = credentials.getUsername();
            BUser user = this.userService.getUser(username);
            if (user != null && !user.isExpired() && user.getEnabled()) {
                return user;
            }
            logger.warning(lex.getText("ldap.warning.noCachedUser"));
            throw new AuthenticationException(lex.getText("ldap.error.authFailed", new Object[]{username}));
        }
        logger.fine(lex.getText("ldap.error.cannotAuthCached"));
        throw new AuthenticationException(lex.getText("ldap.error.authFailed", new Object[]{credentials.getUsername()}));
    }

    private void requireKerberosFeature() throws LicenseException {
        if (!this.ldapv3Feature.getb("kerberos", false)) {
            throw new FeatureNotLicensedException(lex.getText("ldap.kerberos.notLicensed"));
        }
    }

    @Override
    public void checkLicense() throws LicenseException {
        if (this.ldapv3Feature == null) {
            this.ldapv3Feature = Sys.getLicenseManager().getFeature("tridium", "ldapv3");
        }
        this.ldapv3Feature.check();
    }

    public void changed(Property property, Context context) {
        String keytabLocation;
        BOrd keytabOrd;
        this.subject = null;
        this.subjectExpiration = null;
        if (property.equals(keyTabFile) && (keytabOrd = this.getKeyTabFile().getKeyTabLocation()) != null && !keytabOrd.isNull() && (keytabLocation = (String)AccessController.doPrivileged(() -> {
            try {
                return BFileSystem.INSTANCE.pathToLocalFile(keytabOrd.resolve().getFilePath()).getPath();
            }
            catch (Exception e) {
                return null;
            }
        })) != null) {
            AccessController.doPrivileged(() -> {
                try {
                    BKerberosConfig.ensureEncrypted(new File(keytabLocation));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            });
        }
    }

    public void started() {
        BKerberosConfig.encryptKeytabs();
    }

    private static void encryptKeytabs() {
        File ldap = new File(Sys.getProtectedStationHome(), "ldap");
        if (!ldap.isDirectory()) {
            return;
        }
        File[] keytabs = ldap.listFiles();
        if (keytabs != null) {
            for (File f : keytabs) {
                if (f.isDirectory() || f.getName().equals("krb5.conf")) continue;
                AccessController.doPrivileged(() -> {
                    try {
                        BKerberosConfig.ensureEncrypted(f);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return null;
                });
            }
        }
    }

    private static boolean ensureEncrypted(File f) throws IOException {
        try (FileInputStream fileInRaw = new FileInputStream(f);){
            InputStream encryptedInput = AESStreamEncryption.ifEncrypted((InputStream)fileInRaw, null, unencryptedContents -> new KeyRingEncryptingInputStream(unencryptedContents, SecurityInitializer.getInstance().getSecurityInfoProvider()));
            if (encryptedInput == null) {
                boolean bl = true;
                return bl;
            }
            ByteArrayOutputStream encryptedBytes = new ByteArrayOutputStream();
            FileUtil.pipe((InputStream)encryptedInput, (OutputStream)encryptedBytes);
            try (ByteArrayInputStream in = new ByteArrayInputStream(encryptedBytes.toByteArray());
                 FileOutputStream fileOutRaw = new FileOutputStream(f);
                 BufferedOutputStream out = new BufferedOutputStream(fileOutRaw);){
                FileUtil.pipe((InputStream)in, (OutputStream)out);
            }
            boolean bl = false;
            return bl;
        }
    }

    public String getAllKdcHosts() {
        String origHost = this.getKeyDistributionCenter();
        try {
            String host = origHost;
            String port = null;
            if (host.contains(":")) {
                String[] hostPort = host.split(":");
                host = hostPort[0];
                port = hostPort[1];
            }
            InetAddress[] addrs = InetAddress.getAllByName(host);
            StringBuilder builder = new StringBuilder();
            for (InetAddress addr : addrs) {
                if (builder.length() > 0) {
                    builder.append(" ");
                }
                builder.append(addr.getCanonicalHostName());
                if (port == null) continue;
                builder.append(":" + port);
            }
            host = builder.toString();
            logger.fine(lex.getText("ldap.kerberos.kdcResolve", new Object[]{origHost, host}));
            return host;
        }
        catch (Exception e) {
            BKerberosConfig.logException(lex.getText("ldap.kerberos.kdcResolveFailed", new Object[]{origHost}), e, Level.FINE);
            return origHost;
        }
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static String readKrb5Conf(Context cx) throws Exception {
        BFileSpace fs;
        BIFile file;
        FilePath path;
        boolean canRead = false;
        if (Sys.isStation()) {
            path = new FilePath("^^ldap/krb5.conf");
            BAuthenticationService service = (BAuthenticationService)Sys.getService((Type)BAuthenticationService.TYPE);
            for (BAuthenticationScheme scheme : service.getSupportedSchemes()) {
                if (!(scheme instanceof BKerberosAuthenticationScheme) || !scheme.getPermissions(cx).hasOperatorRead()) continue;
                canRead = true;
                break;
            }
            if (!canRead) {
                throw new PermissionException("Cannot read krb5.conf");
            }
        } else {
            path = new FilePath("!security/krb5.conf");
        }
        if ((file = (fs = (BFileSpace)BOrd.make((String)"file:").get()).findFile(path)) == null) {
            return "";
        }
        return AccessController.doPrivileged(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static void writeKrb5Conf(String contents, Context cx) throws Exception {
        FilePath path;
        boolean canWrite = false;
        if (Sys.isStation()) {
            path = new FilePath("^^ldap/krb5.conf");
            BAuthenticationService service = (BAuthenticationService)Sys.getService((Type)BAuthenticationService.TYPE);
            for (BAuthenticationScheme scheme : service.getSupportedSchemes()) {
                if (!(scheme instanceof BKerberosAuthenticationScheme) || !scheme.getPermissions(cx).hasOperatorWrite()) continue;
                canWrite = true;
                break;
            }
            if (!canWrite) {
                throw new PermissionException("Cannot write krb5.conf");
            }
        } else {
            path = new FilePath("!security/krb5.conf");
        }
        BFileSpace fs = (BFileSpace)BOrd.make((String)"file:").get();
        AccessController.doPrivileged(() -> {
            BIFile file = fs.makeFile(path);
            try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter(file.getOutputStream()));){
                out.write(contents.replace("\n", System.lineSeparator()));
            }
            return null;
        });
    }

    public static void setKrb5ConfLocation() {
        BOrd location = Sys.isStation() ? BOrd.make((String)"file:^^ldap/krb5.conf") : BOrd.make((String)"file:!security/krb5.conf");
        try {
            BIFile file = (BIFile)location.get();
            String path = BFileSystem.INSTANCE.pathToLocalFile(file.getFilePath()).getPath();
            System.setProperty("java.security.krb5.conf", path);
            logger.fine(lex.getText("ldap.kerberos.foundKrb5Conf", new Object[]{location}));
        }
        catch (UnresolvedException ignored) {
            logger.fine(lex.getText("ldap.kerberos.krb5ConNotFound", new Object[]{location}));
        }
    }

    private /* synthetic */ Object lambda$getStationSubject$5(String principal, Configuration kerberosConfig) {
        try {
            LoginContext temp = new LoginContext("com.tridium.ldap.auth.KerberosLoginModule", null, (CallbackHandler)new KerberosCallbackHandler(principal, AccessController.doPrivileged(() -> ((BPassword)this.getStationKerberosPassword()).getValue())), kerberosConfig);
            temp.login();
            return temp;
        }
        catch (LoginException e) {
            BLdapConfig.logException(lex.getText("ldap.error.subjectError"), e, Level.SEVERE);
            return null;
        }
    }

    private static /* synthetic */ Object lambda$initialDirContext$1(BUsernameAndPassword upCreds, Configuration kerberosConfig) throws Exception {
        LoginContext temp = null;
        temp = new LoginContext("com.tridium.ldap.v3.auth.BKerberosAuthenticator", null, (CallbackHandler)new KerberosCallbackHandler(upCreds.getUsername(), AccessController.doPrivileged(() -> ((BPassword)upCreds.getPassword()).getValue())), kerberosConfig);
        temp.login();
        return temp;
    }
}

