/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ldap;

import com.tridium.authn.NiagaraFailedLoginException;
import com.tridium.util.EscUtil;
import java.net.InetAddress;
import java.net.URI;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.authn.BAuthenticationScheme;
import javax.baja.data.BIDataValue;
import javax.baja.license.LicenseException;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BAbstractAuthenticator;
import javax.baja.security.BAes256Pbkdf2HmacSha256PasswordEncoder;
import javax.baja.security.BICredentials;
import javax.baja.security.BIUserCredentials;
import javax.baja.security.BPassword;
import javax.baja.security.BPasswordCache;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.user.BUser;
import javax.baja.user.BUserPrototype;
import javax.baja.user.BUserPrototypeMergePolicy;
import javax.baja.user.BUserPrototypes;
import javax.baja.user.BUserService;
import javax.baja.user.IHasPrototypeMergePolicy;
import javax.baja.util.Lexicon;
import javax.naming.CommunicationException;
import javax.naming.ConfigurationException;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.ServiceUnavailableException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.security.auth.login.LoginException;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enableConnectionPooling", type="boolean", defaultValue="true"), @NiagaraProperty(name="connectionUrl", type="String", defaultValue="BLdapConfig.DEFAULT_LDAP_URI_VALUE"), @NiagaraProperty(name="SSL", type="boolean", defaultValue="false", facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")}), @NiagaraProperty(name="userLoginAttr", type="String", defaultValue=""), @NiagaraProperty(name="userBase", type="String", defaultValue=""), @NiagaraProperty(name="attrEmail", type="String", defaultValue=""), @NiagaraProperty(name="attrFullName", type="String", defaultValue=""), @NiagaraProperty(name="attrLanguage", type="String", defaultValue=""), @NiagaraProperty(name="attrCellPhoneNumber", type="String", defaultValue=""), @NiagaraProperty(name="attrPrototype", type="String", defaultValue=""), @NiagaraProperty(name="cacheExpiration", type="BRelTime", defaultValue="BRelTime.make(604800000)"), @NiagaraProperty(name="connectionTimeout", type="int", defaultValue="15", facets={@Facet(name="BFacets.UNITS", value="BUnit.getUnit(\"second\")"), @Facet(name="BFacets.MIN", value="0"), @Facet(name="BFacets.MAX", value="60")}), @NiagaraProperty(name="initialContextFactory", type="String", defaultValue="BLdapConfig.DEFAULT_LDAP_CONTEXT_VALUE", flags=4), @NiagaraProperty(name="referral", type="String", defaultValue="follow", flags=4)})
public class BLdapConfig
extends BComponent {
    @Generated
    public static final Property enableConnectionPooling = BLdapConfig.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property connectionUrl = BLdapConfig.newProperty((int)0, (String)"ldap://example.com", null);
    @Generated
    public static final Property SSL = BLdapConfig.newProperty((int)0, (boolean)false, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property userLoginAttr = BLdapConfig.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property userBase = BLdapConfig.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property attrEmail = BLdapConfig.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property attrFullName = BLdapConfig.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property attrLanguage = BLdapConfig.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property attrCellPhoneNumber = BLdapConfig.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property attrPrototype = BLdapConfig.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property cacheExpiration = BLdapConfig.newProperty((int)0, (BValue)BRelTime.make((long)604800000L), null);
    @Generated
    public static final Property connectionTimeout = BLdapConfig.newProperty((int)0, (int)15, (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"second")), (BFacets)BFacets.make((String)"min", (int)0)), (BFacets)BFacets.make((String)"max", (int)60)));
    @Generated
    public static final Property initialContextFactory = BLdapConfig.newProperty((int)4, (String)"com.sun.jndi.ldap.LdapCtxFactory", null);
    @Generated
    public static final Property referral = BLdapConfig.newProperty((int)4, (String)"follow", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BLdapConfig.class);
    protected static final Lexicon lex = Lexicon.make((String)"ldap");
    protected BUserService userService = null;
    private BAuthenticationScheme scheme = null;
    protected static Logger logger = Logger.getLogger("ldap");
    private static final BComponent[] EMPTY_COMPONENT_ARRAY = new BComponent[0];
    private static final String DEFAULT_LDAP_URI_VALUE = "ldap://example.com";
    private static final String DEFAULT_LDAP_CONTEXT_VALUE = "com.sun.jndi.ldap.LdapCtxFactory";

    @Generated
    public boolean getEnableConnectionPooling() {
        return this.getBoolean(enableConnectionPooling);
    }

    @Generated
    public void setEnableConnectionPooling(boolean v) {
        this.setBoolean(enableConnectionPooling, v, null);
    }

    @Generated
    public String getConnectionUrl() {
        return this.getString(connectionUrl);
    }

    @Generated
    public void setConnectionUrl(String v) {
        this.setString(connectionUrl, v, null);
    }

    @Generated
    public boolean getSSL() {
        return this.getBoolean(SSL);
    }

    @Generated
    public void setSSL(boolean v) {
        this.setBoolean(SSL, v, null);
    }

    @Generated
    public String getUserLoginAttr() {
        return this.getString(userLoginAttr);
    }

    @Generated
    public void setUserLoginAttr(String v) {
        this.setString(userLoginAttr, v, null);
    }

    @Generated
    public String getUserBase() {
        return this.getString(userBase);
    }

    @Generated
    public void setUserBase(String v) {
        this.setString(userBase, v, null);
    }

    @Generated
    public String getAttrEmail() {
        return this.getString(attrEmail);
    }

    @Generated
    public void setAttrEmail(String v) {
        this.setString(attrEmail, v, null);
    }

    @Generated
    public String getAttrFullName() {
        return this.getString(attrFullName);
    }

    @Generated
    public void setAttrFullName(String v) {
        this.setString(attrFullName, v, null);
    }

    @Generated
    public String getAttrLanguage() {
        return this.getString(attrLanguage);
    }

    @Generated
    public void setAttrLanguage(String v) {
        this.setString(attrLanguage, v, null);
    }

    @Generated
    public String getAttrCellPhoneNumber() {
        return this.getString(attrCellPhoneNumber);
    }

    @Generated
    public void setAttrCellPhoneNumber(String v) {
        this.setString(attrCellPhoneNumber, v, null);
    }

    @Generated
    public String getAttrPrototype() {
        return this.getString(attrPrototype);
    }

    @Generated
    public void setAttrPrototype(String v) {
        this.setString(attrPrototype, v, null);
    }

    @Generated
    public BRelTime getCacheExpiration() {
        return (BRelTime)this.get(cacheExpiration);
    }

    @Generated
    public void setCacheExpiration(BRelTime v) {
        this.set(cacheExpiration, (BValue)v, null);
    }

    @Generated
    public int getConnectionTimeout() {
        return this.getInt(connectionTimeout);
    }

    @Generated
    public void setConnectionTimeout(int v) {
        this.setInt(connectionTimeout, v, null);
    }

    @Generated
    public String getInitialContextFactory() {
        return this.getString(initialContextFactory);
    }

    @Generated
    public void setInitialContextFactory(String v) {
        this.setString(initialContextFactory, v, null);
    }

    @Generated
    public String getReferral() {
        return this.getString(referral);
    }

    @Generated
    public void setReferral(String v) {
        this.setString(referral, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BUser authenticate(String username, String password) throws LoginException {
        return this.authenticate((BIUserCredentials)new BUsernameAndPassword(username, password));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BUser authenticate(BIUserCredentials credentials) throws LoginException {
        this.checkLicense();
        this.userService = (BUserService)Sys.getService((Type)BUserService.TYPE);
        AccessController.doPrivileged(() -> {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            return null;
        });
        String username = credentials.getUsername();
        logger.fine(lex.getText("ldap.login.attemptingLogin", new Object[]{username, this.scheme.getName()}));
        BUser ret = this.userService.getUser(username);
        DirContext dir = null;
        try {
            dir = this.initialDirContext(credentials);
        }
        catch (CommunicationException | ConfigurationException | ServiceUnavailableException ce) {
            BLdapConfig.logException(lex.getText("ldap.error.unableToConnect"), ce, Level.SEVERE);
            return this.authCachedCredentials(credentials);
        }
        catch (Exception x) {
            String msg = lex.getText("ldap.error.authFailed", new Object[]{username});
            BLdapConfig.logException(msg, x, Level.SEVERE);
            throw new NiagaraFailedLoginException(username, msg);
        }
        try {
            Attributes attrs;
            String name = this.getUserLoginAttr() + "=" + username;
            logger.fine(lex.getText("ldap.login.searching", new Object[]{name}));
            SearchResult sr = this.getSearchResult(dir, name);
            if (sr == null) {
                String msg = lex.getText("ldap.error.userNotFound", new Object[]{username});
                logger.warning(msg);
                throw new NiagaraFailedLoginException(username, msg);
            }
            logger.fine(lex.getText("ldap.login.searchResults", new Object[]{sr.getName()}));
            try {
                name = this.getUserBase();
                name = name.length() > 0 ? sr.getName() + "," + name : sr.getName();
                this.rebind(dir, (BICredentials)credentials, name);
                attrs = dir.getAttributes(name);
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer(lex.getText("ldap.login.userAttributes"));
                    BLdapConfig.logAttributes(attrs);
                }
            }
            catch (Exception x) {
                String msg = lex.getText("ldap.error.ldapsearch", new Object[]{name});
                BLdapConfig.logException(msg, x, Level.SEVERE);
                throw new NiagaraFailedLoginException(username, lex.getText(msg, new Object[]{username}));
            }
            try {
                ret = this.prepareUser(credentials, ret, attrs, dir);
            }
            catch (Exception x) {
                String msg = lex.getText("ldap.error.attributes", new Object[]{username});
                BLdapConfig.logException(msg, x, Level.SEVERE);
                throw new NiagaraFailedLoginException(username, msg);
            }
        }
        finally {
            try {
                dir.close();
            }
            catch (Exception name) {}
        }
        if (!this.userService.canLogin(ret)) {
            String msg = lex.getText("ldap.error.lockout", new Object[]{username});
            logger.severe(msg);
            throw new NiagaraFailedLoginException(username, msg);
        }
        logger.fine(lex.getText("ldap.login.success", new Object[]{username}));
        return ret;
    }

    protected DirContext initialDirContext(BIUserCredentials credentials) throws Exception {
        String s;
        String url;
        String username = credentials.getUsername();
        String password = null;
        if (credentials instanceof BUsernameAndPassword) {
            password = AccessController.doPrivileged(() -> ((BPassword)((BUsernameAndPassword)credentials).getPassword()).getValue());
        }
        if ((url = this.getConnectionUrl()).isEmpty()) {
            throw new Exception("connection url is empty.");
        }
        Hashtable<String, String> h = new Hashtable<String, String>();
        h.put("java.naming.factory.initial", this.getInitialContextFactory());
        h.put("java.naming.provider.url", this.getAllConnectionUrls());
        username = this.getConnectionUser(username);
        password = this.getConnectionPwd(password);
        if (username != null) {
            logger.fine(lex.getText("ldap.login.initialBind", new Object[]{username}));
            logger.fine(lex.getText("ldap.login.authMech", new Object[]{this.getAuthMech()}));
            h.put("java.naming.security.authentication", this.getAuthMech());
            h.put("java.naming.security.principal", username);
            h.put("java.naming.security.credentials", password);
        } else {
            logger.fine(lex.getText("ldap.login.anonymous"));
        }
        String timeout = String.valueOf(this.getConnectionTimeout() * 1000);
        h.put("com.sun.jndi.ldap.connect.timeout", timeout);
        if (!this.getEnableConnectionPooling()) {
            h.put("com.sun.jndi.ldap.connect.pool", "false");
        }
        if (this.getSSL()) {
            h.put("java.naming.security.protocol", "ssl");
            h.put("java.naming.ldap.factory.socket", "javax.baja.security.crypto.se.BajaSSLSocketFactory");
        }
        if ((s = this.getReferral()).length() > 0) {
            h.put("java.naming.referral", s);
        }
        return new InitialDirContext(h);
    }

    protected void rebind(DirContext dir, BICredentials credentials, String userBase) throws Exception {
    }

    protected BUser authCachedCredentials(BIUserCredentials credentials) throws LoginException {
        logger.info(lex.getText("ldap.login.authCached"));
        String username = credentials.getUsername();
        if (credentials instanceof BUsernameAndPassword) {
            String password = AccessController.doPrivileged(() -> ((BPassword)((BUsernameAndPassword)credentials).getPassword()).getValue());
            BUser user = this.userService.getUser(username);
            if (null != user && this.userService.canLogin(user)) {
                if (((BPasswordCache)user.getAuthenticator()).validate(password)) {
                    return user;
                }
                logger.warning(lex.getText("ldap.warning.invalidCachedCreds"));
            } else {
                logger.warning(lex.getText("ldap.warning.noCachedUser"));
            }
        }
        throw new NiagaraFailedLoginException(username, lex.getText("ldap.error.authFailed", new Object[]{username}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SearchResult getSearchResult(DirContext dir, String name) throws LoginException {
        SearchResult sr = null;
        try {
            SearchControls sc = new SearchControls();
            sc.setSearchScope(2);
            sc.setCountLimit(1L);
            try (NamingEnumeration<SearchResult> ne = dir.search(this.getUserBase(), name, sc);){
                if (ne.hasMore()) {
                    sr = ne.next();
                }
            }
        }
        catch (Exception x) {
            String msg = lex.getText("ldap.error.ldapsearch", new Object[]{name});
            BLdapConfig.logException(msg, x, Level.SEVERE);
            throw new LoginException(msg);
        }
        return sr;
    }

    protected BUser prepareUser(BIUserCredentials credentials, BUser user, Attributes attributeSet, DirContext dir) throws NamingException {
        BUserPrototypes prototypes;
        BValue temp;
        String name = credentials.getUsername();
        String password = "";
        if (credentials instanceof BUsernameAndPassword) {
            password = AccessController.doPrivileged(() -> ((BPassword)((BUsernameAndPassword)credentials).getPassword()).getValue());
        }
        Object prototype = (temp = (prototypes = this.userService.getUserPrototypes()).get(prototypes.getAlternateDefaultPrototype())) instanceof BUser || temp instanceof BUserPrototype ? (BComponent)temp : this.userService.getUserPrototypes().getDefaultPrototype();
        prototype = this.getPrototypeUserAccount(attributeSet, dir, (BComponent)prototype, name);
        if (user == null) {
            user = this.addUser(name, (BComponent)prototype);
        }
        if (password != null && this.scheme.getDefaultAuthenticator() instanceof BPasswordCache) {
            user.setAuthenticator((BAbstractAuthenticator)new BPasswordCache(BPassword.make((String)password, (String)BAes256Pbkdf2HmacSha256PasswordEncoder.ENCODING_TYPE)));
        } else {
            user.setAuthenticator(this.scheme.getDefaultAuthenticator());
        }
        this.updateUserFromPrototype(user, (BComponent)prototype, attributeSet);
        return user;
    }

    protected String getEmailFromLDAPAttribute(Attributes attributeSet, String name) throws NamingException {
        if (!this.getAttrEmail().isEmpty()) {
            Attribute attr = attributeSet.get(this.getAttrEmail());
            if (attr != null) {
                return attr.get().toString();
            }
            logger.warning(lex.getText("ldap.error.userEmailAtt", new Object[]{name, this.getAttrEmail()}));
        }
        return null;
    }

    protected String getFullNameFromLDAPAttribute(Attributes attributeSet, String name) throws NamingException {
        if (!this.getAttrFullName().isEmpty()) {
            Attribute attr = attributeSet.get(this.getAttrFullName());
            if (attr != null) {
                return attr.get().toString();
            }
            logger.warning(lex.getText("ldap.error.userNameAtt", new Object[]{name, this.getAttrFullName()}));
        }
        return null;
    }

    protected String getLanguageFromLDAPAttribute(Attributes attributeSet, String name) throws NamingException {
        if (!this.getAttrLanguage().isEmpty()) {
            Attribute attr = attributeSet.get(this.getAttrLanguage());
            if (attr != null) {
                return attr.get().toString();
            }
            logger.warning(lex.getText("ldap.error.userLangAtt", new Object[]{name, this.getAttrLanguage()}));
        }
        return null;
    }

    protected String getCellPhoneNumberFromLDAPAttribute(Attributes attributeSet, String name) throws NamingException {
        if (!this.getAttrCellPhoneNumber().isEmpty()) {
            Attribute attr = attributeSet.get(this.getAttrCellPhoneNumber());
            if (attr != null) {
                return attr.get().toString();
            }
            logger.warning(lex.getText("ldap.error.userCellAtt", new Object[]{name, this.getAttrCellPhoneNumber()}));
        }
        return null;
    }

    protected BComponent getPrototypeUserAccount(Attributes attributeSet, DirContext dir, BComponent prototype, String username) throws NamingException {
        BUserPrototypeMergePolicy prototypeMergePolicy;
        if (this.getAttrPrototype().isEmpty()) {
            logger.warning(lex.getText("ldap.error.prototypeAttrNotConfigured", new Object[]{this.scheme.getName()}));
            return prototype;
        }
        BComponent[] protoUsers = this.getProtoUsers();
        if (protoUsers == null || protoUsers.length == 0) {
            return prototype;
        }
        Attribute attribute = attributeSet.get(this.getAttrPrototype());
        if (attribute == null || attribute.size() == 0) {
            logger.warning(lex.getText("ldap.error.missingPrototypeAtt", new Object[]{username, this.getAttrPrototype()}));
            return prototype;
        }
        if (this.scheme instanceof IHasPrototypeMergePolicy && (prototypeMergePolicy = ((IHasPrototypeMergePolicy)this.scheme).getPrototypeMergePolicy()).getEnabled()) {
            return this.getMergedUserPrototypeAccount(prototypeMergePolicy, protoUsers, attribute, dir, prototype, username);
        }
        return this.getSingleUserPrototypeAccount(protoUsers, attribute, dir, prototype, username);
    }

    private BComponent getMergedUserPrototypeAccount(BUserPrototypeMergePolicy prototypeMergePolicy, BComponent[] protoUsers, Attribute prototypeAttribute, DirContext dir, BComponent prototype, String username) throws NamingException {
        int size = prototypeAttribute.size();
        NameParser np = dir.getNameParser("");
        BComponent mainPrototype = prototype;
        HashSet<BComponent> prototypes = new HashSet<BComponent>();
        int lowestIndex = Integer.MAX_VALUE;
        for (int i = 0; i < size; ++i) {
            int index;
            String prototypeName = prototypeAttribute.get(i).toString().trim();
            if (prototypeName.indexOf(61) >= 0) {
                try {
                    prototypeName = this.prototypeName(np.parse(prototypeName));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (prototypeName.length() <= 0 || (index = this.indexOf(prototypeName, protoUsers)) < 0) continue;
            prototypes.add(protoUsers[index]);
            if (index >= lowestIndex) continue;
            mainPrototype = protoUsers[index];
            lowestIndex = index;
        }
        prototypes.remove(mainPrototype);
        if (lowestIndex == Integer.MAX_VALUE) {
            logger.warning(lex.getText("ldap.warning.prototypeNotFound", new Object[]{username}));
        }
        if (prototypes.isEmpty()) {
            return mainPrototype;
        }
        ArrayList<BComponent> prototypesList = new ArrayList<BComponent>(prototypes);
        prototypesList.add(0, mainPrototype);
        BComponent dummyParent = new BComponent();
        BUserPrototype mergedPrototype = prototypeMergePolicy.mergePrototypes(mainPrototype, prototypes.toArray(EMPTY_COMPONENT_ARRAY));
        dummyParent.add(BUserPrototypeMergePolicy.getMergedPrototypeName(prototypesList), (BValue)mergedPrototype);
        return mergedPrototype;
    }

    private BComponent getSingleUserPrototypeAccount(BComponent[] protoUsers, Attribute prototypeAttribute, DirContext dir, BComponent prototype, String name) throws NamingException {
        int size = prototypeAttribute.size();
        NameParser np = dir.getNameParser("");
        int lowestIndex = Integer.MAX_VALUE;
        for (int i = 0; i < size; ++i) {
            int index;
            String prototypeName = prototypeAttribute.get(i).toString().trim();
            if (prototypeName.indexOf(61) >= 0) {
                try {
                    prototypeName = this.prototypeName(np.parse(prototypeName));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (prototypeName.length() <= 0 || (index = this.indexOf(prototypeName, protoUsers)) < 0 || index >= lowestIndex) continue;
            lowestIndex = index;
        }
        if (lowestIndex < Integer.MAX_VALUE) {
            prototype = protoUsers[lowestIndex];
        } else {
            logger.warning(lex.getText("ldap.warning.prototypeNotFound", new Object[]{name}));
        }
        return prototype;
    }

    protected BComponent[] getProtoUsers() {
        BUserPrototypes f = this.userService.getUserPrototypes();
        return f.getPrototypes();
    }

    protected String prototypeName(Name n) {
        n = n.getSuffix(n.size() - 1);
        String s = n.toString();
        return s.substring(s.indexOf(61) + 1);
    }

    protected int indexOf(String name, BComponent[] prototypes) {
        name = SlotPath.escape((String)name);
        int i = prototypes.length;
        while (--i >= 0) {
            if (!prototypes[i].getName().equals(name)) continue;
            return i;
        }
        return -1;
    }

    protected BUser addUser(String username, BComponent prototype) {
        String prototypeName = prototype.getName();
        logger.fine(lex.getText("ldap.login.userAdd", new Object[]{username, prototypeName}));
        BUser user = prototype instanceof BUser ? (BUser)prototype.newCopy(true) : new BUser();
        this.userService.add(EscUtil.slot.escape(username), (BValue)user);
        return user;
    }

    protected void updateUserFromPrototype(BUser user, BComponent prot, Attributes attrs) throws NamingException {
        if (prot instanceof BUser) {
            this.updateUserFromLegacyPrototype(user, (BUser)prot, attrs);
        } else if (prot instanceof BUserPrototype) {
            BUserPrototype prototype = (BUserPrototype)prot;
            String userName = user.getName();
            HashMap<String, Object> values = new HashMap<String, Object>();
            String email = this.getEmailFromLDAPAttribute(attrs, userName);
            String name = this.getFullNameFromLDAPAttribute(attrs, userName);
            String language = this.getLanguageFromLDAPAttribute(attrs, userName);
            String cell = this.getCellPhoneNumberFromLDAPAttribute(attrs, userName);
            if (email != null) {
                values.put("email", BString.make((String)email));
            }
            if (name != null) {
                values.put("fullName", BString.make((String)name));
            }
            if (language != null) {
                values.put("language", BString.make((String)language));
            }
            if (cell != null) {
                values.put("cellPhoneNumber", BString.make((String)cell));
            }
            BAbsTime expirationTime = (BAbsTime)prototype.getExpiration().getValue();
            BRelTime rt = this.getCacheExpiration();
            if (rt.getMillis() > 0L) {
                BAbsTime tmp = Clock.time().add(rt);
                if (expirationTime.isNull() || tmp.isBefore(expirationTime)) {
                    expirationTime = tmp;
                }
            }
            values.put("expiration", expirationTime);
            values.put("prototypeName", BString.make((String)prototype.getName()));
            values.put("authenticationSchemeName", BString.make((String)this.scheme.getName()));
            if (!prototype.getName().equals(user.getPrototypeName())) {
                prototype.updateUserFromPrototype(user, values, true);
            } else {
                prototype.updateUserFromPrototype(user, values);
            }
            user.setFlags((Slot)BUser.authenticationSchemeName, user.getFlags((Slot)BUser.authenticationSchemeName) | 1);
            user.setFlags((Slot)BUser.prototypeName, user.getFlags((Slot)BUser.prototypeName) | 1);
        } else {
            throw new IllegalArgumentException("BUser or BUserPrototype required for prototype.");
        }
    }

    protected void updateUserFromLegacyPrototype(BUser user, BUser prototype, Attributes attrs) throws NamingException {
        user.setEnabled(prototype.getEnabled());
        user.setRoles(prototype.getRoles());
        user.setPrototypeName(prototype.getName());
        String userName = user.getName();
        String email = this.getEmailFromLDAPAttribute(attrs, userName);
        String name = this.getFullNameFromLDAPAttribute(attrs, userName);
        String language = this.getLanguageFromLDAPAttribute(attrs, userName);
        String cell = this.getCellPhoneNumberFromLDAPAttribute(attrs, userName);
        if (email != null) {
            user.setEmail(email);
        }
        if (name != null) {
            user.setFullName(name);
        }
        if (language != null) {
            user.setLanguage(language);
        }
        if (cell != null) {
            user.setCellPhoneNumber(cell);
        }
        BAbsTime expirationTime = prototype.getExpiration();
        BRelTime rt = this.getCacheExpiration();
        if (rt.getMillis() > 0L) {
            BAbsTime tmp = Clock.time().add(rt);
            if (expirationTime.isNull() || tmp.isBefore(expirationTime)) {
                expirationTime = tmp;
            }
        }
        user.setExpiration(expirationTime);
        user.setPrototypeName(prototype.getName());
        user.setAuthenticationSchemeName(this.scheme.getName());
    }

    protected String getAuthMech() {
        return "simple";
    }

    protected String getConnectionUser(String user) {
        return user;
    }

    protected String getConnectionPwd(String password) {
        return password;
    }

    public void setScheme(BAuthenticationScheme scheme) {
        this.scheme = scheme;
    }

    public void checkLicense() throws LicenseException {
    }

    public String getAllConnectionUrls() {
        String origConnectionUrl = this.getConnectionUrl();
        try {
            URI connectionUri = new URI(origConnectionUrl);
            String host = connectionUri.getHost();
            InetAddress[] addrs = InetAddress.getAllByName(host);
            StringBuilder builder = new StringBuilder();
            for (InetAddress addr : addrs) {
                if (builder.length() > 0) {
                    builder.append(" ");
                }
                String url = origConnectionUrl.replace(host, addr.getCanonicalHostName());
                builder.append(url);
            }
            String url = builder.toString();
            logger.fine(lex.getText("ldap.login.connectionUrlResolve", new Object[]{origConnectionUrl, url}));
            return url;
        }
        catch (Exception e) {
            BLdapConfig.logException(lex.getText("ldap.login.connectionUrlResolveFailed", new Object[]{origConnectionUrl}), e, Level.FINE);
            return origConnectionUrl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void logAttributes(Attributes attrs) {
        try {
            System.out.println("\n*************************************");
            try (NamingEnumeration<? extends Attribute> e = attrs.getAll();){
                while (e.hasMore()) {
                    Attribute a = e.next();
                    String id = a.getID();
                    int len = a.size();
                    for (int i = 0; i < len; ++i) {
                        System.out.println(id + ": " + a.get(i));
                    }
                }
            }
            System.out.println("*************************************\n");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void logException(String message, Exception e, Level level) {
        logger.log(level, message + ": " + e);
        if (logger.isLoggable(Level.FINER)) {
            e.printStackTrace();
        }
    }
}

