/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndio.ui;

import com.tridium.ndio.conv.BThermistorType3Conversion;
import com.tridium.ndio.enums.BNdioIoTypeEnum;
import com.tridium.ndio.ext.BLinearCalibrationExt;
import com.tridium.ndio.learn.BNdioPointEntry;
import com.tridium.ndio.point.BNdioPointDeviceExt;
import com.tridium.ndio.point.BNdioProxyExt;
import com.tridium.ndio.point.BNdioResistiveInputProxyExt;
import com.tridium.ndio.point.BNdioVoltageInputProxyExt;
import java.util.ArrayList;
import javax.baja.control.BControlPoint;
import javax.baja.control.BIWritablePoint;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.data.BIDataValue;
import javax.baja.driver.point.BDefaultProxyConversion;
import javax.baja.driver.point.BIPointFolder;
import javax.baja.driver.point.BProxyConversion;
import javax.baja.driver.point.BProxyExt;
import javax.baja.driver.ui.point.BPointManager;
import javax.baja.driver.ui.point.PointController;
import javax.baja.driver.ui.point.PointModel;
import javax.baja.gx.BImage;
import javax.baja.job.BJob;
import javax.baja.log.Log;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.CommandArtifact;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrState;
import javax.baja.workbench.mgr.MgrTypeInfo;

@NiagaraType(agent={@AgentOn(types={"ndio:NdioPointDeviceExt", "ndio:NdioPointFolder"}, requiredPermissions="r")})
public class BNdioPointManager
extends BPointManager {
    @Generated
    public static final Type TYPE = Sys.loadType(BNdioPointManager.class);
    static final Lexicon lex = Lexicon.make(MgrController.class);
    static Lexicon abstractLex = Lexicon.make(BPointManager.class);
    static Lexicon ndioLex = Lexicon.make((String)"ndio");
    static BImage ndioFloatIcon = BImage.make((String)"module://icons/x16/statusNumeric.png");
    static BImage ndioBooleanIcon = BImage.make((String)"module://icons/x16/statusBoolean.png");
    static BImage ndioMixIcon = BImage.make((String)"module://icons/x16/statusMixed.png");
    MgrColumn colName = new MgrColumn.Name();
    MgrColumn colType = new MgrColumn.Type(1);
    MgrColumn colAddress = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BNdioProxyExt.address}, 1);
    MgrColumn collPollFrequency = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BNdioProxyExt.pollFrequency}, 3);
    MgrColumn colConversion = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.conversion}, 3);
    MgrColumn colFacets = new MgrColumn.Prop(BControlPoint.facets, 3);
    MgrColumn colString = new MgrColumn.ToString(ndioLex.getText("pointManager.out"), 0);
    MgrColumn[] cols = new MgrColumn[]{this.colName, this.colType, this.colAddress, this.collPollFrequency, this.colConversion, this.colString, this.colFacets};
    static final Log log = Log.getLog((String)"ndio");
    private BNdioPointDeviceExt deviceExt = null;
    private BNdioPointEntry[] lastLearn = null;

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected void init() {
        super.init();
        try {
            this.deviceExt = (BNdioPointDeviceExt)((BIPointFolder)this.getCurrentValue()).getDeviceExt();
            if (this.getCurrentValue() != this.deviceExt) {
                this.registerForComponentEvents((BComponent)this.deviceExt);
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    protected MgrModel makeModel() {
        return new Model(this);
    }

    protected MgrLearn makeLearn() {
        return new Learn(this);
    }

    protected MgrState makeState() {
        return new State();
    }

    protected MgrController makeController() {
        return new Controller(this);
    }

    private void updateDiscoveryRows(BComponent event) {
        Object[] rows = (BNdioPointEntry[])event.getChildren(BNdioPointEntry.class);
        this.lastLearn = rows;
        for (int i = 0; i < rows.length; ++i) {
            rows[i].loadSlots();
        }
        this.getLearn().updateRoots(rows);
    }

    static /* synthetic */ BNdioPointEntry[] access$202(BNdioPointManager x0, BNdioPointEntry[] x1) {
        x0.lastLearn = x1;
        return x1;
    }

    static class State
    extends MgrState {
        BNdioPointEntry[] lastLearn = null;

        State() {
        }

        protected void saveForOrd(BAbstractManager m) {
            super.saveForOrd(m);
            BNdioPointManager manager = (BNdioPointManager)m;
            this.lastLearn = manager.lastLearn;
        }

        protected void restoreForOrd(BAbstractManager m) {
            super.restoreForOrd(m);
            BNdioPointManager manager = (BNdioPointManager)m;
            if (this.lastLearn != null) {
                BNdioPointManager.access$202(manager, this.lastLearn);
                manager.getLearn().updateRoots((Object[])this.lastLearn);
            }
        }
    }

    static class NdioMgrTypeInfo
    extends MgrTypeInfo {
        private TypeInfo extType;
        private TypeInfo pntType;
        private String displayName;
        private BProxyConversion converter;

        NdioMgrTypeInfo(TypeInfo extType, TypeInfo pntType, BProxyConversion converter, String displayKey) {
            this.extType = extType;
            this.pntType = pntType;
            this.converter = converter;
            this.displayName = ndioLex.getText(displayKey);
            if (this.converter == null) {
                this.converter = BDefaultProxyConversion.DEFAULT;
            }
        }

        NdioMgrTypeInfo(BComponent c) {
            BControlPoint cp = (BControlPoint)c;
            BNdioProxyExt cpe = (BNdioProxyExt)cp.getProxyExt();
            this.pntType = cp.getType().getTypeInfo();
            this.extType = cpe.getType().getTypeInfo();
            this.converter = cpe.getConversion();
            this.displayName = this.converter instanceof BThermistorType3Conversion ? ndioLex.getText("type.NdioThermistorInputProxyExtPoint") : (this.pntType.is(BIWritablePoint.TYPE) ? ndioLex.getText("type." + this.extType.getTypeName() + "Writable") : ndioLex.getText("type." + this.extType.getTypeName() + "Point"));
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public TypeInfo getPointTypeInfo() {
            return this.pntType;
        }

        public TypeInfo getExtTypeInfo() {
            return this.extType;
        }

        public BProxyConversion getConverter() {
            return this.converter;
        }

        public BImage getIcon() {
            return null;
        }

        public BComponent newInstance() {
            BControlPoint pnt = (BControlPoint)this.pntType.getInstance();
            BNdioProxyExt ext = (BNdioProxyExt)this.extType.getInstance();
            ext.setConversion(this.converter);
            pnt.setProxyExt((BAbstractProxyExt)ext);
            BFacets facets = pnt.getFacets();
            if (this.converter instanceof BThermistorType3Conversion) {
                facets = BFacets.make((BFacets)facets, (String)"units", (BIDataValue)BUnit.getUnit((String)"celsius"));
            } else {
                BIDataValue facetsValue = (BIDataValue)ext.getDeviceFacets().get("units");
                if (facetsValue != null) {
                    facets = BFacets.make((BFacets)facets, (String)"units", (BIDataValue)facetsValue);
                }
            }
            pnt.setFacets(facets);
            if (ext instanceof BNdioVoltageInputProxyExt) {
                pnt.add("linearCalibration", (BValue)new BLinearCalibrationExt(BUnit.getUnit((String)"volt")), 0);
            }
            if (ext instanceof BNdioResistiveInputProxyExt) {
                if (this.converter instanceof BThermistorType3Conversion) {
                    pnt.add("linearCalibration", (BValue)new BLinearCalibrationExt(BUnit.getUnit((String)"celsius")), 0);
                } else {
                    pnt.add("linearCalibration", (BValue)new BLinearCalibrationExt(BUnit.getUnit((String)"ohm")), 0);
                }
            }
            return pnt;
        }

        public boolean isMatchable(BComponent db) {
            return false;
        }
    }

    class Learn
    extends MgrLearn {
        Learn(BNdioPointManager mgr) {
            super((BAbstractManager)mgr);
        }

        protected MgrColumn[] makeColumns() {
            return new MgrColumn[]{new MgrColumn.Prop(BNdioPointEntry.ioType, 0), new MgrColumn.Prop(BNdioPointEntry.address, 0)};
        }

        public boolean isMatchable(Object dis, BComponent db) {
            return false;
        }

        public void jobComplete(BJob job) {
            super.jobComplete(job);
            BNdioPointManager.this.updateDiscoveryRows((BComponent)job);
        }

        public BImage getIcon(Object dis) {
            BNdioPointEntry entry = (BNdioPointEntry)dis;
            if (entry.getIoType() == BNdioIoTypeEnum.universalInput) {
                return ndioMixIcon;
            }
            if (entry.getIoType() == BNdioIoTypeEnum.analogOutput) {
                return ndioFloatIcon;
            }
            return ndioBooleanIcon;
        }

        public MgrTypeInfo[] toTypes(Object dis) {
            ArrayList<NdioMgrTypeInfo> list = new ArrayList<NdioMgrTypeInfo>();
            BNdioPointEntry entry = (BNdioPointEntry)dis;
            if (entry.getIoType() == BNdioIoTypeEnum.universalInput) {
                list.add(new NdioMgrTypeInfo(Sys.getRegistry().getType("ndio:NdioVoltageInputProxyExt"), Sys.getRegistry().getType("control:NumericPoint"), null, "type.NdioVoltageInputProxyExtPoint"));
                list.add(new NdioMgrTypeInfo(Sys.getRegistry().getType("ndio:NdioResistiveInputProxyExt"), Sys.getRegistry().getType("control:NumericPoint"), null, "type.NdioResistiveInputProxyExtPoint"));
                list.add(new NdioMgrTypeInfo(Sys.getRegistry().getType("ndio:NdioResistiveInputProxyExt"), Sys.getRegistry().getType("control:NumericPoint"), (BProxyConversion)BThermistorType3Conversion.DEFAULT, "type.NdioThermistorInputProxyExtPoint"));
                list.add(new NdioMgrTypeInfo(Sys.getRegistry().getType("ndio:NdioCounterInputProxyExt"), Sys.getRegistry().getType("control:NumericPoint"), null, "type.NdioCounterInputProxyExtPoint"));
                list.add(new NdioMgrTypeInfo(Sys.getRegistry().getType("ndio:NdioBooleanInputProxyExt"), Sys.getRegistry().getType("control:BooleanPoint"), null, "type.NdioBooleanInputProxyExtPoint"));
            } else if (entry.getIoType() == BNdioIoTypeEnum.analogOutput) {
                list.add(new NdioMgrTypeInfo(Sys.getRegistry().getType("ndio:NdioVoltageOutputProxyExt"), Sys.getRegistry().getType("control:NumericWritable"), null, "type.NdioVoltageOutputProxyExtWritable"));
            } else if (entry.getIoType() == BNdioIoTypeEnum.booleanOutput) {
                list.add(new NdioMgrTypeInfo(Sys.getRegistry().getType("ndio:NdioBooleanOutputProxyExt"), Sys.getRegistry().getType("control:BooleanWritable"), null, "type.NdioBooleanOutputProxyExtWritable"));
            } else {
                log.error("didn't find a valid point type: " + entry.getIoType());
                return new MgrTypeInfo[0];
            }
            return list.toArray(new MgrTypeInfo[0]);
        }

        public void toRow(Object discovery, MgrEditRow row) throws Exception {
            BNdioPointEntry entry = (BNdioPointEntry)discovery;
            if (entry.getIoType() == BNdioIoTypeEnum.universalInput) {
                row.setDefaultName(ndioLex.getText("default.universalInputName"));
            } else if (entry.getIoType() == BNdioIoTypeEnum.analogOutput) {
                row.setDefaultName(ndioLex.getText("default.analogOutputName"));
            } else if (entry.getIoType() == BNdioIoTypeEnum.booleanOutput) {
                row.setDefaultName(ndioLex.getText("default.booleanOutputName"));
            } else {
                row.setDefaultName("somethingWrong");
            }
            row.setCell(BNdioPointManager.this.colAddress, (BValue)BInteger.make((int)entry.getAddress()));
        }

        public boolean isExisting(Object discovery, BComponent component) {
            try {
                BNdioPointEntry entry = (BNdioPointEntry)discovery;
                return entry.is(component);
            }
            catch (Throwable e) {
                return false;
            }
        }
    }

    public class Model
    extends PointModel {
        Model(BNdioPointManager mgr) {
            super((BPointManager)mgr);
        }

        protected MgrColumn[] makeColumns() {
            return BNdioPointManager.this.cols;
        }

        public BComponent newInstance(MgrTypeInfo type) throws Exception {
            NdioMgrTypeInfo ndioType = (NdioMgrTypeInfo)type;
            BControlPoint pt = (BControlPoint)ndioType.newInstance();
            return pt;
        }

        public MgrTypeInfo toType(BComponent c) {
            return new NdioMgrTypeInfo(c);
        }

        public MgrTypeInfo[] getNewTypes() {
            ArrayList<NdioMgrTypeInfo> list = new ArrayList<NdioMgrTypeInfo>();
            list.add(new NdioMgrTypeInfo(Sys.getRegistry().getType("ndio:NdioVoltageInputProxyExt"), Sys.getRegistry().getType("control:NumericPoint"), null, "type.NdioVoltageInputProxyExtPoint"));
            list.add(new NdioMgrTypeInfo(Sys.getRegistry().getType("ndio:NdioResistiveInputProxyExt"), Sys.getRegistry().getType("control:NumericPoint"), null, "type.NdioResistiveInputProxyExtPoint"));
            list.add(new NdioMgrTypeInfo(Sys.getRegistry().getType("ndio:NdioResistiveInputProxyExt"), Sys.getRegistry().getType("control:NumericPoint"), (BProxyConversion)BThermistorType3Conversion.DEFAULT, "type.NdioThermistorInputProxyExtPoint"));
            list.add(new NdioMgrTypeInfo(Sys.getRegistry().getType("ndio:NdioCounterInputProxyExt"), Sys.getRegistry().getType("control:NumericPoint"), null, "type.NdioCounterInputProxyExtPoint"));
            list.add(new NdioMgrTypeInfo(Sys.getRegistry().getType("ndio:NdioBooleanInputProxyExt"), Sys.getRegistry().getType("control:BooleanPoint"), null, "type.NdioBooleanInputProxyExtPoint"));
            list.add(new NdioMgrTypeInfo(Sys.getRegistry().getType("ndio:NdioVoltageOutputProxyExt"), Sys.getRegistry().getType("control:NumericWritable"), null, "type.NdioVoltageOutputProxyExtWritable"));
            list.add(new NdioMgrTypeInfo(Sys.getRegistry().getType("ndio:NdioBooleanOutputProxyExt"), Sys.getRegistry().getType("control:BooleanWritable"), null, "type.NdioBooleanOutputProxyExtWritable"));
            return list.toArray(new MgrTypeInfo[0]);
        }
    }

    public class Controller
    extends PointController {
        Controller(BNdioPointManager manager) {
            super((BPointManager)manager);
        }

        protected MgrController.IMgrCommand[] makeCommands() {
            return new MgrController.IMgrCommand[]{this.newCommand, this.newFolder, this.allDescendants, this.edit, this.learnMode, this.discover, this.add};
        }

        public MgrController.IMgrCommand[] getDropDownCommands(MgrController.IMgrCommand command) {
            return null;
        }

        public CommandArtifact doDiscover(Context context) throws Exception {
            super.doDiscover(context);
            BNdioPointManager.this.getLearn().setJob(BNdioPointManager.this.deviceExt.submitDiscoveryJob());
            return null;
        }
    }
}

