/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.haystack;

import com.tridium.haystack.BHaystack3To4MigrationJob;
import com.tridium.haystack.BHaystack3To4MigrationParams;
import com.tridium.haystack.Haystack4Importer;
import com.tridium.sys.module.BModulePaletteNode;
import com.tridium.tagdictionary.BNiagaraTagDictionary;
import com.tridium.tagdictionary.neqlize.FilteredTagsMap;
import com.tridium.tagdictionary.util.ImportUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringJoiner;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.RelationKnob;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.TagGroupInfo;
import javax.baja.tagdictionary.BRelationInfoList;
import javax.baja.tagdictionary.BSmartTagDictionary;
import javax.baja.tagdictionary.BTagDictionary;
import javax.baja.tagdictionary.BTagGroupInfo;
import javax.baja.tagdictionary.BTagGroupInfoList;
import javax.baja.tagdictionary.BTagInfoList;
import javax.baja.tagdictionary.BTagRuleList;
import javax.baja.util.LexiconModule;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="namespace", type="String", defaultValue="h4", flags=1, override=true), @NiagaraProperty(name="frozen", type="boolean", defaultValue="true", flags=1, override=true), @NiagaraProperty(name="neqlizeExcludedTags", type="String", defaultValue="", flags=1, facets={@Facet(name="BFacets.MULTI_LINE", value="BBoolean.TRUE")}, override=true), @NiagaraProperty(name="neqlizeExcludedRelations", type="String", defaultValue="", flags=1, facets={@Facet(name="BFacets.MULTI_LINE", value="BBoolean.TRUE")}, override=true), @NiagaraProperty(name="version", type="String", defaultValue="Undefined", flags=1, override=true)})
@NiagaraActions(value={@NiagaraAction(name="importDictionary", parameterType="BOrd", defaultValue="BOrd.make(\"module://haystack/com/tridium/haystack/data/haystack-4-defs\")", override=true), @NiagaraAction(name="migrateHaystack3Items", parameterType="BHaystack3To4MigrationParams", defaultValue="new BHaystack3To4MigrationParams()", returnType="BOrd")})
public class BHaystack4TagDictionary
extends BSmartTagDictionary {
    @Generated
    public static final Property namespace = BHaystack4TagDictionary.newProperty((int)1, (String)"h4", null);
    @Generated
    public static final Property frozen = BHaystack4TagDictionary.newProperty((int)1, (boolean)true, null);
    @Generated
    public static final Property neqlizeExcludedTags = BHaystack4TagDictionary.newProperty((int)1, (String)"", (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property neqlizeExcludedRelations = BHaystack4TagDictionary.newProperty((int)1, (String)"", (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property version = BHaystack4TagDictionary.newProperty((int)1, (String)"Undefined", null);
    @Generated
    public static final Action importDictionary = BHaystack4TagDictionary.newAction((int)0, (BValue)BOrd.make((String)"module://haystack/com/tridium/haystack/data/haystack-4-defs"), null);
    @Generated
    public static final Action migrateHaystack3Items = BHaystack4TagDictionary.newAction((int)0, (BValue)new BHaystack3To4MigrationParams(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BHaystack4TagDictionary.class);
    static final Logger LOGGER = Logger.getLogger("tag.haystack4");
    static final LexiconModule LEXICON = LexiconModule.make((String)"haystack");
    private static final String TAG_GROUP_RELATION_STR = BNiagaraTagDictionary.TAG_GROUP_RELATION.toString();
    private static final String DEFAULT_EXCLUDE_TAGS = "h4:area, h4:coolingCapacity,\nh4:cur, h4:curErr, h4:curStatus, h4:curVal,\nh4:dis, h4:ductArea, h4:enum,\nh4:floorNum, h4:geo*, h4:his,\nh4:hisErr, h4:hisMode, h4:hisStatus,\nh4:hisTotalized, h4:hvacMode,\nh4:kind, h4:maxVal, h4:minVal,\nh4:primaryFunction, h4:tz,\nh4:unit, h4:writable,\nh4:writeErr, h4:writeLevel,\nh4:writeStatus, h4:writeVal,\nh4:yearBuilt";
    private static final String EXCLUDED_TAG_DELIMITER = ", ";

    @Generated
    public BOrd migrateHaystack3Items(BHaystack3To4MigrationParams parameter) {
        return (BOrd)this.invoke(migrateHaystack3Items, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        if (!this.getTagDefinitions().iterator().hasNext()) {
            new Thread(() -> {
                try {
                    this.doImportDictionary((BOrd)importDictionary.getParameterDefault());
                }
                catch (Exception e) {
                    this.setStatus(BStatus.fault);
                    this.setFaultCause(e.getLocalizedMessage());
                    this.setVersion("Undefined");
                }
            }).start();
        }
    }

    public String toString(Context context) {
        String name = this.getName();
        if (name != null) {
            return LEXICON.getText("h4.tag.dictionary.shortName", context, new Object[]{name});
        }
        return super.toString(context);
    }

    public BOrd doMigrateHaystack3Items(BHaystack3To4MigrationParams params, Context cx) {
        return new BHaystack3To4MigrationJob(params, this).submit(cx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doImportDictionary(BOrd defsFolder, Context context) {
        BHaystack4TagDictionary newDictionary;
        if (this.getSpace() instanceof BModulePaletteNode) {
            throw new BajaRuntimeException("Haystack.importDictionary action does not function in a module palette.");
        }
        try {
            newDictionary = new Haystack4Importer(defsFolder, this.getMaxImportFileSize()).doImport();
        }
        catch (RuntimeException e) {
            LOGGER.log(Level.WARNING, "Error importing Haystack 4 tag dictionary " + this.getName() + " from " + defsFolder, e);
            throw e;
        }
        List<TagGroupInfo> tagGroupsInUse = this.areAnyRemovedTagGroupsInUse(newDictionary);
        if (!tagGroupsInUse.isEmpty()) {
            StringBuilder inUse = new StringBuilder();
            tagGroupsInUse.forEach(tagGroupInfo -> inUse.append('\n').append(tagGroupInfo.getName()));
            throw new LocalizableRuntimeException("haystack", "importHaystack4.tagGroupsInUse", new Object[]{this.getName(), defsFolder, inUse});
        }
        try {
            this.setFrozen(false);
            ImportUtil.updateTags((BTagInfoList)newDictionary.getTagDefinitions(), (BTagInfoList)this.getTagDefinitions(), (Context)context);
            ImportUtil.updateTagGroups((BTagGroupInfoList)newDictionary.getTagGroupDefinitions(), (BTagGroupInfoList)this.getTagGroupDefinitions(), (Context)context);
            ImportUtil.updateRelations((BRelationInfoList)newDictionary.getRelationDefinitions(), (BRelationInfoList)this.getRelationDefinitions(), (Context)context);
            ImportUtil.updateTagRules((BTagRuleList)newDictionary.getTagRules(), (BTagRuleList)this.getTagRules(), (Context)context);
            this.updateNeqlizeExcludedTags(newDictionary.getNeqlizeExcludedTags());
            this.setVersion(newDictionary.getVersion());
        }
        finally {
            this.setFrozen(true);
        }
        this.setStatus(BStatus.ok);
        this.setFaultCause("");
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info(this.getName() + " tag dictionary has been reloaded.");
        }
    }

    public void doImportDictionary(BOrd defsFolder) {
        this.doImportDictionary(defsFolder, null);
    }

    private List<TagGroupInfo> areAnyRemovedTagGroupsInUse(BHaystack4TagDictionary newDictionary) {
        ArrayList<TagGroupInfo> tagGroupsInUse = new ArrayList<TagGroupInfo>();
        BTagGroupInfoList newTagGroups = newDictionary.getTagGroupDefinitions();
        for (BTagGroupInfo tagGroup : (BTagGroupInfo[])this.getTagGroupDefinitions().getChildren(BTagGroupInfo.class)) {
            if (newTagGroups.containsTagId(tagGroup.getGroupId())) continue;
            for (RelationKnob knob : tagGroup.getRelationKnobs()) {
                if (!TAG_GROUP_RELATION_STR.equals(knob.getRelationId())) continue;
                tagGroupsInUse.add((TagGroupInfo)tagGroup);
            }
        }
        return tagGroupsInUse;
    }

    private void updateNeqlizeExcludedTags(String importedExcludedTags) {
        if (importedExcludedTags.isEmpty()) {
            this.setNeqlizeExcludedTags(DEFAULT_EXCLUDE_TAGS);
            return;
        }
        String combined = "h4:area, h4:coolingCapacity,\nh4:cur, h4:curErr, h4:curStatus, h4:curVal,\nh4:dis, h4:ductArea, h4:enum,\nh4:floorNum, h4:geo*, h4:his,\nh4:hisErr, h4:hisMode, h4:hisStatus,\nh4:hisTotalized, h4:hvacMode,\nh4:kind, h4:maxVal, h4:minVal,\nh4:primaryFunction, h4:tz,\nh4:unit, h4:writable,\nh4:writeErr, h4:writeLevel,\nh4:writeStatus, h4:writeVal,\nh4:yearBuilt," + importedExcludedTags;
        String[] sortedExcludedTags = FilteredTagsMap.EXCLUSION_STRING_SPLIT.split(combined);
        Arrays.sort(sortedExcludedTags, String.CASE_INSENSITIVE_ORDER);
        int extraChars = EXCLUDED_TAG_DELIMITER.length();
        StringJoiner lineJoiner = new StringJoiner(EXCLUDED_TAG_DELIMITER);
        StringJoiner excludedTags = new StringJoiner(",\n");
        for (String excludedTag : sortedExcludedTags) {
            if (lineJoiner.length() + excludedTag.length() + extraChars > 35) {
                excludedTags.add(lineJoiner.toString());
                lineJoiner = new StringJoiner(EXCLUDED_TAG_DELIMITER);
            }
            lineJoiner.add(excludedTag);
        }
        excludedTags.add(lineJoiner.toString());
        this.setNeqlizeExcludedTags(excludedTags.toString());
    }

    public BTagDictionary getStandardDictionary() {
        return new Haystack4Importer((BOrd)importDictionary.getParameterDefault()).doImport();
    }
}

