/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.slottool.processor;

import com.tridium.slottool.generator.CodeGenerator;
import com.tridium.slottool.generator.GeneratedCodeBlock;
import com.tridium.slottool.model.Topic;
import com.tridium.slottool.processor.SlotProcessor;
import java.util.Optional;

public class TopicProcessor
extends SlotProcessor<Topic> {
    public TopicProcessor(GeneratedCodeBlock cg) {
        super(cg);
    }

    @Override
    public void accept(Topic topic) {
        String name = topic.getName();
        String fire = "fire" + CodeGenerator.getMethodizedName(name);
        String type = topic.getReturnType().orElse("BValue");
        String flags = topic.getFlags().orElse("0");
        String facets = TopicProcessor.processFacets(topic.getFacets()).orElse("null");
        Optional<String> javaDoc = topic.getJavaDoc();
        this.cg.addImport("javax.baja.sys.Topic");
        if (topic.getFlags().isPresent()) {
            this.cg.addImport("javax.baja.sys.Flags");
        }
        if (!topic.getFacets().isEmpty()) {
            this.cg.addImport("javax.baja.sys.BFacets");
        }
        this.cg.startRegion("Topic \"" + name + "\"");
        this.cg.println();
        this.cg.println("/**");
        this.cg.println(" * Slot for the {@code " + name + "} topic.");
        javaDoc.ifPresent(this.cg::printJavadocComment);
        this.cg.println(" * @see #" + fire);
        this.cg.println(" */");
        if (topic.isDeprecated()) {
            this.cg.println("@Deprecated");
        }
        this.cg.println("public static final Topic " + name + " = newTopic(" + flags + ", " + facets + ");");
        if (!topic.isOverride()) {
            String parameter;
            this.cg.println();
            this.cg.println("/**");
            this.cg.println(" * Fire an event for the {@code " + name + "} topic.");
            javaDoc.ifPresent(this.cg::printJavadocComment);
            this.cg.println(" * @see #" + name);
            this.cg.println(" */");
            String string = parameter = !"event".equals(name) ? "event" : "parameter";
            if (topic.isDeprecated()) {
                this.cg.println("@Deprecated");
            }
            this.cg.println("public void " + fire + "(" + type + " " + parameter + ") { fire(" + name + ", " + parameter + ", null); }");
        }
        this.cg.endRegion();
    }
}

