/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.slottool.processor;

import com.tridium.slottool.generator.GeneratedCodeBlock;
import com.tridium.slottool.model.Facet;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;

public abstract class SlotProcessor<T>
implements Consumer<T> {
    protected final GeneratedCodeBlock cg;

    protected SlotProcessor(GeneratedCodeBlock cg) {
        this.cg = cg;
    }

    public static Optional<String> processFacets(List<Facet> facets) {
        if (facets == null || facets.isEmpty()) {
            return Optional.empty();
        }
        switch (facets.size()) {
            case 0: {
                return Optional.of("BFacets.NULL");
            }
            case 1: {
                return Optional.of(facets.get(0).getFacet());
            }
        }
        String str = String.format("BFacets.make(%s, %s)", facets.get(0).getFacet(), facets.get(1).getFacet());
        for (int i = 2; i < facets.size(); ++i) {
            str = String.format("BFacets.make(%s, %s)", str, facets.get(i).getFacet());
        }
        return Optional.of(str);
    }
}

