/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.slottool.model.annotation.processors;

import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.NormalAnnotationExpr;
import com.tridium.slottool.SlotomaticOptions;
import com.tridium.slottool.generator.ExistingCodeBlock;
import com.tridium.slottool.generator.LineRange;
import com.tridium.slottool.model.Adapter;
import com.tridium.slottool.model.AgentOn;
import com.tridium.slottool.model.NiagaraType;
import com.tridium.slottool.model.annotation.AnnotationClass;
import com.tridium.slottool.model.annotation.AnnotationProcessor;
import com.tridium.slottool.util.JavaParserUtil;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class NiagaraTypeProcessor
extends AnnotationProcessor {
    public NiagaraTypeProcessor(SlotomaticOptions slotomaticOptions, AnnotationClass unit, String source) {
        super(slotomaticOptions, unit, source);
    }

    @Override
    public String getAnnotationName() {
        return "NiagaraType";
    }

    @Override
    public void accept(AnnotationExpr annotation) {
        Optional<Expression> agentExpr;
        Optional<Expression> fileExtExpr;
        if (!annotation.isNormalAnnotationExpr()) {
            this.unit.setNiagaraType(NiagaraType.EMPTY);
            return;
        }
        NiagaraType type = new NiagaraType();
        NormalAnnotationExpr expr = annotation.asNormalAnnotationExpr();
        AnnotationProcessor.AnnotationAttributes attributes = new AnnotationProcessor.AnnotationAttributes(expr);
        type.setOrdScheme(attributes.getAndMap("ordScheme", AnnotationProcessor::getValue));
        Optional<Expression> adapterExpr = attributes.get("adapter");
        if (adapterExpr.isPresent()) {
            Expression adapter = adapterExpr.get();
            List adapters = NiagaraTypeProcessor.getChildrenAnnotations(adapter).stream().map(NiagaraTypeProcessor::extractAdapter).collect(Collectors.toList());
            if (adapters.size() != 1) {
                throw new IllegalStateException("Found adapter attribute with multiple adapters");
            }
            type.setAdapter(Optional.of(adapters.get(0)));
        }
        if ((fileExtExpr = attributes.get("ext")).isPresent()) {
            Expression fileExt = fileExtExpr.get();
            NiagaraTypeProcessor.getChildrenAnnotations(fileExt).stream().map(NiagaraTypeProcessor::extractFileExt).forEach(type::addFileExt);
        }
        if ((agentExpr = attributes.get("agent")).isPresent()) {
            Expression agent = agentExpr.get();
            NiagaraTypeProcessor.getChildrenAnnotations(agent).stream().map(NiagaraTypeProcessor::extractAgentOn).forEach(type::addAgentOn);
        }
        Optional<Comment> comment = annotation.getComment();
        comment.ifPresent(it -> {
            LineRange commentRange = JavaParserUtil.getRange(annotation);
            type.setJavaDoc(Optional.of(new ExistingCodeBlock(commentRange, this.sourceLines, this.slotomaticOptions.getLineSeparator()).getBlock()));
        });
        this.unit.setNiagaraType(type);
    }

    private static Adapter extractAdapter(AnnotationExpr annotation) {
        if (!annotation.isNormalAnnotationExpr()) {
            throw new IllegalArgumentException("Cannot extract Adapter from NiagaraType");
        }
        NormalAnnotationExpr expr = annotation.asNormalAnnotationExpr();
        AnnotationProcessor.AnnotationAttributes attributes = new AnnotationProcessor.AnnotationAttributes(expr);
        String from = attributes.requireAndMap("from", AnnotationProcessor::getStringValue);
        String to = attributes.requireAndMap("to", AnnotationProcessor::getStringValue);
        return new Adapter(from, to);
    }

    private static String extractFileExt(AnnotationExpr annotation) {
        if (!annotation.isNormalAnnotationExpr()) {
            throw new IllegalArgumentException("Cannot extract FileExt from NiagaraType");
        }
        NormalAnnotationExpr expr = annotation.asNormalAnnotationExpr();
        AnnotationProcessor.AnnotationAttributes attributes = new AnnotationProcessor.AnnotationAttributes(expr);
        return attributes.getAndMap("name", AnnotationProcessor::makeName).orElseThrow(() -> new IllegalArgumentException("FileExt annotation has no name attribute"));
    }

    private static AgentOn extractAgentOn(AnnotationExpr annotation) {
        if (!annotation.isNormalAnnotationExpr()) {
            throw new IllegalArgumentException("Cannot extract AgentOn from NiagaraType");
        }
        AgentOn agentOn = new AgentOn();
        NormalAnnotationExpr expr = annotation.asNormalAnnotationExpr();
        AnnotationProcessor.AnnotationAttributes attributes = new AnnotationProcessor.AnnotationAttributes(expr);
        attributes.getAndMap("types", AnnotationProcessor::getStringList).orElse(Collections.emptyList()).forEach(agentOn::addType);
        agentOn.setApp(attributes.getAndMap("app", AnnotationProcessor::getStringValue));
        Optional<String> defaultAgent = attributes.getAndMap("defaultAgent", AnnotationProcessor::getValue).map(it -> {
            if (it.endsWith("NORMAL")) {
                return null;
            }
            if (it.endsWith("NOT_PREFERRED")) {
                return "false";
            }
            if (it.endsWith("PREFERRED")) {
                return "true";
            }
            throw new IllegalArgumentException(it + " is not a valid defaultAgent value");
        });
        agentOn.setPreferredDefault(defaultAgent);
        agentOn.setRequiredPermissions(attributes.getAndMap("requiredPermissions", AnnotationProcessor::getStringValue));
        return agentOn;
    }
}

