/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.slottool.model;

import java.util.Arrays;

public enum BajaType {
    BOOLEAN_TYPE("boolean"),
    INT_TYPE("int"),
    LONG_TYPE("long"),
    FLOAT_TYPE("float"),
    DOUBLE_TYPE("double"),
    STRING_TYPE("String"),
    BOBJECT_TYPE("BObject"),
    BBOOLEAN_TYPE("BBoolean"),
    BINT_TYPE("BInteger"),
    BLONG_TYPE("BLong"),
    BFLOAT_TYPE("BFloat"),
    BDOUBLE_TYPE("BDouble"),
    BSTRING_TYPE("BString"),
    BVALUE_TYPE("BValue");

    private final String typeName;

    private BajaType(String typeName) {
        this.typeName = typeName;
    }

    public String typeName() {
        return this.typeName;
    }

    public static BajaType forName(String name) {
        return Arrays.asList(BajaType.values()).stream().filter(enm -> enm.typeName().equals(name)).findFirst().orElse(BOBJECT_TYPE);
    }

    public boolean isBType() {
        return this.typeName.charAt(0) == 'B';
    }

    public String getImport() {
        if (this.isBType()) {
            return "javax.baja.sys." + this.typeName;
        }
        throw new IllegalArgumentException(this.typeName + " is not a baja type");
    }
}

